import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [rhelkb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrhelknowledgebaseportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Rhelkb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to access the Red Hat Knowledgebase portal
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rhel.html
     */
    toGetRhelURL(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [rhelkb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonrhelknowledgebaseportal.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
