"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerMlflow = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [sagemaker-mlflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerwithmlflow.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SagemakerMlflow extends shared_1.PolicyStatement {
    /**
     * Grants permission to access the MLflow UI
     *
     * Access Level: Read
     */
    toAccessUI() {
        return this.to('AccessUI');
    }
    /**
     * Grants permission to create an MLflow experiment
     *
     * Access Level: Write
     */
    toCreateExperiment() {
        return this.to('CreateExperiment');
    }
    /**
     * Grants permission to create a new model version
     *
     * Access Level: Write
     */
    toCreateModelVersion() {
        return this.to('CreateModelVersion');
    }
    /**
     * Grants permission to create a registered model
     *
     * Access Level: Write
     */
    toCreateRegisteredModel() {
        return this.to('CreateRegisteredModel');
    }
    /**
     * Grants permission to create a new run within an experiment
     *
     * Access Level: Write
     */
    toCreateRun() {
        return this.to('CreateRun');
    }
    /**
     * Grants permission to mark an MLflow experiment for deletion
     *
     * Access Level: Write
     */
    toDeleteExperiment() {
        return this.to('DeleteExperiment');
    }
    /**
     * Grants permission to delete a model version
     *
     * Access Level: Write
     */
    toDeleteModelVersion() {
        return this.to('DeleteModelVersion');
    }
    /**
     * Grants permission to delete a model version tag
     *
     * Access Level: Write
     */
    toDeleteModelVersionTag() {
        return this.to('DeleteModelVersionTag');
    }
    /**
     * Grants permission to delete a registered model
     *
     * Access Level: Write
     */
    toDeleteRegisteredModel() {
        return this.to('DeleteRegisteredModel');
    }
    /**
     * Grants permission to delete a registered model alias
     *
     * Access Level: Write
     */
    toDeleteRegisteredModelAlias() {
        return this.to('DeleteRegisteredModelAlias');
    }
    /**
     * Grants permission to delete a registered model tag
     *
     * Access Level: Write
     */
    toDeleteRegisteredModelTag() {
        return this.to('DeleteRegisteredModelTag');
    }
    /**
     * Grants permission to mark a run for deletion
     *
     * Access Level: Write
     */
    toDeleteRun() {
        return this.to('DeleteRun');
    }
    /**
     * Grants permission to delete a tag on a run
     *
     * Access Level: Write
     */
    toDeleteTag() {
        return this.to('DeleteTag');
    }
    /**
     * Grants permission to delete a trace tag in MLflow
     *
     * Access Level: Write
     */
    toDeleteTraceTag() {
        return this.to('DeleteTraceTag');
    }
    /**
     * Grants permission to delete traces in MLflow
     *
     * Access Level: Write
     */
    toDeleteTraces() {
        return this.to('DeleteTraces');
    }
    /**
     * Grants permission to end a trace in MLflow
     *
     * Access Level: Write
     */
    toEndTrace() {
        return this.to('EndTrace');
    }
    /**
     * Grants permission to get a URI to download model artifacts for a specific model version
     *
     * Access Level: Read
     */
    toGetDownloadURIForModelVersionArtifacts() {
        return this.to('GetDownloadURIForModelVersionArtifacts');
    }
    /**
     * Grants permission to get metadata for an MLflow experiment
     *
     * Access Level: Read
     */
    toGetExperiment() {
        return this.to('GetExperiment');
    }
    /**
     * Grants permission to get metadata for an MLflow experiment by name
     *
     * Access Level: Read
     */
    toGetExperimentByName() {
        return this.to('GetExperimentByName');
    }
    /**
     * Grants permission to get the latest model versions
     *
     * Access Level: List
     */
    toGetLatestModelVersions() {
        return this.to('GetLatestModelVersions');
    }
    /**
     * Grants permission to get a list of all values for the specified metric for a given run
     *
     * Access Level: Read
     */
    toGetMetricHistory() {
        return this.to('GetMetricHistory');
    }
    /**
     * Grants permission to get a model version by model name and version
     *
     * Access Level: Read
     */
    toGetModelVersion() {
        return this.to('GetModelVersion');
    }
    /**
     * Grants permission to get model version by alias in MLflow
     *
     * Access Level: Read
     */
    toGetModelVersionByAlias() {
        return this.to('GetModelVersionByAlias');
    }
    /**
     * Grants permission to get a registered model
     *
     * Access Level: Read
     */
    toGetRegisteredModel() {
        return this.to('GetRegisteredModel');
    }
    /**
     * Grants permission to get metadata, metrics, parameters, and tags for a run
     *
     * Access Level: Read
     */
    toGetRun() {
        return this.to('GetRun');
    }
    /**
     * Grants permission to get information about a trace in MLflow
     *
     * Access Level: Read
     */
    toGetTraceInfo() {
        return this.to('GetTraceInfo');
    }
    /**
     * Grants permission to list artifacts for a run
     *
     * Access Level: List
     */
    toListArtifacts() {
        return this.to('ListArtifacts');
    }
    /**
     * Grants permission to log a batch of metrics, parameters, and tags for a run
     *
     * Access Level: Write
     */
    toLogBatch() {
        return this.to('LogBatch');
    }
    /**
     * Grants permission to log inputs for a run
     *
     * Access Level: Write
     */
    toLogInputs() {
        return this.to('LogInputs');
    }
    /**
     * Grants permission to log a metric for a run
     *
     * Access Level: Write
     */
    toLogMetric() {
        return this.to('LogMetric');
    }
    /**
     * Grants permission to log the model associated with a run
     *
     * Access Level: Write
     */
    toLogModel() {
        return this.to('LogModel');
    }
    /**
     * Grants permission to log a parameter tracked during a run
     *
     * Access Level: Write
     */
    toLogParam() {
        return this.to('LogParam');
    }
    /**
     * Grants permission to rename a registered model
     *
     * Access Level: Write
     */
    toRenameRegisteredModel() {
        return this.to('RenameRegisteredModel');
    }
    /**
     * Grants permission to restore an experiment marked for deletion
     *
     * Access Level: Write
     */
    toRestoreExperiment() {
        return this.to('RestoreExperiment');
    }
    /**
     * Grants permission to restore a deleted run
     *
     * Access Level: Write
     */
    toRestoreRun() {
        return this.to('RestoreRun');
    }
    /**
     * Grants permission to search for MLflow experiments
     *
     * Access Level: Read
     */
    toSearchExperiments() {
        return this.to('SearchExperiments');
    }
    /**
     * Grants permission to search for a model version
     *
     * Access Level: Read
     */
    toSearchModelVersions() {
        return this.to('SearchModelVersions');
    }
    /**
     * Grants permission to search for registered models in MLflow
     *
     * Access Level: Read
     */
    toSearchRegisteredModels() {
        return this.to('SearchRegisteredModels');
    }
    /**
     * Grants permission to search for runs that satisfy expressions
     *
     * Access Level: Read
     */
    toSearchRuns() {
        return this.to('SearchRuns');
    }
    /**
     * Grants permission to search for traces in MLflow
     *
     * Access Level: Read
     */
    toSearchTraces() {
        return this.to('SearchTraces');
    }
    /**
     * Grants permission to set a tag on an experiment
     *
     * Access Level: Write
     */
    toSetExperimentTag() {
        return this.to('SetExperimentTag');
    }
    /**
     * Grants permission to set a tag for the model version
     *
     * Access Level: Write
     */
    toSetModelVersionTag() {
        return this.to('SetModelVersionTag');
    }
    /**
     * Grants permission to set a registered model alias
     *
     * Access Level: Write
     */
    toSetRegisteredModelAlias() {
        return this.to('SetRegisteredModelAlias');
    }
    /**
     * Grants permission to set a tag for a registered model
     *
     * Access Level: Write
     */
    toSetRegisteredModelTag() {
        return this.to('SetRegisteredModelTag');
    }
    /**
     * Grants permission to set a tag on a run
     *
     * Access Level: Write
     */
    toSetTag() {
        return this.to('SetTag');
    }
    /**
     * Grants permission to set a trace tag in MLflow
     *
     * Access Level: Write
     */
    toSetTraceTag() {
        return this.to('SetTraceTag');
    }
    /**
     * Grants permission to start a trace in MLflow
     *
     * Access Level: Write
     */
    toStartTrace() {
        return this.to('StartTrace');
    }
    /**
     * Grants permission to transition a model version to a particular stage
     *
     * Access Level: Write
     */
    toTransitionModelVersionStage() {
        return this.to('TransitionModelVersionStage');
    }
    /**
     * Grants permission to update the metadata for an MLflow experiment
     *
     * Access Level: Write
     */
    toUpdateExperiment() {
        return this.to('UpdateExperiment');
    }
    /**
     * Grants permission to update the model version
     *
     * Access Level: Write
     */
    toUpdateModelVersion() {
        return this.to('UpdateModelVersion');
    }
    /**
     * Grants permission to update a registered model
     *
     * Access Level: Write
     */
    toUpdateRegisteredModel() {
        return this.to('UpdateRegisteredModel');
    }
    /**
     * Grants permission to update run metadata
     *
     * Access Level: Write
     */
    toUpdateRun() {
        return this.to('UpdateRun');
    }
    /**
     * Adds a resource of type mlflow-tracking-server to the statement
     *
     * https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MlflowTrackingServer.html
     *
     * @param mlflowTrackingServerName - Identifier for the mlflowTrackingServerName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifSagemakerResourceTag()
     */
    onMlflowTrackingServer(mlflowTrackingServerName, account, region, partition) {
        return this.on(`arn:${partition ?? this.defaultPartition}:sagemaker:${region ?? this.defaultRegion}:${account ?? this.defaultAccount}:mlflow-tracking-server/${mlflowTrackingServerName}`);
    }
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - mlflow-tracking-server
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey, value, operator) {
        return this.if(`aws:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Filters access by a tag key and value pair
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsagemaker.html#amazonsagemaker-policy-keys
     *
     * Applies to resource types:
     * - mlflow-tracking-server
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSagemakerResourceTag(tagKey, value, operator) {
        return this.if(`sagemaker:ResourceTag/${tagKey}`, value, operator ?? 'StringLike');
    }
    /**
     * Statement provider for service [sagemaker-mlflow](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsagemakerwithmlflow.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'sagemaker-mlflow';
        this.accessLevelList = {
            Read: [
                'AccessUI',
                'GetDownloadURIForModelVersionArtifacts',
                'GetExperiment',
                'GetExperimentByName',
                'GetMetricHistory',
                'GetModelVersion',
                'GetModelVersionByAlias',
                'GetRegisteredModel',
                'GetRun',
                'GetTraceInfo',
                'SearchExperiments',
                'SearchModelVersions',
                'SearchRegisteredModels',
                'SearchRuns',
                'SearchTraces'
            ],
            Write: [
                'CreateExperiment',
                'CreateModelVersion',
                'CreateRegisteredModel',
                'CreateRun',
                'DeleteExperiment',
                'DeleteModelVersion',
                'DeleteModelVersionTag',
                'DeleteRegisteredModel',
                'DeleteRegisteredModelAlias',
                'DeleteRegisteredModelTag',
                'DeleteRun',
                'DeleteTag',
                'DeleteTraceTag',
                'DeleteTraces',
                'EndTrace',
                'LogBatch',
                'LogInputs',
                'LogMetric',
                'LogModel',
                'LogParam',
                'RenameRegisteredModel',
                'RestoreExperiment',
                'RestoreRun',
                'SetExperimentTag',
                'SetModelVersionTag',
                'SetRegisteredModelAlias',
                'SetRegisteredModelTag',
                'SetTag',
                'SetTraceTag',
                'StartTrace',
                'TransitionModelVersionStage',
                'UpdateExperiment',
                'UpdateModelVersion',
                'UpdateRegisteredModel',
                'UpdateRun'
            ],
            List: [
                'GetLatestModelVersions',
                'ListArtifacts'
            ]
        };
    }
}
exports.SagemakerMlflow = SagemakerMlflow;
//# sourceMappingURL=data:application/json;base64,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