import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [serverlessrepo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Serverlessrepo extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create an application, optionally including an AWS SAM file to create the first application version in the same call
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications.html
     */
    toCreateApplication(): this;
    /**
     * Grants permission to create an application version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-versions-semanticversion.html
     */
    toCreateApplicationVersion(): this;
    /**
     * Grants permission to create an AWS CloudFormation ChangeSet for the given application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-changesets.html
     */
    toCreateCloudFormationChangeSet(): this;
    /**
     * Grants permission to create an AWS CloudFormation template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-templates.html
     */
    toCreateCloudFormationTemplate(): this;
    /**
     * Grants permission to delete the specified application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid.html
     */
    toDeleteApplication(): this;
    /**
     * Grants permission to get the specified application
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid.html
     */
    toGetApplication(): this;
    /**
     * Grants permission to get the policy for the specified application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-policy.html
     */
    toGetApplicationPolicy(): this;
    /**
     * Grants permission to get the specified AWS CloudFormation template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-templates-templateid.html
     */
    toGetCloudFormationTemplate(): this;
    /**
     * Grants permission to retrieve the list of applications nested in the containing application
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-dependencies.html
     */
    toListApplicationDependencies(): this;
    /**
     * Grants permission to list versions for the specified application owned by the requester
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-versions.html
     */
    toListApplicationVersions(): this;
    /**
     * Grants permission to list applications owned by the requester
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications.html
     */
    toListApplications(): this;
    /**
     * Grants permission to put the policy for the specified application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid-policy.html
     */
    toPutApplicationPolicy(): this;
    /**
     * Grants permission to get all applications authorized for this user
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifApplicationType()
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid.html
     */
    toSearchApplications(): this;
    /**
     * Grants permission to unshare the specified application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid.html
     */
    toUnshareApplication(): this;
    /**
     * Grants permission to update meta-data of the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications-applicationid.html
     */
    toUpdateApplication(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type applications to the statement
     *
     * https://docs.aws.amazon.com/serverlessrepo/latest/devguide/applications.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onApplications(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by application type
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/applications.html
     *
     * Applies to actions:
     * - .toCreateCloudFormationChangeSet()
     * - .toCreateCloudFormationTemplate()
     * - .toGetApplication()
     * - .toListApplicationDependencies()
     * - .toListApplicationVersions()
     * - .toSearchApplications()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifApplicationType(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [serverlessrepo](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserverlessapplicationrepository.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
