import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [scn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Scn extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add AWS Supply Chain administrator permission to federated user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toAssignAdminPermissionsToUser(): this;
    /**
     * Grants permission to create a BillOfMaterialsImportJob which will import a CSV file of BillOfMaterials records
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateBillOfMaterialsImportJob(): this;
    /**
     * Grants permission to create DataIntegrationFlow that can transform from multiple sources to one target
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateDataIntegrationFlow(): this;
    /**
     * Grants permission to create the data lake dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateDataLakeDataset(): this;
    /**
     * Grants permission to create the data lake namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateDataLakeNamespace(): this;
    /**
     * Grants permission to create a new AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateInstance(): this;
    /**
     * Grants permission to create IAM Identity Center application for a AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toCreateSSOApplication(): this;
    /**
     * Grants permission to delete the DataIntegrationFlow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteDataIntegrationFlow(): this;
    /**
     * Grants permission to delete the data lake dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteDataLakeDataset(): this;
    /**
     * Grants permission to delete the data lake namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteDataLakeNamespace(): this;
    /**
     * Grants permission to delete an AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteInstance(): this;
    /**
     * Grants permission to delete IAM Identity Center application of the AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDeleteSSOApplication(): this;
    /**
     * Grants permission to view details of an AWS Supply Chain instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toDescribeInstance(): this;
    /**
     * Grants permission to view status and details of a BillOfMaterialsImportJob
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetBillOfMaterialsImportJob(): this;
    /**
     * Grants permission to get a DataIntegrationEvent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetDataIntegrationEvent(): this;
    /**
     * Grants permission to get the DataIntegrationFlow details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetDataIntegrationFlow(): this;
    /**
     * Grants permission to get a particular execution of one specified DataIntegrationFlow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetDataIntegrationFlowExecution(): this;
    /**
     * Grants permission to get the dataset details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetDataLakeDataset(): this;
    /**
     * Grants permission to get the namespace details
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetDataLakeNamespace(): this;
    /**
     * Grants permission to view details of an AWS Supply Chain instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toGetInstance(): this;
    /**
     * Grants permission to list AWS Supply Chain administrators of an instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListAdminUsers(): this;
    /**
     * Grants permission to list all DataIntegrationEvents under an instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListDataIntegrationEvents(): this;
    /**
     * Grants permission to list all executions of one specified DataIntegrationFlow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListDataIntegrationFlowExecutions(): this;
    /**
     * Grants permission to list all the DataIntegrationFlows in a paginated way
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListDataIntegrationFlows(): this;
    /**
     * Grants permission to list the data lake datasets under specific instance and namespace
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListDataLakeDatasets(): this;
    /**
     * Grants permission to list the data lake namespaces under specific instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListDataLakeNamespaces(): this;
    /**
     * Grants permission to view the AWS Supply Chain instances associated with an AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListInstances(): this;
    /**
     * Grants permission to list tags for an AWS Supply Chain resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to remove AWS Supply Chain administrator permission from federated user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toRemoveAdminPermissionsForUser(): this;
    /**
     * Grants permission to create a DataIntegrationEvent which will ingest data in real-time
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toSendDataIntegrationEvent(): this;
    /**
     * Grants permission to tag an AWS Supply Chain resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tag from an AWS Supply Chain resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the DataIntegrationFlow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toUpdateDataIntegrationFlow(): this;
    /**
     * Grants permission to update the data lake dataset
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toUpdateDataLakeDataset(): this;
    /**
     * Grants permission to update the data lake namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toUpdateDataLakeNamespace(): this;
    /**
     * Grants permission to update an AWS Supply Chain instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     */
    toUpdateInstance(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onInstance(instanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type bill-of-materials-import-job to the statement
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBillOfMaterialsImportJob(instanceId: string, jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-integration-flow to the statement
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param flowName - Identifier for the flowName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataIntegrationFlow(instanceId: string, flowName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type namespace to the statement
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param namespace - Identifier for the namespace.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNamespace(instanceId: string, namespace: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type dataset to the statement
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param namespace - Identifier for the namespace.
     * @param datasetName - Identifier for the datasetName.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataset(instanceId: string, namespace: string, datasetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by using tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by using tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by using tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [scn](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupplychain.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
