"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupportConsole = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [support-console](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportconsole.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class SupportConsole extends shared_1.PolicyStatement {
    /**
     * Grants permission to check whether the account has access to given product
     *
     * Access Level: Read
     */
    toCheckSubscription() {
        return this.to('CheckSubscription');
    }
    /**
     * Grants permission to create or update case draft for the given case type
     *
     * Access Level: Write
     */
    toCreateCaseDraft() {
        return this.to('CreateCaseDraft');
    }
    /**
     * Grants permission to create an authenticated contact for the given contact type
     *
     * Access Level: Write
     */
    toCreateContact() {
        return this.to('CreateContact');
    }
    /**
     * Grants permission to delete a case draft for the given case type
     *
     * Access Level: Write
     */
    toDeleteCaseDraft() {
        return this.to('DeleteCaseDraft');
    }
    /**
     * Grants permission to get dynamic help resources for given service and category
     *
     * Access Level: Read
     */
    toDescribeDynamicHelp() {
        return this.to('DescribeDynamicHelp');
    }
    /**
     * Grants permission to determines whether the calling account is GovCloud enabled
     *
     * Access Level: Read
     */
    toGetAccountGovCloudEnabled() {
        return this.to('GetAccountGovCloudEnabled');
    }
    /**
     * Grants permission to get the state of the calling account
     *
     * Access Level: Read
     */
    toGetAccountState() {
        return this.to('GetAccountState');
    }
    /**
     * Grants permission to get the support banner information
     *
     * Access Level: Read
     */
    toGetBanner() {
        return this.to('GetBanner');
    }
    /**
     * Grants permission to get a case draft for given case type
     *
     * Access Level: Read
     */
    toGetCaseDraft() {
        return this.to('GetCaseDraft');
    }
    /**
     * Grants permission to get a feedback questionnaire
     *
     * Access Level: Read
     */
    toGetQuestionnaire() {
        return this.to('GetQuestionnaire');
    }
    /**
     * Grants permission to save questionnaire feedback
     *
     * Access Level: Write
     */
    toSaveFeedback() {
        return this.to('SaveFeedback');
    }
    /**
     * Statement provider for service [support-console](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportconsole.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'support-console';
        this.accessLevelList = {
            Read: [
                'CheckSubscription',
                'DescribeDynamicHelp',
                'GetAccountGovCloudEnabled',
                'GetAccountState',
                'GetBanner',
                'GetCaseDraft',
                'GetQuestionnaire'
            ],
            Write: [
                'CreateCaseDraft',
                'CreateContact',
                'DeleteCaseDraft',
                'SaveFeedback'
            ]
        };
    }
}
exports.SupportConsole = SupportConsole;
//# sourceMappingURL=data:application/json;base64,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