"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Supportrecommendations = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [supportrecommendations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportrecommendations.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Supportrecommendations extends shared_1.PolicyStatement {
    /**
     * Grants permission to the GetSupportTroubleshootingResponse API which lists troubleshooting responses for users' issues
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-recommendations.html/
     */
    toGetSupportTroubleshootingResponse() {
        return this.to('GetSupportTroubleshootingResponse');
    }
    /**
     * Grants permission to the StartSupportTroubleshooting API which starts troubleshooting for users' issues
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-recommendations.html/
     */
    toStartSupportTroubleshooting() {
        return this.to('StartSupportTroubleshooting');
    }
    /**
     * Statement provider for service [supportrecommendations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportrecommendations.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'supportrecommendations';
        this.accessLevelList = {
            Read: [
                'GetSupportTroubleshootingResponse',
                'StartSupportTroubleshooting'
            ]
        };
    }
}
exports.Supportrecommendations = Supportrecommendations;
//# sourceMappingURL=data:application/json;base64,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