import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [ssm-guiconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerguiconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsmGuiconnect extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to terminate a GUI Connect connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-manager-remote-desktop-connections.html
     */
    toCancelConnection(): this;
    /**
     * Grants permission to remove GUI Connect connection recording preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ssm-guiconnect/latest/APIReference/API_DeleteConnectionRecordingPreferences.html
     */
    toDeleteConnectionRecordingPreferences(): this;
    /**
     * Grants permission to get the metadata for a GUI Connect connection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-manager-remote-desktop-connections.html
     */
    toGetConnection(): this;
    /**
     * Grants permission to get GUI Connect connection recording preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ssm-guiconnect/latest/APIReference/API_GetConnectionRecordingPreferences.html
     */
    toGetConnectionRecordingPreferences(): this;
    /**
     * Grants permission to list the metadata for GUI Connect connections
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-manager-remote-desktop-connections.html
     */
    toListConnections(): this;
    /**
     * Grants permission to start a GUI Connect connection
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-manager-remote-desktop-connections.html
     */
    toStartConnection(): this;
    /**
     * Grants permission to update GUI Connect connection recording preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ssm-guiconnect/latest/APIReference/API_UpdateConnectionRecordingPreferences.html
     */
    toUpdateConnectionRecordingPreferences(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [ssm-guiconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerguiconnect.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
