import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Textract extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to detect instances of real-world document entities within an image provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     */
    toAnalyzeDocument(): this;
    /**
     * Grants permission to detect instances of real-world document entities within an image provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeExpense.html
     */
    toAnalyzeExpense(): this;
    /**
     * Grants permission to detect relevant information from identity documents provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeID.html
     */
    toAnalyzeID(): this;
    /**
     * Grants permission to create an Amazon Textract adapter
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_CreateAdapter.html
     */
    toCreateAdapter(): this;
    /**
     * Grants permission to create an Amazon Textract adapter version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_CreateAdapterVersion.html
     */
    toCreateAdapterVersion(): this;
    /**
     * Grants permission to delete an Amazon Textract adapter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DeleteAdapter.html
     */
    toDeleteAdapter(): this;
    /**
     * Grants permission to delete an Amazon Textract adapter version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DeleteAdapterVersion.html
     */
    toDeleteAdapterVersion(): this;
    /**
     * Grants permission to detect text in document images
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     */
    toDetectDocumentText(): this;
    /**
     * Grants permission to get an Amazon Textract adapter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetAdapter.html
     */
    toGetAdapter(): this;
    /**
     * Grants permission to get an Amazon Textract adapter version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetAdapterVersion.html
     */
    toGetAdapterVersion(): this;
    /**
     * Grants permission to return information about a document analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     */
    toGetDocumentAnalysis(): this;
    /**
     * Grants permission to return information about a document text detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     */
    toGetDocumentTextDetection(): this;
    /**
     * Grants permission to return information about an expense analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetExpenseAnalysis.html
     */
    toGetExpenseAnalysis(): this;
    /**
     * Grants permission to retrieve page-level information regarding a lending analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetLendingAnalysis.html
     */
    toGetLendingAnalysis(): this;
    /**
     * Grants permission to retrieve summarized information regarding a lending analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetLendingAnalysisSummary.html
     */
    toGetLendingAnalysisSummary(): this;
    /**
     * Grants permission to list Amazon Textract adapter versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_ListAdapterVersions.html
     */
    toListAdapterVersions(): this;
    /**
     * Grants permission to list Amazon Textract adapters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_ListAdapters.html
     */
    toListAdapters(): this;
    /**
     * Grants permission to return a list of tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     */
    toStartDocumentAnalysis(): this;
    /**
     * Grants permission to start an asynchronous job to detect text in document images or pdfs
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     */
    toStartDocumentTextDetection(): this;
    /**
     * Grants permission to start an asynchronous job to detect instances of invoices or receipts within an image or pdf provided as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartExpenseAnalysis.html
     */
    toStartExpenseAnalysis(): this;
    /**
     * Grants permission to start an asynchronous job for detection of entities in a lending document, takes a provided image or PDF as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartLendingAnalysis.html
     */
    toStartLendingAnalysis(): this;
    /**
     * Grants permission to add one or more tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update Amazon Textract adapter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_UpdateAdapter.html
     */
    toUpdateAdapter(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type adapter to the statement
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AdapterOverview.html
     *
     * @param adapterId - Identifier for the adapterId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAdapter(adapterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type adapterversion to the statement
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AdapterVersionOverview.html
     *
     * @param adapterId - Identifier for the adapterId.
     * @param adapterVersion - Identifier for the adapterVersion.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAdapterversion(adapterId: string, adapterVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAdapter()
     * - .toCreateAdapterVersion()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to resource types:
     * - adapter
     * - adapterversion
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAdapter()
     * - .toCreateAdapterVersion()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
