"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserSubscriptions = void 0;
const shared_1 = require("../../shared");
/**
 * Statement provider for service [user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusersubscriptions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class UserSubscriptions extends shared_1.PolicyStatement {
    /**
     * Grants permission to create a User subscription Claim
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCreateForSelf()
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toCreateClaim() {
        return this.to('CreateClaim');
    }
    /**
     * Grants permission to delete a User subscription Claim
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toDeleteClaim() {
        return this.to('DeleteClaim');
    }
    /**
     * Grants permission to list all User subscription Claims for Application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toListApplicationClaims() {
        return this.to('ListApplicationClaims');
    }
    /**
     * Grants permission to list all User subscription Claims
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toListClaims() {
        return this.to('ListClaims');
    }
    /**
     * Grants permission to list all User subscriptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toListUserSubscriptions() {
        return this.to('ListUserSubscriptions');
    }
    /**
     * Grants permission to update a User subscription Claim
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security_iam_permissions.html
     */
    toUpdateClaim() {
        return this.to('UpdateClaim');
    }
    /**
     * Filters access by only allowing creation of User subscription Claims for the caller
     *
     * https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/security-iam-service-with-iam.html#security_iam_service-with-iam-id-based-policies-conditionkeys
     *
     * Applies to actions:
     * - .toCreateClaim()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifCreateForSelf(value) {
        return this.if(`CreateForSelf`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Statement provider for service [user-subscriptions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsusersubscriptions.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'user-subscriptions';
        this.accessLevelList = {
            Write: [
                'CreateClaim',
                'DeleteClaim',
                'UpdateClaim'
            ],
            List: [
                'ListApplicationClaims',
                'ListClaims',
                'ListUserSubscriptions'
            ]
        };
    }
}
exports.UserSubscriptions = UserSubscriptions;
//# sourceMappingURL=data:application/json;base64,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