import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [vpc-lattice](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonvpclattice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class VpcLattice extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a resource configuration through Amazon EventBridge and AWS Step Functions service networks
     *
     * Access Level: Permissions management
     */
    toAssociateViaAWSServiceEventsAndStates(): this;
    /**
     * Grants permission to create an access log subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:GetLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateAccessLogSubscription.html
     */
    toCreateAccessLogSubscription(): this;
    /**
     * Grants permission to create a listener
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifProtocol()
     * - .ifTargetGroupArns()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateListener.html
     */
    toCreateListener(): this;
    /**
     * Grants permission to create a resource configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateResourceConfiguration.html
     */
    toCreateResourceConfiguration(): this;
    /**
     * Grants permission to create a resource gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVpcId()
     *
     * Dependent actions:
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateResourceGateway.html
     */
    toCreateResourceGateway(): this;
    /**
     * Grants permission to create a rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifTargetGroupArns()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateRule.html
     */
    toCreateRule(): this;
    /**
     * Grants permission to create a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAuthType()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateService.html
     */
    toCreateService(): this;
    /**
     * Grants permission to create a service network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifAuthType()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetwork.html
     */
    toCreateServiceNetwork(): this;
    /**
     * Grants permission to create an association between a service network and a resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifResourceConfigurationArn()
     * - .ifServiceNetworkArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetworkResourceAssociation.html
     */
    toCreateServiceNetworkResourceAssociation(): this;
    /**
     * Grants permission to create a service network and service association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifServiceArn()
     * - .ifServiceNetworkArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetworkServiceAssociation.html
     */
    toCreateServiceNetworkServiceAssociation(): this;
    /**
     * Grants permission to create a service network and VPC association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifSecurityGroupIds()
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateServiceNetworkVpcAssociation.html
     */
    toCreateServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to create an association between a service network and VPC endpoint
     *
     * Access Level: Permissions management
     */
    toCreateServiceNetworkVpcEndpointAssociation(): this;
    /**
     * Grants permission to create a target group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifVpcId()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_CreateTargetGroup.html
     */
    toCreateTargetGroup(): this;
    /**
     * Grants permission to delete an access log subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - logs:DeleteLogDelivery
     * - logs:GetLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteAccessLogSubscription.html
     */
    toDeleteAccessLogSubscription(): this;
    /**
     * Grants permission to delete an auth policy
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteAuthPolicy.html
     */
    toDeleteAuthPolicy(): this;
    /**
     * Grants permission to delete a listener
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteListener.html
     */
    toDeleteListener(): this;
    /**
     * Grants permission to delete a resource configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteResourceConfiguration.html
     */
    toDeleteResourceConfiguration(): this;
    /**
     * Grants permission to delete a resource endpoint association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteResourceEndpointAssociation.html
     */
    toDeleteResourceEndpointAssociation(): this;
    /**
     * Grants permission to delete a resource gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteResourceGateway.html
     */
    toDeleteResourceGateway(): this;
    /**
     * Grants permission to delete a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteRule.html
     */
    toDeleteRule(): this;
    /**
     * Grants permission to delete a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteService.html
     */
    toDeleteService(): this;
    /**
     * Grants permission to delete a service network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetwork.html
     */
    toDeleteServiceNetwork(): this;
    /**
     * Grants permission to delete the association between a service network and resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetworkResourceAssociation.html
     */
    toDeleteServiceNetworkResourceAssociation(): this;
    /**
     * Grants permission to delete a service network service association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifServiceArn()
     * - .ifServiceNetworkArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetworkServiceAssociation.html
     */
    toDeleteServiceNetworkServiceAssociation(): this;
    /**
     * Grants permission to delete a service network and VPC association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteServiceNetworkVpcAssociation.html
     */
    toDeleteServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to delete a target group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeleteTargetGroup.html
     */
    toDeleteTargetGroup(): this;
    /**
     * Grants permission to deregister targets from a target group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_DeregisterTargets.html
     */
    toDeregisterTargets(): this;
    /**
     * Grants permission to get information about an access log subscription
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - logs:GetLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetAccessLogSubscription.html
     */
    toGetAccessLogSubscription(): this;
    /**
     * Grants permission to get information about an auth policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetAuthPolicy.html
     */
    toGetAuthPolicy(): this;
    /**
     * Grants permission to get information about a listener
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetListener.html
     */
    toGetListener(): this;
    /**
     * Grants permission to get information about a resource configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetResourceConfiguration.html
     */
    toGetResourceConfiguration(): this;
    /**
     * Grants permission to get information about a resource gateway
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetResourceGateway.html
     */
    toGetResourceGateway(): this;
    /**
     * Grants permission to get information about a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetResourcePolicy.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to get information about a rule
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetRule.html
     */
    toGetRule(): this;
    /**
     * Grants permission to get information about a service
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetService.html
     */
    toGetService(): this;
    /**
     * Grants permission to get information about a service network
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetwork.html
     */
    toGetServiceNetwork(): this;
    /**
     * Grants permission to get information about an association between a service network and resource configuration
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetworkResourceAssociation.html
     */
    toGetServiceNetworkResourceAssociation(): this;
    /**
     * Grants permission to get information about a service network and service association
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifServiceArn()
     * - .ifServiceNetworkArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetworkServiceAssociation.html
     */
    toGetServiceNetworkServiceAssociation(): this;
    /**
     * Grants permission to get information about a service network and VPC association
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetServiceNetworkVpcAssociation.html
     */
    toGetServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to get information about a target group
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_GetTargetGroup.html
     */
    toGetTargetGroup(): this;
    /**
     * Grants permission to list some or all access log subscriptions about a service network or a service
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListAccessLogSubscriptions.html
     */
    toListAccessLogSubscriptions(): this;
    /**
     * Grants permission to list some or all listeners
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListListeners.html
     */
    toListListeners(): this;
    /**
     * Grants permission to list some or all resource configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListResourceConfigurations.html
     */
    toListResourceConfigurations(): this;
    /**
     * Grants permission to list some or all associations between a resource configuration and VPC endpoint
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifResourceConfigurationArn()
     * - .ifVpcEndpointId()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListResourceEndpointAssociations.html
     */
    toListResourceEndpointAssociations(): this;
    /**
     * Grants permission to list some or all resource gateways
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListResourceGateways.html
     */
    toListResourceGateways(): this;
    /**
     * Grants permission to list some or all rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListRules.html
     */
    toListRules(): this;
    /**
     * Grants permission to list some or all associations between a service network and resource configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworkResourceAssociations.html
     */
    toListServiceNetworkResourceAssociations(): this;
    /**
     * Grants permission to list some or all service network and service associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifServiceArn()
     * - .ifServiceNetworkArn()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworkServiceAssociations.html
     */
    toListServiceNetworkServiceAssociations(): this;
    /**
     * Grants permission to list some or all service network and VPC associations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworkVpcAssociations.html
     */
    toListServiceNetworkVpcAssociations(): this;
    /**
     * Grants permission to list some or all associations between a service network and VPC endpoint
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworkVpcEndpointAssociations.html
     */
    toListServiceNetworkVpcEndpointAssociations(): this;
    /**
     * Grants permission to list the service networks owned by a caller account or shared with the caller account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServiceNetworks.html
     */
    toListServiceNetworks(): this;
    /**
     * Grants permission to list the services owned by a caller account or shared with the caller account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListServices.html
     */
    toListServices(): this;
    /**
     * Grants permission to list tags for a vpc-lattice resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list some or all target groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListTargetGroups.html
     */
    toListTargetGroups(): this;
    /**
     * Grants permission to list some or all targets in a target group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_ListTargets.html
     */
    toListTargets(): this;
    /**
     * Grants permission to create or update the auth policy for a service network or a service
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_PutAuthPolicy.html
     */
    toPutAuthPolicy(): this;
    /**
     * Grants permission to create a resource policy for a resource configuration, service, or service network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to register targets to a target group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_RegisterTargets.html
     */
    toRegisterTargets(): this;
    /**
     * Grants permission to tag a vpc-lattice resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a vpc-lattice resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an access log subscription
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - logs:GetLogDelivery
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateAccessLogSubscription.html
     */
    toUpdateAccessLogSubscription(): this;
    /**
     * Grants permission to update a listener
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifTargetGroupArns()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateListener.html
     */
    toUpdateListener(): this;
    /**
     * Grants permission to update a resource configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateResourceConfiguration.html
     */
    toUpdateResourceConfiguration(): this;
    /**
     * Grants permission to update a resource gateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateResourceGateway.html
     */
    toUpdateResourceGateway(): this;
    /**
     * Grants permission to update a rule
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifTargetGroupArns()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateRule.html
     */
    toUpdateRule(): this;
    /**
     * Grants permission to update a service
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAuthType()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateService.html
     */
    toUpdateService(): this;
    /**
     * Grants permission to update a service network
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAuthType()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateServiceNetwork.html
     */
    toUpdateServiceNetwork(): this;
    /**
     * Grants permission to update a service network and VPC association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifSecurityGroupIds()
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     *
     * Dependent actions:
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateServiceNetworkVpcAssociation.html
     */
    toUpdateServiceNetworkVpcAssociation(): this;
    /**
     * Grants permission to update a target group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/APIReference/API_UpdateTargetGroup.html
     */
    toUpdateTargetGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type AccessLogSubscription to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html
     *
     * @param accessLogSubscriptionId - Identifier for the accessLogSubscriptionId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onAccessLogSubscription(accessLogSubscriptionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Listener to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html
     *
     * @param serviceId - Identifier for the serviceId.
     * @param listenerId - Identifier for the listenerId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifProtocol()
     * - .ifTargetGroupArns()
     */
    onListener(serviceId: string, listenerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ResourceConfiguration to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/resource-configurations.html
     *
     * @param resourceConfigurationId - Identifier for the resourceConfigurationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     */
    onResourceConfiguration(resourceConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ResourceEndpointAssociation to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/resource-endpoint-associations.html
     *
     * @param resourceEndpointAssociationId - Identifier for the resourceEndpointAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifResourceConfigurationArn()
     * - .ifVpcEndpointId()
     */
    onResourceEndpointAssociation(resourceEndpointAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ResourceGateway to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/resource-gateways.html
     *
     * @param resourceGatewayId - Identifier for the resourceGatewayId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifVpcId()
     */
    onResourceGateway(resourceGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Rule to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules
     *
     * @param serviceId - Identifier for the serviceId.
     * @param listenerId - Identifier for the listenerId.
     * @param ruleId - Identifier for the ruleId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifTargetGroupArns()
     */
    onRule(serviceId: string, listenerId: string, ruleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Service to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html
     *
     * @param serviceId - Identifier for the serviceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAuthType()
     */
    onService(serviceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ServiceNetwork to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html
     *
     * @param serviceNetworkId - Identifier for the serviceNetworkId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifAuthType()
     */
    onServiceNetwork(serviceNetworkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ServiceNetworkResourceAssociation to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-resource-configuration
     *
     * @param serviceNetworkResourceAssociationId - Identifier for the serviceNetworkResourceAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifResourceConfigurationArn()
     * - .ifServiceNetworkArn()
     */
    onServiceNetworkResourceAssociation(serviceNetworkResourceAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ServiceNetworkServiceAssociation to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations
     *
     * @param serviceNetworkServiceAssociationId - Identifier for the serviceNetworkServiceAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifServiceArn()
     * - .ifServiceNetworkArn()
     */
    onServiceNetworkServiceAssociation(serviceNetworkServiceAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ServiceNetworkVpcAssociation to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations
     *
     * @param serviceNetworkVpcAssociationId - Identifier for the serviceNetworkVpcAssociationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifSecurityGroupIds()
     * - .ifServiceNetworkArn()
     * - .ifVpcId()
     */
    onServiceNetworkVpcAssociation(serviceNetworkVpcAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TargetGroup to the statement
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html
     *
     * @param targetGroupId - Identifier for the targetGroupId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     * - .ifAwsTagKeys()
     * - .ifVpcId()
     */
    onTargetGroup(targetGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the presence of tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateAccessLogSubscription()
     * - .toCreateListener()
     * - .toCreateResourceConfiguration()
     * - .toCreateResourceGateway()
     * - .toCreateRule()
     * - .toCreateService()
     * - .toCreateServiceNetwork()
     * - .toCreateServiceNetworkResourceAssociation()
     * - .toCreateServiceNetworkServiceAssociation()
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toCreateTargetGroup()
     * - .toTagResource()
     *
     * Applies to resource types:
     * - AccessLogSubscription
     * - Listener
     * - ResourceConfiguration
     * - ResourceEndpointAssociation
     * - ResourceGateway
     * - Rule
     * - Service
     * - ServiceNetwork
     * - ServiceNetworkResourceAssociation
     * - ServiceNetworkServiceAssociation
     * - ServiceNetworkVpcAssociation
     * - TargetGroup
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toDeleteAccessLogSubscription()
     * - .toDeleteListener()
     * - .toDeleteResourceConfiguration()
     * - .toDeleteResourceEndpointAssociation()
     * - .toDeleteResourceGateway()
     * - .toDeleteRule()
     * - .toDeleteService()
     * - .toDeleteServiceNetwork()
     * - .toDeleteServiceNetworkResourceAssociation()
     * - .toDeleteServiceNetworkServiceAssociation()
     * - .toDeleteServiceNetworkVpcAssociation()
     * - .toDeleteTargetGroup()
     * - .toGetAccessLogSubscription()
     * - .toGetListener()
     * - .toGetResourceConfiguration()
     * - .toGetResourceGateway()
     * - .toGetRule()
     * - .toGetService()
     * - .toGetServiceNetwork()
     * - .toGetServiceNetworkResourceAssociation()
     * - .toGetServiceNetworkServiceAssociation()
     * - .toGetServiceNetworkVpcAssociation()
     * - .toGetTargetGroup()
     * - .toTagResource()
     * - .toUpdateAccessLogSubscription()
     * - .toUpdateListener()
     * - .toUpdateResourceConfiguration()
     * - .toUpdateResourceGateway()
     * - .toUpdateRule()
     * - .toUpdateService()
     * - .toUpdateServiceNetwork()
     * - .toUpdateServiceNetworkVpcAssociation()
     * - .toUpdateTargetGroup()
     *
     * Applies to resource types:
     * - AccessLogSubscription
     * - Listener
     * - ResourceConfiguration
     * - ResourceEndpointAssociation
     * - ResourceGateway
     * - Rule
     * - Service
     * - ServiceNetwork
     * - ServiceNetworkResourceAssociation
     * - ServiceNetworkServiceAssociation
     * - ServiceNetworkVpcAssociation
     * - TargetGroup
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the presence of tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateAccessLogSubscription()
     * - .toCreateListener()
     * - .toCreateResourceConfiguration()
     * - .toCreateResourceGateway()
     * - .toCreateRule()
     * - .toCreateService()
     * - .toCreateServiceNetwork()
     * - .toCreateServiceNetworkResourceAssociation()
     * - .toCreateServiceNetworkServiceAssociation()
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toCreateTargetGroup()
     * - .toTagResource()
     * - .toUntagResource()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - AccessLogSubscription
     * - Listener
     * - ResourceConfiguration
     * - ResourceEndpointAssociation
     * - ResourceGateway
     * - Rule
     * - Service
     * - ServiceNetwork
     * - ServiceNetworkResourceAssociation
     * - ServiceNetworkServiceAssociation
     * - ServiceNetworkVpcAssociation
     * - TargetGroup
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the auth type specified in the request
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateService()
     * - .toCreateServiceNetwork()
     * - .toUpdateService()
     * - .toUpdateServiceNetwork()
     *
     * Applies to resource types:
     * - Service
     * - ServiceNetwork
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAuthType(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the protocol specified in the request
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateListener()
     *
     * Applies to resource types:
     * - Listener
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProtocol(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a resource configuration
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkResourceAssociation()
     * - .toListResourceEndpointAssociations()
     *
     * Applies to resource types:
     * - ResourceEndpointAssociation
     * - ServiceNetworkResourceAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifResourceConfigurationArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the IDs of security groups
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toUpdateResourceGateway()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - ServiceNetworkVpcAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSecurityGroupIds(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a service
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkServiceAssociation()
     * - .toDeleteServiceNetworkServiceAssociation()
     * - .toGetServiceNetworkServiceAssociation()
     * - .toListServiceNetworkServiceAssociations()
     *
     * Applies to resource types:
     * - ServiceNetworkServiceAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARN of a service network
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateServiceNetworkResourceAssociation()
     * - .toCreateServiceNetworkServiceAssociation()
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toDeleteServiceNetworkServiceAssociation()
     * - .toDeleteServiceNetworkVpcAssociation()
     * - .toGetServiceNetworkServiceAssociation()
     * - .toGetServiceNetworkVpcAssociation()
     * - .toListServiceNetworkServiceAssociations()
     * - .toListServiceNetworkVpcAssociations()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - ServiceNetworkResourceAssociation
     * - ServiceNetworkServiceAssociation
     * - ServiceNetworkVpcAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifServiceNetworkArn(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ARNs of target groups
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateListener()
     * - .toCreateRule()
     * - .toUpdateListener()
     * - .toUpdateRule()
     *
     * Applies to resource types:
     * - Listener
     * - Rule
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifTargetGroupArns(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a VPC endpoint
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toListResourceEndpointAssociations()
     *
     * Applies to resource types:
     * - ResourceEndpointAssociation
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcEndpointId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of a virtual private cloud (VPC)
     *
     * https://docs.aws.amazon.com/vpc-lattice/latest/ug/
     *
     * Applies to actions:
     * - .toCreateResourceGateway()
     * - .toCreateServiceNetworkVpcAssociation()
     * - .toCreateTargetGroup()
     * - .toDeleteServiceNetworkVpcAssociation()
     * - .toGetServiceNetworkVpcAssociation()
     * - .toListServiceNetworkVpcAssociations()
     * - .toUpdateServiceNetworkVpcAssociation()
     *
     * Applies to resource types:
     * - ResourceGateway
     * - ServiceNetworkVpcAssociation
     * - TargetGroup
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifVpcId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [vpc-lattice](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonvpclattice.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
