import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Wellarchitected extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to associate a lens to the specified workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_AssociateLenses.html
     */
    toAssociateLenses(): this;
    /**
     * Grants permission to associate a profile to the specified workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_AssociateProfiles.html
     */
    toAssociateProfiles(): this;
    /**
     * Grants permission to configure the integration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/setting-up-jira.html
     */
    toConfigureIntegration(): this;
    /**
     * Grants permission to an owner of a lens to share with other AWS accounts and IAM users
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateLensShare.html
     */
    toCreateLensShare(): this;
    /**
     * Grants permission to create a new lens version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateLensVersion.html
     */
    toCreateLensVersion(): this;
    /**
     * Grants permission to create a new milestone for the specified workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateMilestone.html
     */
    toCreateMilestone(): this;
    /**
     * Grants permission to create a new profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to an owner of a profile to share with other AWS accounts and IAM users
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateProfileShare.html
     */
    toCreateProfileShare(): this;
    /**
     * Grants permission to create a new review template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateReviewTemplate.html
     */
    toCreateReviewTemplate(): this;
    /**
     * Grants permission to an owner of a review template to share with other AWS accounts and IAM users
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateTemplateShare.html
     */
    toCreateTemplateShare(): this;
    /**
     * Grants permission to create a new workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifJiraProjectKey()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateWorkload.html
     */
    toCreateWorkload(): this;
    /**
     * Grants permission to share a workload with another account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateWorkloadShare.html
     */
    toCreateWorkloadShare(): this;
    /**
     * Grants permission to delete a lens
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteLens.html
     */
    toDeleteLens(): this;
    /**
     * Grants permission to delete an existing lens share
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteLensShare.html
     */
    toDeleteLensShare(): this;
    /**
     * Grants permission to delete a profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete an existing profile share
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteProfileShare.html
     */
    toDeleteProfileShare(): this;
    /**
     * Grants permission to delete an existing review template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteReviewTemplate.html
     */
    toDeleteReviewTemplate(): this;
    /**
     * Grants permission to delete an existing review template share
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteTemplateShare.html
     */
    toDeleteTemplateShare(): this;
    /**
     * Grants permission to delete an existing workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteWorkload.html
     */
    toDeleteWorkload(): this;
    /**
     * Grants permission to delete an existing workload share
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteWorkloadShare.html
     */
    toDeleteWorkloadShare(): this;
    /**
     * Grants permission to disassociate a lens from the specified workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DisassociateLenses.html
     */
    toDisassociateLenses(): this;
    /**
     * Grants permission to disassociate a profile from the specified workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DisassociateProfiles.html
     */
    toDisassociateProfiles(): this;
    /**
     * Grants permission to export an existing lens
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ExportLens.html
     */
    toExportLens(): this;
    /**
     * Grants permission to retrieve the specified answer from the specified lens review
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetAnswer.html
     */
    toGetAnswer(): this;
    /**
     * Grants permission to get consolidated report metrics or to generate the consolidated report PDF in this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetConsolidatedReport.html
     */
    toGetConsolidatedReport(): this;
    /**
     * Grants permission to get all settings for the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetGlobalSettings.html
     */
    toGetGlobalSettings(): this;
    /**
     * Grants permission to get an existing lens
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteLensShare.html
     */
    toGetLens(): this;
    /**
     * Grants permission to retrieve the specified lens review of the specified workload
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensReview.html
     */
    toGetLensReview(): this;
    /**
     * Grants permission to retrieve the report for the specified lens review
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensReviewReport.html
     */
    toGetLensReviewReport(): this;
    /**
     * Grants permission to get the difference between the specified lens version and latest available lens version
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensVersionDifference.html
     */
    toGetLensVersionDifference(): this;
    /**
     * Grants permission to retrieve the specified milestone of the specified workload
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetMilestone.html
     */
    toGetMilestone(): this;
    /**
     * Grants permission to retrieve the specified profile
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetProfile.html
     */
    toGetProfile(): this;
    /**
     * Grants permission to retrieve the specified profile template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetProfileTemplate.html
     */
    toGetProfileTemplate(): this;
    /**
     * Grants permission to retrieve the specified review template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetReviewTemplate.html
     */
    toGetReviewTemplate(): this;
    /**
     * Grants permission to retrieve the specified answer from the specified review template lens review
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetReviewTemplateAnswer.html
     */
    toGetReviewTemplateAnswer(): this;
    /**
     * Grants permission to retrieve the specified lens review of the specified review template
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetReviewTemplateLensReview.html
     */
    toGetReviewTemplateLensReview(): this;
    /**
     * Grants permission to retrieve the specified workload
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetWorkload.html
     */
    toGetWorkload(): this;
    /**
     * Grants permission to import a new lens
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ImportLens.html
     */
    toImportLens(): this;
    /**
     * Grants permission to list the answers from the specified lens review
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListAnswers.html
     */
    toListAnswers(): this;
    /**
     * Grants permission to list the check-details for the workload
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListCheckDetails.html
     */
    toListCheckDetails(): this;
    /**
     * Grants permission to list the check-summaries for the workload
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListCheckSummaries.html
     */
    toListCheckSummaries(): this;
    /**
     * Grants permission to list the improvements of the specified lens review
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensReviewImprovements.html
     */
    toListLensReviewImprovements(): this;
    /**
     * Grants permission to list the lens reviews of the specified workload
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensReviews.html
     */
    toListLensReviews(): this;
    /**
     * Grants permission to list all shares created for a lens
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensShares.html
     */
    toListLensShares(): this;
    /**
     * Grants permission to list the lenses available to this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLenses.html
     */
    toListLenses(): this;
    /**
     * Grants permission to list the milestones of the specified workload
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListMilestones.html
     */
    toListMilestones(): this;
    /**
     * Grants permission to list notifications related to the account or specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListNotifications.html
     */
    toListNotifications(): this;
    /**
     * Grants permission to list profile notifications related to specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListProfileNotifications.html
     */
    toListProfileNotifications(): this;
    /**
     * Grants permission to list all shares created for a profile
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListProfileShares.html
     */
    toListProfileShares(): this;
    /**
     * Grants permission to list the profiles available to this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to list the answers from the specified review template lens review
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListReviewTemplateAnswers.html
     */
    toListReviewTemplateAnswers(): this;
    /**
     * Grants permission to list the review templates available to this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListReviewTemplates.html
     */
    toListReviewTemplates(): this;
    /**
     * Grants permission to list the workload share invitations of the specified account or user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListShareInvitations.html
     */
    toListShareInvitations(): this;
    /**
     * Grants permission to list tags for a Well-Architected resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all shares created for a review template
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListTemplateShares.html
     */
    toListTemplateShares(): this;
    /**
     * Grants permission to list the workload shares of the specified workload
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListWorkloadShares.html
     */
    toListWorkloadShares(): this;
    /**
     * Grants permission to list the workloads in this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListWorkloads.html
     */
    toListWorkloads(): this;
    /**
     * Grants permission to tag a Well-Architected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a Well-Architected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update properties of the specified answer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateAnswer.html
     */
    toUpdateAnswer(): this;
    /**
     * Grants permission to manage all settings for the account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifJiraProjectKey()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateGlobalSettings.html
     */
    toUpdateGlobalSettings(): this;
    /**
     * Grants permission to update properties of the integration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateIntegration.html
     */
    toUpdateIntegration(): this;
    /**
     * Grants permission to update properties of the specified lens review
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateLensReview.html
     */
    toUpdateLensReview(): this;
    /**
     * Grants permission to update properties of the specified profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    /**
     * Grants permission to update properties of the specified review template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateReviewTemplate.html
     */
    toUpdateReviewTemplate(): this;
    /**
     * Grants permission to update properties of the specified review template answer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateReviewTemplateAnswer.html
     */
    toUpdateReviewTemplateAnswer(): this;
    /**
     * Grants permission to update properties of the specified review template lens review
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateReviewTemplateLensReview.html
     */
    toUpdateReviewTemplateLensReview(): this;
    /**
     * Grants permission to update status of the specified workload share invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateShareInvitation.html
     */
    toUpdateShareInvitation(): this;
    /**
     * Grants permission to update properties of the specified workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifJiraProjectKey()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateWorkload.html
     */
    toUpdateWorkload(): this;
    /**
     * Grants permission to update properties of the specified workload share
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateWorkloadShare.html
     */
    toUpdateWorkloadShare(): this;
    /**
     * Grants permission to upgrade the specified lens review to use the latest version of the associated lens
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpgradeLensReview.html
     */
    toUpgradeLensReview(): this;
    /**
     * Grants permission to upgrade the specified workload to use the latest version of the associated profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpgradeProfileVersion.html
     */
    toUpgradeProfileVersion(): this;
    /**
     * Grants permission to upgrade the specified lens review of the specified review template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpgradeReviewTemplateLensReview.html
     */
    toUpgradeReviewTemplateLensReview(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type workload to the statement
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_Workload.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkload(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type lens to the statement
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_Lens.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLens(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_Profile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type review-template to the statement
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ReviewTemplate.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReviewTemplate(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by tag key-value pairs in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCreateProfile()
     * - .toCreateReviewTemplate()
     * - .toCreateWorkload()
     * - .toImportLens()
     * - .toTagResource()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag key-value pairs attached to the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toAssociateLenses()
     * - .toAssociateProfiles()
     * - .toCreateLensShare()
     * - .toCreateLensVersion()
     * - .toCreateMilestone()
     * - .toCreateProfileShare()
     * - .toCreateTemplateShare()
     * - .toCreateWorkloadShare()
     * - .toDeleteLens()
     * - .toDeleteLensShare()
     * - .toDeleteProfile()
     * - .toDeleteProfileShare()
     * - .toDeleteReviewTemplate()
     * - .toDeleteTemplateShare()
     * - .toDeleteWorkload()
     * - .toDeleteWorkloadShare()
     * - .toDisassociateLenses()
     * - .toDisassociateProfiles()
     * - .toExportLens()
     * - .toGetAnswer()
     * - .toGetLens()
     * - .toGetLensReview()
     * - .toGetLensReviewReport()
     * - .toGetLensVersionDifference()
     * - .toGetMilestone()
     * - .toGetProfile()
     * - .toGetReviewTemplate()
     * - .toGetReviewTemplateAnswer()
     * - .toGetReviewTemplateLensReview()
     * - .toGetWorkload()
     * - .toListAnswers()
     * - .toListCheckDetails()
     * - .toListCheckSummaries()
     * - .toListLensReviewImprovements()
     * - .toListLensReviews()
     * - .toListLensShares()
     * - .toListMilestones()
     * - .toListProfileShares()
     * - .toListReviewTemplateAnswers()
     * - .toListTagsForResource()
     * - .toListTemplateShares()
     * - .toListWorkloadShares()
     * - .toUpdateAnswer()
     * - .toUpdateIntegration()
     * - .toUpdateLensReview()
     * - .toUpdateProfile()
     * - .toUpdateReviewTemplate()
     * - .toUpdateReviewTemplateAnswer()
     * - .toUpdateReviewTemplateLensReview()
     * - .toUpdateWorkload()
     * - .toUpdateWorkloadShare()
     * - .toUpgradeLensReview()
     * - .toUpgradeProfileVersion()
     * - .toUpgradeReviewTemplateLensReview()
     *
     * Applies to resource types:
     * - workload
     * - lens
     * - profile
     * - review-template
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by tag keys in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCreateProfile()
     * - .toCreateReviewTemplate()
     * - .toCreateWorkload()
     * - .toImportLens()
     * - .toTagResource()
     * - .toUntagResource()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by project key
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/userguide/security_iam_id-based-policy-examples.html
     *
     * Applies to actions:
     * - .toCreateWorkload()
     * - .toUpdateGlobalSettings()
     * - .toUpdateWorkload()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifJiraProjectKey(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
