import { AccessLevelList } from '../../shared/access-level';
import { PolicyStatement, Operator } from '../../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [workspaces](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspaces.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Workspaces extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to accept invitations from other AWS accounts to share the same configuration for WorkSpaces BYOL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AcceptAccountLinkInvitation.html
     */
    toAcceptAccountLinkInvitation(): this;
    /**
     * Grants permission to associate connection aliases with directories
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AssociateConnectionAlias.html
     */
    toAssociateConnectionAlias(): this;
    /**
     * Grants permission to associate IP access control groups with directories
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AssociateIpGroups.html
     */
    toAssociateIpGroups(): this;
    /**
     * Grants permission to associate a workspace application with a WorkSpace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AssociateWorkspaceApplication.html
     */
    toAssociateWorkspaceApplication(): this;
    /**
     * Grants permission to add rules to IP access control groups
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - workspaces:UpdateRulesOfIpGroup
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_AuthorizeIpRules.html
     */
    toAuthorizeIpRules(): this;
    /**
     * Grants permission to copy a WorkSpace image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - workspaces:DescribeWorkspaceImages
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CopyWorkspaceImage.html
     */
    toCopyWorkspaceImage(): this;
    /**
     * Grants permission to invite other AWS accounts to share the same configuration for WorkSpaces BYOL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateAccountLinkInvitation.html
     */
    toCreateAccountLinkInvitation(): this;
    /**
     * Grants permission to create an Amazon Connect client add-in within a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateConnectClientAddIn.html
     */
    toCreateConnectClientAddIn(): this;
    /**
     * Grants permission to create connection aliases for use with cross-Region redirection
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateConnectionAlias.html
     */
    toCreateConnectionAlias(): this;
    /**
     * Grants permission to create IP access control groups
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateIpGroup.html
     */
    toCreateIpGroup(): this;
    /**
     * Grants permission to create one or more Standby WorkSpaces
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateStandbyWorkspaces.html
     */
    toCreateStandbyWorkspaces(): this;
    /**
     * Grants permission to create tags for WorkSpaces resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateTags.html
     */
    toCreateTags(): this;
    /**
     * Grants permission to create an updated WorkSpace image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateUpdatedWorkspaceImage.html
     */
    toCreateUpdatedWorkspaceImage(): this;
    /**
     * Grants permission to create a WorkSpace bundle
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - workspaces:CreateTags
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateWorkspaceBundle.html
     */
    toCreateWorkspaceBundle(): this;
    /**
     * Grants permission to create a new WorkSpace image
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateWorkspaceImage.html
     */
    toCreateWorkspaceImage(): this;
    /**
     * Grants permission to create one or more WorkSpaces
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateWorkspaces.html
     */
    toCreateWorkspaces(): this;
    /**
     * Grants permission to create a WorkSpaces Pool
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_CreateWorkspacesPool.html
     */
    toCreateWorkspacesPool(): this;
    /**
     * Grants permission to delete invitations to other AWS accounts to share the same configuration for WorkSpaces BYOL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteAccountLinkInvitation.html
     */
    toDeleteAccountLinkInvitation(): this;
    /**
     * Grants permission to delete AWS WorkSpaces Client branding data within a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteClientBranding.html
     */
    toDeleteClientBranding(): this;
    /**
     * Grants permission to delete an Amazon Connect client add-in that is configured within a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteConnectClientAddIn.html
     */
    toDeleteConnectClientAddIn(): this;
    /**
     * Grants permission to delete connection aliases
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteConnectionAlias.html
     */
    toDeleteConnectionAlias(): this;
    /**
     * Grants permission to delete IP access control groups
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteIpGroup.html
     */
    toDeleteIpGroup(): this;
    /**
     * Grants permission to delete tags from WorkSpaces resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteTags.html
     */
    toDeleteTags(): this;
    /**
     * Grants permission to delete WorkSpace bundles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteWorkspaceBundle.html
     */
    toDeleteWorkspaceBundle(): this;
    /**
     * Grants permission to delete WorkSpace images
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeleteWorkspaceImage.html
     */
    toDeleteWorkspaceImage(): this;
    /**
     * Grants permission to deploy all pending workspace applications on a WorkSpace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeployWorkspaceApplications.html
     */
    toDeployWorkspaceApplications(): this;
    /**
     * Grants permission to deregister directories from use with Amazon WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DeregisterWorkspaceDirectory.html
     */
    toDeregisterWorkspaceDirectory(): this;
    /**
     * Grants permission to retrieve the configuration of Bring Your Own License (BYOL) for WorkSpaces accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeAccount.html
     */
    toDescribeAccount(): this;
    /**
     * Grants permission to retrieve modifications to the configuration of Bring Your Own License (BYOL) for WorkSpaces accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeAccountModifications.html
     */
    toDescribeAccountModifications(): this;
    /**
     * Grants permission to retrieve information about resources associated with a WorkSpace application
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeApplicationAssociations.html
     */
    toDescribeApplicationAssociations(): this;
    /**
     * Grants permission to obtain information about WorkSpace applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeApplications.html
     */
    toDescribeApplications(): this;
    /**
     * Grants permission to retrieve information about resources associated with a WorkSpace bundle
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeBundleAssociations.html
     */
    toDescribeBundleAssociations(): this;
    /**
     * Grants permission to retrieve AWS WorkSpaces Client branding data within a directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeClientBranding.html
     */
    toDescribeClientBranding(): this;
    /**
     * Grants permission to retrieve information about WorkSpaces clients
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeClientProperties.html
     */
    toDescribeClientProperties(): this;
    /**
     * Grants permission to retrieve a list of Amazon Connect client add-ins that have been created
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectClientAddIns.html
     */
    toDescribeConnectClientAddIns(): this;
    /**
     * Grants permission to retrieve the permissions that the owners of connection aliases have granted to other AWS accounts for connection aliases
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliasPermissions.html
     */
    toDescribeConnectionAliasPermissions(): this;
    /**
     * Grants permission to retrieve a list that describes the connection aliases used for cross-Region redirection
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html
     */
    toDescribeConnectionAliases(): this;
    /**
     * Grants permission to retrieve information about resources associated with a WorkSpace image
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeImageAssociations.html
     */
    toDescribeImageAssociations(): this;
    /**
     * Grants permission to retrieve information about IP access control groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeIpGroups.html
     */
    toDescribeIpGroups(): this;
    /**
     * Grants permission to describe the tags for WorkSpaces resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeTags.html
     */
    toDescribeTags(): this;
    /**
     * Grants permission to retrieve information about resources associated with a WorkSpace
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceAssociations.html
     */
    toDescribeWorkspaceAssociations(): this;
    /**
     * Grants permission to obtain information about WorkSpace bundles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceBundles.html
     */
    toDescribeWorkspaceBundles(): this;
    /**
     * Grants permission to retrieve information about directories that are registered with WorkSpaces
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html
     */
    toDescribeWorkspaceDirectories(): this;
    /**
     * Grants permission to retrieve information about WorkSpace image permissions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html
     */
    toDescribeWorkspaceImagePermissions(): this;
    /**
     * Grants permission to retrieve information about WorkSpace images
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html
     */
    toDescribeWorkspaceImages(): this;
    /**
     * Grants permission to retrieve information about WorkSpace snapshots
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceSnapshots.html
     */
    toDescribeWorkspaceSnapshots(): this;
    /**
     * Grants permission to obtain information about WorkSpaces
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html
     */
    toDescribeWorkspaces(): this;
    /**
     * Grants permission to obtain the connection status of WorkSpaces
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspacesConnectionStatus.html
     */
    toDescribeWorkspacesConnectionStatus(): this;
    /**
     * Grants permission to retrieve information about the sessions of a WorkSpaces Pool
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspacesPoolSessions.html
     */
    toDescribeWorkspacesPoolSessions(): this;
    /**
     * Grants permission to retrieve information about WorkSpaces Pools
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspacesPools.html
     */
    toDescribeWorkspacesPools(): this;
    /**
     * Grants permission to disassociate connection aliases from directories
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DisassociateConnectionAlias.html
     */
    toDisassociateConnectionAlias(): this;
    /**
     * Grants permission to disassociate IP access control groups from directories
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DisassociateIpGroups.html
     */
    toDisassociateIpGroups(): this;
    /**
     * Grants permission to disassociate a workspace application from a WorkSpace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_DisassociateWorkspaceApplication.html
     */
    toDisassociateWorkspaceApplication(): this;
    /**
     * Grants permission to retrieve a link with another AWS Account for sharing configuration for WorkSpaces BYOL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_GetAccountLink.html
     */
    toGetAccountLink(): this;
    /**
     * Grants permission to import AWS WorkSpaces Client branding data within a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ImportClientBranding.html
     */
    toImportClientBranding(): this;
    /**
     * Grants permission to import Bring Your Own License (BYOL) images into Amazon WorkSpaces
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeImages
     * - ec2:ModifyImageAttribute
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ImportWorkspaceImage.html
     */
    toImportWorkspaceImage(): this;
    /**
     * Grants permission to retrieve links with the AWS Account(s) that share your configuration for WorkSpaces BYOL
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ListAccountLinks.html
     */
    toListAccountLinks(): this;
    /**
     * Grants permission to list the available CIDR ranges for enabling Bring Your Own License (BYOL) for WorkSpaces accounts
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ListAvailableManagementCidrRanges.html
     */
    toListAvailableManagementCidrRanges(): this;
    /**
     * Grants permission to migrate WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_MigrateWorkspace.html
     */
    toMigrateWorkspace(): this;
    /**
     * Grants permission to modify the configuration of Bring Your Own License (BYOL) for WorkSpaces accounts
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyAccount.html
     */
    toModifyAccount(): this;
    /**
     * Grants permission to modify the certificate-based authorization properties of a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyCertificateBasedAuthProperties.html
     */
    toModifyCertificateBasedAuthProperties(): this;
    /**
     * Grants permission to modify the properties of WorkSpaces clients
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyClientProperties.html
     */
    toModifyClientProperties(): this;
    /**
     * Grants permission to configure the specified directory between Standard TLS and FIPS 140-2 validated mode
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyEndpointEncryptionMode.html
     */
    toModifyEndpointEncryptionMode(): this;
    /**
     * Grants permission to modify the SAML properties of a directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifySamlProperties.html
     */
    toModifySamlProperties(): this;
    /**
     * Grants permission to modify the self-service WorkSpace management capabilities for your users
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifySelfservicePermissions.html
     */
    toModifySelfservicePermissions(): this;
    /**
     * Grants permission to modify the streaming properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyStreamingProperties.html
     */
    toModifyStreamingProperties(): this;
    /**
     * Grants permission to specify which devices and operating systems users can use to access their WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceAccessProperties.html
     */
    toModifyWorkspaceAccessProperties(): this;
    /**
     * Grants permission to modify the default properties used to create WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceCreationProperties.html
     */
    toModifyWorkspaceCreationProperties(): this;
    /**
     * Grants permission to modify WorkSpace properties, including the running mode and the AutoStop period
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceProperties.html
     */
    toModifyWorkspaceProperties(): this;
    /**
     * Grants permission to modify the state of WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_ModifyWorkspaceState.html
     */
    toModifyWorkspaceState(): this;
    /**
     * Grants permission to reboot WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RebootWorkspaces.html
     */
    toRebootWorkspaces(): this;
    /**
     * Grants permission to rebuild WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RebuildWorkspaces.html
     */
    toRebuildWorkspaces(): this;
    /**
     * Grants permission to register directories for use with Amazon WorkSpaces
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RegisterWorkspaceDirectory.html
     */
    toRegisterWorkspaceDirectory(): this;
    /**
     * Grants permission to reject invitations from other AWS accounts to share the same configuration for WorkSpaces BYOL
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RejectAccountLinkInvitation.html
     */
    toRejectAccountLinkInvitation(): this;
    /**
     * Grants permission to restore WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RestoreWorkspace.html
     */
    toRestoreWorkspace(): this;
    /**
     * Grants permission to remove rules from IP access control groups
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - workspaces:UpdateRulesOfIpGroup
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_RevokeIpRules.html
     */
    toRevokeIpRules(): this;
    /**
     * Grants permission to start AutoStop WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_StartWorkspaces.html
     */
    toStartWorkspaces(): this;
    /**
     * Grants permission to start a WorkSpaces Pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_StartWorkspacesPool.html
     */
    toStartWorkspacesPool(): this;
    /**
     * Grants permission to stop AutoStop WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_StopWorkspaces.html
     */
    toStopWorkspaces(): this;
    /**
     * Grants permission to stop a WorkSpaces Pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_StopWorkspacesPool.html
     */
    toStopWorkspacesPool(): this;
    /**
     * Grants permission to federated users to sign in by using their existing credentials and stream their workspace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifUserId()
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_Stream.html
     */
    toStream(): this;
    /**
     * Grants permission to terminate WorkSpaces
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_TerminateWorkspaces.html
     */
    toTerminateWorkspaces(): this;
    /**
     * Grants permission to terminate a WorkSpaces Pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_TerminateWorkspacesPool.html
     */
    toTerminateWorkspacesPool(): this;
    /**
     * Grants permission to terminate a WorkSpaces Pool session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_TerminateWorkspacesPoolSession.html
     */
    toTerminateWorkspacesPoolSession(): this;
    /**
     * Grants permission to update an Amazon Connect client add-in. Use this action to update the name and endpoint URL of an Amazon Connect client add-in
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateConnectClientAddIn.html
     */
    toUpdateConnectClientAddIn(): this;
    /**
     * Grants permission to share or unshare connection aliases with other accounts
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateConnectionAliasPermission.html
     */
    toUpdateConnectionAliasPermission(): this;
    /**
     * Grants permission to replace rules for IP access control groups
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - workspaces:AuthorizeIpRules
     * - workspaces:RevokeIpRules
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateRulesOfIpGroup.html
     */
    toUpdateRulesOfIpGroup(): this;
    /**
     * Grants permission to update the WorkSpace images used in WorkSpace bundles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateWorkspaceBundle.html
     */
    toUpdateWorkspaceBundle(): this;
    /**
     * Grants permission to share or unshare WorkSpace images with other accounts by specifying whether other accounts have permission to copy the image
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateWorkspaceImagePermission.html
     */
    toUpdateWorkspaceImagePermission(): this;
    /**
     * Grants permission to update the WorkSpaces pool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workspaces/latest/api/API_UpdateWorkspacesPool.html
     */
    toUpdateWorkspacesPool(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type directoryid to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/manage-workspaces-directory.html
     *
     * @param directoryId - Identifier for the directoryId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDirectoryid(directoryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workspacebundle to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/bundles.html
     *
     * @param bundleId - Identifier for the bundleId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspacebundle(bundleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workspaceid to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/wsp_workspace_management.html
     *
     * @param workspaceId - Identifier for the workspaceId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspaceid(workspaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workspaceimage to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/bundles.html
     *
     * @param imageId - Identifier for the imageId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspaceimage(imageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workspaceipgroup to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-ip-access-control-groups.html
     *
     * @param groupId - Identifier for the groupId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspaceipgroup(groupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workspacespoolid to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-pool.html
     *
     * @param poolId - Identifier for the poolId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspacespoolid(poolId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type connectionalias to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html
     *
     * @param connectionAliasId - Identifier for the connectionAliasId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConnectionalias(connectionAliasId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workspaceapplication to the statement
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/application-bundle-management.html
     *
     * @param workSpaceApplicationId - Identifier for the workSpaceApplicationId.
     * @param account - Account of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's account.
     * @param region - Region of the resource; defaults to `*`, unless using the CDK, where the default is the current Stack's region.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkspaceapplication(workSpaceApplicationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the tags that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-requesttag
     *
     * Applies to actions:
     * - .toCopyWorkspaceImage()
     * - .toCreateConnectionAlias()
     * - .toCreateIpGroup()
     * - .toCreateStandbyWorkspaces()
     * - .toCreateTags()
     * - .toCreateUpdatedWorkspaceImage()
     * - .toCreateWorkspaceBundle()
     * - .toCreateWorkspaceImage()
     * - .toCreateWorkspaces()
     * - .toCreateWorkspacesPool()
     * - .toDeleteTags()
     * - .toRegisterWorkspaceDirectory()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsRequestTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tags associated with the resource
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-resourcetag
     *
     * Applies to actions:
     * - .toAssociateWorkspaceApplication()
     * - .toDeployWorkspaceApplications()
     * - .toDescribeApplicationAssociations()
     * - .toDescribeBundleAssociations()
     * - .toDescribeImageAssociations()
     * - .toDescribeWorkspaceAssociations()
     * - .toDisassociateWorkspaceApplication()
     *
     * Applies to resource types:
     * - directoryid
     * - workspacebundle
     * - workspaceid
     * - workspaceimage
     * - workspaceipgroup
     * - workspacespoolid
     * - connectionalias
     * - workspaceapplication
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access based on the tag keys that are passed in the request
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-tagkeys
     *
     * Applies to actions:
     * - .toCopyWorkspaceImage()
     * - .toCreateConnectionAlias()
     * - .toCreateIpGroup()
     * - .toCreateStandbyWorkspaces()
     * - .toCreateTags()
     * - .toCreateUpdatedWorkspaceImage()
     * - .toCreateWorkspaceBundle()
     * - .toCreateWorkspaceImage()
     * - .toCreateWorkspaces()
     * - .toCreateWorkspacesPool()
     * - .toDeleteTags()
     * - .toRegisterWorkspaceDirectory()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAwsTagKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the ID of the Workspaces user
     *
     * https://docs.aws.amazon.com/workspaces/latest/adminguide/external-identity-providers-setting-up-saml.html#external-identity-providers-embed-inline-policy-for-IAM-role
     *
     * Applies to actions:
     * - .toStream()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifUserId(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [workspaces](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkspaces.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
