import { PolicyStatementWithActions } from './3-actions';
import { aws_iam as _iam } from "aws-cdk-lib";
export type ResourceTypes = Record<string, ResourceType>;
export interface ResourceType {
    name: string;
    url: string;
    arn: string;
    conditionKeys: string[];
}
/**
 * Adds "resource" functionality to the Policy Statement
 */
export declare class PolicyStatementWithResources extends PolicyStatementWithActions {
    private useNotResource;
    protected floydResources: string[];
    protected skipAutoResource: boolean;
    private cdkResourcesApplied;
    /**
     * Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON(): any;
    toStatementJson(): any;
    freeze(): _iam.PolicyStatement;
    private cdkApplyResources;
    /**
     * Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     */
    notResource(): this;
    /**
     * Checks weather any resource was applied to the policy.
     */
    hasResources(): boolean;
    /**
     * Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     */
    on(...arns: string[]): this;
    /**
     * Add all resources (`*`) to the statement
     *
     * This is the default behavior, unless the statement has principals.
     */
    onAllResources(): this;
    private ensureResource;
}
