"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = void 0;
// This file is used in the CDK variant of the package: cdk-iam-floyd
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _4_resources_1 = require("./4-resources");
/**
 * Adds "effect" functionality to the Policy Statement
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        // @ts-ignore only available after swapping 1-base
        statement.Effect = this.effect;
        return statement;
    }
    /**
     * Allow the actions in this statement
     */
    allow() {
        // @ts-ignore only available after swapping 1-base
        this.effect = aws_cdk_lib_1.aws_iam.Effect.ALLOW;
        return this;
    }
    /**
     * Deny the actions in this statement
     */
    deny() {
        // @ts-ignore only available after swapping 1-base
        this.effect = aws_cdk_lib_1.aws_iam.Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
//# sourceMappingURL=data:application/json;base64,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