"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import agent.agent.v1alpha.common_pb2
import agent.agent.v1alpha.table_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class AgentConfig(google.protobuf.message.Message):
    """AgentConfig represents the config for the chat agent."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ConnectionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTRUCTIONS_FIELD_NUMBER: builtins.int
    CONNECTIONS_FIELD_NUMBER: builtins.int
    instructions: builtins.str
    """instructions"""
    @property
    def connections(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """connection key(used connection id in recipe) and value(connection uid from namespace)."""
    def __init__(
        self,
        *,
        instructions: builtins.str = ...,
        connections: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["connections", b"connections", "instructions", b"instructions"]) -> None: ...

global___AgentConfig = AgentConfig

@typing_extensions.final
class Chat(google.protobuf.message.Message):
    """Chat represents a chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AGENT_CONFIG_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    DELETE_TIME_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """unique identifier of the conversation created by the system."""
    namespace_id: builtins.str
    """namespace id."""
    chat_display_name: builtins.str
    """conversation display name."""
    @property
    def agent_config(self) -> global___AgentConfig:
        """agent config."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """chat create time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """chat update time."""
    @property
    def delete_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """chat delete time."""
    catalog_id: builtins.str
    """catalog id"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        namespace_id: builtins.str = ...,
        chat_display_name: builtins.str = ...,
        agent_config: global___AgentConfig | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        delete_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "create_time", b"create_time", "delete_time", b"delete_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "catalog_id", b"catalog_id", "chat_display_name", b"chat_display_name", "create_time", b"create_time", "delete_time", b"delete_time", "namespace_id", b"namespace_id", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___Chat = Chat

@typing_extensions.final
class Message(google.protobuf.message.Message):
    """Message represents a single message in a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MessageType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MessageTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Message._MessageType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MESSAGE_TYPE_UNSPECIFIED: Message._MessageType.ValueType  # 0
        """unspecified"""
        MESSAGE_TYPE_TEXT: Message._MessageType.ValueType  # 1
        """text"""

    class MessageType(_MessageType, metaclass=_MessageTypeEnumTypeWrapper):
        """message type"""

    MESSAGE_TYPE_UNSPECIFIED: Message.MessageType.ValueType  # 0
    """unspecified"""
    MESSAGE_TYPE_TEXT: Message.MessageType.ValueType  # 1
    """text"""

    UID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    MSG_SENDER_UID_FIELD_NUMBER: builtins.int
    CITATIONS_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    ENABLE_WEB_SEARCH_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """message uid"""
    chat_uid: builtins.str
    """chat uid"""
    content: builtins.str
    """message content"""
    role: builtins.str
    """message role e.g., "user" or "assistant" or "agent" """
    type: global___Message.MessageType.ValueType
    """message type"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the message"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """update time of the message"""
    msg_sender_uid: builtins.str
    """message sender uid(only for user messages)"""
    @property
    def citations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[agent.agent.v1alpha.common_pb2.Citation]:
        """citations (only for agent messages)"""
    @property
    def context(self) -> global___ChatContext:
        """context for the message"""
    @property
    def attachments(self) -> global___ChatAttachments:
        """attachments for the message"""
    enable_web_search: builtins.bool
    """enable web search (only for user messages)"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        chat_uid: builtins.str = ...,
        content: builtins.str = ...,
        role: builtins.str = ...,
        type: global___Message.MessageType.ValueType = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        msg_sender_uid: builtins.str = ...,
        citations: collections.abc.Iterable[agent.agent.v1alpha.common_pb2.Citation] | None = ...,
        context: global___ChatContext | None = ...,
        attachments: global___ChatAttachments | None = ...,
        enable_web_search: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attachments", b"attachments", "context", b"context", "create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attachments", b"attachments", "chat_uid", b"chat_uid", "citations", b"citations", "content", b"content", "context", b"context", "create_time", b"create_time", "enable_web_search", b"enable_web_search", "msg_sender_uid", b"msg_sender_uid", "role", b"role", "type", b"type", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___Message = Message

@typing_extensions.final
class ChatContext(google.protobuf.message.Message):
    """The context for the message."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_UIDS_FIELD_NUMBER: builtins.int
    @property
    def table_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The table uids to include in the context."""
    def __init__(
        self,
        *,
        table_uids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["table_uids", b"table_uids"]) -> None: ...

global___ChatContext = ChatContext

@typing_extensions.final
class ChatAttachments(google.protobuf.message.Message):
    """ChatAttachments represents the attachment for the message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILE_URLS_FIELD_NUMBER: builtins.int
    @property
    def file_urls(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """file urls (only for user messages)"""
    def __init__(
        self,
        *,
        file_urls: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_urls", b"file_urls"]) -> None: ...

global___ChatAttachments = ChatAttachments

@typing_extensions.final
class CreateChatRequest(google.protobuf.message.Message):
    """CreateChatRequest is used to create a new chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AGENT_CONFIG_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    chat_display_name: builtins.str
    """chat display name"""
    @property
    def agent_config(self) -> global___AgentConfig:
        """agent config"""
    catalog_id: builtins.str
    """catalog id"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_display_name: builtins.str = ...,
        agent_config: global___AgentConfig | None = ...,
        catalog_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "catalog_id", b"catalog_id", "chat_display_name", b"chat_display_name", "namespace_id", b"namespace_id"]) -> None: ...

global___CreateChatRequest = CreateChatRequest

@typing_extensions.final
class CreateChatResponse(google.protobuf.message.Message):
    """CreateChatResponse returns the created chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAT_FIELD_NUMBER: builtins.int
    @property
    def chat(self) -> global___Chat:
        """chat"""
    def __init__(
        self,
        *,
        chat: global___Chat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chat", b"chat"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat", b"chat"]) -> None: ...

global___CreateChatResponse = CreateChatResponse

@typing_extensions.final
class ListChatsRequest(google.protobuf.message.Message):
    """ListChatsRequest is used to list chats"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    IF_ALL_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    page_size: builtins.int
    """page size"""
    page_token: builtins.str
    """page token"""
    if_all: builtins.bool
    """if true, all chats will be returned. This has higher priority over page_size and page_token."""
    chat_uid: builtins.str
    """chat_uid this is optional, if provided, only the chat with the given chat_uid will be returned
    first check chat_uid then check if_all
    """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        if_all: builtins.bool = ...,
        chat_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "if_all", b"if_all", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListChatsRequest = ListChatsRequest

@typing_extensions.final
class ListChatsResponse(google.protobuf.message.Message):
    """ListChatsResponse returns a list of chats"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHATS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def chats(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Chat]:
        """chats"""
    next_page_token: builtins.str
    """next page token"""
    total_size: builtins.int
    """total size"""
    def __init__(
        self,
        *,
        chats: collections.abc.Iterable[global___Chat] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chats", b"chats", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListChatsResponse = ListChatsResponse

@typing_extensions.final
class UpdateChatRequest(google.protobuf.message.Message):
    """UpdateChatRequest is used to update a chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    CHAT_DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AGENT_CONFIG_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    chat_uid: builtins.str
    """chat uid"""
    chat_display_name: builtins.str
    """chat display name"""
    @property
    def agent_config(self) -> global___AgentConfig:
        """ai agent settings"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
        chat_display_name: builtins.str = ...,
        agent_config: global___AgentConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "chat_display_name", b"chat_display_name", "chat_uid", b"chat_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___UpdateChatRequest = UpdateChatRequest

@typing_extensions.final
class UpdateChatResponse(google.protobuf.message.Message):
    """UpdateChatResponse returns the updated chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAT_FIELD_NUMBER: builtins.int
    @property
    def chat(self) -> global___Chat:
        """chat"""
    def __init__(
        self,
        *,
        chat: global___Chat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chat", b"chat"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat", b"chat"]) -> None: ...

global___UpdateChatResponse = UpdateChatResponse

@typing_extensions.final
class GetChatRequest(google.protobuf.message.Message):
    """GetChatRequest is used to get a chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    chat_uid: builtins.str
    """chat uid"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___GetChatRequest = GetChatRequest

@typing_extensions.final
class GetChatResponse(google.protobuf.message.Message):
    """GetChatResponse returns the chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHAT_FIELD_NUMBER: builtins.int
    @property
    def chat(self) -> global___Chat:
        """chat"""
    def __init__(
        self,
        *,
        chat: global___Chat | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chat", b"chat"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat", b"chat"]) -> None: ...

global___GetChatResponse = GetChatResponse

@typing_extensions.final
class DeleteChatRequest(google.protobuf.message.Message):
    """DeleteChatRequest is used to delete a chat"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    chat_uid: builtins.str
    """chat uid"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___DeleteChatRequest = DeleteChatRequest

@typing_extensions.final
class DeleteChatResponse(google.protobuf.message.Message):
    """DeleteChatResponse is empty as no content needs to be returned"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteChatResponse = DeleteChatResponse

@typing_extensions.final
class MessageSenderProfile(google.protobuf.message.Message):
    """MessageSenderProfile describes the public data of a message sender.
    refer to core.mgmt.v1beta.UserProfile for more details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MSG_SENDER_UID_FIELD_NUMBER: builtins.int
    MSG_SENDER_ID_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    msg_sender_uid: builtins.str
    """sender uid"""
    msg_sender_id: builtins.str
    """sender id"""
    display_name: builtins.str
    """Display name."""
    avatar: builtins.str
    """Avatar url. this url might be expired or not exist."""
    def __init__(
        self,
        *,
        msg_sender_uid: builtins.str = ...,
        msg_sender_id: builtins.str = ...,
        display_name: builtins.str | None = ...,
        avatar: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_display_name", b"_display_name", "avatar", b"avatar", "display_name", b"display_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_display_name", b"_display_name", "avatar", b"avatar", "display_name", b"display_name", "msg_sender_id", b"msg_sender_id", "msg_sender_uid", b"msg_sender_uid"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_avatar", b"_avatar"]) -> typing_extensions.Literal["avatar"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_display_name", b"_display_name"]) -> typing_extensions.Literal["display_name"] | None: ...

global___MessageSenderProfile = MessageSenderProfile

@typing_extensions.final
class ListMessagesRequest(google.protobuf.message.Message):
    """ListMessagesRequest is used to list messages in a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    IF_ALL_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    chat_uid: builtins.str
    """chat uid"""
    page_size: builtins.int
    """page size"""
    page_token: builtins.str
    """page token"""
    if_all: builtins.bool
    """If true, all messages will be returned. This has higher priority over page_size and page_token."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        if_all: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "if_all", b"if_all", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListMessagesRequest = ListMessagesRequest

@typing_extensions.final
class ListMessagesResponse(google.protobuf.message.Message):
    """ListMessagesResponse returns a list of messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    SENDER_PROFILES_FIELD_NUMBER: builtins.int
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Message]:
        """messages"""
    next_page_token: builtins.str
    """next page token"""
    total_size: builtins.int
    """total size"""
    @property
    def sender_profiles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MessageSenderProfile]:
        """message sender profiles"""
    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___Message] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
        sender_profiles: collections.abc.Iterable[global___MessageSenderProfile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["messages", b"messages", "next_page_token", b"next_page_token", "sender_profiles", b"sender_profiles", "total_size", b"total_size"]) -> None: ...

global___ListMessagesResponse = ListMessagesResponse

@typing_extensions.final
class ChatWithAgentRequest(google.protobuf.message.Message):
    """ChatWithAgentRequest represents a request to send a message
    to a chatbot synchronously and streams back the results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    FILE_UIDS_FIELD_NUMBER: builtins.int
    ENABLE_WEB_SEARCH_FIELD_NUMBER: builtins.int
    OBJECT_UIDS_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    chat_uid: builtins.str
    """chat uid"""
    message: builtins.str
    """User message"""
    @property
    def file_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """file UIDs"""
    enable_web_search: builtins.bool
    """Whether to enable web search for the chat."""
    @property
    def object_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """object UIDs"""
    @property
    def context(self) -> global___ChatContext:
        """The context for the chat."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
        message: builtins.str = ...,
        file_uids: collections.abc.Iterable[builtins.str] | None = ...,
        enable_web_search: builtins.bool = ...,
        object_uids: collections.abc.Iterable[builtins.str] | None = ...,
        context: global___ChatContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["context", b"context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "context", b"context", "enable_web_search", b"enable_web_search", "file_uids", b"file_uids", "message", b"message", "namespace_id", b"namespace_id", "object_uids", b"object_uids"]) -> None: ...

global___ChatWithAgentRequest = ChatWithAgentRequest

@typing_extensions.final
class ChatWithAgentResponse(google.protobuf.message.Message):
    """ChatWithAgentResponse contains the chatbot response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Conversation responses."""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["outputs", b"outputs"]) -> None: ...

global___ChatWithAgentResponse = ChatWithAgentResponse

@typing_extensions.final
class TableBuilderAgentMessage(google.protobuf.message.Message):
    """TableBuilderAgentMessage represents a message from the table builder agent."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    message: builtins.str
    """The message."""
    def __init__(
        self,
        *,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message"]) -> None: ...

global___TableBuilderAgentMessage = TableBuilderAgentMessage

@typing_extensions.final
class ListTableBuilderAgentMessagesRequest(google.protobuf.message.Message):
    """ListTableBuilderAgentMessagesRequest is used to list messages in a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    IF_ALL_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    table_uid: builtins.str
    """table uid"""
    page_size: builtins.int
    """page size"""
    page_token: builtins.str
    """page token"""
    if_all: builtins.bool
    """If true, all messages will be returned. This has higher priority over page_size and page_token."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        if_all: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["if_all", b"if_all", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token", "table_uid", b"table_uid"]) -> None: ...

global___ListTableBuilderAgentMessagesRequest = ListTableBuilderAgentMessagesRequest

@typing_extensions.final
class ListTableBuilderAgentMessagesResponse(google.protobuf.message.Message):
    """ListTableBuilderAgentMessagesResponse returns a list of messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    SENDER_PROFILES_FIELD_NUMBER: builtins.int
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Message]:
        """messages"""
    next_page_token: builtins.str
    """next page token"""
    total_size: builtins.int
    """total size"""
    @property
    def sender_profiles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MessageSenderProfile]:
        """message sender profiles"""
    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___Message] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
        sender_profiles: collections.abc.Iterable[global___MessageSenderProfile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["messages", b"messages", "next_page_token", b"next_page_token", "sender_profiles", b"sender_profiles", "total_size", b"total_size"]) -> None: ...

global___ListTableBuilderAgentMessagesResponse = ListTableBuilderAgentMessagesResponse

@typing_extensions.final
class ChatWithTableBuilderAgentRequest(google.protobuf.message.Message):
    """ChatWithTableBuilderAgentRequest represents a request to chat with the table builder agent."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to send a message to."""
    message: builtins.str
    """User message"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___ChatWithTableBuilderAgentRequest = ChatWithTableBuilderAgentRequest

@typing_extensions.final
class ChatWithTableBuilderAgentResponse(google.protobuf.message.Message):
    """ChatWithTableBuilderAgentResponse contains the response from the table builder agent."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_FIELD_NUMBER: builtins.int
    @property
    def event(self) -> global___ChatEvent:
        """The response from the table builder agent."""
    def __init__(
        self,
        *,
        event: global___ChatEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["event", b"event"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event", b"event"]) -> None: ...

global___ChatWithTableBuilderAgentResponse = ChatWithTableBuilderAgentResponse

@typing_extensions.final
class ChatEvent(google.protobuf.message.Message):
    """ChatEvent represents an event for a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CHAT_STARTED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_STATUS_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_OUTPUT_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_NAME_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_REPLAN_TRIGGERED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_CITATION_LIST_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_TABLE_CREATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_ERROR_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_DEBUG_OUTPUT_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_ENDED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_ATTACHMENTS_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_CONTEXT_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    CHAT_TABLE_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    event: builtins.str
    """The event type.
    In text/event-stream format, this maps to the `event` field.
    """
    id: builtins.str
    """The ID of the event.
    In text/event-stream format, this maps to the `id` field.
    """
    @property
    def chat_started_event(self) -> global___ChatStartedEvent:
        """The chat was started."""
    @property
    def chat_status_updated_event(self) -> global___ChatStatusUpdatedEvent:
        """The chat status was updated."""
    @property
    def chat_output_updated_event(self) -> global___ChatOutputUpdatedEvent:
        """The chat output was updated."""
    @property
    def chat_name_updated_event(self) -> global___ChatNameUpdatedEvent:
        """The chat name was updated."""
    @property
    def chat_replan_triggered_event(self) -> global___ChatReplanTriggeredEvent:
        """The chat replan was triggered."""
    @property
    def chat_citation_list_updated_event(self) -> global___ChatCitationListUpdatedEvent:
        """The chat citation list was updated."""
    @property
    def chat_table_created_event(self) -> global___ChatTableCreatedEvent:
        """The table was created."""
    @property
    def chat_error_updated_event(self) -> global___ChatErrorUpdatedEvent:
        """The error was updated."""
    @property
    def chat_debug_output_updated_event(self) -> global___ChatDebugOutputUpdatedEvent:
        """The debug output was updated."""
    @property
    def chat_ended_event(self) -> global___ChatEndedEvent:
        """The chat ended."""
    @property
    def chat_attachments_updated_event(self) -> global___ChatAttachmentsUpdatedEvent:
        """The chat attachments were updated."""
    @property
    def chat_context_updated_event(self) -> global___ChatContextUpdatedEvent:
        """The chat context was updated."""
    @property
    def chat_table_updated_event(self) -> global___ChatTableUpdatedEvent:
        """The table was updated."""
    def __init__(
        self,
        *,
        event: builtins.str = ...,
        id: builtins.str = ...,
        chat_started_event: global___ChatStartedEvent | None = ...,
        chat_status_updated_event: global___ChatStatusUpdatedEvent | None = ...,
        chat_output_updated_event: global___ChatOutputUpdatedEvent | None = ...,
        chat_name_updated_event: global___ChatNameUpdatedEvent | None = ...,
        chat_replan_triggered_event: global___ChatReplanTriggeredEvent | None = ...,
        chat_citation_list_updated_event: global___ChatCitationListUpdatedEvent | None = ...,
        chat_table_created_event: global___ChatTableCreatedEvent | None = ...,
        chat_error_updated_event: global___ChatErrorUpdatedEvent | None = ...,
        chat_debug_output_updated_event: global___ChatDebugOutputUpdatedEvent | None = ...,
        chat_ended_event: global___ChatEndedEvent | None = ...,
        chat_attachments_updated_event: global___ChatAttachmentsUpdatedEvent | None = ...,
        chat_context_updated_event: global___ChatContextUpdatedEvent | None = ...,
        chat_table_updated_event: global___ChatTableUpdatedEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["chat_attachments_updated_event", b"chat_attachments_updated_event", "chat_citation_list_updated_event", b"chat_citation_list_updated_event", "chat_context_updated_event", b"chat_context_updated_event", "chat_debug_output_updated_event", b"chat_debug_output_updated_event", "chat_ended_event", b"chat_ended_event", "chat_error_updated_event", b"chat_error_updated_event", "chat_name_updated_event", b"chat_name_updated_event", "chat_output_updated_event", b"chat_output_updated_event", "chat_replan_triggered_event", b"chat_replan_triggered_event", "chat_started_event", b"chat_started_event", "chat_status_updated_event", b"chat_status_updated_event", "chat_table_created_event", b"chat_table_created_event", "chat_table_updated_event", b"chat_table_updated_event", "data", b"data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_attachments_updated_event", b"chat_attachments_updated_event", "chat_citation_list_updated_event", b"chat_citation_list_updated_event", "chat_context_updated_event", b"chat_context_updated_event", "chat_debug_output_updated_event", b"chat_debug_output_updated_event", "chat_ended_event", b"chat_ended_event", "chat_error_updated_event", b"chat_error_updated_event", "chat_name_updated_event", b"chat_name_updated_event", "chat_output_updated_event", b"chat_output_updated_event", "chat_replan_triggered_event", b"chat_replan_triggered_event", "chat_started_event", b"chat_started_event", "chat_status_updated_event", b"chat_status_updated_event", "chat_table_created_event", b"chat_table_created_event", "chat_table_updated_event", b"chat_table_updated_event", "data", b"data", "event", b"event", "id", b"id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["data", b"data"]) -> typing_extensions.Literal["chat_started_event", "chat_status_updated_event", "chat_output_updated_event", "chat_name_updated_event", "chat_replan_triggered_event", "chat_citation_list_updated_event", "chat_table_created_event", "chat_error_updated_event", "chat_debug_output_updated_event", "chat_ended_event", "chat_attachments_updated_event", "chat_context_updated_event", "chat_table_updated_event"] | None: ...

global___ChatEvent = ChatEvent

@typing_extensions.final
class ChatStartedEvent(google.protobuf.message.Message):
    """ChatStartedEvent represents an event for a chat started"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when chat start"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> None: ...

global___ChatStartedEvent = ChatStartedEvent

@typing_extensions.final
class ChatStatusUpdatedEvent(google.protobuf.message.Message):
    """ChatStatusUpdatedEvent represents an event for a chat status change"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    CHAT_STATUS_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when chat status change"""
    chat_status: builtins.str
    """The updated chat status"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        chat_status: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_status", b"chat_status", "create_time", b"create_time"]) -> None: ...

global___ChatStatusUpdatedEvent = ChatStatusUpdatedEvent

@typing_extensions.final
class ChatOutputUpdatedEvent(google.protobuf.message.Message):
    """ChatOutputUpdatedEvent represents an event for chat has new output"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    OUTPUT_CHUNK_DELTA_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when chat has new output"""
    output_chunk_delta: builtins.str
    """The output chunk delta"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        output_chunk_delta: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "output_chunk_delta", b"output_chunk_delta"]) -> None: ...

global___ChatOutputUpdatedEvent = ChatOutputUpdatedEvent

@typing_extensions.final
class ChatNameUpdatedEvent(google.protobuf.message.Message):
    """ChatNameUpdatedEvent represents an event for chat name change"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when chat name change"""
    name: builtins.str
    """The updated chat name"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "name", b"name"]) -> None: ...

global___ChatNameUpdatedEvent = ChatNameUpdatedEvent

@typing_extensions.final
class ChatReplanTriggeredEvent(google.protobuf.message.Message):
    """ChatReplanTriggeredEvent represents an event for a triggered replan"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    NUMBER_OF_REPLAN_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when replan trigger"""
    number_of_replan: builtins.int
    """The current number of replan"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        number_of_replan: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "number_of_replan", b"number_of_replan"]) -> None: ...

global___ChatReplanTriggeredEvent = ChatReplanTriggeredEvent

@typing_extensions.final
class ChatCitationListUpdatedEvent(google.protobuf.message.Message):
    """ChatCitationListUpdatedEvent represents an event for a citation list output"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    CITATIONS_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when citation list output"""
    @property
    def citations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[agent.agent.v1alpha.common_pb2.Citation]:
        """The citation list"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        citations: collections.abc.Iterable[agent.agent.v1alpha.common_pb2.Citation] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["citations", b"citations", "create_time", b"create_time"]) -> None: ...

global___ChatCitationListUpdatedEvent = ChatCitationListUpdatedEvent

@typing_extensions.final
class ChatAttachmentsUpdatedEvent(google.protobuf.message.Message):
    """ChatAttachmentsUpdatedEvent represents an event for a attachment list output"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    ATTACHMENTS_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when attachment list updated"""
    @property
    def attachments(self) -> global___ChatAttachments:
        """The attachments"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        attachments: global___ChatAttachments | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attachments", b"attachments", "create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attachments", b"attachments", "create_time", b"create_time"]) -> None: ...

global___ChatAttachmentsUpdatedEvent = ChatAttachmentsUpdatedEvent

@typing_extensions.final
class ChatContextUpdatedEvent(google.protobuf.message.Message):
    """ChatContextUpdatedEvent represents an event for a context updated"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when context updated"""
    @property
    def context(self) -> global___ChatContext:
        """The context"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        context: global___ChatContext | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["context", b"context", "create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["context", b"context", "create_time", b"create_time"]) -> None: ...

global___ChatContextUpdatedEvent = ChatContextUpdatedEvent

@typing_extensions.final
class ChatTableCreatedEvent(google.protobuf.message.Message):
    """ChatTableCreatedEvent represents an event for a table creation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ColumnDefinitionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> agent.agent.v1alpha.table_pb2.ColumnDefinition: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: agent.agent.v1alpha.table_pb2.ColumnDefinition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CREATE_TIME_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    TABLE_FIELD_NUMBER: builtins.int
    COLUMN_DEFINITIONS_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when table is created"""
    table_uid: builtins.str
    """The created table uid"""
    @property
    def table(self) -> agent.agent.v1alpha.table_pb2.Table:
        """The created table"""
    @property
    def column_definitions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, agent.agent.v1alpha.table_pb2.ColumnDefinition]:
        """The created column definitions"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        table_uid: builtins.str = ...,
        table: agent.agent.v1alpha.table_pb2.Table | None = ...,
        column_definitions: collections.abc.Mapping[builtins.str, agent.agent.v1alpha.table_pb2.ColumnDefinition] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definitions", b"column_definitions", "create_time", b"create_time", "table", b"table", "table_uid", b"table_uid"]) -> None: ...

global___ChatTableCreatedEvent = ChatTableCreatedEvent

@typing_extensions.final
class ChatTableUpdatedEvent(google.protobuf.message.Message):
    """ChatTableUpdatedEvent represents an event for a table update"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ColumnDefinitionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> agent.agent.v1alpha.table_pb2.ColumnDefinition: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: agent.agent.v1alpha.table_pb2.ColumnDefinition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    CREATE_TIME_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    TABLE_FIELD_NUMBER: builtins.int
    COLUMN_DEFINITIONS_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when table updated"""
    table_uid: builtins.str
    """The updated table uid"""
    @property
    def table(self) -> agent.agent.v1alpha.table_pb2.Table:
        """The updated table"""
    @property
    def column_definitions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, agent.agent.v1alpha.table_pb2.ColumnDefinition]:
        """The updated column definitions"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        table_uid: builtins.str = ...,
        table: agent.agent.v1alpha.table_pb2.Table | None = ...,
        column_definitions: collections.abc.Mapping[builtins.str, agent.agent.v1alpha.table_pb2.ColumnDefinition] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definitions", b"column_definitions", "create_time", b"create_time", "table", b"table", "table_uid", b"table_uid"]) -> None: ...

global___ChatTableUpdatedEvent = ChatTableUpdatedEvent

@typing_extensions.final
class ChatErrorUpdatedEvent(google.protobuf.message.Message):
    """ChatErrorUpdatedEvent represents an event for an error"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    ERROR_TYPE_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when error triggered"""
    error_type: builtins.str
    """The error type"""
    error: builtins.str
    """The error message"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        error_type: builtins.str = ...,
        error: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "error", b"error", "error_type", b"error_type"]) -> None: ...

global___ChatErrorUpdatedEvent = ChatErrorUpdatedEvent

@typing_extensions.final
class ChatDebugOutputUpdatedEvent(google.protobuf.message.Message):
    """ChatDebugOutputUpdatedEvent represents an event for debug log"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    DEBUG_OUTPUT_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when debug log output"""
    debug_output: builtins.str
    """The debug output"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        debug_output: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "debug_output", b"debug_output"]) -> None: ...

global___ChatDebugOutputUpdatedEvent = ChatDebugOutputUpdatedEvent

@typing_extensions.final
class ChatEndedEvent(google.protobuf.message.Message):
    """ChatEndedEvent represents an event when chat ends"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CREATE_TIME_FIELD_NUMBER: builtins.int
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when chat ends"""
    def __init__(
        self,
        *,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["create_time", b"create_time"]) -> None: ...

global___ChatEndedEvent = ChatEndedEvent
