"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import agent.agent.v1alpha.common_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Type:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Type.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TYPE_UNSPECIFIED: _Type.ValueType  # 0
    """The type is not specified."""
    TYPE_STRING: _Type.ValueType  # 1
    """The type is a string."""
    TYPE_NUMBER: _Type.ValueType  # 2
    """The type is a number."""
    TYPE_BOOLEAN: _Type.ValueType  # 3
    """The type is a boolean."""
    TYPE_FILE: _Type.ValueType  # 4
    """The type is a file resource."""
    TYPE_DOCUMENT: _Type.ValueType  # 5
    """The type is a document resource."""

class Type(_Type, metaclass=_TypeEnumTypeWrapper):
    """The type of the column."""

TYPE_UNSPECIFIED: Type.ValueType  # 0
"""The type is not specified."""
TYPE_STRING: Type.ValueType  # 1
"""The type is a string."""
TYPE_NUMBER: Type.ValueType  # 2
"""The type is a number."""
TYPE_BOOLEAN: Type.ValueType  # 3
"""The type is a boolean."""
TYPE_FILE: Type.ValueType  # 4
"""The type is a file resource."""
TYPE_DOCUMENT: Type.ValueType  # 5
"""The type is a document resource."""
global___Type = Type

class _CellStatus:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _CellStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_CellStatus.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    CELL_STATUS_UNSPECIFIED: _CellStatus.ValueType  # 0
    """The cell status is not specified or unknown."""
    CELL_STATUS_IDLE: _CellStatus.ValueType  # 1
    """The cell is in a stable, ready state with no active processing."""
    CELL_STATUS_DATA_UPLOADING: _CellStatus.ValueType  # 2
    """The cell's file data is currently being uploaded to the server.
    This status only applies to cells with file type values.
    """
    CELL_STATUS_DATA_PENDING: _CellStatus.ValueType  # 3
    """The cell's data is queued for processing but has not started yet."""
    CELL_STATUS_DATA_PROCESSING: _CellStatus.ValueType  # 4
    """The cell's data is actively being processed."""
    CELL_STATUS_DATA_FAILED: _CellStatus.ValueType  # 5
    """The cell's data processing encountered an error and failed to complete."""
    CELL_STATUS_TRANSPARENCY_PENDING: _CellStatus.ValueType  # 6
    """The cell's transparency information is queued for generation but has not started yet."""
    CELL_STATUS_TRANSPARENCY_PROCESSING: _CellStatus.ValueType  # 7
    """The cell's transparency information is actively being generated."""
    CELL_STATUS_TRANSPARENCY_FAILED: _CellStatus.ValueType  # 8
    """The cell's transparency generation encountered an error and failed to complete."""

class CellStatus(_CellStatus, metaclass=_CellStatusEnumTypeWrapper):
    """CellStatus represents the processing state of a cell."""

CELL_STATUS_UNSPECIFIED: CellStatus.ValueType  # 0
"""The cell status is not specified or unknown."""
CELL_STATUS_IDLE: CellStatus.ValueType  # 1
"""The cell is in a stable, ready state with no active processing."""
CELL_STATUS_DATA_UPLOADING: CellStatus.ValueType  # 2
"""The cell's file data is currently being uploaded to the server.
This status only applies to cells with file type values.
"""
CELL_STATUS_DATA_PENDING: CellStatus.ValueType  # 3
"""The cell's data is queued for processing but has not started yet."""
CELL_STATUS_DATA_PROCESSING: CellStatus.ValueType  # 4
"""The cell's data is actively being processed."""
CELL_STATUS_DATA_FAILED: CellStatus.ValueType  # 5
"""The cell's data processing encountered an error and failed to complete."""
CELL_STATUS_TRANSPARENCY_PENDING: CellStatus.ValueType  # 6
"""The cell's transparency information is queued for generation but has not started yet."""
CELL_STATUS_TRANSPARENCY_PROCESSING: CellStatus.ValueType  # 7
"""The cell's transparency information is actively being generated."""
CELL_STATUS_TRANSPARENCY_FAILED: CellStatus.ValueType  # 8
"""The cell's transparency generation encountered an error and failed to complete."""
global___CellStatus = CellStatus

class _LockState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LockStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LockState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LOCK_STATE_UNSPECIFIED: _LockState.ValueType  # 0
    """The lock state is not specified."""
    LOCK_STATE_LOCKED: _LockState.ValueType  # 1
    """The cell is locked."""
    LOCK_STATE_UNLOCKED: _LockState.ValueType  # 2
    """The cell is unlocked."""

class LockState(_LockState, metaclass=_LockStateEnumTypeWrapper):
    """The lock state of a cell."""

LOCK_STATE_UNSPECIFIED: LockState.ValueType  # 0
"""The lock state is not specified."""
LOCK_STATE_LOCKED: LockState.ValueType  # 1
"""The cell is locked."""
LOCK_STATE_UNLOCKED: LockState.ValueType  # 2
"""The cell is unlocked."""
global___LockState = LockState

class _ExportFormat:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ExportFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ExportFormat.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    EXPORT_FORMAT_UNSPECIFIED: _ExportFormat.ValueType  # 0
    """The format is not specified."""
    EXPORT_FORMAT_CSV: _ExportFormat.ValueType  # 1
    """The format is CSV."""
    EXPORT_FORMAT_PARQUET: _ExportFormat.ValueType  # 2
    """The format is Parquet."""

class ExportFormat(_ExportFormat, metaclass=_ExportFormatEnumTypeWrapper):
    """ExportFormat represents the format to export the data in."""

EXPORT_FORMAT_UNSPECIFIED: ExportFormat.ValueType  # 0
"""The format is not specified."""
EXPORT_FORMAT_CSV: ExportFormat.ValueType  # 1
"""The format is CSV."""
EXPORT_FORMAT_PARQUET: ExportFormat.ValueType  # 2
"""The format is Parquet."""
global___ExportFormat = ExportFormat

@typing_extensions.final
class Table(google.protobuf.message.Message):
    """Table represents a table resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class AgentConfig(google.protobuf.message.Message):
        """The configuration for the agent."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLE_TRANSPARENCY_FIELD_NUMBER: builtins.int
        enable_transparency: builtins.bool
        """Whether to enable transparency for the table."""
        def __init__(
            self,
            *,
            enable_transparency: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["enable_transparency", b"enable_transparency"]) -> None: ...

    UID_FIELD_NUMBER: builtins.int
    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    AGENT_CONFIG_FIELD_NUMBER: builtins.int
    DRAFT_MODE_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """The unique identifier of the table."""
    title: builtins.str
    """The title of the table."""
    description: builtins.str
    """A description of the table."""
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Additional metadata associated with the table."""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp when the table was created."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp when the table was last updated."""
    @property
    def agent_config(self) -> global___Table.AgentConfig:
        """The configuration for the agent."""
    draft_mode: builtins.bool
    """Whether to enable draft mode for the table."""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        title: builtins.str = ...,
        description: builtins.str = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        agent_config: global___Table.AgentConfig | None = ...,
        draft_mode: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "create_time", b"create_time", "metadata", b"metadata", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "create_time", b"create_time", "description", b"description", "draft_mode", b"draft_mode", "metadata", b"metadata", "title", b"title", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___Table = Table

@typing_extensions.final
class ListTablesRequest(google.protobuf.message.Message):
    """ListTablesRequest represents a request to list tables."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the tables."""
    page_token: builtins.str
    """The page token for pagination."""
    page_size: builtins.int
    """The maximum number of tables to return."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        page_token: builtins.str = ...,
        page_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListTablesRequest = ListTablesRequest

@typing_extensions.final
class ListTablesResponse(google.protobuf.message.Message):
    """ListTablesResponse contains the list of tables."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def tables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Table]:
        """The list of tables."""
    next_page_token: builtins.str
    """The token for the next page of results."""
    total_size: builtins.int
    """The total number of tables."""
    def __init__(
        self,
        *,
        tables: collections.abc.Iterable[global___Table] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "tables", b"tables", "total_size", b"total_size"]) -> None: ...

global___ListTablesResponse = ListTablesResponse

@typing_extensions.final
class CreateTableRequest(google.protobuf.message.Message):
    """CreateTableRequest represents a request to create a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace where the table will be created."""
    @property
    def table(self) -> global___Table:
        """The table resource to create."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table: global___Table | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "table", b"table"]) -> None: ...

global___CreateTableRequest = CreateTableRequest

@typing_extensions.final
class CreateTableResponse(google.protobuf.message.Message):
    """CreateTableResponse contains the created table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> global___Table:
        """The created table resource."""
    def __init__(
        self,
        *,
        table: global___Table | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["table", b"table"]) -> None: ...

global___CreateTableResponse = CreateTableResponse

@typing_extensions.final
class GetTableRequest(google.protobuf.message.Message):
    """GetTableRequest represents a request to fetch a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to fetch."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___GetTableRequest = GetTableRequest

@typing_extensions.final
class GetTableResponse(google.protobuf.message.Message):
    """GetTableResponse contains the requested table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> global___Table:
        """The table resource."""
    def __init__(
        self,
        *,
        table: global___Table | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["table", b"table"]) -> None: ...

global___GetTableResponse = GetTableResponse

@typing_extensions.final
class UpdateTableRequest(google.protobuf.message.Message):
    """UpdateTableRequest represents a request to update a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    TABLE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to update."""
    @property
    def table(self) -> global___Table:
        """The table fields that will replace the existing ones."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        table: global___Table | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "table", b"table", "table_uid", b"table_uid", "update_mask", b"update_mask"]) -> None: ...

global___UpdateTableRequest = UpdateTableRequest

@typing_extensions.final
class UpdateTableResponse(google.protobuf.message.Message):
    """UpdateTableResponse contains the updated table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> global___Table:
        """The updated table resource."""
    def __init__(
        self,
        *,
        table: global___Table | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["table", b"table"]) -> None: ...

global___UpdateTableResponse = UpdateTableResponse

@typing_extensions.final
class DeleteTableRequest(google.protobuf.message.Message):
    """DeleteTableRequest represents a request to delete a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to delete."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___DeleteTableRequest = DeleteTableRequest

@typing_extensions.final
class DeleteTableResponse(google.protobuf.message.Message):
    """DeleteTableResponse is an empty response for deleting a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteTableResponse = DeleteTableResponse

@typing_extensions.final
class NumberFormat(google.protobuf.message.Message):
    """NumberFormat defines the display format for number type columns."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Format:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NumberFormat._Format.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FORMAT_UNSPECIFIED: NumberFormat._Format.ValueType  # 0
        """Default number format with no specific formatting applied."""
        FORMAT_PLAIN: NumberFormat._Format.ValueType  # 1
        """Plain number format without any separators or special formatting."""
        FORMAT_COMMAS: NumberFormat._Format.ValueType  # 2
        """Number format with commas as thousand separators (e.g., 1,234,567)."""
        FORMAT_CURRENCY: NumberFormat._Format.ValueType  # 3
        """Currency format that displays values with a currency symbol."""
        FORMAT_PERCENTAGE: NumberFormat._Format.ValueType  # 4
        """Percentage format that displays values with a percent symbol."""

    class Format(_Format, metaclass=_FormatEnumTypeWrapper):
        """Format specifies the visual representation of numbers in the column."""

    FORMAT_UNSPECIFIED: NumberFormat.Format.ValueType  # 0
    """Default number format with no specific formatting applied."""
    FORMAT_PLAIN: NumberFormat.Format.ValueType  # 1
    """Plain number format without any separators or special formatting."""
    FORMAT_COMMAS: NumberFormat.Format.ValueType  # 2
    """Number format with commas as thousand separators (e.g., 1,234,567)."""
    FORMAT_CURRENCY: NumberFormat.Format.ValueType  # 3
    """Currency format that displays values with a currency symbol."""
    FORMAT_PERCENTAGE: NumberFormat.Format.ValueType  # 4
    """Percentage format that displays values with a percent symbol."""

    FORMAT_FIELD_NUMBER: builtins.int
    DECIMAL_PLACES_FIELD_NUMBER: builtins.int
    CURRENCY_CODE_FIELD_NUMBER: builtins.int
    format: global___NumberFormat.Format.ValueType
    """The specific format to apply to numbers in this column."""
    decimal_places: builtins.int
    """Number of decimal places to display (e.g., 2 would show 1.23).
    If not specified, a default appropriate to the format will be used.
    """
    currency_code: builtins.str
    """ISO 4217 currency code (e.g., "USD", "EUR", "JPY") for currency format.
    Required when format is FORMAT_CURRENCY, ignored for other formats.
    """
    def __init__(
        self,
        *,
        format: global___NumberFormat.Format.ValueType = ...,
        decimal_places: builtins.int = ...,
        currency_code: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["currency_code", b"currency_code", "decimal_places", b"decimal_places", "format", b"format"]) -> None: ...

global___NumberFormat = NumberFormat

@typing_extensions.final
class ColumnDefinition(google.protobuf.message.Message):
    """ColumnDefinition represents a column definition in a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Sort:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SortEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ColumnDefinition._Sort.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SORT_UNSPECIFIED: ColumnDefinition._Sort.ValueType  # 0
        """The sort is not specified."""
        SORT_ASCENDING: ColumnDefinition._Sort.ValueType  # 1
        """The sort is ascending."""
        SORT_DESCENDING: ColumnDefinition._Sort.ValueType  # 2
        """The sort is descending."""

    class Sort(_Sort, metaclass=_SortEnumTypeWrapper):
        """The sort of the column."""

    SORT_UNSPECIFIED: ColumnDefinition.Sort.ValueType  # 0
    """The sort is not specified."""
    SORT_ASCENDING: ColumnDefinition.Sort.ValueType  # 1
    """The sort is ascending."""
    SORT_DESCENDING: ColumnDefinition.Sort.ValueType  # 2
    """The sort is descending."""

    @typing_extensions.final
    class AgentConfig(google.protobuf.message.Message):
        """The configuration for the agent."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class Context(google.protobuf.message.Message):
            """The context for the agent."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            COLUMN_UIDS_FIELD_NUMBER: builtins.int
            @property
            def column_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
                """The column uids to include in the context."""
            def __init__(
                self,
                *,
                column_uids: collections.abc.Iterable[builtins.str] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["column_uids", b"column_uids"]) -> None: ...

        INSTRUCTIONS_FIELD_NUMBER: builtins.int
        ENABLE_WEB_SEARCH_FIELD_NUMBER: builtins.int
        ENABLE_AUTOMATIC_COMPUTATION_FIELD_NUMBER: builtins.int
        CONTEXT_FIELD_NUMBER: builtins.int
        instructions: builtins.str
        """The instructions for the agent."""
        enable_web_search: builtins.bool
        """Whether to enable web search for the column."""
        enable_automatic_computation: builtins.bool
        """Whether to enable automatic computation for the column."""
        @property
        def context(self) -> global___ColumnDefinition.AgentConfig.Context:
            """The context for the agent. This setting is only used if enable_automatic_computation is true."""
        def __init__(
            self,
            *,
            instructions: builtins.str = ...,
            enable_web_search: builtins.bool = ...,
            enable_automatic_computation: builtins.bool | None = ...,
            context: global___ColumnDefinition.AgentConfig.Context | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["_enable_automatic_computation", b"_enable_automatic_computation", "context", b"context", "enable_automatic_computation", b"enable_automatic_computation"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["_enable_automatic_computation", b"_enable_automatic_computation", "context", b"context", "enable_automatic_computation", b"enable_automatic_computation", "enable_web_search", b"enable_web_search", "instructions", b"instructions"]) -> None: ...
        def WhichOneof(self, oneof_group: typing_extensions.Literal["_enable_automatic_computation", b"_enable_automatic_computation"]) -> typing_extensions.Literal["enable_automatic_computation"] | None: ...

    @typing_extensions.final
    class Selection(google.protobuf.message.Message):
        """The selection settings of the column."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _SelectionType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _SelectionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ColumnDefinition.Selection._SelectionType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            SELECTION_TYPE_UNSPECIFIED: ColumnDefinition.Selection._SelectionType.ValueType  # 0
            """The selection is not specified."""
            SELECTION_TYPE_NONE: ColumnDefinition.Selection._SelectionType.ValueType  # 1
            """No selection."""
            SELECTION_TYPE_SINGLE: ColumnDefinition.Selection._SelectionType.ValueType  # 2
            """The selection is a single value."""

        class SelectionType(_SelectionType, metaclass=_SelectionTypeEnumTypeWrapper):
            """The type of the selection."""

        SELECTION_TYPE_UNSPECIFIED: ColumnDefinition.Selection.SelectionType.ValueType  # 0
        """The selection is not specified."""
        SELECTION_TYPE_NONE: ColumnDefinition.Selection.SelectionType.ValueType  # 1
        """No selection."""
        SELECTION_TYPE_SINGLE: ColumnDefinition.Selection.SelectionType.ValueType  # 2
        """The selection is a single value."""

        @typing_extensions.final
        class Option(google.protobuf.message.Message):
            """An option for the selection."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            STRING_VALUE_FIELD_NUMBER: builtins.int
            NUMBER_VALUE_FIELD_NUMBER: builtins.int
            COLOR_FIELD_NUMBER: builtins.int
            string_value: builtins.str
            """The value of the cell as a string."""
            number_value: builtins.float
            """The value of the cell as a number."""
            color: builtins.str
            """Display color of the option."""
            def __init__(
                self,
                *,
                string_value: builtins.str = ...,
                number_value: builtins.float = ...,
                color: builtins.str = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["number_value", b"number_value", "string_value", b"string_value", "value", b"value"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["color", b"color", "number_value", b"number_value", "string_value", b"string_value", "value", b"value"]) -> None: ...
            def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["string_value", "number_value"] | None: ...

        TYPE_FIELD_NUMBER: builtins.int
        OPTIONS_FIELD_NUMBER: builtins.int
        type: global___ColumnDefinition.Selection.SelectionType.ValueType
        """The selection of the column."""
        @property
        def options(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ColumnDefinition.Selection.Option]:
            """The options for the selection."""
        def __init__(
            self,
            *,
            type: global___ColumnDefinition.Selection.SelectionType.ValueType = ...,
            options: collections.abc.Iterable[global___ColumnDefinition.Selection.Option] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["options", b"options", "type", b"type"]) -> None: ...

    COLUMN_UID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    AGENT_CONFIG_FIELD_NUMBER: builtins.int
    SORT_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    NUMBER_FORMAT_FIELD_NUMBER: builtins.int
    SELECTION_FIELD_NUMBER: builtins.int
    column_uid: builtins.str
    """The unique identifier of the column."""
    name: builtins.str
    """The name of the column.
    The name of the column. If this differs from the key in the ColumnDefinitions map,
    the key will be updated to match this value.
    """
    type: global___Type.ValueType
    """The type of the column."""
    order: builtins.int
    """The order of the column in the table, starting at 1. This determines the column's position
    when displaying or processing table data.
    """
    @property
    def agent_config(self) -> global___ColumnDefinition.AgentConfig:
        """The configuration for the agent."""
    sort: global___ColumnDefinition.Sort.ValueType
    """The sort of the column."""
    description: builtins.str
    """The description for the column."""
    @property
    def number_format(self) -> global___NumberFormat:
        """Format for number type columns."""
    @property
    def selection(self) -> global___ColumnDefinition.Selection:
        """The selection settings of the column."""
    def __init__(
        self,
        *,
        column_uid: builtins.str = ...,
        name: builtins.str = ...,
        type: global___Type.ValueType = ...,
        order: builtins.int = ...,
        agent_config: global___ColumnDefinition.AgentConfig | None = ...,
        sort: global___ColumnDefinition.Sort.ValueType = ...,
        description: builtins.str = ...,
        number_format: global___NumberFormat | None = ...,
        selection: global___ColumnDefinition.Selection | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "format", b"format", "number_format", b"number_format", "selection", b"selection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["agent_config", b"agent_config", "column_uid", b"column_uid", "description", b"description", "format", b"format", "name", b"name", "number_format", b"number_format", "order", b"order", "selection", b"selection", "sort", b"sort", "type", b"type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["format", b"format"]) -> typing_extensions.Literal["number_format"] | None: ...

global___ColumnDefinition = ColumnDefinition

@typing_extensions.final
class GetColumnDefinitionsRequest(google.protobuf.message.Message):
    """GetColumnDefinitionsRequest represents a request to fetch column definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table whose columns to fetch."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___GetColumnDefinitionsRequest = GetColumnDefinitionsRequest

@typing_extensions.final
class GetColumnDefinitionsResponse(google.protobuf.message.Message):
    """GetColumnDefinitionsResponse contains the column definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ColumnDefinitionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ColumnDefinition: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ColumnDefinition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    COLUMN_DEFINITIONS_FIELD_NUMBER: builtins.int
    @property
    def column_definitions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ColumnDefinition]:
        """Map of column UID to their definitions."""
    def __init__(
        self,
        *,
        column_definitions: collections.abc.Mapping[builtins.str, global___ColumnDefinition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definitions", b"column_definitions"]) -> None: ...

global___GetColumnDefinitionsResponse = GetColumnDefinitionsResponse

@typing_extensions.final
class UpdateColumnDefinitionsRequest(google.protobuf.message.Message):
    """UpdateColumnDefinitionsRequest represents a request to update column definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ColumnDefinitionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ColumnDefinition: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ColumnDefinition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    COLUMN_DEFINITIONS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table whose columns to update."""
    @property
    def column_definitions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ColumnDefinition]:
        """Map of column UID to their new definitions."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        column_definitions: collections.abc.Mapping[builtins.str, global___ColumnDefinition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definitions", b"column_definitions", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___UpdateColumnDefinitionsRequest = UpdateColumnDefinitionsRequest

@typing_extensions.final
class UpdateColumnDefinitionsResponse(google.protobuf.message.Message):
    """UpdateColumnDefinitionsResponse contains the updated column definitions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ColumnDefinitionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ColumnDefinition: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ColumnDefinition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    COLUMN_DEFINITIONS_FIELD_NUMBER: builtins.int
    @property
    def column_definitions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ColumnDefinition]:
        """Map of column UID to the updated definitions."""
    def __init__(
        self,
        *,
        column_definitions: collections.abc.Mapping[builtins.str, global___ColumnDefinition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definitions", b"column_definitions"]) -> None: ...

global___UpdateColumnDefinitionsResponse = UpdateColumnDefinitionsResponse

@typing_extensions.final
class GetColumnDefinitionRequest(google.protobuf.message.Message):
    """GetColumnDefinitionRequest represents a request to fetch a column definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    COLUMN_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table whose column definition to fetch."""
    column_uid: builtins.str
    """The UID of the column whose definition to fetch."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        column_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_uid", b"column_uid", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___GetColumnDefinitionRequest = GetColumnDefinitionRequest

@typing_extensions.final
class GetColumnDefinitionResponse(google.protobuf.message.Message):
    """GetColumnDefinitionResponse contains the requested column definition."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COLUMN_DEFINITION_FIELD_NUMBER: builtins.int
    @property
    def column_definition(self) -> global___ColumnDefinition:
        """The column definition."""
    def __init__(
        self,
        *,
        column_definition: global___ColumnDefinition | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["column_definition", b"column_definition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definition", b"column_definition"]) -> None: ...

global___GetColumnDefinitionResponse = GetColumnDefinitionResponse

@typing_extensions.final
class RecomputeColumnRequest(google.protobuf.message.Message):
    """RecomputeColumnRequest represents a request to recompute a column."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    COLUMN_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table whose column to recompute."""
    column_uid: builtins.str
    """The UID of the column to recompute."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        column_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_uid", b"column_uid", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___RecomputeColumnRequest = RecomputeColumnRequest

@typing_extensions.final
class RecomputeColumnResponse(google.protobuf.message.Message):
    """RecomputeColumnResponse is an empty response for recomputing a column."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RecomputeColumnResponse = RecomputeColumnResponse

@typing_extensions.final
class Cell(google.protobuf.message.Message):
    """Cell represents a cell in a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Transparency(google.protobuf.message.Message):
        """The transparency of the cell."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TEXT_FIELD_NUMBER: builtins.int
        text: builtins.str
        """The text of the transparency."""
        def __init__(
            self,
            *,
            text: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["text", b"text"]) -> None: ...

    UID_FIELD_NUMBER: builtins.int
    COLUMN_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    STRING_VALUE_FIELD_NUMBER: builtins.int
    NUMBER_VALUE_FIELD_NUMBER: builtins.int
    BOOLEAN_VALUE_FIELD_NUMBER: builtins.int
    FILE_VALUE_FIELD_NUMBER: builtins.int
    DOCUMENT_VALUE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CITATIONS_FIELD_NUMBER: builtins.int
    TRANSPARENCY_FIELD_NUMBER: builtins.int
    LOCK_STATE_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """The unique identifier of the cell."""
    column_uid: builtins.str
    """The unique identifier of the column this cell belongs to."""
    row_uid: builtins.str
    """The row that this cell belongs to."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp when the cell was last updated."""
    type: global___Type.ValueType
    """The type of the cell's value."""
    @property
    def string_value(self) -> global___StringCell:
        """The value of the cell as a string."""
    @property
    def number_value(self) -> global___NumberCell:
        """The value of the cell as a number."""
    @property
    def boolean_value(self) -> global___BooleanCell:
        """The value of the cell as a boolean."""
    @property
    def file_value(self) -> global___FileCell:
        """The value of the cell as a file resource. This can represent various file types
        such as images, documents, audio, or other binary data.
        """
    @property
    def document_value(self) -> global___DocumentCell:
        """The value of the cell as a document resource. The document resource is a
        file resource that is specifically designed for document types, such as
        TXT, Markdown, PDF, DOC, and PPT.
        """
    @property
    def metadata(self) -> google.protobuf.struct_pb2.Struct:
        """Additional metadata for the cell."""
    status: global___CellStatus.ValueType
    """The status of the cell."""
    @property
    def citations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[agent.agent.v1alpha.common_pb2.Citation]:
        """The citations for the cell."""
    @property
    def transparency(self) -> global___Cell.Transparency:
        """The transparency of the cell."""
    lock_state: global___LockState.ValueType
    """The lock state of the cell."""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        column_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: global___Type.ValueType = ...,
        string_value: global___StringCell | None = ...,
        number_value: global___NumberCell | None = ...,
        boolean_value: global___BooleanCell | None = ...,
        file_value: global___FileCell | None = ...,
        document_value: global___DocumentCell | None = ...,
        metadata: google.protobuf.struct_pb2.Struct | None = ...,
        status: global___CellStatus.ValueType = ...,
        citations: collections.abc.Iterable[agent.agent.v1alpha.common_pb2.Citation] | None = ...,
        transparency: global___Cell.Transparency | None = ...,
        lock_state: global___LockState.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["boolean_value", b"boolean_value", "document_value", b"document_value", "file_value", b"file_value", "metadata", b"metadata", "number_value", b"number_value", "string_value", b"string_value", "transparency", b"transparency", "update_time", b"update_time", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["boolean_value", b"boolean_value", "citations", b"citations", "column_uid", b"column_uid", "document_value", b"document_value", "file_value", b"file_value", "lock_state", b"lock_state", "metadata", b"metadata", "number_value", b"number_value", "row_uid", b"row_uid", "status", b"status", "string_value", b"string_value", "transparency", b"transparency", "type", b"type", "uid", b"uid", "update_time", b"update_time", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["value", b"value"]) -> typing_extensions.Literal["string_value", "number_value", "boolean_value", "file_value", "document_value"] | None: ...

global___Cell = Cell

@typing_extensions.final
class NullCell(google.protobuf.message.Message):
    """NullCell represents a null cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___NullCell = NullCell

@typing_extensions.final
class StringCell(google.protobuf.message.Message):
    """StringCell represents a cell with a string value."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    USER_INPUT_FIELD_NUMBER: builtins.int
    COMPUTED_VALUE_FIELD_NUMBER: builtins.int
    value: builtins.str
    """The value of the cell as a string."""
    user_input: builtins.str
    """The value of the cell that directly set by the user."""
    computed_value: builtins.str
    """The value of the cell that was computed by the automatic computation."""
    def __init__(
        self,
        *,
        value: builtins.str = ...,
        user_input: builtins.str | None = ...,
        computed_value: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_computed_value", b"_computed_value", "_user_input", b"_user_input", "computed_value", b"computed_value", "user_input", b"user_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_computed_value", b"_computed_value", "_user_input", b"_user_input", "computed_value", b"computed_value", "user_input", b"user_input", "value", b"value"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_computed_value", b"_computed_value"]) -> typing_extensions.Literal["computed_value"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_user_input", b"_user_input"]) -> typing_extensions.Literal["user_input"] | None: ...

global___StringCell = StringCell

@typing_extensions.final
class NumberCell(google.protobuf.message.Message):
    """NumberCell represents a cell with a number value."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    USER_INPUT_FIELD_NUMBER: builtins.int
    COMPUTED_VALUE_FIELD_NUMBER: builtins.int
    value: builtins.float
    """The value of the cell as a number."""
    user_input: builtins.float
    """The value of the cell that directly set by the user."""
    computed_value: builtins.float
    """The value of the cell that was computed by the automatic computation."""
    def __init__(
        self,
        *,
        value: builtins.float = ...,
        user_input: builtins.float | None = ...,
        computed_value: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_computed_value", b"_computed_value", "_user_input", b"_user_input", "computed_value", b"computed_value", "user_input", b"user_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_computed_value", b"_computed_value", "_user_input", b"_user_input", "computed_value", b"computed_value", "user_input", b"user_input", "value", b"value"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_computed_value", b"_computed_value"]) -> typing_extensions.Literal["computed_value"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_user_input", b"_user_input"]) -> typing_extensions.Literal["user_input"] | None: ...

global___NumberCell = NumberCell

@typing_extensions.final
class BooleanCell(google.protobuf.message.Message):
    """BooleanCell represents a cell with a boolean value."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    USER_INPUT_FIELD_NUMBER: builtins.int
    COMPUTED_VALUE_FIELD_NUMBER: builtins.int
    value: builtins.bool
    """The value of the cell as a boolean."""
    user_input: builtins.bool
    """The value of the cell that directly set by the user."""
    computed_value: builtins.bool
    """The value of the cell that was computed by the automatic computation."""
    def __init__(
        self,
        *,
        value: builtins.bool = ...,
        user_input: builtins.bool | None = ...,
        computed_value: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_computed_value", b"_computed_value", "_user_input", b"_user_input", "computed_value", b"computed_value", "user_input", b"user_input"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_computed_value", b"_computed_value", "_user_input", b"_user_input", "computed_value", b"computed_value", "user_input", b"user_input", "value", b"value"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_computed_value", b"_computed_value"]) -> typing_extensions.Literal["computed_value"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_user_input", b"_user_input"]) -> typing_extensions.Literal["user_input"] | None: ...

global___BooleanCell = BooleanCell

@typing_extensions.final
class FileCell(google.protobuf.message.Message):
    """FileCell represents a cell with a file resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    OBJECT_UID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MIME_TYPE_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    FILE_URL_FIELD_NUMBER: builtins.int
    namespace: builtins.str
    """The namespace of the file resource."""
    file_uid: builtins.str
    """The File UID of the file resource."""
    object_uid: builtins.str
    """The UID of the raw object that the file resource belongs to."""
    name: builtins.str
    """File name"""
    mime_type: builtins.str
    """MIME type of the file."""
    catalog_id: builtins.str
    """The catalog ID of the file resource."""
    file_url: builtins.str
    """The URL of the file resource."""
    def __init__(
        self,
        *,
        namespace: builtins.str = ...,
        file_uid: builtins.str = ...,
        object_uid: builtins.str = ...,
        name: builtins.str = ...,
        mime_type: builtins.str = ...,
        catalog_id: builtins.str = ...,
        file_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["catalog_id", b"catalog_id", "file_uid", b"file_uid", "file_url", b"file_url", "mime_type", b"mime_type", "name", b"name", "namespace", b"namespace", "object_uid", b"object_uid"]) -> None: ...

global___FileCell = FileCell

@typing_extensions.final
class DocumentCell(google.protobuf.message.Message):
    """DocumentCell represents a cell with a document resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_FIELD_NUMBER: builtins.int
    FILE_UID_FIELD_NUMBER: builtins.int
    OBJECT_UID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MIME_TYPE_FIELD_NUMBER: builtins.int
    namespace: builtins.str
    """The namespace of the document resource."""
    file_uid: builtins.str
    """The File UID of the document resource."""
    object_uid: builtins.str
    """The UID of the raw object that the document resource belongs to."""
    name: builtins.str
    """File name"""
    mime_type: builtins.str
    """MIME type of the document."""
    def __init__(
        self,
        *,
        namespace: builtins.str = ...,
        file_uid: builtins.str = ...,
        object_uid: builtins.str = ...,
        name: builtins.str = ...,
        mime_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["file_uid", b"file_uid", "mime_type", b"mime_type", "name", b"name", "namespace", b"namespace", "object_uid", b"object_uid"]) -> None: ...

global___DocumentCell = DocumentCell

@typing_extensions.final
class Row(google.protobuf.message.Message):
    """Row represents a row in a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class CellsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___Cell: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___Cell | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    UID_FIELD_NUMBER: builtins.int
    CELLS_FIELD_NUMBER: builtins.int
    ORDER_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """The unique identifier of the row."""
    @property
    def cells(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___Cell]:
        """Map of column UID to their cell values."""
    order: builtins.int
    """The order of the row in the table, starting at 1. This determines the row's position
    when displaying or processing table data.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp when the row was created."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp when the row was last updated."""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        cells: collections.abc.Mapping[builtins.str, global___Cell] | None = ...,
        order: builtins.int = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cells", b"cells", "create_time", b"create_time", "order", b"order", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___Row = Row

@typing_extensions.final
class ListRowsRequest(google.protobuf.message.Message):
    """ListRowsRequest represents a request to fetch rows from a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table whose rows to fetch."""
    page_size: builtins.int
    """The maximum number of rows to return."""
    page_token: builtins.str
    """The page token for pagination."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token", "table_uid", b"table_uid"]) -> None: ...

global___ListRowsRequest = ListRowsRequest

@typing_extensions.final
class ListRowsResponse(google.protobuf.message.Message):
    """ListRowsResponse contains the requested rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROWS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def rows(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Row]:
        """The list of rows."""
    next_page_token: builtins.str
    """The token for the next page of results."""
    total_size: builtins.int
    """The total number of rows that match the request."""
    def __init__(
        self,
        *,
        rows: collections.abc.Iterable[global___Row] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "rows", b"rows", "total_size", b"total_size"]) -> None: ...

global___ListRowsResponse = ListRowsResponse

@typing_extensions.final
class InsertRowRequest(google.protobuf.message.Message):
    """InsertRowRequest represents a request to insert a row into a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_FIELD_NUMBER: builtins.int
    BEFORE_ROW_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to insert rows into."""
    @property
    def row(self) -> global___Row:
        """The rows to insert."""
    before_row_uid: builtins.str
    """The unique identifier of the row to insert before."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row: global___Row | None = ...,
        before_row_uid: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_before_row_uid", b"_before_row_uid", "before_row_uid", b"before_row_uid", "row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_before_row_uid", b"_before_row_uid", "before_row_uid", b"before_row_uid", "namespace_id", b"namespace_id", "row", b"row", "table_uid", b"table_uid"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_before_row_uid", b"_before_row_uid"]) -> typing_extensions.Literal["before_row_uid"] | None: ...

global___InsertRowRequest = InsertRowRequest

@typing_extensions.final
class InsertRowResponse(google.protobuf.message.Message):
    """InsertRowResponse contains the inserted row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    @property
    def row(self) -> global___Row:
        """The inserted row resource."""
    def __init__(
        self,
        *,
        row: global___Row | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["row", b"row"]) -> None: ...

global___InsertRowResponse = InsertRowResponse

@typing_extensions.final
class UpdateRowRequest(google.protobuf.message.Message):
    """UpdateRowRequest represents a request to update a row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    ROW_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the row."""
    row_uid: builtins.str
    """The unique identifier of the row to update."""
    @property
    def row(self) -> global___Row:
        """The new row data."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        row: global___Row | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "row", b"row", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___UpdateRowRequest = UpdateRowRequest

@typing_extensions.final
class UpdateRowResponse(google.protobuf.message.Message):
    """UpdateRowResponse contains the updated row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    @property
    def row(self) -> global___Row:
        """The updated row resource."""
    def __init__(
        self,
        *,
        row: global___Row | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["row", b"row"]) -> None: ...

global___UpdateRowResponse = UpdateRowResponse

@typing_extensions.final
class GetRowRequest(google.protobuf.message.Message):
    """GetRowRequest represents a request to get a row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the row."""
    row_uid: builtins.str
    """The unique identifier of the row to get."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___GetRowRequest = GetRowRequest

@typing_extensions.final
class GetRowResponse(google.protobuf.message.Message):
    """GetRowResponse contains the requested row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    @property
    def row(self) -> global___Row:
        """The row resource."""
    def __init__(
        self,
        *,
        row: global___Row | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["row", b"row"]) -> None: ...

global___GetRowResponse = GetRowResponse

@typing_extensions.final
class UpdateRowsRequest(google.protobuf.message.Message):
    """UpdateRowsRequest represents a request to update multiple rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROWS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the rows."""
    @property
    def rows(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Row]:
        """The rows to update."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        rows: collections.abc.Iterable[global___Row] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "rows", b"rows", "table_uid", b"table_uid"]) -> None: ...

global___UpdateRowsRequest = UpdateRowsRequest

@typing_extensions.final
class UpdateRowsResponse(google.protobuf.message.Message):
    """UpdateRowsResponse contains the updated rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROWS_FIELD_NUMBER: builtins.int
    @property
    def rows(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Row]:
        """The updated row resources."""
    def __init__(
        self,
        *,
        rows: collections.abc.Iterable[global___Row] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["rows", b"rows"]) -> None: ...

global___UpdateRowsResponse = UpdateRowsResponse

@typing_extensions.final
class DeleteRowRequest(google.protobuf.message.Message):
    """DeleteRowRequest represents a request to delete a row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the row."""
    row_uid: builtins.str
    """The unique identifier of the row to delete."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___DeleteRowRequest = DeleteRowRequest

@typing_extensions.final
class DeleteRowResponse(google.protobuf.message.Message):
    """DeleteRowResponse is an empty response for deleting a row."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteRowResponse = DeleteRowResponse

@typing_extensions.final
class DeleteRowsRequest(google.protobuf.message.Message):
    """DeleteRowsRequest represents a request to delete multiple rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UIDS_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the rows."""
    @property
    def row_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The unique identifiers of the rows to delete."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "row_uids", b"row_uids", "table_uid", b"table_uid"]) -> None: ...

global___DeleteRowsRequest = DeleteRowsRequest

@typing_extensions.final
class DeleteRowsResponse(google.protobuf.message.Message):
    """DeleteRowsResponse is an empty response for deleting multiple rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteRowsResponse = DeleteRowsResponse

@typing_extensions.final
class MoveRowsRequest(google.protobuf.message.Message):
    """MoveRowsRequest represents a request to move multiple rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UIDS_FIELD_NUMBER: builtins.int
    BEFORE_ROW_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the row."""
    @property
    def row_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The unique identifiers of the rows to be moved."""
    before_row_uid: builtins.str
    """The unique identifier of the row to move before."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uids: collections.abc.Iterable[builtins.str] | None = ...,
        before_row_uid: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_before_row_uid", b"_before_row_uid", "before_row_uid", b"before_row_uid"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_before_row_uid", b"_before_row_uid", "before_row_uid", b"before_row_uid", "namespace_id", b"namespace_id", "row_uids", b"row_uids", "table_uid", b"table_uid"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_before_row_uid", b"_before_row_uid"]) -> typing_extensions.Literal["before_row_uid"] | None: ...

global___MoveRowsRequest = MoveRowsRequest

@typing_extensions.final
class MoveRowsResponse(google.protobuf.message.Message):
    """MoveRowsResponse is an empty response for moving multiple rows."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___MoveRowsResponse = MoveRowsResponse

@typing_extensions.final
class GetCellRequest(google.protobuf.message.Message):
    """GetCellRequest represents a request to get a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    CELL_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the row."""
    row_uid: builtins.str
    """The unique identifier of the row containing the cell."""
    cell_uid: builtins.str
    """The unique identifier of the cell to get."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        cell_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell_uid", b"cell_uid", "namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___GetCellRequest = GetCellRequest

@typing_extensions.final
class GetCellResponse(google.protobuf.message.Message):
    """GetCellResponse contains the requested cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The cell resource."""
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> None: ...

global___GetCellResponse = GetCellResponse

@typing_extensions.final
class UpdateCellRequest(google.protobuf.message.Message):
    """UpdateCellRequest represents a request to update a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    CELL_UID_FIELD_NUMBER: builtins.int
    CELL_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the row."""
    row_uid: builtins.str
    """The unique identifier of the row containing the cell."""
    cell_uid: builtins.str
    """The unique identifier of the cell to update."""
    @property
    def cell(self) -> global___Cell:
        """The new cell data."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        cell_uid: builtins.str = ...,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell", "cell_uid", b"cell_uid", "namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___UpdateCellRequest = UpdateCellRequest

@typing_extensions.final
class UpdateCellResponse(google.protobuf.message.Message):
    """UpdateCellResponse contains the updated cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The updated cell resource."""
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> None: ...

global___UpdateCellResponse = UpdateCellResponse

@typing_extensions.final
class RecomputeCellRequest(google.protobuf.message.Message):
    """RecomputeCellRequest represents a request to recompute a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    CELL_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the cell."""
    row_uid: builtins.str
    """The unique identifier of the row containing the cell."""
    cell_uid: builtins.str
    """The unique identifier of the cell to recompute."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        cell_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell_uid", b"cell_uid", "namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___RecomputeCellRequest = RecomputeCellRequest

@typing_extensions.final
class RecomputeCellResponse(google.protobuf.message.Message):
    """RecomputeCellResponse contains the updated cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The updated cell resource."""
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> None: ...

global___RecomputeCellResponse = RecomputeCellResponse

@typing_extensions.final
class ResetCellRequest(google.protobuf.message.Message):
    """ResetCellRequest represents a request to reset a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    CELL_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the cell."""
    row_uid: builtins.str
    """The unique identifier of the row containing the cell."""
    cell_uid: builtins.str
    """The unique identifier of the cell to reset."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        cell_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell_uid", b"cell_uid", "namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___ResetCellRequest = ResetCellRequest

@typing_extensions.final
class ResetCellResponse(google.protobuf.message.Message):
    """ResetCellResponse is an empty response for resetting a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The updated cell resource."""
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> None: ...

global___ResetCellResponse = ResetCellResponse

@typing_extensions.final
class LockCellRequest(google.protobuf.message.Message):
    """LockCellRequest represents a request to lock a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    CELL_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the cell."""
    row_uid: builtins.str
    """The unique identifier of the row containing the cell."""
    cell_uid: builtins.str
    """The unique identifier of the cell to lock."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        cell_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell_uid", b"cell_uid", "namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___LockCellRequest = LockCellRequest

@typing_extensions.final
class LockCellResponse(google.protobuf.message.Message):
    """LockCellResponse is an empty response for locking a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The updated cell resource."""
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> None: ...

global___LockCellResponse = LockCellResponse

@typing_extensions.final
class UnlockCellRequest(google.protobuf.message.Message):
    """UnlockCellRequest represents a request to unlock a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    ROW_UID_FIELD_NUMBER: builtins.int
    CELL_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table containing the cell."""
    row_uid: builtins.str
    """The unique identifier of the row containing the cell."""
    cell_uid: builtins.str
    """The unique identifier of the cell to unlock."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        row_uid: builtins.str = ...,
        cell_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell_uid", b"cell_uid", "namespace_id", b"namespace_id", "row_uid", b"row_uid", "table_uid", b"table_uid"]) -> None: ...

global___UnlockCellRequest = UnlockCellRequest

@typing_extensions.final
class UnlockCellResponse(google.protobuf.message.Message):
    """UnlockCellResponse is an empty response for unlocking a cell."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The updated cell resource."""
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> None: ...

global___UnlockCellResponse = UnlockCellResponse

@typing_extensions.final
class ExportTableRequest(google.protobuf.message.Message):
    """ExportTableRequest represents a request to export table data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to export."""
    format: global___ExportFormat.ValueType
    """The format to export the data in."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        format: global___ExportFormat.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["format", b"format", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___ExportTableRequest = ExportTableRequest

@typing_extensions.final
class ExportTableResponse(google.protobuf.message.Message):
    """ExportTableResponse is an empty response for exporting table data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """The exported data."""
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["data", b"data"]) -> None: ...

global___ExportTableResponse = ExportTableResponse

@typing_extensions.final
class GetTableEventsRequest(google.protobuf.message.Message):
    """GetTableEventsRequest represents a request to fetch events for a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to fetch events for."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___GetTableEventsRequest = GetTableEventsRequest

@typing_extensions.final
class GetTableEventsResponse(google.protobuf.message.Message):
    """GetTableEventsResponse contains the events for a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_FIELD_NUMBER: builtins.int
    @property
    def event(self) -> global___TableEvent:
        """The events for the table."""
    def __init__(
        self,
        *,
        event: global___TableEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["event", b"event"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event", b"event"]) -> None: ...

global___GetTableEventsResponse = GetTableEventsResponse

@typing_extensions.final
class TableEvent(google.protobuf.message.Message):
    """TableEvent represents an event for a table."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EVENT_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TABLE_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    TABLE_DELETED_EVENT_FIELD_NUMBER: builtins.int
    COLUMN_DEFINITIONS_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    ROW_INSERTED_EVENT_FIELD_NUMBER: builtins.int
    ROW_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    ROW_DELETED_EVENT_FIELD_NUMBER: builtins.int
    ROWS_MOVED_EVENT_FIELD_NUMBER: builtins.int
    CELL_UPDATED_EVENT_FIELD_NUMBER: builtins.int
    event: builtins.str
    """The event type.
    In text/event-stream format, this maps to the `event` field.
    """
    id: builtins.str
    """The ID of the event.
    In text/event-stream format, this maps to the `id` field.
    """
    @property
    def table_updated_event(self) -> global___TableUpdatedEvent:
        """The table that was updated."""
    @property
    def table_deleted_event(self) -> global___TableDeletedEvent:
        """The table that was deleted."""
    @property
    def column_definitions_updated_event(self) -> global___ColumnDefinitionsUpdatedEvent:
        """The column definitions that were updated."""
    @property
    def row_inserted_event(self) -> global___RowInsertedEvent:
        """The row that was inserted."""
    @property
    def row_updated_event(self) -> global___RowUpdatedEvent:
        """The row that was updated."""
    @property
    def row_deleted_event(self) -> global___RowDeletedEvent:
        """The row that was deleted."""
    @property
    def rows_moved_event(self) -> global___RowsMovedEvent:
        """The rows that were moved."""
    @property
    def cell_updated_event(self) -> global___CellUpdatedEvent:
        """The cell that was updated."""
    def __init__(
        self,
        *,
        event: builtins.str = ...,
        id: builtins.str = ...,
        table_updated_event: global___TableUpdatedEvent | None = ...,
        table_deleted_event: global___TableDeletedEvent | None = ...,
        column_definitions_updated_event: global___ColumnDefinitionsUpdatedEvent | None = ...,
        row_inserted_event: global___RowInsertedEvent | None = ...,
        row_updated_event: global___RowUpdatedEvent | None = ...,
        row_deleted_event: global___RowDeletedEvent | None = ...,
        rows_moved_event: global___RowsMovedEvent | None = ...,
        cell_updated_event: global___CellUpdatedEvent | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell_updated_event", b"cell_updated_event", "column_definitions_updated_event", b"column_definitions_updated_event", "data", b"data", "row_deleted_event", b"row_deleted_event", "row_inserted_event", b"row_inserted_event", "row_updated_event", b"row_updated_event", "rows_moved_event", b"rows_moved_event", "table_deleted_event", b"table_deleted_event", "table_updated_event", b"table_updated_event"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell_updated_event", b"cell_updated_event", "column_definitions_updated_event", b"column_definitions_updated_event", "data", b"data", "event", b"event", "id", b"id", "row_deleted_event", b"row_deleted_event", "row_inserted_event", b"row_inserted_event", "row_updated_event", b"row_updated_event", "rows_moved_event", b"rows_moved_event", "table_deleted_event", b"table_deleted_event", "table_updated_event", b"table_updated_event"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["data", b"data"]) -> typing_extensions.Literal["table_updated_event", "table_deleted_event", "column_definitions_updated_event", "row_inserted_event", "row_updated_event", "row_deleted_event", "rows_moved_event", "cell_updated_event"] | None: ...

global___TableEvent = TableEvent

@typing_extensions.final
class TableUpdatedEvent(google.protobuf.message.Message):
    """TableUpdatedEvent represents an event for a table being updated."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> global___Table:
        """The table that was updated."""
    def __init__(
        self,
        *,
        table: global___Table | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["table", b"table"]) -> None: ...

global___TableUpdatedEvent = TableUpdatedEvent

@typing_extensions.final
class TableDeletedEvent(google.protobuf.message.Message):
    """TableDeletedEvent represents an event for a table being deleted."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___TableDeletedEvent = TableDeletedEvent

@typing_extensions.final
class ColumnDefinitionsUpdatedEvent(google.protobuf.message.Message):
    """ColumnDefinitionsUpdatedEvent represents an event for column definitions being updated."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class ColumnDefinitionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___ColumnDefinition: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___ColumnDefinition | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    COLUMN_DEFINITIONS_FIELD_NUMBER: builtins.int
    @property
    def column_definitions(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___ColumnDefinition]:
        """The column definitions that were updated."""
    def __init__(
        self,
        *,
        column_definitions: collections.abc.Mapping[builtins.str, global___ColumnDefinition] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["column_definitions", b"column_definitions"]) -> None: ...

global___ColumnDefinitionsUpdatedEvent = ColumnDefinitionsUpdatedEvent

@typing_extensions.final
class RowInsertedEvent(google.protobuf.message.Message):
    """RowInsertedEvent represents an event for a row being inserted."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    BEFORE_ROW_UID_FIELD_NUMBER: builtins.int
    @property
    def row(self) -> global___Row:
        """The row that was inserted.
        Note: Only the row metadata is returned, not the cell data.
        """
    before_row_uid: builtins.str
    """The unique identifier of the row that was inserted before."""
    def __init__(
        self,
        *,
        row: global___Row | None = ...,
        before_row_uid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["before_row_uid", b"before_row_uid", "row", b"row"]) -> None: ...

global___RowInsertedEvent = RowInsertedEvent

@typing_extensions.final
class RowUpdatedEvent(google.protobuf.message.Message):
    """RowUpdatedEvent represents an event for a row being updated."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_FIELD_NUMBER: builtins.int
    @property
    def row(self) -> global___Row:
        """The row that was updated.
        Note: Only the row metadata is returned, not the cell data.
        """
    def __init__(
        self,
        *,
        row: global___Row | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["row", b"row"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["row", b"row"]) -> None: ...

global___RowUpdatedEvent = RowUpdatedEvent

@typing_extensions.final
class RowDeletedEvent(google.protobuf.message.Message):
    """RowDeletedEvent represents an event for a row being deleted."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_UID_FIELD_NUMBER: builtins.int
    row_uid: builtins.str
    """The unique identifier of the row that was deleted."""
    def __init__(
        self,
        *,
        row_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["row_uid", b"row_uid"]) -> None: ...

global___RowDeletedEvent = RowDeletedEvent

@typing_extensions.final
class RowsMovedEvent(google.protobuf.message.Message):
    """RowsMovedEvent represents an event for multiple rows being moved."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ROW_UIDS_FIELD_NUMBER: builtins.int
    BEFORE_ROW_UID_FIELD_NUMBER: builtins.int
    @property
    def row_uids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The unique identifiers of the rows that were moved."""
    before_row_uid: builtins.str
    """The unique identifier of the row that was moved before."""
    def __init__(
        self,
        *,
        row_uids: collections.abc.Iterable[builtins.str] | None = ...,
        before_row_uid: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_before_row_uid", b"_before_row_uid", "before_row_uid", b"before_row_uid"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_before_row_uid", b"_before_row_uid", "before_row_uid", b"before_row_uid", "row_uids", b"row_uids"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_before_row_uid", b"_before_row_uid"]) -> typing_extensions.Literal["before_row_uid"] | None: ...

global___RowsMovedEvent = RowsMovedEvent

@typing_extensions.final
class CellUpdatedEvent(google.protobuf.message.Message):
    """CellUpdatedEvent represents an event for a cell being updated."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CELL_FIELD_NUMBER: builtins.int
    DELTA_MODE_FIELD_NUMBER: builtins.int
    @property
    def cell(self) -> global___Cell:
        """The cell that was updated."""
    delta_mode: builtins.bool
    """Whether the event is a delta update.
    Only cells with string type can be returned in delta mode. Delta mode returns
    only the changes made to the cell value rather than the full value.
    """
    def __init__(
        self,
        *,
        cell: global___Cell | None = ...,
        delta_mode: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cell", b"cell"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cell", b"cell", "delta_mode", b"delta_mode"]) -> None: ...

global___CellUpdatedEvent = CellUpdatedEvent

@typing_extensions.final
class GenerateMockTableRequest(google.protobuf.message.Message):
    """GenerateMockTableRequest represents a request to generate mock table data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GenerateMockTableRequest._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: GenerateMockTableRequest._Mode.ValueType  # 0
        """The mode is not specified."""
        MODE_FILE: GenerateMockTableRequest._Mode.ValueType  # 1
        """The mode is to generate mock data for a file-type table."""
        MODE_SHEET: GenerateMockTableRequest._Mode.ValueType  # 2
        """The mode is to generate mock data for a sheet-type table."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper):
        """The mode to generate mock data."""

    MODE_UNSPECIFIED: GenerateMockTableRequest.Mode.ValueType  # 0
    """The mode is not specified."""
    MODE_FILE: GenerateMockTableRequest.Mode.ValueType  # 1
    """The mode is to generate mock data for a file-type table."""
    MODE_SHEET: GenerateMockTableRequest.Mode.ValueType  # 2
    """The mode is to generate mock data for a sheet-type table."""

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    NUM_ROWS_FIELD_NUMBER: builtins.int
    ENABLE_TRANSPARENCY_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    table_uid: builtins.str
    """The UID of the table to generate mock data for."""
    num_rows: builtins.int
    """The number of rows to generate."""
    enable_transparency: builtins.bool
    """Whether to enable transparency for the mock data."""
    mode: global___GenerateMockTableRequest.Mode.ValueType
    """The mode to generate mock data."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        table_uid: builtins.str = ...,
        num_rows: builtins.int | None = ...,
        enable_transparency: builtins.bool | None = ...,
        mode: global___GenerateMockTableRequest.Mode.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_enable_transparency", b"_enable_transparency", "_num_rows", b"_num_rows", "enable_transparency", b"enable_transparency", "num_rows", b"num_rows"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_enable_transparency", b"_enable_transparency", "_num_rows", b"_num_rows", "enable_transparency", b"enable_transparency", "mode", b"mode", "namespace_id", b"namespace_id", "num_rows", b"num_rows", "table_uid", b"table_uid"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_enable_transparency", b"_enable_transparency"]) -> typing_extensions.Literal["enable_transparency"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_num_rows", b"_num_rows"]) -> typing_extensions.Literal["num_rows"] | None: ...

global___GenerateMockTableRequest = GenerateMockTableRequest

@typing_extensions.final
class GenerateMockTableResponse(google.protobuf.message.Message):
    """GenerateMockTableResponse is an empty response for generating mock table data."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GenerateMockTableResponse = GenerateMockTableResponse

@typing_extensions.final
class BindChatTableRequest(google.protobuf.message.Message):
    """BindChatTableRequest represents a request to bind a table to a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    chat_uid: builtins.str
    """The UID of the chat to bind the table to."""
    table_uid: builtins.str
    """The UID of the table to bind to the chat."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
        table_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___BindChatTableRequest = BindChatTableRequest

@typing_extensions.final
class BindChatTableResponse(google.protobuf.message.Message):
    """BindChatTableResponse is an empty response for binding a table to a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___BindChatTableResponse = BindChatTableResponse

@typing_extensions.final
class UnbindChatTableRequest(google.protobuf.message.Message):
    """UnbindChatTableRequest represents a request to unbind a table from a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    TABLE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    chat_uid: builtins.str
    """The UID of the chat to unbind the table from."""
    table_uid: builtins.str
    """The UID of the table to unbind from the chat."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
        table_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "namespace_id", b"namespace_id", "table_uid", b"table_uid"]) -> None: ...

global___UnbindChatTableRequest = UnbindChatTableRequest

@typing_extensions.final
class UnbindChatTableResponse(google.protobuf.message.Message):
    """UnbindChatTableResponse is an empty response for unbinding a table from a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___UnbindChatTableResponse = UnbindChatTableResponse

@typing_extensions.final
class ListChatTablesRequest(google.protobuf.message.Message):
    """ListChatTablesRequest represents a request to list tables bound to a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    CHAT_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """The ID of the namespace that owns the table."""
    chat_uid: builtins.str
    """The UID of the chat to list tables for."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        chat_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chat_uid", b"chat_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___ListChatTablesRequest = ListChatTablesRequest

@typing_extensions.final
class ListChatTablesResponse(google.protobuf.message.Message):
    """ListChatTablesResponse contains the list of tables bound to a chat."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLES_FIELD_NUMBER: builtins.int
    @property
    def tables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Table]:
        """The tables bound to the chat."""
    def __init__(
        self,
        *,
        tables: collections.abc.Iterable[global___Table] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tables", b"tables"]) -> None: ...

global___ListChatTablesResponse = ListChatTablesResponse
