"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ReportPipelineTriggerRequest(google.protobuf.message.Message):
    """Pipeline trigger records REQ and RES messages for `pipeline-backend` clients

    ReportPipelineTriggerRequest represents a request for reporting a
    pipeline-trigger record
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    PIPELINE_FIELD_NUMBER: builtins.int
    USAGE_RECORD_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def pipeline(self) -> global___PipelineData:
        """Pipeline information"""
    @property
    def usage_record(self) -> global___PipelineUsageRecord:
        """Pipeline trigger record"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        pipeline: global___PipelineData | None = ...,
        usage_record: global___PipelineUsageRecord | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "usage_record", b"usage_record", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "usage_record", b"usage_record", "user", b"user"]) -> None: ...

global___ReportPipelineTriggerRequest = ReportPipelineTriggerRequest

@typing_extensions.final
class ReportPipelineTriggerResponse(google.protobuf.message.Message):
    """ReportPipelineTriggerResponse represents a respond to a
    pipeline-trigger-record report request
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NULL_FIELD_NUMBER: builtins.int
    @property
    def null(self) -> global___NullMessage:
        """Null message for empty response"""
    def __init__(
        self,
        *,
        null: global___NullMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["null", b"null"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["null", b"null"]) -> None: ...

global___ReportPipelineTriggerResponse = ReportPipelineTriggerResponse

@typing_extensions.final
class ReportPipelineTriggersRequest(google.protobuf.message.Message):
    """ReportPipelineTriggersRequest represents a request for reporting a list of
    pipeline-trigger records in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINE_TRIGGER_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def pipeline_trigger_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReportPipelineTriggerRequest]:
        """A list of pipeline trigger requests"""
    def __init__(
        self,
        *,
        pipeline_trigger_records: collections.abc.Iterable[global___ReportPipelineTriggerRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline_trigger_records", b"pipeline_trigger_records"]) -> None: ...

global___ReportPipelineTriggersRequest = ReportPipelineTriggersRequest

@typing_extensions.final
class ReportPipelineTriggersResponse(google.protobuf.message.Message):
    """ReportPipelineTriggersResponse represents a respond to a
    pipeline-trigger-records reporting bulk request
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NULL_FIELD_NUMBER: builtins.int
    @property
    def null(self) -> global___NullMessage:
        """Null message for empty response"""
    def __init__(
        self,
        *,
        null: global___NullMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["null", b"null"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["null", b"null"]) -> None: ...

global___ReportPipelineTriggersResponse = ReportPipelineTriggersResponse

@typing_extensions.final
class ReportModelOnlineRequest(google.protobuf.message.Message):
    """Model online records REQ and RES messages for `model-backend` clients

    ReportModelOnlineRequest represents a request for reporting a model-online
    record
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    CUM_USAGE_RECORD_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def model(self) -> global___ModelData:
        """Model information"""
    @property
    def cum_usage_record(self) -> global___ModelUsageRecord:
        """Model online record"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        model: global___ModelData | None = ...,
        cum_usage_record: global___ModelUsageRecord | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["cum_usage_record", b"cum_usage_record", "model", b"model", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cum_usage_record", b"cum_usage_record", "model", b"model", "user", b"user"]) -> None: ...

global___ReportModelOnlineRequest = ReportModelOnlineRequest

@typing_extensions.final
class ReportModelOnlineResponse(google.protobuf.message.Message):
    """ReportModelOnlineResponse represents a respond to a model-online-record
    report request
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NULL_FIELD_NUMBER: builtins.int
    @property
    def null(self) -> global___NullMessage:
        """Null message for empty response"""
    def __init__(
        self,
        *,
        null: global___NullMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["null", b"null"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["null", b"null"]) -> None: ...

global___ReportModelOnlineResponse = ReportModelOnlineResponse

@typing_extensions.final
class ReportModelOnlinesRequest(google.protobuf.message.Message):
    """ReportModelOnlinesRequest represents a request for reporting a list of
    model-online records in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_ONLINE_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def model_online_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReportModelOnlineRequest]:
        """A list of model online requests"""
    def __init__(
        self,
        *,
        model_online_records: collections.abc.Iterable[global___ReportModelOnlineRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["model_online_records", b"model_online_records"]) -> None: ...

global___ReportModelOnlinesRequest = ReportModelOnlinesRequest

@typing_extensions.final
class ReportModelOnlinesResponse(google.protobuf.message.Message):
    """ReportModelOnlinesResponse represents a respond to a model-online-records
    reporting bulk request
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NULL_FIELD_NUMBER: builtins.int
    @property
    def null(self) -> global___NullMessage:
        """Null message for empty response"""
    def __init__(
        self,
        *,
        null: global___NullMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["null", b"null"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["null", b"null"]) -> None: ...

global___ReportModelOnlinesResponse = ReportModelOnlinesResponse

@typing_extensions.final
class GetPipelinesRequest(google.protobuf.message.Message):
    """Query pipeline info with user info

    GetPipelinesRequest represents a request for the pipelines recorded given a
    user and time interval
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetPipelinesRequest = GetPipelinesRequest

@typing_extensions.final
class GetPipelinesResponse(google.protobuf.message.Message):
    """GetPipelinesResponse represents a respond to GetPipelineRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIPELINES_FIELD_NUMBER: builtins.int
    @property
    def pipelines(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineData]:
        """A list of pipeline informations"""
    def __init__(
        self,
        *,
        pipelines: collections.abc.Iterable[global___PipelineData] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipelines", b"pipelines"]) -> None: ...

global___GetPipelinesResponse = GetPipelinesResponse

@typing_extensions.final
class GetModelsRequest(google.protobuf.message.Message):
    """Query model info with user info

    GetModelsRequest represents a request for the models recorded given user and
    time interval
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetModelsRequest = GetModelsRequest

@typing_extensions.final
class GetModelsResponse(google.protobuf.message.Message):
    """GetPipelinesResponse represents a respond to GetModelsRequest"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODELS_FIELD_NUMBER: builtins.int
    @property
    def models(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelData]:
        """A list of model informations"""
    def __init__(
        self,
        *,
        models: collections.abc.Iterable[global___ModelData] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["models", b"models"]) -> None: ...

global___GetModelsResponse = GetModelsResponse

@typing_extensions.final
class GetPipelineTriggerRecordsRequest(google.protobuf.message.Message):
    """Query REQ and RES for pipeline trigger records and summary

    GetPipelineTriggerRecordsRequest represents a query for pipeline trigger
    records
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    PIPELINE_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def pipeline(self) -> global___PipelineData:
        """Pipeline information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        pipeline: global___PipelineData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetPipelineTriggerRecordsRequest = GetPipelineTriggerRecordsRequest

@typing_extensions.final
class GetPipelineTriggerRecordsResponse(google.protobuf.message.Message):
    """GetPipelineTriggerRecordsResponse represents a response to
    GetPipelineTriggerRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORDS_FIELD_NUMBER: builtins.int
    @property
    def records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineUsageRecord]:
        """A list of pipeline trigger records"""
    def __init__(
        self,
        *,
        records: collections.abc.Iterable[global___PipelineUsageRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["records", b"records"]) -> None: ...

global___GetPipelineTriggerRecordsResponse = GetPipelineTriggerRecordsResponse

@typing_extensions.final
class GetBulkPipelineTriggerRecordsRequest(google.protobuf.message.Message):
    """GetBulkPipelineTriggerRecordsRequest represents a query for pipeline trigger
    records in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPipelineTriggerRecordsRequest]:
        """A list of pipeline trigger record request payloads"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetPipelineTriggerRecordsRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkPipelineTriggerRecordsRequest = GetBulkPipelineTriggerRecordsRequest

@typing_extensions.final
class GetBulkPipelineTriggerRecordsResponse(google.protobuf.message.Message):
    """GetBulkPipelineTriggerRecordsResponse represents a response to
    GetBulkPipelineTriggerRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def bulk_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPipelineTriggerRecordsResponse]:
        """A list of pipeline trigger record lists"""
    def __init__(
        self,
        *,
        bulk_records: collections.abc.Iterable[global___GetPipelineTriggerRecordsResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_records", b"bulk_records"]) -> None: ...

global___GetBulkPipelineTriggerRecordsResponse = GetBulkPipelineTriggerRecordsResponse

@typing_extensions.final
class GetCumulativePipelineTriggerRecordsRequest(google.protobuf.message.Message):
    """GetCumulativePipelineTriggerRecordsRequest represents a query for cumulative
    pipeline trigger records
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    PIPELINE_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def pipeline(self) -> global___PipelineData:
        """Pipeline information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        pipeline: global___PipelineData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetCumulativePipelineTriggerRecordsRequest = GetCumulativePipelineTriggerRecordsRequest

@typing_extensions.final
class GetCumulativePipelineTriggerRecordsResponse(google.protobuf.message.Message):
    """GetCumulativePipelineTriggerRecordsResponse represents a response to
    GetCumulativePipelineTriggerRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CUMULATIVE_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def cumulative_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PipelineUsageRecord]:
        """Pipeline trigger records where values are in cumulative formats"""
    def __init__(
        self,
        *,
        cumulative_records: collections.abc.Iterable[global___PipelineUsageRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cumulative_records", b"cumulative_records"]) -> None: ...

global___GetCumulativePipelineTriggerRecordsResponse = GetCumulativePipelineTriggerRecordsResponse

@typing_extensions.final
class GetBulkCumulativePipelineTriggerRecordsRequest(google.protobuf.message.Message):
    """GetBulkCumulativePipelineTriggerRecordsRequest represents a query for
    cumulative pipeline trigger records in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetCumulativePipelineTriggerRecordsRequest]:
        """A list of cumulative pipeline trigger record request payloads"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetCumulativePipelineTriggerRecordsRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkCumulativePipelineTriggerRecordsRequest = GetBulkCumulativePipelineTriggerRecordsRequest

@typing_extensions.final
class GetBulkCumulativePipelineTriggerRecordsResponse(google.protobuf.message.Message):
    """GetBulkCumulativePipelineTriggerRecordsResponse represents a response to
    GetBulkCumulativePipelineTriggerRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_CUMULATIVE_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def bulk_cumulative_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetCumulativePipelineTriggerRecordsResponse]:
        """A list of cumulative pipeline trigger record lists"""
    def __init__(
        self,
        *,
        bulk_cumulative_records: collections.abc.Iterable[global___GetCumulativePipelineTriggerRecordsResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_cumulative_records", b"bulk_cumulative_records"]) -> None: ...

global___GetBulkCumulativePipelineTriggerRecordsResponse = GetBulkCumulativePipelineTriggerRecordsResponse

@typing_extensions.final
class GetPipelineTriggerSummaryRequest(google.protobuf.message.Message):
    """GetPipelineTriggerSummaryRequest represents a query for pipeline trigger
    summary
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    PIPELINE_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def pipeline(self) -> global___PipelineData:
        """Pipeline information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        pipeline: global___PipelineData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetPipelineTriggerSummaryRequest = GetPipelineTriggerSummaryRequest

@typing_extensions.final
class GetPipelineTriggerSummaryResponse(google.protobuf.message.Message):
    """GetPipelineTriggerSummaryResponse represents a response to
    GetPipelineTriggerSummaryRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUMMARIES_FIELD_NUMBER: builtins.int
    @property
    def summaries(self) -> global___UsageSummary:
        """The total pipeline trigger usage in the time interval"""
    def __init__(
        self,
        *,
        summaries: global___UsageSummary | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["summaries", b"summaries"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["summaries", b"summaries"]) -> None: ...

global___GetPipelineTriggerSummaryResponse = GetPipelineTriggerSummaryResponse

@typing_extensions.final
class GetBulkPipelineTriggerSummariesRequest(google.protobuf.message.Message):
    """GetBulkPipelineTriggerSummariesRequest represents a query for pipeline
    trigger summaries in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPipelineTriggerSummaryRequest]:
        """A list of queries for pipeline trigger summaries"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetPipelineTriggerSummaryRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkPipelineTriggerSummariesRequest = GetBulkPipelineTriggerSummariesRequest

@typing_extensions.final
class GetBulkPipelineTriggerSummariesResponse(google.protobuf.message.Message):
    """GetBulkPipelineTriggerSummariesResponse represents a response to
    GetBulkPipelineTriggerSummariesRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_SUMMARIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_summaries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPipelineTriggerSummaryResponse]:
        """A list of pipeline trigger usage summaries"""
    def __init__(
        self,
        *,
        bulk_summaries: collections.abc.Iterable[global___GetPipelineTriggerSummaryResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_summaries", b"bulk_summaries"]) -> None: ...

global___GetBulkPipelineTriggerSummariesResponse = GetBulkPipelineTriggerSummariesResponse

@typing_extensions.final
class GetModelOnlineRecordsRequest(google.protobuf.message.Message):
    """Query REQ and RES for model online records and summary

    GetModelOnlineRecordsRequest represent a query for model online records
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def model(self) -> global___ModelData:
        """Model information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        model: global___ModelData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetModelOnlineRecordsRequest = GetModelOnlineRecordsRequest

@typing_extensions.final
class GetModelOnlineRecordsResponse(google.protobuf.message.Message):
    """GetModelOnlineRecordsResponse represents a response to
    GetModelOnlineRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RECORDS_FIELD_NUMBER: builtins.int
    @property
    def records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelUsageRecord]:
        """A list of model trigger records"""
    def __init__(
        self,
        *,
        records: collections.abc.Iterable[global___ModelUsageRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["records", b"records"]) -> None: ...

global___GetModelOnlineRecordsResponse = GetModelOnlineRecordsResponse

@typing_extensions.final
class GetBulkModelOnlineRecordsRequest(google.protobuf.message.Message):
    """GetBulkModelOnlineRecordsRequest represents a query for model online records
    in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetModelOnlineRecordsRequest]:
        """A list of model online records request payloads"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetModelOnlineRecordsRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkModelOnlineRecordsRequest = GetBulkModelOnlineRecordsRequest

@typing_extensions.final
class GetBulkModelOnlineRecordsResponse(google.protobuf.message.Message):
    """GetBulkModelOnlineRecordsResponse represents a response to
    GetBulkModelOnlineRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def bulk_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetModelOnlineRecordsResponse]:
        """A list of model online record lists"""
    def __init__(
        self,
        *,
        bulk_records: collections.abc.Iterable[global___GetModelOnlineRecordsResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_records", b"bulk_records"]) -> None: ...

global___GetBulkModelOnlineRecordsResponse = GetBulkModelOnlineRecordsResponse

@typing_extensions.final
class GetCumulativeModelOnlineRecordsRequest(google.protobuf.message.Message):
    """GetCumulativeModelOnlineRecordsRequest represents a query for cumulative
    model online records
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def model(self) -> global___ModelData:
        """Model information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        model: global___ModelData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetCumulativeModelOnlineRecordsRequest = GetCumulativeModelOnlineRecordsRequest

@typing_extensions.final
class GetCumulativeModelOnlineRecordsResponse(google.protobuf.message.Message):
    """GetCumulativeModelOnlineRecordsResponse represents a response to
    GetCumulativeModelOnlineRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CUMULATIVE_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def cumulative_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ModelUsageRecord]:
        """A list of model online records in cumulative format"""
    def __init__(
        self,
        *,
        cumulative_records: collections.abc.Iterable[global___ModelUsageRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["cumulative_records", b"cumulative_records"]) -> None: ...

global___GetCumulativeModelOnlineRecordsResponse = GetCumulativeModelOnlineRecordsResponse

@typing_extensions.final
class GetBulkCumulativeModelOnlineRecordsRequest(google.protobuf.message.Message):
    """GetBulkCumulativeModelOnlineRecordsRequest represents a query for cumulative
    model online records in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetCumulativeModelOnlineRecordsRequest]:
        """A list of cumulative model online record request payloads"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetCumulativeModelOnlineRecordsRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkCumulativeModelOnlineRecordsRequest = GetBulkCumulativeModelOnlineRecordsRequest

@typing_extensions.final
class GetBulkCumulativeModelOnlineRecordsResponse(google.protobuf.message.Message):
    """GetBulkCumulativeModelOnlineRecordsResponse represents a response to
    GetBulkCumulativeModelOnlineRecordsRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_CUMULATIVE_RECORDS_FIELD_NUMBER: builtins.int
    @property
    def bulk_cumulative_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetCumulativeModelOnlineRecordsResponse]:
        """A list of cumulative model online record lists"""
    def __init__(
        self,
        *,
        bulk_cumulative_records: collections.abc.Iterable[global___GetCumulativeModelOnlineRecordsResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_cumulative_records", b"bulk_cumulative_records"]) -> None: ...

global___GetBulkCumulativeModelOnlineRecordsResponse = GetBulkCumulativeModelOnlineRecordsResponse

@typing_extensions.final
class GetModelOnlineSummaryRequest(google.protobuf.message.Message):
    """GetModelOnlineSummaryRequest represents a query for model online summary"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def model(self) -> global___ModelData:
        """Pipeline information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        model: global___ModelData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetModelOnlineSummaryRequest = GetModelOnlineSummaryRequest

@typing_extensions.final
class GetModelOnlineSummaryResponse(google.protobuf.message.Message):
    """GetModelOnlineSummaryResponse represents a response to
    GetModelOnlineSummaryRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUMMARY_FIELD_NUMBER: builtins.int
    @property
    def summary(self) -> global___UsageSummary:
        """The total model online usage in the time interval"""
    def __init__(
        self,
        *,
        summary: global___UsageSummary | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["summary", b"summary"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["summary", b"summary"]) -> None: ...

global___GetModelOnlineSummaryResponse = GetModelOnlineSummaryResponse

@typing_extensions.final
class GetBulkModelOnlineSummaryRequest(google.protobuf.message.Message):
    """GetBulkModelOnlineSummaryRequest represents a query for model online
    summaries in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetModelOnlineSummaryRequest]:
        """A list of queries for model online summaries"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetModelOnlineSummaryRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkModelOnlineSummaryRequest = GetBulkModelOnlineSummaryRequest

@typing_extensions.final
class GetBulkModelOnlineSummaryResponse(google.protobuf.message.Message):
    """GetBulkModelOnlineSummaryResponse represents a response to
    GetBulkModelOnlineSummaryRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_SUMMARIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_summaries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetModelOnlineSummaryResponse]:
        """A list of model online usage summaries"""
    def __init__(
        self,
        *,
        bulk_summaries: collections.abc.Iterable[global___GetModelOnlineSummaryResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_summaries", b"bulk_summaries"]) -> None: ...

global___GetBulkModelOnlineSummaryResponse = GetBulkModelOnlineSummaryResponse

@typing_extensions.final
class GetPipelineTriggerPriceRequest(google.protobuf.message.Message):
    """We only provide the price that will be charged for the current period

    GetPipelineTriggerPriceRequest represents a query for pipeline trigger prices
    given the billing periods covered by the time interval
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    PIPELINE_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def pipeline(self) -> global___PipelineData:
        """Pipeline information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        pipeline: global___PipelineData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["pipeline", b"pipeline", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetPipelineTriggerPriceRequest = GetPipelineTriggerPriceRequest

@typing_extensions.final
class GetPipelineTriggerPriceResponse(google.protobuf.message.Message):
    """GetPipelineTriggerPriceResponse represents a response to
    GetPipelineTriggerPriceRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRICE_FIELD_NUMBER: builtins.int
    @property
    def price(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PriceData]:
        """A list of pipeline trigger prices given the billing periods covered by the
        time interval
        """
    def __init__(
        self,
        *,
        price: collections.abc.Iterable[global___PriceData] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["price", b"price"]) -> None: ...

global___GetPipelineTriggerPriceResponse = GetPipelineTriggerPriceResponse

@typing_extensions.final
class GetBulkPipelineTriggerPriceRequest(google.protobuf.message.Message):
    """GetBulkPipelineTriggerPriceRequest represents a query for pipeline trigger
    prices in bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPipelineTriggerPriceRequest]:
        """A list of pipeline trigger price request payloads"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetPipelineTriggerPriceRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkPipelineTriggerPriceRequest = GetBulkPipelineTriggerPriceRequest

@typing_extensions.final
class GetBulkPipelineTriggerPriceResponse(google.protobuf.message.Message):
    """GetBulkPipelineTriggerPriceResponse represents a response to
    GetBulkPipelineTriggerPriceRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_PRICES_FIELD_NUMBER: builtins.int
    @property
    def bulk_prices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetPipelineTriggerPriceResponse]:
        """A list of pipeline trigger price lists"""
    def __init__(
        self,
        *,
        bulk_prices: collections.abc.Iterable[global___GetPipelineTriggerPriceResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_prices", b"bulk_prices"]) -> None: ...

global___GetBulkPipelineTriggerPriceResponse = GetBulkPipelineTriggerPriceResponse

@typing_extensions.final
class GetModelOnlinePriceRequest(google.protobuf.message.Message):
    """Query for model online price

    GetPipelineTriggerPriceRequest represents a query for price data of the
    billing periods covered by the time interval
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    USER_FIELD_NUMBER: builtins.int
    MODEL_FIELD_NUMBER: builtins.int
    TIME_INTERVAL_FIELD_NUMBER: builtins.int
    @property
    def user(self) -> global___UserData:
        """User information"""
    @property
    def model(self) -> global___ModelData:
        """Pipeline information"""
    @property
    def time_interval(self) -> global___TimeInterval:
        """Time interval"""
    def __init__(
        self,
        *,
        user: global___UserData | None = ...,
        model: global___ModelData | None = ...,
        time_interval: global___TimeInterval | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["model", b"model", "time_interval", b"time_interval", "user", b"user"]) -> None: ...

global___GetModelOnlinePriceRequest = GetModelOnlinePriceRequest

@typing_extensions.final
class GetModelOnlinePriceResponse(google.protobuf.message.Message):
    """GetModelOnlinePriceResponse represents a response to
    GetModelOnlinePriceRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PRICE_FIELD_NUMBER: builtins.int
    @property
    def price(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PriceData]:
        """A list of model online prices given the billing periods covered by the time
        interval
        """
    def __init__(
        self,
        *,
        price: collections.abc.Iterable[global___PriceData] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["price", b"price"]) -> None: ...

global___GetModelOnlinePriceResponse = GetModelOnlinePriceResponse

@typing_extensions.final
class GetBulkModelOnlinePriceRequest(google.protobuf.message.Message):
    """GetBulkModelOnlinePriceRequest represents a query for model online prices in
    bulk
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_QUERIES_FIELD_NUMBER: builtins.int
    @property
    def bulk_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetModelOnlinePriceRequest]:
        """A list of model online price request payloads"""
    def __init__(
        self,
        *,
        bulk_queries: collections.abc.Iterable[global___GetModelOnlinePriceRequest] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_queries", b"bulk_queries"]) -> None: ...

global___GetBulkModelOnlinePriceRequest = GetBulkModelOnlinePriceRequest

@typing_extensions.final
class GetBulkModelOnlinePriceResponse(google.protobuf.message.Message):
    """GetBulkModelOnlinePriceResponse represents a response to
    GetBulkModelOnlinePriceRequest
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BULK_PRICES_FIELD_NUMBER: builtins.int
    @property
    def bulk_prices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GetModelOnlinePriceResponse]:
        """A list of model online price lists"""
    def __init__(
        self,
        *,
        bulk_prices: collections.abc.Iterable[global___GetModelOnlinePriceResponse] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["bulk_prices", b"bulk_prices"]) -> None: ...

global___GetBulkModelOnlinePriceResponse = GetBulkModelOnlinePriceResponse

@typing_extensions.final
class NullMessage(google.protobuf.message.Message):
    """Nul Message for gRPC REQ/RES"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___NullMessage = NullMessage

@typing_extensions.final
class UserData(google.protobuf.message.Message):
    """Records for all usage reports

    User records definition
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """User unique id"""
    name: builtins.str
    """User name, which is not necessary for service queries"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "uid", b"uid"]) -> None: ...

global___UserData = UserData

@typing_extensions.final
class PipelineData(google.protobuf.message.Message):
    """Records for pipeline trigger reports and queries

    Pipeline records definition
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Pipeline unique id that is auto generated"""
    id: builtins.str
    """Pipeline id assigned by users"""
    task: builtins.str
    """Pipeline task indicate the AI task this pipeline supports"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        task: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "task", b"task", "uid", b"uid"]) -> None: ...

global___PipelineData = PipelineData

@typing_extensions.final
class PipelineUsageRecord(google.protobuf.message.Message):
    """Pipeline trigger usage record definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    OPERATION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    TRIGGER_TIME_FIELD_NUMBER: builtins.int
    RECORD_TIME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    request_id: builtins.str
    """A unique request id given by Instill Core when trigger the pipeline."""
    operation_id: builtins.str
    """A unique operation id given by Instill Core"""
    status: builtins.str
    """The HTTP status received when user trigger the pipeline"""
    @property
    def trigger_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the pipeline is triggered"""
    @property
    def record_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the pipeline trigger usage is recorded"""
    value: builtins.int
    """The pipeline trigger usage record. The unit of the usage should be
    consistent with Stripe
    """
    def __init__(
        self,
        *,
        request_id: builtins.str = ...,
        operation_id: builtins.str = ...,
        status: builtins.str = ...,
        trigger_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        record_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        value: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["record_time", b"record_time", "trigger_time", b"trigger_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["operation_id", b"operation_id", "record_time", b"record_time", "request_id", b"request_id", "status", b"status", "trigger_time", b"trigger_time", "value", b"value"]) -> None: ...

global___PipelineUsageRecord = PipelineUsageRecord

@typing_extensions.final
class ModelData(google.protobuf.message.Message):
    """Records for model online reports and queries

    Pipeline records definition
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    INSTANCE_ID_FIELD_NUMBER: builtins.int
    TASK_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """Model unique id that is auto generated"""
    id: builtins.str
    """Model id that is given by the users"""
    instance_id: builtins.str
    """The id of the model instance that is deployed"""
    task: builtins.str
    """The AI task supported by this model"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        instance_id: builtins.str = ...,
        task: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id", b"id", "instance_id", b"instance_id", "task", b"task", "uid", b"uid"]) -> None: ...

global___ModelData = ModelData

@typing_extensions.final
class ModelUsageRecord(google.protobuf.message.Message):
    """Model online usage record definition"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEPLOY_TIME_FIELD_NUMBER: builtins.int
    RECORD_TIME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    @property
    def deploy_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the model is ONLINE"""
    @property
    def record_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when model online usage is recorded"""
    value: builtins.int
    """The model online usage record that is logged in cumulative manner. This
    value records the cumulative usage since model is online in the current
    billing period
    """
    def __init__(
        self,
        *,
        deploy_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        record_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        value: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["deploy_time", b"deploy_time", "record_time", b"record_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["deploy_time", b"deploy_time", "record_time", b"record_time", "value", b"value"]) -> None: ...

global___ModelUsageRecord = ModelUsageRecord

@typing_extensions.final
class UsageSummary(google.protobuf.message.Message):
    """Record for query response

    Usage summary definition
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the summary is generated"""
    value: builtins.int
    """The total usage since the beginning of the current billing period"""
    def __init__(
        self,
        *,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        value: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["time", b"time", "value", b"value"]) -> None: ...

global___UsageSummary = UsageSummary

@typing_extensions.final
class PriceData(google.protobuf.message.Message):
    """Pricing information"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    CURRENCY_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    @property
    def time(self) -> global___TimeInterval:
        """Time when the price record is generated"""
    currency: builtins.str
    """The currency of the price"""
    amount: builtins.float
    """The price of the query usage in the current billing period"""
    def __init__(
        self,
        *,
        time: global___TimeInterval | None = ...,
        currency: builtins.str = ...,
        amount: builtins.float = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["amount", b"amount", "currency", b"currency", "time", b"time"]) -> None: ...

global___PriceData = PriceData

@typing_extensions.final
class TimeInterval(google.protobuf.message.Message):
    """Arguments for query

    Time interval
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_TIME_FIELD_NUMBER: builtins.int
    END_TIME_FIELD_NUMBER: builtins.int
    @property
    def start_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Start time of the interval"""
    @property
    def end_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """End time of the interval"""
    def __init__(
        self,
        *,
        start_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        end_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["end_time", b"end_time", "start_time", b"start_time"]) -> None: ...

global___TimeInterval = TimeInterval
