"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Secret(google.protobuf.message.Message):
    """API secrets allow users to make requests to the Instill AI API."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    UID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the secret, define by its ID.
    - Format: `secrets/{secret.id}`.
    """
    uid: builtins.str
    """Secret UUID."""
    id: builtins.str
    """Secret resource ID (used in `name` as the last segment). This conforms
    to RFC-1034, which restricts to letters, numbers, and hyphen, with the
    first character a letter, the last a letter or a number, and a 63
    character maximum.
    """
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation time."""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update time."""
    value: builtins.str
    """The value of the secret, which is input-only and will never be returned in API responses."""
    description: builtins.str
    """Description"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        uid: builtins.str = ...,
        id: builtins.str = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        value: builtins.str | None = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_value", b"_value", "create_time", b"create_time", "update_time", b"update_time", "value", b"value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_value", b"_value", "create_time", b"create_time", "description", b"description", "id", b"id", "name", b"name", "uid", b"uid", "update_time", b"update_time", "value", b"value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_value", b"_value"]) -> typing_extensions.Literal["value"] | None: ...

global___Secret = Secret

@typing_extensions.final
class CreateNamespaceSecretRequest(google.protobuf.message.Message):
    """CreateamespaceSecretRequest represents a request to create a secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    SECRET_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    @property
    def secret(self) -> global___Secret:
        """The properties of the secret to be created."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "secret", b"secret"]) -> None: ...

global___CreateNamespaceSecretRequest = CreateNamespaceSecretRequest

@typing_extensions.final
class CreateNamespaceSecretResponse(google.protobuf.message.Message):
    """CreateNamespaceSecretResponse contains the created secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The created secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___CreateNamespaceSecretResponse = CreateNamespaceSecretResponse

@typing_extensions.final
class ListNamespaceSecretsRequest(google.protobuf.message.Message):
    """ListNamespaceSecretsRequest represents a request to list the secrets of a namespace."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    page_size: builtins.int
    """The maximum number of secrets to return. If this parameter is unspecified,
    at most 10 pipelines will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page secret."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListNamespaceSecretsRequest = ListNamespaceSecretsRequest

@typing_extensions.final
class ListNamespaceSecretsResponse(google.protobuf.message.Message):
    """ListNamespaceSecretsResponse contains a list of secrets."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def secrets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Secret]:
        """A list of secret resources."""
    next_page_token: builtins.str
    """Next page secret."""
    total_size: builtins.int
    """Total number of secret resources."""
    def __init__(
        self,
        *,
        secrets: collections.abc.Iterable[global___Secret] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "secrets", b"secrets", "total_size", b"total_size"]) -> None: ...

global___ListNamespaceSecretsResponse = ListNamespaceSecretsResponse

@typing_extensions.final
class GetNamespaceSecretRequest(google.protobuf.message.Message):
    """GetNamespaceSecretRequest represents a request to fetch the details of a secret"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    SECRET_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    secret_id: builtins.str
    """Secret ID"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        secret_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "secret_id", b"secret_id"]) -> None: ...

global___GetNamespaceSecretRequest = GetNamespaceSecretRequest

@typing_extensions.final
class GetNamespaceSecretResponse(google.protobuf.message.Message):
    """GetNamespaceSecretResponse contains the requested secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___GetNamespaceSecretResponse = GetNamespaceSecretResponse

@typing_extensions.final
class UpdateNamespaceSecretRequest(google.protobuf.message.Message):
    """UpdateNamespaceSecretRequest represents a request to update a namespace secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    SECRET_ID_FIELD_NUMBER: builtins.int
    SECRET_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    secret_id: builtins.str
    """Secret ID"""
    @property
    def secret(self) -> global___Secret:
        """The secret fields to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        secret_id: builtins.str = ...,
        secret: global___Secret | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "secret", b"secret", "secret_id", b"secret_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateNamespaceSecretRequest = UpdateNamespaceSecretRequest

@typing_extensions.final
class UpdateNamespaceSecretResponse(google.protobuf.message.Message):
    """UpdateNamespaceSecretResponse contains the updated secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The updated secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___UpdateNamespaceSecretResponse = UpdateNamespaceSecretResponse

@typing_extensions.final
class DeleteNamespaceSecretRequest(google.protobuf.message.Message):
    """DeleteNamespaceSecretRequest represents a request to delete a secret resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    SECRET_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    secret_id: builtins.str
    """Secret ID"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        secret_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["namespace_id", b"namespace_id", "secret_id", b"secret_id"]) -> None: ...

global___DeleteNamespaceSecretRequest = DeleteNamespaceSecretRequest

@typing_extensions.final
class DeleteNamespaceSecretResponse(google.protobuf.message.Message):
    """DeleteNamespaceSecretResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteNamespaceSecretResponse = DeleteNamespaceSecretResponse

@typing_extensions.final
class CreateUserSecretRequest(google.protobuf.message.Message):
    """CreateUserSecretRequest represents a request to create a secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The properties of the secret to be created."""
    parent: builtins.str
    """The parent resource, i.e., the user that creates the secret.
    - Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "secret", b"secret"]) -> None: ...

global___CreateUserSecretRequest = CreateUserSecretRequest

@typing_extensions.final
class CreateUserSecretResponse(google.protobuf.message.Message):
    """CreateUserSecretResponse contains the created secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The created secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___CreateUserSecretResponse = CreateUserSecretResponse

@typing_extensions.final
class ListUserSecretsRequest(google.protobuf.message.Message):
    """ListUserSecretsRequest represents a request to list the secrets of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of secrets to return. If this parameter is unspecified,
    at most 10 pipelines will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page secret."""
    parent: builtins.str
    """The parent resource, i.e., the user that creates the secret.
    - Format: `users/{user.id}`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListUserSecretsRequest = ListUserSecretsRequest

@typing_extensions.final
class ListUserSecretsResponse(google.protobuf.message.Message):
    """ListUserSecretsResponse contains a list of secrets."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def secrets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Secret]:
        """A list of secret resources."""
    next_page_token: builtins.str
    """Next page secret."""
    total_size: builtins.int
    """Total number of secret resources."""
    def __init__(
        self,
        *,
        secrets: collections.abc.Iterable[global___Secret] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "secrets", b"secrets", "total_size", b"total_size"]) -> None: ...

global___ListUserSecretsResponse = ListUserSecretsResponse

@typing_extensions.final
class GetUserSecretRequest(google.protobuf.message.Message):
    """GetUserSecretRequest represents a request to fetch the details of a secret"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the secret, which allows its access by ID.
    - Format: `users/{user.id}/secrets/{secret.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetUserSecretRequest = GetUserSecretRequest

@typing_extensions.final
class GetUserSecretResponse(google.protobuf.message.Message):
    """GetUserSecretResponse contains the requested secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___GetUserSecretResponse = GetUserSecretResponse

@typing_extensions.final
class UpdateUserSecretRequest(google.protobuf.message.Message):
    """UpdateUserSecretRequest represents a request to update a user secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The secret fields to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret", "update_mask", b"update_mask"]) -> None: ...

global___UpdateUserSecretRequest = UpdateUserSecretRequest

@typing_extensions.final
class UpdateUserSecretResponse(google.protobuf.message.Message):
    """UpdateUserSecretResponse contains the updated secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The updated secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___UpdateUserSecretResponse = UpdateUserSecretResponse

@typing_extensions.final
class DeleteUserSecretRequest(google.protobuf.message.Message):
    """DeleteUserSecretRequest represents a request to delete a secret resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the secret, which allows its access by ID.
    - Format: `users/{user.id}/secrets/{secret.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteUserSecretRequest = DeleteUserSecretRequest

@typing_extensions.final
class DeleteUserSecretResponse(google.protobuf.message.Message):
    """DeleteUserSecretResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteUserSecretResponse = DeleteUserSecretResponse

@typing_extensions.final
class CreateOrganizationSecretRequest(google.protobuf.message.Message):
    """CreateOrganizationSecretRequest represents a request to create a secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The properties of the secret to be created."""
    parent: builtins.str
    """The parent resource, i.e., the organization that creates the secret.
    - Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["parent", b"parent", "secret", b"secret"]) -> None: ...

global___CreateOrganizationSecretRequest = CreateOrganizationSecretRequest

@typing_extensions.final
class CreateOrganizationSecretResponse(google.protobuf.message.Message):
    """CreateOrganizationSecretResponse contains the created secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The created secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___CreateOrganizationSecretResponse = CreateOrganizationSecretResponse

@typing_extensions.final
class ListOrganizationSecretsRequest(google.protobuf.message.Message):
    """ListOrganizationSecretsRequest represents a request to list the secrets of a user."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    PARENT_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of secrets to return. If this parameter is unspecified,
    at most 10 pipelines will be returned. The cap value for this parameter is
    100 (i.e. any value above that will be coerced to 100).
    """
    page_token: builtins.str
    """Page secret."""
    parent: builtins.str
    """The parent resource, i.e., the organization that creates the secret.
    - Format: `organizations/{organization.id}`.
    """
    def __init__(
        self,
        *,
        page_size: builtins.int | None = ...,
        page_token: builtins.str | None = ...,
        parent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_page_size", b"_page_size", "_page_token", b"_page_token", "page_size", b"page_size", "page_token", b"page_token", "parent", b"parent"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_size", b"_page_size"]) -> typing_extensions.Literal["page_size"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_page_token", b"_page_token"]) -> typing_extensions.Literal["page_token"] | None: ...

global___ListOrganizationSecretsRequest = ListOrganizationSecretsRequest

@typing_extensions.final
class ListOrganizationSecretsResponse(google.protobuf.message.Message):
    """ListOrganizationSecretsResponse contains a list of secrets."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRETS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def secrets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Secret]:
        """A list of secret resources."""
    next_page_token: builtins.str
    """Next page secret."""
    total_size: builtins.int
    """Total number of secret resources."""
    def __init__(
        self,
        *,
        secrets: collections.abc.Iterable[global___Secret] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["next_page_token", b"next_page_token", "secrets", b"secrets", "total_size", b"total_size"]) -> None: ...

global___ListOrganizationSecretsResponse = ListOrganizationSecretsResponse

@typing_extensions.final
class GetOrganizationSecretRequest(google.protobuf.message.Message):
    """GetOrganizationSecretRequest represents a request to fetch the details of a secret"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the secret, which allows its access by ID.
    - Format: `organizations/{organization.id}/secrets/{secret.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetOrganizationSecretRequest = GetOrganizationSecretRequest

@typing_extensions.final
class GetOrganizationSecretResponse(google.protobuf.message.Message):
    """GetOrganizationSecretResponse contains the requested secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___GetOrganizationSecretResponse = GetOrganizationSecretResponse

@typing_extensions.final
class UpdateOrganizationSecretRequest(google.protobuf.message.Message):
    """UpdateOrganizationSecretRequest represents a request to update a user secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The secret fields to update."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The update mask specifies the subset of fields that should be modified.

        For more information about this field, see
        https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#field-mask.
        """
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret", "update_mask", b"update_mask"]) -> None: ...

global___UpdateOrganizationSecretRequest = UpdateOrganizationSecretRequest

@typing_extensions.final
class UpdateOrganizationSecretResponse(google.protobuf.message.Message):
    """UpdateOrganizationSecretResponse contains the updated secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECRET_FIELD_NUMBER: builtins.int
    @property
    def secret(self) -> global___Secret:
        """The updated secret resource."""
    def __init__(
        self,
        *,
        secret: global___Secret | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["secret", b"secret"]) -> None: ...

global___UpdateOrganizationSecretResponse = UpdateOrganizationSecretResponse

@typing_extensions.final
class DeleteOrganizationSecretRequest(google.protobuf.message.Message):
    """DeleteOrganizationSecretRequest represents a request to delete a secret resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The resource name of the secret, which allows its access by ID.
    - Format: `organizations/{organization.id}/secrets/{secret.id}`.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___DeleteOrganizationSecretRequest = DeleteOrganizationSecretRequest

@typing_extensions.final
class DeleteOrganizationSecretResponse(google.protobuf.message.Message):
    """DeleteOrganizationSecretResponse is an empty response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteOrganizationSecretResponse = DeleteOrganizationSecretResponse
