#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Tue Apr  4 08:40:16 2023 by generateDS.py version 2.41.3.
# Python 3.10.6 (main, Mar 10 2023, 10:55:28) [GCC 11.3.0]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('-o', './dhl_express_lib/datatypes_global_v10.py')
#
# Command line arguments:
#   ./schemas/datatypes_global_v10.xsd
#
# Command line:
#   /home/kserver/Workspace/karrio/.venv/karrio/bin/generateDS --no-namespace-defs -o "./dhl_express_lib/datatypes_global_v10.py" ./schemas/datatypes_global_v10.xsd
#
# Current working directory (os.getcwd()):
#   dhl_express
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % float(input_data)).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class AccountType(str, Enum):
    """AccountType -- Account Type by method of payment ( DHL account)
    
    """
    D='D'


class BillCode(str, Enum):
    """BillCode -- DHL billing options
    
    """
    DSA='DSA'
    DBA='DBA'
    TCA='TCA'
    IEA='IEA'
    UAN='UAN'


class CommunicationType(str, Enum):
    """CommunicationType -- Communications line type (P: phone, F: fax)
    
    """
    P='P'
    F='F'


class CurrencyRoleTypeCode(str, Enum):
    """CurrencyRoleTypeCode -- CurrencyRoleTypeCode
    
    """
    BILLC='BILLC'
    PULCL='PULCL'
    INVCU='INVCU'
    BASEC='BASEC'


class CustomsInvoiceTemplate(str, Enum):
    """CustomsInvoiceTemplate -- DHL Customs Invoice Template
    
    """
    COMMERCIAL_INVOICE__04='COMMERCIAL_INVOICE_04'
    COMMERCIAL_INVOICE_P__10='COMMERCIAL_INVOICE_P_10'
    COMMERCIAL_INVOICE_L__10='COMMERCIAL_INVOICE_L_10'
    RET_COM_INVOICE_A_4__01='RET_COM_INVOICE_A4_01'


class DG_UOM(str, Enum):
    """DG_UOM -- DG_UOM
    
    """
    KG='KG'
    LB='LB'


class DimensionUnit(str, Enum):
    """DimensionUnit -- Dimension Unit C (centimeter)
    
    """
    C='C'
    I='I'


class DocumentFunction(str, Enum):
    """DocumentFunction -- Document function describes for what purpose was the document details captured and are planned to be used.
    
    """
    IMPORT='IMPORT'
    EXPORT='EXPORT'
    BOTH='BOTH'


class DoorTo(str, Enum):
    """DoorTo -- Defines the type of delivery service that applies to the shipment
    
    """
    DD='DD'
    DA='DA'
    AA='AA'
    DC='DC'


class FTSR(str, Enum):
    """FTSR -- FTSR
    
    """
    _3_0_2D_2='30.2(d)(2)'
    _3_0_36='30.36'
    _3_0_37A='30.37(a)'
    _3_0_37B='30.37(b)'
    _3_0_37E='30.37(e)'
    _3_0_37F='30.37(f)'
    _3_0_37G='30.37(g)'
    _3_0_37H='30.37(h)'
    _3_0_37J='30.37(j)'
    _3_0_37K='30.37(k)'
    _3_0_39='30.39'
    _3_0_40A='30.40(a)'
    _3_0_40B='30.40(b)'
    _3_0_40C='30.40(c)'
    _3_0_40D='30.40(d)'


class FilingType(str, Enum):
    """FilingType -- FilingType
    
    """
    FTR='FTR'
    ITN='ITN'
    AES_4='AES4'


class ImageFormat(str, Enum):
    """ImageFormat -- Image Format
    
    """
    PDF='PDF'
    PNG='PNG'
    TIFF='TIFF'
    GIF='GIF'
    JPEG='JPEG'


class InvLanguageCode(str, Enum):
    """InvLanguageCode --
    Invoice Language Code
    bg=Bugalrian br=Portuguse Brazil bs=Bosnian
    cs=Czech da=Danish de=German el=Greek en=English ep=English with SVP
    et=Estonian fi=Finnish fr=French he=Hebrew hr=Croatian hu=Hungaria
    is=Icelandic it=Italian lt=Lithuanian lv=Latvian mk=Macedon nl=Dutch
    no=Norwegian pl=Polish pt=Portuguse ro=Romanian ru=Russian
    si=Slovenian sk=Slovak sp=Spanish Latam SVP sq=Albanian sr=Serbian
    sv=Swedish tr=Turkish uk=Ukranian
    
    """
    BG='bg'
    BR='br'
    CS='cs'
    DA='da'
    DE='de'
    EL='el'
    EN='en'
    EP='ep'
    ET='et'
    FI='fi'
    FR='fr'
    HE='he'
    HR='hr'
    HU='hu'
    IS='is'
    IT='it'
    LT='lt'
    LV='lv'
    MK='mk'
    NL='nl'
    NO='no'
    PL='pl'
    PT='pt'
    RO='ro'
    RU='ru'
    SI='si'
    SK='sk'
    SP='sp'
    SQ='sq'
    SR='sr'
    SV='sv'
    TR='tr'
    UK='uk'


class InvoiceType(str, Enum):
    """InvoiceType -- DHL Invoice Types CMI(Commercail Invoice), PFI (Proforma Invoice), RET(Returns Invoice)
    
    """
    CMI='CMI'
    PFI='PFI'
    RET='RET'


class LabelImageFormat(str, Enum):
    """LabelImageFormat -- LabelImageFormat
    
    """
    PDF='PDF'
    ZPL_2='ZPL2'
    EPL_2='EPL2'


class LabelTemplate(str, Enum):
    """LabelTemplate -- LabelTemplate
    
    """
    _8_X_4_A_4_PDF='8X4_A4_PDF'
    _8_X_4_THERMAL='8X4_thermal'
    _8_X_4_A_4_TC_PDF='8X4_A4_TC_PDF'
    _6_X_4_THERMAL='6X4_thermal'
    _6_X_4_A_4_PDF='6X4_A4_PDF'
    _8_X_4_CI_PDF='8X4_CI_PDF'
    _8_X_4_CI_THERMAL='8X4_CI_thermal'
    _8_X_4_RU_A_4_PDF='8X4_RU_A4_PDF'
    _6_X_4_PDF='6X4_PDF'
    _8_X_4_PDF='8X4_PDF'
    _8_X_4__CUST_BAR_CODE_PDF='8X4_CustBarCode_PDF'
    _8_X_4__CUST_BAR_CODE_THERMAL='8X4_CustBarCode_thermal'
    _8_X_4__CUST_BAR_CODE__ADDITIONAL_INFO_PDF='8X4_CustBarCode_AdditionalInfo_PDF'
    _8_X_4__CUST_BAR_CODE__ADDITIONAL_INFO_THERMAL='8X4_CustBarCode_AdditionalInfo_thermal'
    _8_X_4_LBBX_PDF='8X4_LBBX_PDF'
    _8_X_4_LBBX_THERMAL='8X4_LBBX_thermal'
    _7_X_11_THERMAL='7X11_thermal'
    ECOM_26__64__001='ECOM26_64_001'
    ECOM_26__64__002='ECOM26_64_002'
    ECOM_26__64__004='ECOM26_64_004'
    ECOM_26__74_CI__001='ECOM26_74CI_001'
    ECOM_26__84__002='ECOM26_84_002'
    ECOM_26__84__002_CL='ECOM26_84_002_CL'
    ECOM_26__84__002_CO='ECOM26_84_002_CO'
    ECOM_26__84__003='ECOM26_84_003'
    ECOM_26_A_4__001='ECOM26_A4_001'
    ECOM_26_A_6__001='ECOM26_A6_001'
    ECOM_26_A_6__003='ECOM26_A6_003'


class LevelOfDetails(str, Enum):
    """LevelOfDetails -- Checkpoint details selection flag
    
    """
    LAST_CHECK_POINT_ONLY='LAST_CHECK_POINT_ONLY'
    ALL_CHECK_POINTS='ALL_CHECK_POINTS'


class LogoImageFormat(str, Enum):
    """LogoImageFormat -- LogoImage Format
    
    """
    PNG='PNG'
    GIF='GIF'
    JPEG='JPEG'
    JPG='JPG'


class NumberOfArchiveDoc(str, Enum):
    """NumberOfArchiveDoc -- NumberOfArchiveDoc Value
    
    """
    _1='1'
    _2='2'


class OutputFormat(str, Enum):
    """OutputFormat -- OutputFormat
    
    """
    PDF='PDF'
    PL_2='PL2'
    ZPL_2='ZPL2'
    JPG='JPG'
    PNG='PNG'
    EPL_2='EPL2'
    EPLN='EPLN'
    ZPLN='ZPLN'


class PLTStatus(str, Enum):
    """PLTStatus -- PLTStatus
    
    """
    A='A'
    D='D'
    S='S'


class PaymentType(str, Enum):
    """PaymentType -- payment type (S:Shipper,R:Recipient,T:Third Party)
    
    """
    S='S'
    R='R'
    T='T'


class QRCodeImageFormat(str, Enum):
    """QRCodeImageFormat -- QRCode Image Format
    
    """
    PNG='PNG'


class QRCodeTemplate(str, Enum):
    """QRCodeTemplate -- QR Code template
    
    """
    QR__1__00_LL_PNG__001='QR_1_00_LL_PNG_001'


class ReceiptTemplate(str, Enum):
    """ReceiptTemplate -- ReceiptTemplate
    
    """
    SHIP_RECPT_A_4_RU_PDF='SHIP_RECPT_A4_RU_PDF'


class RegionCode(str, Enum):
    """RegionCode -- RegionCode
    
    """
    AP='AP'
    EU='EU'
    AM='AM'


class ResidenceOrBusiness(str, Enum):
    """ResidenceOrBusiness -- Identifies if a location is a business, residence, or both (B:Business, R:Residence, C:Business Residence)
    
    """
    B='B'
    R='R'
    C='C'


class SEDNumber(str, Enum):
    """SEDNumber --
    FTSR - Foreign Trade Statistics Regulations - This is usually used as FTSR 30.55 where 30.55 is a section of the regulation that applies to the commodity, e.g., no SED required
    XTN- External Transaction Number - Comprised of the shipper
    ’
    s EIN or SSN and a customer reference number
    SAS - Shipper Authorization Symbol - This is not used, but is replaced by the XTN
    
    """
    FTSR='FTSR'
    XTN='XTN'
    SAS='SAS'
    ITN='ITN'


class SEDNumberType(str, Enum):
    """SEDNumberType -- This element contains the SED number type. It is an optional element. This field is required if SED number is given. The valid values are one of: F (for FTSR), X (for XTN) or S (for SAS)
    
    """
    F='F'
    X='X'
    S='S'
    I='I'


class ShipmentPaymentType(str, Enum):
    """ShipmentPaymentType -- Shipment payment type (S:Shipper)
    
    """
    S='S'
    R='R'
    T='T'


class ShipmentPurpose(str, Enum):
    """ShipmentPurpose -- Indicates if the Trading Transaction Type, shipment was sent for Personal (Gift) or Commercial (Sale) reasons
    
    """
    PERSONAL='PERSONAL'
    COMMERCIAL='COMMERCIAL'


class TaxesPaid(str, Enum):
    """TaxesPaid -- Indication if Taxes has been paid for the line item
    
    """
    Y='Y'
    N='N'


class Type(str, Enum):
    """Type -- Image Type
    
    """
    HWB='HWB'
    INV='INV'
    PNV='PNV'
    COO='COO'
    NAF='NAF'
    CIN='CIN'
    DCL='DCL'


class UseOwnPieceIdentificationNumberType(str, Enum):
    """UseOwnPieceIdentificationNumberType -- Customer able to provide PID if set to Y. The
    default is N
    
    """
    Y='Y'
    N='N'


class WeightUnit(str, Enum):
    """WeightUnit -- Unit of weight measurement (K:KiloGram)
    
    """
    K='K'
    L='L'


class WeightUnitType(str, Enum):
    """WeightUnitType -- Weight Unit Details
    
    """
    L='L'
    K='K'
    G='G'


class YesNo(str, Enum):
    """YesNo -- Boolean flag
    
    """
    Y='Y'
    N='N'


class DataTypes(GeneratedsSuper):
    """DataTypes -- Comment describing your root element
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DataTypes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DataTypes.subclass:
            return DataTypes.subclass(*args_, **kwargs_)
        else:
            return DataTypes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def _hasContent(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DataTypes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DataTypes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DataTypes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataTypes')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DataTypes', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DataTypes'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DataTypes', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class DataTypes


class Billing(GeneratedsSuper):
    """Billing -- The Billing element contains the billing information of the shipment
    ShipperAccountNumber -- The ShipperAccountNumber element contains the DHL account number. This element must be declared once in the Bill element
    ShippingPaymentType -- The ShippingPaymentType element defines the method of payment. It is a mandatory field. The valid values are S:Shipper, R:Recipient and T:Third Party
    BillingAccountNumber -- The BillingAccountNumber element contains billing account number.This element is required even if the payment method is third party or consignee
    DutyAccountNumber -- The DutyAccountNumber element contains the account number which is used in duty and tax payment
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ShipperAccountNumber=None, ShippingPaymentType=None, BillingAccountNumber=None, DutyAccountNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ShipperAccountNumber = ShipperAccountNumber
        self.validate_AccountNumber(self.ShipperAccountNumber)
        self.ShipperAccountNumber_nsprefix_ = None
        self.ShippingPaymentType = ShippingPaymentType
        self.validate_ShipmentPaymentType(self.ShippingPaymentType)
        self.ShippingPaymentType_nsprefix_ = None
        self.BillingAccountNumber = BillingAccountNumber
        self.validate_AccountNumber(self.BillingAccountNumber)
        self.BillingAccountNumber_nsprefix_ = None
        self.DutyAccountNumber = DutyAccountNumber
        self.validate_AccountNumber(self.DutyAccountNumber)
        self.DutyAccountNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Billing)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Billing.subclass:
            return Billing.subclass(*args_, **kwargs_)
        else:
            return Billing(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ShipperAccountNumber(self):
        return self.ShipperAccountNumber
    def set_ShipperAccountNumber(self, ShipperAccountNumber):
        self.ShipperAccountNumber = ShipperAccountNumber
    def get_ShippingPaymentType(self):
        return self.ShippingPaymentType
    def set_ShippingPaymentType(self, ShippingPaymentType):
        self.ShippingPaymentType = ShippingPaymentType
    def get_BillingAccountNumber(self):
        return self.BillingAccountNumber
    def set_BillingAccountNumber(self, BillingAccountNumber):
        self.BillingAccountNumber = BillingAccountNumber
    def get_DutyAccountNumber(self):
        return self.DutyAccountNumber
    def set_DutyAccountNumber(self, DutyAccountNumber):
        self.DutyAccountNumber = DutyAccountNumber
    def validate_AccountNumber(self, value):
        result = True
        # Validate type AccountNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AccountNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ShipmentPaymentType(self, value):
        result = True
        # Validate type ShipmentPaymentType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['S', 'R', 'T']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ShipmentPaymentType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ShipmentPaymentType' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ShipperAccountNumber is not None or
            self.ShippingPaymentType is not None or
            self.BillingAccountNumber is not None or
            self.DutyAccountNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Billing', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Billing')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Billing':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Billing')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Billing', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Billing'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Billing', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ShipperAccountNumber is not None:
            namespaceprefix_ = self.ShipperAccountNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperAccountNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperAccountNumber>%s</%sShipperAccountNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperAccountNumber), input_name='ShipperAccountNumber')), namespaceprefix_ , eol_))
        if self.ShippingPaymentType is not None:
            namespaceprefix_ = self.ShippingPaymentType_nsprefix_ + ':' if (UseCapturedNS_ and self.ShippingPaymentType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShippingPaymentType>%s</%sShippingPaymentType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShippingPaymentType), input_name='ShippingPaymentType')), namespaceprefix_ , eol_))
        if self.BillingAccountNumber is not None:
            namespaceprefix_ = self.BillingAccountNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.BillingAccountNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBillingAccountNumber>%s</%sBillingAccountNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BillingAccountNumber), input_name='BillingAccountNumber')), namespaceprefix_ , eol_))
        if self.DutyAccountNumber is not None:
            namespaceprefix_ = self.DutyAccountNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.DutyAccountNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDutyAccountNumber>%s</%sDutyAccountNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DutyAccountNumber), input_name='DutyAccountNumber')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ShipperAccountNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperAccountNumber')
            value_ = self.gds_validate_string(value_, node, 'ShipperAccountNumber')
            self.ShipperAccountNumber = value_
            self.ShipperAccountNumber_nsprefix_ = child_.prefix
            # validate type AccountNumber
            self.validate_AccountNumber(self.ShipperAccountNumber)
        elif nodeName_ == 'ShippingPaymentType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShippingPaymentType')
            value_ = self.gds_validate_string(value_, node, 'ShippingPaymentType')
            self.ShippingPaymentType = value_
            self.ShippingPaymentType_nsprefix_ = child_.prefix
            # validate type ShipmentPaymentType
            self.validate_ShipmentPaymentType(self.ShippingPaymentType)
        elif nodeName_ == 'BillingAccountNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BillingAccountNumber')
            value_ = self.gds_validate_string(value_, node, 'BillingAccountNumber')
            self.BillingAccountNumber = value_
            self.BillingAccountNumber_nsprefix_ = child_.prefix
            # validate type AccountNumber
            self.validate_AccountNumber(self.BillingAccountNumber)
        elif nodeName_ == 'DutyAccountNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DutyAccountNumber')
            value_ = self.gds_validate_string(value_, node, 'DutyAccountNumber')
            self.DutyAccountNumber = value_
            self.DutyAccountNumber_nsprefix_ = child_.prefix
            # validate type AccountNumber
            self.validate_AccountNumber(self.DutyAccountNumber)
# end class Billing


class Commodity(GeneratedsSuper):
    """Commodity -- The commodity element identifies the commodity or commodities being shipped. This element should be declared once in the shipment validation request message
    CommodityCode -- The CommodityCode element contains the commodity code of the shipment contents. Its value should be between 2 and 18 characters of string. This field is mandatory
    CommodityName -- The CommodityName element contains the commodity name of the shipment content. Its value should be no more than 35 chars. This field is optional
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CommodityCode=None, CommodityName=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CommodityCode = CommodityCode
        self.validate_CommodityCode(self.CommodityCode)
        self.CommodityCode_nsprefix_ = None
        self.CommodityName = CommodityName
        self.validate_CommodityName(self.CommodityName)
        self.CommodityName_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Commodity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Commodity.subclass:
            return Commodity.subclass(*args_, **kwargs_)
        else:
            return Commodity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CommodityCode(self):
        return self.CommodityCode
    def set_CommodityCode(self, CommodityCode):
        self.CommodityCode = CommodityCode
    def get_CommodityName(self):
        return self.CommodityName
    def set_CommodityName(self, CommodityName):
        self.CommodityName = CommodityName
    def validate_CommodityCode(self, value):
        result = True
        # Validate type CommodityCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CommodityCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CommodityCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CommodityName(self, value):
        result = True
        # Validate type CommodityName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CommodityName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CommodityCode is not None or
            self.CommodityName is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Commodity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Commodity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Commodity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Commodity')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Commodity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Commodity'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Commodity', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CommodityCode is not None:
            namespaceprefix_ = self.CommodityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CommodityCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommodityCode>%s</%sCommodityCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CommodityCode), input_name='CommodityCode')), namespaceprefix_ , eol_))
        if self.CommodityName is not None:
            namespaceprefix_ = self.CommodityName_nsprefix_ + ':' if (UseCapturedNS_ and self.CommodityName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommodityName>%s</%sCommodityName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CommodityName), input_name='CommodityName')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CommodityCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CommodityCode')
            value_ = self.gds_validate_string(value_, node, 'CommodityCode')
            self.CommodityCode = value_
            self.CommodityCode_nsprefix_ = child_.prefix
            # validate type CommodityCode
            self.validate_CommodityCode(self.CommodityCode)
        elif nodeName_ == 'CommodityName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CommodityName')
            value_ = self.gds_validate_string(value_, node, 'CommodityName')
            self.CommodityName = value_
            self.CommodityName_nsprefix_ = child_.prefix
            # validate type CommodityName
            self.validate_CommodityName(self.CommodityName)
# end class Commodity


class Consignee(GeneratedsSuper):
    """Consignee -- Consignee element contains the details of the Consignee (Receiver of the shipment). This element should be declared once in the shipment validation request message
    CompanyName -- The CompanyName element contains the name of the company
    SuiteDepartmentName -- The SuiteDepartmentName element contains the suite or department name of the company
    AddressLine1 -- The AddressLine 1 element contains the address line 1 to the Consignee. It is mandatory field.
    AddressLine2 -- The AddressLine 2 element contains the address line 2 to the Consignee.
    AddressLine3 -- The AddressLine 3 element contains the address line 3 to the Consignee.
    City -- The City element contains the City of the consignee address. It must be declared in the Consignee element for Country/Region that used city
    Division -- The Division name of the consignee location, for instance State, County, Prefecture, etc
    DivisionCode -- The division code of the consignee location
    PostalCode -- The Postal Code element contains the postal code of the consignee location
    CountryCode -- The Country Code element contains the Country/Region code of the consignee location. It must be 2 letters. Please refer to the Reference Data (DHL Country/Region) for country/region codes
    CountryName -- The CountryName element contains Country/Region name of the consignee. Its value should be a valid DHL Country/Region name. This element must be declared once in the Consignee element. Please refer to the Reference Data (DHL Country/Region) for a list of valid Country/Region names
    Contact -- The Contact element contains the receiver
    ’
    s contact information. It must be declared in the consignee element
    Suburb -- The suburb element contains consignee
    ’
    s suburb name. It is an optional field
    StreetName -- The Contact element contains the Exporter
    ’
    s street name.It is an optional field
    BuildingName -- The Contact element contains the Exporter
    ’
    s Building Name.It is an optional field
    StreetNumber -- The Contact element contains the Exporter
    ’
    s It is an optional field. It is an optional field
    RegistrationNumbers -- The Contact element contains the Exporter
    ’
    s contact information.
    BusinessPartyTypeCode -- The Contact element contains the Exporter
    ’
    s Business Party Type Code.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CompanyName=None, SuiteDepartmentName=None, AddressLine1=None, AddressLine2=None, AddressLine3=None, City=None, Division=None, DivisionCode=None, PostalCode=None, CountryCode=None, CountryName=None, FederalTaxId=None, StateTaxId=None, Contact=None, Suburb=None, StreetName=None, BuildingName=None, StreetNumber=None, RegistrationNumbers=None, BusinessPartyTypeCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CompanyName = CompanyName
        self.validate_CompanyNameValidator(self.CompanyName)
        self.CompanyName_nsprefix_ = None
        self.SuiteDepartmentName = SuiteDepartmentName
        self.validate_SuiteDepartmentName(self.SuiteDepartmentName)
        self.SuiteDepartmentName_nsprefix_ = None
        self.AddressLine1 = AddressLine1
        self.validate_AddressLine(self.AddressLine1)
        self.AddressLine1_nsprefix_ = None
        self.AddressLine2 = AddressLine2
        self.validate_AddressLine(self.AddressLine2)
        self.AddressLine2_nsprefix_ = None
        self.AddressLine3 = AddressLine3
        self.validate_AddressLine(self.AddressLine3)
        self.AddressLine3_nsprefix_ = None
        self.City = City
        self.validate_City(self.City)
        self.City_nsprefix_ = None
        self.Division = Division
        self.validate_Division(self.Division)
        self.Division_nsprefix_ = None
        self.DivisionCode = DivisionCode
        self.validate_DivisionCode(self.DivisionCode)
        self.DivisionCode_nsprefix_ = None
        self.PostalCode = PostalCode
        self.validate_PostalCode(self.PostalCode)
        self.PostalCode_nsprefix_ = None
        self.CountryCode = CountryCode
        self.validate_CountryCode(self.CountryCode)
        self.CountryCode_nsprefix_ = None
        self.CountryName = CountryName
        self.validate_CountryName(self.CountryName)
        self.CountryName_nsprefix_ = None
        self.FederalTaxId = FederalTaxId
        self.validate_FederalTaxIdType(self.FederalTaxId)
        self.FederalTaxId_nsprefix_ = None
        self.StateTaxId = StateTaxId
        self.validate_StateTaxIdType(self.StateTaxId)
        self.StateTaxId_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Suburb = Suburb
        self.validate_Suburb(self.Suburb)
        self.Suburb_nsprefix_ = None
        self.StreetName = StreetName
        self.validate_StreetName(self.StreetName)
        self.StreetName_nsprefix_ = None
        self.BuildingName = BuildingName
        self.validate_BuildingName(self.BuildingName)
        self.BuildingName_nsprefix_ = None
        self.StreetNumber = StreetNumber
        self.validate_StreetNumber(self.StreetNumber)
        self.StreetNumber_nsprefix_ = None
        self.RegistrationNumbers = RegistrationNumbers
        self.RegistrationNumbers_nsprefix_ = None
        self.BusinessPartyTypeCode = BusinessPartyTypeCode
        self.validate_BusinessPartyTypeCode(self.BusinessPartyTypeCode)
        self.BusinessPartyTypeCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Consignee)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Consignee.subclass:
            return Consignee.subclass(*args_, **kwargs_)
        else:
            return Consignee(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CompanyName(self):
        return self.CompanyName
    def set_CompanyName(self, CompanyName):
        self.CompanyName = CompanyName
    def get_SuiteDepartmentName(self):
        return self.SuiteDepartmentName
    def set_SuiteDepartmentName(self, SuiteDepartmentName):
        self.SuiteDepartmentName = SuiteDepartmentName
    def get_AddressLine1(self):
        return self.AddressLine1
    def set_AddressLine1(self, AddressLine1):
        self.AddressLine1 = AddressLine1
    def get_AddressLine2(self):
        return self.AddressLine2
    def set_AddressLine2(self, AddressLine2):
        self.AddressLine2 = AddressLine2
    def get_AddressLine3(self):
        return self.AddressLine3
    def set_AddressLine3(self, AddressLine3):
        self.AddressLine3 = AddressLine3
    def get_City(self):
        return self.City
    def set_City(self, City):
        self.City = City
    def get_Division(self):
        return self.Division
    def set_Division(self, Division):
        self.Division = Division
    def get_DivisionCode(self):
        return self.DivisionCode
    def set_DivisionCode(self, DivisionCode):
        self.DivisionCode = DivisionCode
    def get_PostalCode(self):
        return self.PostalCode
    def set_PostalCode(self, PostalCode):
        self.PostalCode = PostalCode
    def get_CountryCode(self):
        return self.CountryCode
    def set_CountryCode(self, CountryCode):
        self.CountryCode = CountryCode
    def get_CountryName(self):
        return self.CountryName
    def set_CountryName(self, CountryName):
        self.CountryName = CountryName
    def get_FederalTaxId(self):
        return self.FederalTaxId
    def set_FederalTaxId(self, FederalTaxId):
        self.FederalTaxId = FederalTaxId
    def get_StateTaxId(self):
        return self.StateTaxId
    def set_StateTaxId(self, StateTaxId):
        self.StateTaxId = StateTaxId
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Suburb(self):
        return self.Suburb
    def set_Suburb(self, Suburb):
        self.Suburb = Suburb
    def get_StreetName(self):
        return self.StreetName
    def set_StreetName(self, StreetName):
        self.StreetName = StreetName
    def get_BuildingName(self):
        return self.BuildingName
    def set_BuildingName(self, BuildingName):
        self.BuildingName = BuildingName
    def get_StreetNumber(self):
        return self.StreetNumber
    def set_StreetNumber(self, StreetNumber):
        self.StreetNumber = StreetNumber
    def get_RegistrationNumbers(self):
        return self.RegistrationNumbers
    def set_RegistrationNumbers(self, RegistrationNumbers):
        self.RegistrationNumbers = RegistrationNumbers
    def get_BusinessPartyTypeCode(self):
        return self.BusinessPartyTypeCode
    def set_BusinessPartyTypeCode(self, BusinessPartyTypeCode):
        self.BusinessPartyTypeCode = BusinessPartyTypeCode
    def validate_CompanyNameValidator(self, value):
        result = True
        # Validate type CompanyNameValidator, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 100:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CompanyNameValidator' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CompanyNameValidator' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SuiteDepartmentName(self, value):
        result = True
        # Validate type SuiteDepartmentName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SuiteDepartmentName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AddressLine(self, value):
        result = True
        # Validate type AddressLine, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AddressLine' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AddressLine' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_City(self, value):
        result = True
        # Validate type City, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on City' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Division(self, value):
        result = True
        # Validate type Division, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Division' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DivisionCode(self, value):
        result = True
        # Validate type DivisionCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on DivisionCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PostalCode(self, value):
        result = True
        # Validate type PostalCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 12:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PostalCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryCode(self, value):
        result = True
        # Validate type CountryCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CountryCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryName(self, value):
        result = True
        # Validate type CountryName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CountryName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_FederalTaxIdType(self, value):
        result = True
        # Validate type FederalTaxIdType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on FederalTaxIdType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on FederalTaxIdType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_StateTaxIdType(self, value):
        result = True
        # Validate type StateTaxIdType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StateTaxIdType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on StateTaxIdType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Suburb(self, value):
        result = True
        # Validate type Suburb, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Suburb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_StreetName(self, value):
        result = True
        # Validate type StreetName, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 250:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StreetName' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on StreetName' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def validate_BuildingName(self, value):
        result = True
        # Validate type BuildingName, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 50:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on BuildingName' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BuildingName' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def validate_StreetNumber(self, value):
        result = True
        # Validate type StreetNumber, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 50:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StreetNumber' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on StreetNumber' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def validate_BusinessPartyTypeCode(self, value):
        result = True
        # Validate type BusinessPartyTypeCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on BusinessPartyTypeCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BusinessPartyTypeCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CompanyName is not None or
            self.SuiteDepartmentName is not None or
            self.AddressLine1 is not None or
            self.AddressLine2 is not None or
            self.AddressLine3 is not None or
            self.City is not None or
            self.Division is not None or
            self.DivisionCode is not None or
            self.PostalCode is not None or
            self.CountryCode is not None or
            self.CountryName is not None or
            self.FederalTaxId is not None or
            self.StateTaxId is not None or
            self.Contact is not None or
            self.Suburb is not None or
            self.StreetName is not None or
            self.BuildingName is not None or
            self.StreetNumber is not None or
            self.RegistrationNumbers is not None or
            self.BusinessPartyTypeCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Consignee', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Consignee')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Consignee':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Consignee')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Consignee', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Consignee'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Consignee', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CompanyName is not None:
            namespaceprefix_ = self.CompanyName_nsprefix_ + ':' if (UseCapturedNS_ and self.CompanyName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompanyName>%s</%sCompanyName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CompanyName), input_name='CompanyName')), namespaceprefix_ , eol_))
        if self.SuiteDepartmentName is not None:
            namespaceprefix_ = self.SuiteDepartmentName_nsprefix_ + ':' if (UseCapturedNS_ and self.SuiteDepartmentName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSuiteDepartmentName>%s</%sSuiteDepartmentName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SuiteDepartmentName), input_name='SuiteDepartmentName')), namespaceprefix_ , eol_))
        if self.AddressLine1 is not None:
            namespaceprefix_ = self.AddressLine1_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine1>%s</%sAddressLine1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine1), input_name='AddressLine1')), namespaceprefix_ , eol_))
        if self.AddressLine2 is not None:
            namespaceprefix_ = self.AddressLine2_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine2>%s</%sAddressLine2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine2), input_name='AddressLine2')), namespaceprefix_ , eol_))
        if self.AddressLine3 is not None:
            namespaceprefix_ = self.AddressLine3_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine3>%s</%sAddressLine3>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine3), input_name='AddressLine3')), namespaceprefix_ , eol_))
        if self.City is not None:
            namespaceprefix_ = self.City_nsprefix_ + ':' if (UseCapturedNS_ and self.City_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCity>%s</%sCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.City), input_name='City')), namespaceprefix_ , eol_))
        if self.Division is not None:
            namespaceprefix_ = self.Division_nsprefix_ + ':' if (UseCapturedNS_ and self.Division_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDivision>%s</%sDivision>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Division), input_name='Division')), namespaceprefix_ , eol_))
        if self.DivisionCode is not None:
            namespaceprefix_ = self.DivisionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.DivisionCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDivisionCode>%s</%sDivisionCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DivisionCode), input_name='DivisionCode')), namespaceprefix_ , eol_))
        if self.PostalCode is not None:
            namespaceprefix_ = self.PostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.PostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPostalCode>%s</%sPostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PostalCode), input_name='PostalCode')), namespaceprefix_ , eol_))
        if self.CountryCode is not None:
            namespaceprefix_ = self.CountryCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CountryCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCountryCode>%s</%sCountryCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CountryCode), input_name='CountryCode')), namespaceprefix_ , eol_))
        if self.CountryName is not None:
            namespaceprefix_ = self.CountryName_nsprefix_ + ':' if (UseCapturedNS_ and self.CountryName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCountryName>%s</%sCountryName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CountryName), input_name='CountryName')), namespaceprefix_ , eol_))
        if self.FederalTaxId is not None:
            namespaceprefix_ = self.FederalTaxId_nsprefix_ + ':' if (UseCapturedNS_ and self.FederalTaxId_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFederalTaxId>%s</%sFederalTaxId>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FederalTaxId), input_name='FederalTaxId')), namespaceprefix_ , eol_))
        if self.StateTaxId is not None:
            namespaceprefix_ = self.StateTaxId_nsprefix_ + ':' if (UseCapturedNS_ and self.StateTaxId_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStateTaxId>%s</%sStateTaxId>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StateTaxId), input_name='StateTaxId')), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            self.Contact.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Contact', pretty_print=pretty_print)
        if self.Suburb is not None:
            namespaceprefix_ = self.Suburb_nsprefix_ + ':' if (UseCapturedNS_ and self.Suburb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSuburb>%s</%sSuburb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Suburb), input_name='Suburb')), namespaceprefix_ , eol_))
        if self.StreetName is not None:
            namespaceprefix_ = self.StreetName_nsprefix_ + ':' if (UseCapturedNS_ and self.StreetName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStreetName>%s</%sStreetName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StreetName), input_name='StreetName')), namespaceprefix_ , eol_))
        if self.BuildingName is not None:
            namespaceprefix_ = self.BuildingName_nsprefix_ + ':' if (UseCapturedNS_ and self.BuildingName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuildingName>%s</%sBuildingName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BuildingName), input_name='BuildingName')), namespaceprefix_ , eol_))
        if self.StreetNumber is not None:
            namespaceprefix_ = self.StreetNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.StreetNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStreetNumber>%s</%sStreetNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StreetNumber), input_name='StreetNumber')), namespaceprefix_ , eol_))
        if self.RegistrationNumbers is not None:
            namespaceprefix_ = self.RegistrationNumbers_nsprefix_ + ':' if (UseCapturedNS_ and self.RegistrationNumbers_nsprefix_) else ''
            self.RegistrationNumbers.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RegistrationNumbers', pretty_print=pretty_print)
        if self.BusinessPartyTypeCode is not None:
            namespaceprefix_ = self.BusinessPartyTypeCode_nsprefix_ + ':' if (UseCapturedNS_ and self.BusinessPartyTypeCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBusinessPartyTypeCode>%s</%sBusinessPartyTypeCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BusinessPartyTypeCode), input_name='BusinessPartyTypeCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CompanyName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CompanyName')
            value_ = self.gds_validate_string(value_, node, 'CompanyName')
            self.CompanyName = value_
            self.CompanyName_nsprefix_ = child_.prefix
            # validate type CompanyNameValidator
            self.validate_CompanyNameValidator(self.CompanyName)
        elif nodeName_ == 'SuiteDepartmentName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SuiteDepartmentName')
            value_ = self.gds_validate_string(value_, node, 'SuiteDepartmentName')
            self.SuiteDepartmentName = value_
            self.SuiteDepartmentName_nsprefix_ = child_.prefix
            # validate type SuiteDepartmentName
            self.validate_SuiteDepartmentName(self.SuiteDepartmentName)
        elif nodeName_ == 'AddressLine1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine1')
            value_ = self.gds_validate_string(value_, node, 'AddressLine1')
            self.AddressLine1 = value_
            self.AddressLine1_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine1)
        elif nodeName_ == 'AddressLine2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine2')
            value_ = self.gds_validate_string(value_, node, 'AddressLine2')
            self.AddressLine2 = value_
            self.AddressLine2_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine2)
        elif nodeName_ == 'AddressLine3':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine3')
            value_ = self.gds_validate_string(value_, node, 'AddressLine3')
            self.AddressLine3 = value_
            self.AddressLine3_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine3)
        elif nodeName_ == 'City':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'City')
            value_ = self.gds_validate_string(value_, node, 'City')
            self.City = value_
            self.City_nsprefix_ = child_.prefix
            # validate type City
            self.validate_City(self.City)
        elif nodeName_ == 'Division':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Division')
            value_ = self.gds_validate_string(value_, node, 'Division')
            self.Division = value_
            self.Division_nsprefix_ = child_.prefix
            # validate type Division
            self.validate_Division(self.Division)
        elif nodeName_ == 'DivisionCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DivisionCode')
            value_ = self.gds_validate_string(value_, node, 'DivisionCode')
            self.DivisionCode = value_
            self.DivisionCode_nsprefix_ = child_.prefix
            # validate type DivisionCode
            self.validate_DivisionCode(self.DivisionCode)
        elif nodeName_ == 'PostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PostalCode')
            value_ = self.gds_validate_string(value_, node, 'PostalCode')
            self.PostalCode = value_
            self.PostalCode_nsprefix_ = child_.prefix
            # validate type PostalCode
            self.validate_PostalCode(self.PostalCode)
        elif nodeName_ == 'CountryCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CountryCode')
            value_ = self.gds_validate_string(value_, node, 'CountryCode')
            self.CountryCode = value_
            self.CountryCode_nsprefix_ = child_.prefix
            # validate type CountryCode
            self.validate_CountryCode(self.CountryCode)
        elif nodeName_ == 'CountryName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CountryName')
            value_ = self.gds_validate_string(value_, node, 'CountryName')
            self.CountryName = value_
            self.CountryName_nsprefix_ = child_.prefix
            # validate type CountryName
            self.validate_CountryName(self.CountryName)
        elif nodeName_ == 'FederalTaxId':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FederalTaxId')
            value_ = self.gds_validate_string(value_, node, 'FederalTaxId')
            self.FederalTaxId = value_
            self.FederalTaxId_nsprefix_ = child_.prefix
            # validate type FederalTaxIdType
            self.validate_FederalTaxIdType(self.FederalTaxId)
        elif nodeName_ == 'StateTaxId':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'StateTaxId')
            value_ = self.gds_validate_string(value_, node, 'StateTaxId')
            self.StateTaxId = value_
            self.StateTaxId_nsprefix_ = child_.prefix
            # validate type StateTaxIdType
            self.validate_StateTaxIdType(self.StateTaxId)
        elif nodeName_ == 'Contact':
            obj_ = Contact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Contact = obj_
            obj_.original_tagname_ = 'Contact'
        elif nodeName_ == 'Suburb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Suburb')
            value_ = self.gds_validate_string(value_, node, 'Suburb')
            self.Suburb = value_
            self.Suburb_nsprefix_ = child_.prefix
            # validate type Suburb
            self.validate_Suburb(self.Suburb)
        elif nodeName_ == 'StreetName':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'StreetName')
            value_ = self.gds_validate_string(value_, node, 'StreetName')
            self.StreetName = value_
            self.StreetName_nsprefix_ = child_.prefix
            # validate type StreetName
            self.validate_StreetName(self.StreetName)
        elif nodeName_ == 'BuildingName':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'BuildingName')
            value_ = self.gds_validate_string(value_, node, 'BuildingName')
            self.BuildingName = value_
            self.BuildingName_nsprefix_ = child_.prefix
            # validate type BuildingName
            self.validate_BuildingName(self.BuildingName)
        elif nodeName_ == 'StreetNumber':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'StreetNumber')
            value_ = self.gds_validate_string(value_, node, 'StreetNumber')
            self.StreetNumber = value_
            self.StreetNumber_nsprefix_ = child_.prefix
            # validate type StreetNumber
            self.validate_StreetNumber(self.StreetNumber)
        elif nodeName_ == 'RegistrationNumbers':
            obj_ = RegistrationNumbers.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RegistrationNumbers = obj_
            obj_.original_tagname_ = 'RegistrationNumbers'
        elif nodeName_ == 'BusinessPartyTypeCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BusinessPartyTypeCode')
            value_ = self.gds_validate_string(value_, node, 'BusinessPartyTypeCode')
            self.BusinessPartyTypeCode = value_
            self.BusinessPartyTypeCode_nsprefix_ = child_.prefix
            # validate type BusinessPartyTypeCode
            self.validate_BusinessPartyTypeCode(self.BusinessPartyTypeCode)
# end class Consignee


class Contact(GeneratedsSuper):
    """Contact -- The Contact element contains the receiver
    ’
    s contact information. It must be declared in the consignee element
    PersonName -- The PersonName element contains the name of the receiver.  It is a mandatory element in the consignee
    ’
    s Contact element. It is a string with a maximum length of 35
    PhoneNumber -- The Phone element contains the receiver
    ’
    s phone number. It is a mandatory element in the consignee
    ’
    s Contact Element
    PhoneExtension -- The PhoneExtension element is the extension number of the consignee. It is an optional element in the consignee
    ’
    s contact Element. The value must be maximum 5 digits long
    FaxNumber -- This element contains the fax number of the consignee. It is an optional element in the consignee contact Element
    Telex -- This element contains telex number and answer back code
    Email -- This element contains the email address of the consignee
    MobilePhoneNumber -- The MobilePhoneNumber element contains the consignee
    ’
    s mobile phone number. It is an optional element in the consignee
    ’
    s contact Element. The value consist of maximum 25 numbers
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PersonName=None, PhoneNumber=None, PhoneExtension=None, FaxNumber=None, Telex=None, Email=None, MobilePhoneNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PersonName = PersonName
        self.validate_PersonName(self.PersonName)
        self.PersonName_nsprefix_ = None
        self.PhoneNumber = PhoneNumber
        self.validate_PhoneNumber(self.PhoneNumber)
        self.PhoneNumber_nsprefix_ = None
        self.PhoneExtension = PhoneExtension
        self.validate_PhoneExtension(self.PhoneExtension)
        self.PhoneExtension_nsprefix_ = None
        self.FaxNumber = FaxNumber
        self.validate_PhoneNumber(self.FaxNumber)
        self.FaxNumber_nsprefix_ = None
        self.Telex = Telex
        self.validate_Telex(self.Telex)
        self.Telex_nsprefix_ = None
        self.Email = Email
        self.validate_EmailAddress(self.Email)
        self.Email_nsprefix_ = None
        self.MobilePhoneNumber = MobilePhoneNumber
        self.validate_MobilePhoneNumber(self.MobilePhoneNumber)
        self.MobilePhoneNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Contact)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Contact.subclass:
            return Contact.subclass(*args_, **kwargs_)
        else:
            return Contact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PersonName(self):
        return self.PersonName
    def set_PersonName(self, PersonName):
        self.PersonName = PersonName
    def get_PhoneNumber(self):
        return self.PhoneNumber
    def set_PhoneNumber(self, PhoneNumber):
        self.PhoneNumber = PhoneNumber
    def get_PhoneExtension(self):
        return self.PhoneExtension
    def set_PhoneExtension(self, PhoneExtension):
        self.PhoneExtension = PhoneExtension
    def get_FaxNumber(self):
        return self.FaxNumber
    def set_FaxNumber(self, FaxNumber):
        self.FaxNumber = FaxNumber
    def get_Telex(self):
        return self.Telex
    def set_Telex(self, Telex):
        self.Telex = Telex
    def get_Email(self):
        return self.Email
    def set_Email(self, Email):
        self.Email = Email
    def get_MobilePhoneNumber(self):
        return self.MobilePhoneNumber
    def set_MobilePhoneNumber(self, MobilePhoneNumber):
        self.MobilePhoneNumber = MobilePhoneNumber
    def validate_PersonName(self, value):
        result = True
        # Validate type PersonName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PersonName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PersonName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PhoneNumber(self, value):
        result = True
        # Validate type PhoneNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 70:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PhoneNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PhoneNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_PhoneNumber_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_PhoneNumber_patterns_, ))
                result = False
        return result
    validate_PhoneNumber_patterns_ = [['^(.*[^\\s].*)$']]
    def validate_PhoneExtension(self, value):
        result = True
        # Validate type PhoneExtension, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 5:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PhoneExtension' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Telex(self, value):
        result = True
        # Validate type Telex, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 25:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Telex' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_EmailAddress(self, value):
        result = True
        # Validate type EmailAddress, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 70:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on EmailAddress' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_MobilePhoneNumber(self, value):
        result = True
        # Validate type MobilePhoneNumber, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 70:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on MobilePhoneNumber' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on MobilePhoneNumber' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.PersonName is not None or
            self.PhoneNumber is not None or
            self.PhoneExtension is not None or
            self.FaxNumber is not None or
            self.Telex is not None or
            self.Email is not None or
            self.MobilePhoneNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Contact', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Contact')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Contact':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Contact')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Contact', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Contact'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Contact', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PersonName is not None:
            namespaceprefix_ = self.PersonName_nsprefix_ + ':' if (UseCapturedNS_ and self.PersonName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPersonName>%s</%sPersonName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PersonName), input_name='PersonName')), namespaceprefix_ , eol_))
        if self.PhoneNumber is not None:
            namespaceprefix_ = self.PhoneNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.PhoneNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhoneNumber>%s</%sPhoneNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PhoneNumber), input_name='PhoneNumber')), namespaceprefix_ , eol_))
        if self.PhoneExtension is not None:
            namespaceprefix_ = self.PhoneExtension_nsprefix_ + ':' if (UseCapturedNS_ and self.PhoneExtension_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhoneExtension>%s</%sPhoneExtension>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PhoneExtension), input_name='PhoneExtension')), namespaceprefix_ , eol_))
        if self.FaxNumber is not None:
            namespaceprefix_ = self.FaxNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.FaxNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFaxNumber>%s</%sFaxNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FaxNumber), input_name='FaxNumber')), namespaceprefix_ , eol_))
        if self.Telex is not None:
            namespaceprefix_ = self.Telex_nsprefix_ + ':' if (UseCapturedNS_ and self.Telex_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTelex>%s</%sTelex>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Telex), input_name='Telex')), namespaceprefix_ , eol_))
        if self.Email is not None:
            namespaceprefix_ = self.Email_nsprefix_ + ':' if (UseCapturedNS_ and self.Email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEmail>%s</%sEmail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Email), input_name='Email')), namespaceprefix_ , eol_))
        if self.MobilePhoneNumber is not None:
            namespaceprefix_ = self.MobilePhoneNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.MobilePhoneNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMobilePhoneNumber>%s</%sMobilePhoneNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.MobilePhoneNumber), input_name='MobilePhoneNumber')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PersonName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PersonName')
            value_ = self.gds_validate_string(value_, node, 'PersonName')
            self.PersonName = value_
            self.PersonName_nsprefix_ = child_.prefix
            # validate type PersonName
            self.validate_PersonName(self.PersonName)
        elif nodeName_ == 'PhoneNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PhoneNumber')
            value_ = self.gds_validate_string(value_, node, 'PhoneNumber')
            self.PhoneNumber = value_
            self.PhoneNumber_nsprefix_ = child_.prefix
            # validate type PhoneNumber
            self.validate_PhoneNumber(self.PhoneNumber)
        elif nodeName_ == 'PhoneExtension':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PhoneExtension')
            value_ = self.gds_validate_string(value_, node, 'PhoneExtension')
            self.PhoneExtension = value_
            self.PhoneExtension_nsprefix_ = child_.prefix
            # validate type PhoneExtension
            self.validate_PhoneExtension(self.PhoneExtension)
        elif nodeName_ == 'FaxNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FaxNumber')
            value_ = self.gds_validate_string(value_, node, 'FaxNumber')
            self.FaxNumber = value_
            self.FaxNumber_nsprefix_ = child_.prefix
            # validate type PhoneNumber
            self.validate_PhoneNumber(self.FaxNumber)
        elif nodeName_ == 'Telex':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Telex')
            value_ = self.gds_validate_string(value_, node, 'Telex')
            self.Telex = value_
            self.Telex_nsprefix_ = child_.prefix
            # validate type Telex
            self.validate_Telex(self.Telex)
        elif nodeName_ == 'Email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Email')
            value_ = self.gds_validate_string(value_, node, 'Email')
            self.Email = value_
            self.Email_nsprefix_ = child_.prefix
            # validate type EmailAddress
            self.validate_EmailAddress(self.Email)
        elif nodeName_ == 'MobilePhoneNumber':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'MobilePhoneNumber')
            value_ = self.gds_validate_string(value_, node, 'MobilePhoneNumber')
            self.MobilePhoneNumber = value_
            self.MobilePhoneNumber_nsprefix_ = child_.prefix
            # validate type MobilePhoneNumber
            self.validate_MobilePhoneNumber(self.MobilePhoneNumber)
# end class Contact


class Dutiable(GeneratedsSuper):
    """Dutiable -- For non-domestic shipments, the Dutiable element provides information which defines the types of duties to be levied
    DeclaredValue -- The DeclaredValue element contains the shipment
    ’
    s monetary value . It is required for non-doc or dutiable products. Please refer to Reference Data (Global Product Codes)
    DeclaredCurrency -- The DeclaredCurrency element contains the DHL currency code in which the declared value is specified.This field is required if a declared value is given. Please refer to the Reference Data (DHL Country/Region) for a valid currency code
    ScheduleB -- The ScheduleB element contains the Schedule B info
    ExportLicense -- The ExportLicense element contains the Export License info
    ImportLicense -- The ImportLicense element contains the consignee import license number. It is an optional field in the Dutiable segment
    TermsOfTrade -- The TermsOfTrade element contains the codes for terms of trade of the shipment. It is required for dutiable shipment. Please refer to the Reference Data and only use the codes defined
    CommerceLicensed -- The CommerceLicensed element indicates the shipment is a Commerce-Licensed shipment
    Filing -- The Filing element represents the filing type for the shipment
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, DeclaredValue=None, DeclaredCurrency=None, ScheduleB=None, ExportLicense=None, ImportLicense=None, TermsOfTrade=None, CommerceLicensed=None, Filing=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.DeclaredValue = DeclaredValue
        self.validate_DeclaredValue_Money(self.DeclaredValue)
        self.DeclaredValue_nsprefix_ = None
        self.DeclaredCurrency = DeclaredCurrency
        self.validate_CurrencyCode(self.DeclaredCurrency)
        self.DeclaredCurrency_nsprefix_ = None
        self.ScheduleB = ScheduleB
        self.validate_ScheduleB(self.ScheduleB)
        self.ScheduleB_nsprefix_ = None
        self.ExportLicense = ExportLicense
        self.validate_ExportLicense(self.ExportLicense)
        self.ExportLicense_nsprefix_ = None
        self.ImportLicense = ImportLicense
        self.validate_ImportLicense(self.ImportLicense)
        self.ImportLicense_nsprefix_ = None
        self.TermsOfTrade = TermsOfTrade
        self.validate_TermsOfTrade(self.TermsOfTrade)
        self.TermsOfTrade_nsprefix_ = None
        self.CommerceLicensed = CommerceLicensed
        self.validate_YesNo(self.CommerceLicensed)
        self.CommerceLicensed_nsprefix_ = None
        self.Filing = Filing
        self.Filing_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Dutiable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Dutiable.subclass:
            return Dutiable.subclass(*args_, **kwargs_)
        else:
            return Dutiable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_DeclaredCurrency(self):
        return self.DeclaredCurrency
    def set_DeclaredCurrency(self, DeclaredCurrency):
        self.DeclaredCurrency = DeclaredCurrency
    def get_ScheduleB(self):
        return self.ScheduleB
    def set_ScheduleB(self, ScheduleB):
        self.ScheduleB = ScheduleB
    def get_ExportLicense(self):
        return self.ExportLicense
    def set_ExportLicense(self, ExportLicense):
        self.ExportLicense = ExportLicense
    def get_ImportLicense(self):
        return self.ImportLicense
    def set_ImportLicense(self, ImportLicense):
        self.ImportLicense = ImportLicense
    def get_TermsOfTrade(self):
        return self.TermsOfTrade
    def set_TermsOfTrade(self, TermsOfTrade):
        self.TermsOfTrade = TermsOfTrade
    def get_CommerceLicensed(self):
        return self.CommerceLicensed
    def set_CommerceLicensed(self, CommerceLicensed):
        self.CommerceLicensed = CommerceLicensed
    def get_Filing(self):
        return self.Filing
    def set_Filing(self, Filing):
        self.Filing = Filing
    def validate_DeclaredValue_Money(self, value):
        result = True
        # Validate type DeclaredValue_Money, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on DeclaredValue_Money' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_CurrencyCode(self, value):
        result = True
        # Validate type CurrencyCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CurrencyCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CurrencyCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CurrencyCode_patterns_, ))
                result = False
        return result
    validate_CurrencyCode_patterns_ = [['^([^ ].*[^ ])$']]
    def validate_ScheduleB(self, value):
        result = True
        # Validate type ScheduleB, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ScheduleB' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ExportLicense(self, value):
        result = True
        # Validate type ExportLicense, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 16:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ExportLicense' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ImportLicense(self, value):
        result = True
        # Validate type ImportLicense, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 16:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ImportLicense' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TermsOfTrade(self, value):
        result = True
        # Validate type TermsOfTrade, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TermsOfTrade' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TermsOfTrade' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_YesNo(self, value):
        result = True
        # Validate type YesNo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on YesNo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on YesNo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.DeclaredValue is not None or
            self.DeclaredCurrency is not None or
            self.ScheduleB is not None or
            self.ExportLicense is not None or
            self.ImportLicense is not None or
            self.TermsOfTrade is not None or
            self.CommerceLicensed is not None or
            self.Filing is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Dutiable', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Dutiable')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Dutiable':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Dutiable')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Dutiable', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Dutiable'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Dutiable', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
        if self.DeclaredCurrency is not None:
            namespaceprefix_ = self.DeclaredCurrency_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredCurrency_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredCurrency>%s</%sDeclaredCurrency>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DeclaredCurrency), input_name='DeclaredCurrency')), namespaceprefix_ , eol_))
        if self.ScheduleB is not None:
            namespaceprefix_ = self.ScheduleB_nsprefix_ + ':' if (UseCapturedNS_ and self.ScheduleB_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sScheduleB>%s</%sScheduleB>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ScheduleB), input_name='ScheduleB')), namespaceprefix_ , eol_))
        if self.ExportLicense is not None:
            namespaceprefix_ = self.ExportLicense_nsprefix_ + ':' if (UseCapturedNS_ and self.ExportLicense_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExportLicense>%s</%sExportLicense>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ExportLicense), input_name='ExportLicense')), namespaceprefix_ , eol_))
        if self.ImportLicense is not None:
            namespaceprefix_ = self.ImportLicense_nsprefix_ + ':' if (UseCapturedNS_ and self.ImportLicense_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImportLicense>%s</%sImportLicense>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ImportLicense), input_name='ImportLicense')), namespaceprefix_ , eol_))
        if self.TermsOfTrade is not None:
            namespaceprefix_ = self.TermsOfTrade_nsprefix_ + ':' if (UseCapturedNS_ and self.TermsOfTrade_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTermsOfTrade>%s</%sTermsOfTrade>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TermsOfTrade), input_name='TermsOfTrade')), namespaceprefix_ , eol_))
        if self.CommerceLicensed is not None:
            namespaceprefix_ = self.CommerceLicensed_nsprefix_ + ':' if (UseCapturedNS_ and self.CommerceLicensed_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommerceLicensed>%s</%sCommerceLicensed>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CommerceLicensed), input_name='CommerceLicensed')), namespaceprefix_ , eol_))
        if self.Filing is not None:
            namespaceprefix_ = self.Filing_nsprefix_ + ':' if (UseCapturedNS_ and self.Filing_nsprefix_) else ''
            self.Filing.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Filing', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
            # validate type DeclaredValue_Money
            self.validate_DeclaredValue_Money(self.DeclaredValue)
        elif nodeName_ == 'DeclaredCurrency':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DeclaredCurrency')
            value_ = self.gds_validate_string(value_, node, 'DeclaredCurrency')
            self.DeclaredCurrency = value_
            self.DeclaredCurrency_nsprefix_ = child_.prefix
            # validate type CurrencyCode
            self.validate_CurrencyCode(self.DeclaredCurrency)
        elif nodeName_ == 'ScheduleB':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ScheduleB')
            value_ = self.gds_validate_string(value_, node, 'ScheduleB')
            self.ScheduleB = value_
            self.ScheduleB_nsprefix_ = child_.prefix
            # validate type ScheduleB
            self.validate_ScheduleB(self.ScheduleB)
        elif nodeName_ == 'ExportLicense':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ExportLicense')
            value_ = self.gds_validate_string(value_, node, 'ExportLicense')
            self.ExportLicense = value_
            self.ExportLicense_nsprefix_ = child_.prefix
            # validate type ExportLicense
            self.validate_ExportLicense(self.ExportLicense)
        elif nodeName_ == 'ImportLicense':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ImportLicense')
            value_ = self.gds_validate_string(value_, node, 'ImportLicense')
            self.ImportLicense = value_
            self.ImportLicense_nsprefix_ = child_.prefix
            # validate type ImportLicense
            self.validate_ImportLicense(self.ImportLicense)
        elif nodeName_ == 'TermsOfTrade':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TermsOfTrade')
            value_ = self.gds_validate_string(value_, node, 'TermsOfTrade')
            self.TermsOfTrade = value_
            self.TermsOfTrade_nsprefix_ = child_.prefix
            # validate type TermsOfTrade
            self.validate_TermsOfTrade(self.TermsOfTrade)
        elif nodeName_ == 'CommerceLicensed':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CommerceLicensed')
            value_ = self.gds_validate_string(value_, node, 'CommerceLicensed')
            self.CommerceLicensed = value_
            self.CommerceLicensed_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.CommerceLicensed)
        elif nodeName_ == 'Filing':
            obj_ = Filing.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Filing = obj_
            obj_.original_tagname_ = 'Filing'
# end class Dutiable


class Filing(GeneratedsSuper):
    """Filing -- The Filing element represents the filing type for the shipment
    FilingType -- The FilingType element represents the type of filing  used for the shipment
    FTSR -- The FTSR element represents the FTR Exemption Code
    ITN -- The ITN element represents the Internal Transaction Number (ITN) provided by the US Customs AES system. This number should be in the format starting with an
    “
    X
    ”
    followed by 14 digits
    AES4EIN -- The AES4EIN element represents Exporter Identification Number of the AESPOST approved entity. Typically this is an EIN Tax ID number or a SSN
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, FilingType=None, FTSR=None, ITN=None, AES4EIN=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.FilingType = FilingType
        self.validate_FilingType(self.FilingType)
        self.FilingType_nsprefix_ = None
        self.FTSR = FTSR
        self.validate_FTSR(self.FTSR)
        self.FTSR_nsprefix_ = None
        self.ITN = ITN
        self.validate_ITN(self.ITN)
        self.ITN_nsprefix_ = None
        self.AES4EIN = AES4EIN
        self.validate_AES4EIN(self.AES4EIN)
        self.AES4EIN_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Filing)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Filing.subclass:
            return Filing.subclass(*args_, **kwargs_)
        else:
            return Filing(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_FilingType(self):
        return self.FilingType
    def set_FilingType(self, FilingType):
        self.FilingType = FilingType
    def get_FTSR(self):
        return self.FTSR
    def set_FTSR(self, FTSR):
        self.FTSR = FTSR
    def get_ITN(self):
        return self.ITN
    def set_ITN(self, ITN):
        self.ITN = ITN
    def get_AES4EIN(self):
        return self.AES4EIN
    def set_AES4EIN(self, AES4EIN):
        self.AES4EIN = AES4EIN
    def validate_FilingType(self, value):
        result = True
        # Validate type FilingType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['FTR', 'ITN', 'AES4']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on FilingType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on FilingType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on FilingType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_FTSR(self, value):
        result = True
        # Validate type FTSR, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['30.2(d)(2)', '30.36', '30.37(a)', '30.37(b)', '30.37(e)', '30.37(f)', '30.37(g)', '30.37(h)', '30.37(j)', '30.37(k)', '30.39', '30.40(a)', '30.40(b)', '30.40(c)', '30.40(d)']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on FTSR' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on FTSR' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 5:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on FTSR' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ITN(self, value):
        result = True
        # Validate type ITN, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ITN' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ITN_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ITN_patterns_, ))
                result = False
        return result
    validate_ITN_patterns_ = [['^(X[0-9]{14})$']]
    def validate_AES4EIN(self, value):
        result = True
        # Validate type AES4EIN, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 11:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AES4EIN' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AES4EIN' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.FilingType is not None or
            self.FTSR is not None or
            self.ITN is not None or
            self.AES4EIN is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Filing', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Filing')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Filing':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Filing')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Filing', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Filing'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Filing', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.FilingType is not None:
            namespaceprefix_ = self.FilingType_nsprefix_ + ':' if (UseCapturedNS_ and self.FilingType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFilingType>%s</%sFilingType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FilingType), input_name='FilingType')), namespaceprefix_ , eol_))
        if self.FTSR is not None:
            namespaceprefix_ = self.FTSR_nsprefix_ + ':' if (UseCapturedNS_ and self.FTSR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFTSR>%s</%sFTSR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FTSR), input_name='FTSR')), namespaceprefix_ , eol_))
        if self.ITN is not None:
            namespaceprefix_ = self.ITN_nsprefix_ + ':' if (UseCapturedNS_ and self.ITN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sITN>%s</%sITN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ITN), input_name='ITN')), namespaceprefix_ , eol_))
        if self.AES4EIN is not None:
            namespaceprefix_ = self.AES4EIN_nsprefix_ + ':' if (UseCapturedNS_ and self.AES4EIN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAES4EIN>%s</%sAES4EIN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AES4EIN), input_name='AES4EIN')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FilingType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FilingType')
            value_ = self.gds_validate_string(value_, node, 'FilingType')
            self.FilingType = value_
            self.FilingType_nsprefix_ = child_.prefix
            # validate type FilingType
            self.validate_FilingType(self.FilingType)
        elif nodeName_ == 'FTSR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FTSR')
            value_ = self.gds_validate_string(value_, node, 'FTSR')
            self.FTSR = value_
            self.FTSR_nsprefix_ = child_.prefix
            # validate type FTSR
            self.validate_FTSR(self.FTSR)
        elif nodeName_ == 'ITN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ITN')
            value_ = self.gds_validate_string(value_, node, 'ITN')
            self.ITN = value_
            self.ITN_nsprefix_ = child_.prefix
            # validate type ITN
            self.validate_ITN(self.ITN)
        elif nodeName_ == 'AES4EIN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AES4EIN')
            value_ = self.gds_validate_string(value_, node, 'AES4EIN')
            self.AES4EIN = value_
            self.AES4EIN_nsprefix_ = child_.prefix
            # validate type AES4EIN
            self.validate_AES4EIN(self.AES4EIN)
# end class Filing


class ExportDeclaration(GeneratedsSuper):
    """ExportDeclaration -- For non-domestic shipments, the ExportDeclaration element provides information which is used to aid in the export of a shipment
    InterConsignee -- The InterConsignee element contains the name and address of the intermediate consignee. It is an optional field
    IsPartiesRelation -- The IsPartiesRelation element indicates the relation of parties to the transaction
    ECCN -- This element contains ECCN info
    SignatureName -- The SignatureName element contains the Signatory
    ’
    s name. It is an optional element
    SignatureTitle -- The SignatureTitle element contains the Signatory
    ’
    s title. It is an optional element
    ExportReason -- This element contains the reason for exporting. It is an optional element
    ExportReasonCode -- This element contains the reason code for exporting.It is a conditional element. The valid values are P:Permanent, T:Temporary, R:Re-Export. It is required for dutiable shipment
    SedNumber -- This element contains the SED number. It is an optional element
    SedNumberType -- This element contains the SED number type. It is an optional element. This field is required if SED number is given. The valid values are one of: F (for FTSR), X (for XTN) or S (for SAS)
    InvoiceNumber -- This element contains the Custom Invoice Number. It is a mandatory element for custom invoice details
    InvoiceDate -- This element contains the Custom Invoice date. It is a mandatory element for custom invoice details
    Remarks -- This element contains the Remarks . It is an optional element for custom invoice details
    OtherCharges -- This element contains the other charges that applicable for the shipment. It is an optional element
    TermsOfPayment -- This element contains the Terms of payment of the shipment. It is an optional element
    SignatureImage -- This element contains the Signature image for the custom invoice document. It is required to be in base64 value with valid format of PNG, GIF, JPEG, JPG. The maximum size is 1 MB
    ReceiverReference -- This element contains the Receiver
    ’
    s Reference details for custom invoice. It is an optional element
    ExporterId -- This element contains the Exporter ID details for custom invoice. It is an optional element
    ExporterCode -- This element contains the Exporter Code of the shipment. It is an optional element
    PackageMarks -- This element contains the Package Marks details of the shipment. It is an optional element
    OtherRemarks2 -- This element contains the Other Remarks 2 for custom invoice. It is an optional element
    OtherRemarks3 -- This element contains the Other Remarks 3 for custom invoice. It is an optional element
    RUBankINN -- This element contains the Russia Bank INN details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    RUBankKPP -- This element contains the Russia Bank KPP details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    RUBankOKPO -- This element contains the Russia Bank OKPO details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    RUBankOGRN -- This element contains the Russia Bank OGRN details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    RUBankSettlementAcctNumUSDEUR -- This element contains the Russia Bank Settlement Account Number in USD/EUR currency details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    RUBankSettlementAcctNumRUR -- This element contains the Russia Bank Settlement Account Number in RUR currency details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    RUBankName -- This element contains the Russia Bank Name details of the shipment. It is an optional element. Note: this is applicable for Russia Country/Region
    AddDeclText1 -- This element contains the additional declaration text 1. It is an optional element
    AddDeclText2 -- This element contains the additional declaration text 2. It is an optional element
    AddDeclText3 -- This element contains the additional declaration text 3. It is an optional element
    ExportLineItem -- Specifics about each of the line item
    ShipmentDocument -- The ShipmentDocument contains the shipment
    ’
    s document reference and type name details.It is a optional field
    InvoiceInstructions -- The InvoiceInstructions contains the invoice instructions details.It is a optional field
    CustomerDataTextEntries -- The CustomerDataTextEntries contains the Customer Data Text entries detail.It is a optional field
    PlaceOfIncoterm -- Name of port of departure, shipment or destination, as required under the applicable delivery term.
    ShipmentPurpose -- The ShipmentPurpose indicates if the shipment was sent for Personal (Gift) or Commercial (Sale) reasons.It is a optional field
    DocumentFunction -- The DocumentFunction describes for what purpose was the document details captured and area planned to be used.It is a optional field
    CustomsDocuments -- The CustomsDocuments contains the customs documents details.It is a optional field
    InvoiceTotalNetWeight -- The gross weight consists of the net weight and the weight of the packaging (tare weight)
    InvoiceTotalGrossWeight -- The net weight is calculated as follows: gross weight minus weight of packaging (tare weight)
    InvoiceReferences -- The InvoiceReferences contains the invoice references details.It is a optional field
    InvoiceIndicativeCustomsValues -- The IndicativeCustomsValues contains the shipment
    ’
    s Import Customs Duties, Import Taxes (VAT/GST), Total Invoice Amount After Tax for Perfect Invoice purpose. It is a optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, InterConsignee=None, IsPartiesRelation=None, ECCN=None, SignatureName=None, SignatureTitle=None, ExportReason=None, ExportReasonCode=None, SedNumber=None, SedNumberType=None, InvoiceNumber=None, InvoiceDate=None, Remarks=None, OtherCharges=None, TermsOfPayment=None, PayerGSTVAT=None, SignatureImage=None, ReceiverReference=None, ExporterId=None, ExporterCode=None, PackageMarks=None, OtherRemarks2=None, OtherRemarks3=None, RUBankINN=None, RUBankKPP=None, RUBankOKPO=None, RUBankOGRN=None, RUBankSettlementAcctNumUSDEUR=None, RUBankSettlementAcctNumRUR=None, RUBankName=None, AddDeclText1=None, AddDeclText2=None, AddDeclText3=None, ExportLineItem=None, ShipmentDocument=None, InvoiceInstructions=None, CustomerDataTextEntries=None, PlaceOfIncoterm=None, ShipmentPurpose=None, DocumentFunction=None, CustomsDocuments=None, InvoiceTotalNetWeight=None, InvoiceTotalGrossWeight=None, InvoiceReferences=None, InvoiceIndicativeCustomsValues=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.InterConsignee = InterConsignee
        self.validate_InterConsigneeType(self.InterConsignee)
        self.InterConsignee_nsprefix_ = None
        self.IsPartiesRelation = IsPartiesRelation
        self.validate_YesNo(self.IsPartiesRelation)
        self.IsPartiesRelation_nsprefix_ = None
        self.ECCN = ECCN
        self.validate_ECCNType(self.ECCN)
        self.ECCN_nsprefix_ = None
        self.SignatureName = SignatureName
        self.validate_SignatureName(self.SignatureName)
        self.SignatureName_nsprefix_ = None
        self.SignatureTitle = SignatureTitle
        self.validate_SignatureTitle(self.SignatureTitle)
        self.SignatureTitle_nsprefix_ = None
        self.ExportReason = ExportReason
        self.validate_ExportReasonType(self.ExportReason)
        self.ExportReason_nsprefix_ = None
        self.ExportReasonCode = ExportReasonCode
        self.validate_ExportReasonCode(self.ExportReasonCode)
        self.ExportReasonCode_nsprefix_ = None
        self.SedNumber = SedNumber
        self.validate_SEDNumber(self.SedNumber)
        self.SedNumber_nsprefix_ = None
        self.SedNumberType = SedNumberType
        self.validate_SEDNumberType(self.SedNumberType)
        self.SedNumberType_nsprefix_ = None
        self.InvoiceNumber = InvoiceNumber
        self.validate_InvoiceNumber(self.InvoiceNumber)
        self.InvoiceNumber_nsprefix_ = None
        if isinstance(InvoiceDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(InvoiceDate, '%Y-%m-%d').date()
        else:
            initvalue_ = InvoiceDate
        self.InvoiceDate = initvalue_
        self.InvoiceDate_nsprefix_ = None
        self.Remarks = Remarks
        self.Remarks_nsprefix_ = None
        self.OtherCharges = OtherCharges
        self.OtherCharges_nsprefix_ = None
        self.TermsOfPayment = TermsOfPayment
        self.TermsOfPayment_nsprefix_ = None
        self.PayerGSTVAT = PayerGSTVAT
        self.PayerGSTVAT_nsprefix_ = None
        self.SignatureImage = SignatureImage
        self.validate_SignatureImage(self.SignatureImage)
        self.SignatureImage_nsprefix_ = None
        self.ReceiverReference = ReceiverReference
        self.ReceiverReference_nsprefix_ = None
        self.ExporterId = ExporterId
        self.ExporterId_nsprefix_ = None
        self.ExporterCode = ExporterCode
        self.ExporterCode_nsprefix_ = None
        self.PackageMarks = PackageMarks
        self.PackageMarks_nsprefix_ = None
        self.OtherRemarks2 = OtherRemarks2
        self.OtherRemarks2_nsprefix_ = None
        self.OtherRemarks3 = OtherRemarks3
        self.OtherRemarks3_nsprefix_ = None
        self.RUBankINN = RUBankINN
        self.RUBankINN_nsprefix_ = None
        self.RUBankKPP = RUBankKPP
        self.RUBankKPP_nsprefix_ = None
        self.RUBankOKPO = RUBankOKPO
        self.RUBankOKPO_nsprefix_ = None
        self.RUBankOGRN = RUBankOGRN
        self.RUBankOGRN_nsprefix_ = None
        self.RUBankSettlementAcctNumUSDEUR = RUBankSettlementAcctNumUSDEUR
        self.RUBankSettlementAcctNumUSDEUR_nsprefix_ = None
        self.RUBankSettlementAcctNumRUR = RUBankSettlementAcctNumRUR
        self.RUBankSettlementAcctNumRUR_nsprefix_ = None
        self.RUBankName = RUBankName
        self.RUBankName_nsprefix_ = None
        self.AddDeclText1 = AddDeclText1
        self.validate_AddDeclText1Type(self.AddDeclText1)
        self.AddDeclText1_nsprefix_ = None
        self.AddDeclText2 = AddDeclText2
        self.validate_AddDeclText(self.AddDeclText2)
        self.AddDeclText2_nsprefix_ = None
        self.AddDeclText3 = AddDeclText3
        self.validate_AddDeclText(self.AddDeclText3)
        self.AddDeclText3_nsprefix_ = None
        if ExportLineItem is None:
            self.ExportLineItem = []
        else:
            self.ExportLineItem = ExportLineItem
        self.ExportLineItem_nsprefix_ = None
        self.ShipmentDocument = ShipmentDocument
        self.ShipmentDocument_nsprefix_ = None
        self.InvoiceInstructions = InvoiceInstructions
        self.validate_InvoiceInstructions(self.InvoiceInstructions)
        self.InvoiceInstructions_nsprefix_ = None
        self.CustomerDataTextEntries = CustomerDataTextEntries
        self.CustomerDataTextEntries_nsprefix_ = None
        self.PlaceOfIncoterm = PlaceOfIncoterm
        self.validate_PlaceOfIncoterm(self.PlaceOfIncoterm)
        self.PlaceOfIncoterm_nsprefix_ = None
        self.ShipmentPurpose = ShipmentPurpose
        self.validate_ShipmentPurpose(self.ShipmentPurpose)
        self.ShipmentPurpose_nsprefix_ = None
        self.DocumentFunction = DocumentFunction
        self.validate_DocumentFunction(self.DocumentFunction)
        self.DocumentFunction_nsprefix_ = None
        self.CustomsDocuments = CustomsDocuments
        self.CustomsDocuments_nsprefix_ = None
        self.InvoiceTotalNetWeight = InvoiceTotalNetWeight
        self.validate_Invoice_Weight(self.InvoiceTotalNetWeight)
        self.InvoiceTotalNetWeight_nsprefix_ = None
        self.InvoiceTotalGrossWeight = InvoiceTotalGrossWeight
        self.validate_Invoice_Weight(self.InvoiceTotalGrossWeight)
        self.InvoiceTotalGrossWeight_nsprefix_ = None
        self.InvoiceReferences = InvoiceReferences
        self.InvoiceReferences_nsprefix_ = None
        self.InvoiceIndicativeCustomsValues = InvoiceIndicativeCustomsValues
        self.InvoiceIndicativeCustomsValues_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExportDeclaration)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExportDeclaration.subclass:
            return ExportDeclaration.subclass(*args_, **kwargs_)
        else:
            return ExportDeclaration(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_InterConsignee(self):
        return self.InterConsignee
    def set_InterConsignee(self, InterConsignee):
        self.InterConsignee = InterConsignee
    def get_IsPartiesRelation(self):
        return self.IsPartiesRelation
    def set_IsPartiesRelation(self, IsPartiesRelation):
        self.IsPartiesRelation = IsPartiesRelation
    def get_ECCN(self):
        return self.ECCN
    def set_ECCN(self, ECCN):
        self.ECCN = ECCN
    def get_SignatureName(self):
        return self.SignatureName
    def set_SignatureName(self, SignatureName):
        self.SignatureName = SignatureName
    def get_SignatureTitle(self):
        return self.SignatureTitle
    def set_SignatureTitle(self, SignatureTitle):
        self.SignatureTitle = SignatureTitle
    def get_ExportReason(self):
        return self.ExportReason
    def set_ExportReason(self, ExportReason):
        self.ExportReason = ExportReason
    def get_ExportReasonCode(self):
        return self.ExportReasonCode
    def set_ExportReasonCode(self, ExportReasonCode):
        self.ExportReasonCode = ExportReasonCode
    def get_SedNumber(self):
        return self.SedNumber
    def set_SedNumber(self, SedNumber):
        self.SedNumber = SedNumber
    def get_SedNumberType(self):
        return self.SedNumberType
    def set_SedNumberType(self, SedNumberType):
        self.SedNumberType = SedNumberType
    def get_InvoiceNumber(self):
        return self.InvoiceNumber
    def set_InvoiceNumber(self, InvoiceNumber):
        self.InvoiceNumber = InvoiceNumber
    def get_InvoiceDate(self):
        return self.InvoiceDate
    def set_InvoiceDate(self, InvoiceDate):
        self.InvoiceDate = InvoiceDate
    def get_Remarks(self):
        return self.Remarks
    def set_Remarks(self, Remarks):
        self.Remarks = Remarks
    def get_OtherCharges(self):
        return self.OtherCharges
    def set_OtherCharges(self, OtherCharges):
        self.OtherCharges = OtherCharges
    def get_TermsOfPayment(self):
        return self.TermsOfPayment
    def set_TermsOfPayment(self, TermsOfPayment):
        self.TermsOfPayment = TermsOfPayment
    def get_PayerGSTVAT(self):
        return self.PayerGSTVAT
    def set_PayerGSTVAT(self, PayerGSTVAT):
        self.PayerGSTVAT = PayerGSTVAT
    def get_SignatureImage(self):
        return self.SignatureImage
    def set_SignatureImage(self, SignatureImage):
        self.SignatureImage = SignatureImage
    def get_ReceiverReference(self):
        return self.ReceiverReference
    def set_ReceiverReference(self, ReceiverReference):
        self.ReceiverReference = ReceiverReference
    def get_ExporterId(self):
        return self.ExporterId
    def set_ExporterId(self, ExporterId):
        self.ExporterId = ExporterId
    def get_ExporterCode(self):
        return self.ExporterCode
    def set_ExporterCode(self, ExporterCode):
        self.ExporterCode = ExporterCode
    def get_PackageMarks(self):
        return self.PackageMarks
    def set_PackageMarks(self, PackageMarks):
        self.PackageMarks = PackageMarks
    def get_OtherRemarks2(self):
        return self.OtherRemarks2
    def set_OtherRemarks2(self, OtherRemarks2):
        self.OtherRemarks2 = OtherRemarks2
    def get_OtherRemarks3(self):
        return self.OtherRemarks3
    def set_OtherRemarks3(self, OtherRemarks3):
        self.OtherRemarks3 = OtherRemarks3
    def get_RUBankINN(self):
        return self.RUBankINN
    def set_RUBankINN(self, RUBankINN):
        self.RUBankINN = RUBankINN
    def get_RUBankKPP(self):
        return self.RUBankKPP
    def set_RUBankKPP(self, RUBankKPP):
        self.RUBankKPP = RUBankKPP
    def get_RUBankOKPO(self):
        return self.RUBankOKPO
    def set_RUBankOKPO(self, RUBankOKPO):
        self.RUBankOKPO = RUBankOKPO
    def get_RUBankOGRN(self):
        return self.RUBankOGRN
    def set_RUBankOGRN(self, RUBankOGRN):
        self.RUBankOGRN = RUBankOGRN
    def get_RUBankSettlementAcctNumUSDEUR(self):
        return self.RUBankSettlementAcctNumUSDEUR
    def set_RUBankSettlementAcctNumUSDEUR(self, RUBankSettlementAcctNumUSDEUR):
        self.RUBankSettlementAcctNumUSDEUR = RUBankSettlementAcctNumUSDEUR
    def get_RUBankSettlementAcctNumRUR(self):
        return self.RUBankSettlementAcctNumRUR
    def set_RUBankSettlementAcctNumRUR(self, RUBankSettlementAcctNumRUR):
        self.RUBankSettlementAcctNumRUR = RUBankSettlementAcctNumRUR
    def get_RUBankName(self):
        return self.RUBankName
    def set_RUBankName(self, RUBankName):
        self.RUBankName = RUBankName
    def get_AddDeclText1(self):
        return self.AddDeclText1
    def set_AddDeclText1(self, AddDeclText1):
        self.AddDeclText1 = AddDeclText1
    def get_AddDeclText2(self):
        return self.AddDeclText2
    def set_AddDeclText2(self, AddDeclText2):
        self.AddDeclText2 = AddDeclText2
    def get_AddDeclText3(self):
        return self.AddDeclText3
    def set_AddDeclText3(self, AddDeclText3):
        self.AddDeclText3 = AddDeclText3
    def get_ExportLineItem(self):
        return self.ExportLineItem
    def set_ExportLineItem(self, ExportLineItem):
        self.ExportLineItem = ExportLineItem
    def add_ExportLineItem(self, value):
        self.ExportLineItem.append(value)
    def insert_ExportLineItem_at(self, index, value):
        self.ExportLineItem.insert(index, value)
    def replace_ExportLineItem_at(self, index, value):
        self.ExportLineItem[index] = value
    def get_ShipmentDocument(self):
        return self.ShipmentDocument
    def set_ShipmentDocument(self, ShipmentDocument):
        self.ShipmentDocument = ShipmentDocument
    def get_InvoiceInstructions(self):
        return self.InvoiceInstructions
    def set_InvoiceInstructions(self, InvoiceInstructions):
        self.InvoiceInstructions = InvoiceInstructions
    def get_CustomerDataTextEntries(self):
        return self.CustomerDataTextEntries
    def set_CustomerDataTextEntries(self, CustomerDataTextEntries):
        self.CustomerDataTextEntries = CustomerDataTextEntries
    def get_PlaceOfIncoterm(self):
        return self.PlaceOfIncoterm
    def set_PlaceOfIncoterm(self, PlaceOfIncoterm):
        self.PlaceOfIncoterm = PlaceOfIncoterm
    def get_ShipmentPurpose(self):
        return self.ShipmentPurpose
    def set_ShipmentPurpose(self, ShipmentPurpose):
        self.ShipmentPurpose = ShipmentPurpose
    def get_DocumentFunction(self):
        return self.DocumentFunction
    def set_DocumentFunction(self, DocumentFunction):
        self.DocumentFunction = DocumentFunction
    def get_CustomsDocuments(self):
        return self.CustomsDocuments
    def set_CustomsDocuments(self, CustomsDocuments):
        self.CustomsDocuments = CustomsDocuments
    def get_InvoiceTotalNetWeight(self):
        return self.InvoiceTotalNetWeight
    def set_InvoiceTotalNetWeight(self, InvoiceTotalNetWeight):
        self.InvoiceTotalNetWeight = InvoiceTotalNetWeight
    def get_InvoiceTotalGrossWeight(self):
        return self.InvoiceTotalGrossWeight
    def set_InvoiceTotalGrossWeight(self, InvoiceTotalGrossWeight):
        self.InvoiceTotalGrossWeight = InvoiceTotalGrossWeight
    def get_InvoiceReferences(self):
        return self.InvoiceReferences
    def set_InvoiceReferences(self, InvoiceReferences):
        self.InvoiceReferences = InvoiceReferences
    def get_InvoiceIndicativeCustomsValues(self):
        return self.InvoiceIndicativeCustomsValues
    def set_InvoiceIndicativeCustomsValues(self, InvoiceIndicativeCustomsValues):
        self.InvoiceIndicativeCustomsValues = InvoiceIndicativeCustomsValues
    def validate_InterConsigneeType(self, value):
        result = True
        # Validate type InterConsigneeType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 70:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on InterConsigneeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on InterConsigneeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_YesNo(self, value):
        result = True
        # Validate type YesNo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on YesNo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on YesNo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ECCNType(self, value):
        result = True
        # Validate type ECCNType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ECCNType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ECCNType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SignatureName(self, value):
        result = True
        # Validate type SignatureName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SignatureName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SignatureTitle(self, value):
        result = True
        # Validate type SignatureTitle, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SignatureTitle' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ExportReasonType(self, value):
        result = True
        # Validate type ExportReasonType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ExportReasonType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ExportReasonCode(self, value):
        result = True
        # Validate type ExportReasonCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ExportReasonCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SEDNumber(self, value):
        result = True
        # Validate type SEDNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['FTSR', 'XTN', 'SAS', 'ITN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on SEDNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SEDNumberType(self, value):
        result = True
        # Validate type SEDNumberType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['F', 'X', 'S', 'I']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on SEDNumberType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on SEDNumberType' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_InvoiceNumber(self, value):
        result = True
        # Validate type InvoiceNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on InvoiceNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SignatureImage(self, value):
        result = True
        # Validate type SignatureImage, a restriction on xsd:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if len(value) > 1048576:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SignatureImage' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_AddDeclText1Type(self, value):
        result = True
        # Validate type AddDeclText1Type, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 700:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AddDeclText1Type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AddDeclText(self, value):
        result = True
        # Validate type AddDeclText, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 140:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AddDeclText' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_InvoiceInstructions(self, value):
        result = True
        # Validate type InvoiceInstructions, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 300:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on InvoiceInstructions' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PlaceOfIncoterm(self, value):
        result = True
        # Validate type PlaceOfIncoterm, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 256:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PlaceOfIncoterm' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ShipmentPurpose(self, value):
        result = True
        # Validate type ShipmentPurpose, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PERSONAL', 'COMMERCIAL']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ShipmentPurpose' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DocumentFunction(self, value):
        result = True
        # Validate type DocumentFunction, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['IMPORT', 'EXPORT', 'BOTH']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DocumentFunction' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Invoice_Weight(self, value):
        result = True
        # Validate type Invoice_Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on Invoice_Weight' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on Invoice_Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.InterConsignee is not None or
            self.IsPartiesRelation is not None or
            self.ECCN is not None or
            self.SignatureName is not None or
            self.SignatureTitle is not None or
            self.ExportReason is not None or
            self.ExportReasonCode is not None or
            self.SedNumber is not None or
            self.SedNumberType is not None or
            self.InvoiceNumber is not None or
            self.InvoiceDate is not None or
            self.Remarks is not None or
            self.OtherCharges is not None or
            self.TermsOfPayment is not None or
            self.PayerGSTVAT is not None or
            self.SignatureImage is not None or
            self.ReceiverReference is not None or
            self.ExporterId is not None or
            self.ExporterCode is not None or
            self.PackageMarks is not None or
            self.OtherRemarks2 is not None or
            self.OtherRemarks3 is not None or
            self.RUBankINN is not None or
            self.RUBankKPP is not None or
            self.RUBankOKPO is not None or
            self.RUBankOGRN is not None or
            self.RUBankSettlementAcctNumUSDEUR is not None or
            self.RUBankSettlementAcctNumRUR is not None or
            self.RUBankName is not None or
            self.AddDeclText1 is not None or
            self.AddDeclText2 is not None or
            self.AddDeclText3 is not None or
            self.ExportLineItem or
            self.ShipmentDocument is not None or
            self.InvoiceInstructions is not None or
            self.CustomerDataTextEntries is not None or
            self.PlaceOfIncoterm is not None or
            self.ShipmentPurpose is not None or
            self.DocumentFunction is not None or
            self.CustomsDocuments is not None or
            self.InvoiceTotalNetWeight is not None or
            self.InvoiceTotalGrossWeight is not None or
            self.InvoiceReferences is not None or
            self.InvoiceIndicativeCustomsValues is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportDeclaration', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExportDeclaration')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExportDeclaration':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExportDeclaration')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExportDeclaration', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ExportDeclaration'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportDeclaration', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.InterConsignee is not None:
            namespaceprefix_ = self.InterConsignee_nsprefix_ + ':' if (UseCapturedNS_ and self.InterConsignee_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInterConsignee>%s</%sInterConsignee>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InterConsignee), input_name='InterConsignee')), namespaceprefix_ , eol_))
        if self.IsPartiesRelation is not None:
            namespaceprefix_ = self.IsPartiesRelation_nsprefix_ + ':' if (UseCapturedNS_ and self.IsPartiesRelation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsPartiesRelation>%s</%sIsPartiesRelation>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IsPartiesRelation), input_name='IsPartiesRelation')), namespaceprefix_ , eol_))
        if self.ECCN is not None:
            namespaceprefix_ = self.ECCN_nsprefix_ + ':' if (UseCapturedNS_ and self.ECCN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sECCN>%s</%sECCN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ECCN), input_name='ECCN')), namespaceprefix_ , eol_))
        if self.SignatureName is not None:
            namespaceprefix_ = self.SignatureName_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignatureName>%s</%sSignatureName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SignatureName), input_name='SignatureName')), namespaceprefix_ , eol_))
        if self.SignatureTitle is not None:
            namespaceprefix_ = self.SignatureTitle_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureTitle_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignatureTitle>%s</%sSignatureTitle>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SignatureTitle), input_name='SignatureTitle')), namespaceprefix_ , eol_))
        if self.ExportReason is not None:
            namespaceprefix_ = self.ExportReason_nsprefix_ + ':' if (UseCapturedNS_ and self.ExportReason_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExportReason>%s</%sExportReason>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ExportReason), input_name='ExportReason')), namespaceprefix_ , eol_))
        if self.ExportReasonCode is not None:
            namespaceprefix_ = self.ExportReasonCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ExportReasonCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExportReasonCode>%s</%sExportReasonCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ExportReasonCode), input_name='ExportReasonCode')), namespaceprefix_ , eol_))
        if self.SedNumber is not None:
            namespaceprefix_ = self.SedNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.SedNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSedNumber>%s</%sSedNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SedNumber), input_name='SedNumber')), namespaceprefix_ , eol_))
        if self.SedNumberType is not None:
            namespaceprefix_ = self.SedNumberType_nsprefix_ + ':' if (UseCapturedNS_ and self.SedNumberType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSedNumberType>%s</%sSedNumberType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SedNumberType), input_name='SedNumberType')), namespaceprefix_ , eol_))
        if self.InvoiceNumber is not None:
            namespaceprefix_ = self.InvoiceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceNumber>%s</%sInvoiceNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InvoiceNumber), input_name='InvoiceNumber')), namespaceprefix_ , eol_))
        if self.InvoiceDate is not None:
            namespaceprefix_ = self.InvoiceDate_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceDate>%s</%sInvoiceDate>%s' % (namespaceprefix_ , self.gds_format_date(self.InvoiceDate, input_name='InvoiceDate'), namespaceprefix_ , eol_))
        if self.Remarks is not None:
            namespaceprefix_ = self.Remarks_nsprefix_ + ':' if (UseCapturedNS_ and self.Remarks_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRemarks>%s</%sRemarks>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Remarks), input_name='Remarks')), namespaceprefix_ , eol_))
        if self.OtherCharges is not None:
            namespaceprefix_ = self.OtherCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherCharges_nsprefix_) else ''
            self.OtherCharges.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OtherCharges', pretty_print=pretty_print)
        if self.TermsOfPayment is not None:
            namespaceprefix_ = self.TermsOfPayment_nsprefix_ + ':' if (UseCapturedNS_ and self.TermsOfPayment_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTermsOfPayment>%s</%sTermsOfPayment>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TermsOfPayment), input_name='TermsOfPayment')), namespaceprefix_ , eol_))
        if self.PayerGSTVAT is not None:
            namespaceprefix_ = self.PayerGSTVAT_nsprefix_ + ':' if (UseCapturedNS_ and self.PayerGSTVAT_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPayerGSTVAT>%s</%sPayerGSTVAT>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PayerGSTVAT), input_name='PayerGSTVAT')), namespaceprefix_ , eol_))
        if self.SignatureImage is not None:
            namespaceprefix_ = self.SignatureImage_nsprefix_ + ':' if (UseCapturedNS_ and self.SignatureImage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignatureImage>%s</%sSignatureImage>%s' % (namespaceprefix_ , self.gds_format_base64(self.SignatureImage, input_name='SignatureImage'), namespaceprefix_ , eol_))
        if self.ReceiverReference is not None:
            namespaceprefix_ = self.ReceiverReference_nsprefix_ + ':' if (UseCapturedNS_ and self.ReceiverReference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReceiverReference>%s</%sReceiverReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ReceiverReference), input_name='ReceiverReference')), namespaceprefix_ , eol_))
        if self.ExporterId is not None:
            namespaceprefix_ = self.ExporterId_nsprefix_ + ':' if (UseCapturedNS_ and self.ExporterId_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExporterId>%s</%sExporterId>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ExporterId), input_name='ExporterId')), namespaceprefix_ , eol_))
        if self.ExporterCode is not None:
            namespaceprefix_ = self.ExporterCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ExporterCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sExporterCode>%s</%sExporterCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ExporterCode), input_name='ExporterCode')), namespaceprefix_ , eol_))
        if self.PackageMarks is not None:
            namespaceprefix_ = self.PackageMarks_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageMarks_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageMarks>%s</%sPackageMarks>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageMarks), input_name='PackageMarks')), namespaceprefix_ , eol_))
        if self.OtherRemarks2 is not None:
            namespaceprefix_ = self.OtherRemarks2_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherRemarks2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOtherRemarks2>%s</%sOtherRemarks2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OtherRemarks2), input_name='OtherRemarks2')), namespaceprefix_ , eol_))
        if self.OtherRemarks3 is not None:
            namespaceprefix_ = self.OtherRemarks3_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherRemarks3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOtherRemarks3>%s</%sOtherRemarks3>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OtherRemarks3), input_name='OtherRemarks3')), namespaceprefix_ , eol_))
        if self.RUBankINN is not None:
            namespaceprefix_ = self.RUBankINN_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankINN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankINN>%s</%sRUBankINN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankINN), input_name='RUBankINN')), namespaceprefix_ , eol_))
        if self.RUBankKPP is not None:
            namespaceprefix_ = self.RUBankKPP_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankKPP_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankKPP>%s</%sRUBankKPP>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankKPP), input_name='RUBankKPP')), namespaceprefix_ , eol_))
        if self.RUBankOKPO is not None:
            namespaceprefix_ = self.RUBankOKPO_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankOKPO_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankOKPO>%s</%sRUBankOKPO>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankOKPO), input_name='RUBankOKPO')), namespaceprefix_ , eol_))
        if self.RUBankOGRN is not None:
            namespaceprefix_ = self.RUBankOGRN_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankOGRN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankOGRN>%s</%sRUBankOGRN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankOGRN), input_name='RUBankOGRN')), namespaceprefix_ , eol_))
        if self.RUBankSettlementAcctNumUSDEUR is not None:
            namespaceprefix_ = self.RUBankSettlementAcctNumUSDEUR_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankSettlementAcctNumUSDEUR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankSettlementAcctNumUSDEUR>%s</%sRUBankSettlementAcctNumUSDEUR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankSettlementAcctNumUSDEUR), input_name='RUBankSettlementAcctNumUSDEUR')), namespaceprefix_ , eol_))
        if self.RUBankSettlementAcctNumRUR is not None:
            namespaceprefix_ = self.RUBankSettlementAcctNumRUR_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankSettlementAcctNumRUR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankSettlementAcctNumRUR>%s</%sRUBankSettlementAcctNumRUR>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankSettlementAcctNumRUR), input_name='RUBankSettlementAcctNumRUR')), namespaceprefix_ , eol_))
        if self.RUBankName is not None:
            namespaceprefix_ = self.RUBankName_nsprefix_ + ':' if (UseCapturedNS_ and self.RUBankName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRUBankName>%s</%sRUBankName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RUBankName), input_name='RUBankName')), namespaceprefix_ , eol_))
        if self.AddDeclText1 is not None:
            namespaceprefix_ = self.AddDeclText1_nsprefix_ + ':' if (UseCapturedNS_ and self.AddDeclText1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddDeclText1>%s</%sAddDeclText1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddDeclText1), input_name='AddDeclText1')), namespaceprefix_ , eol_))
        if self.AddDeclText2 is not None:
            namespaceprefix_ = self.AddDeclText2_nsprefix_ + ':' if (UseCapturedNS_ and self.AddDeclText2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddDeclText2>%s</%sAddDeclText2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddDeclText2), input_name='AddDeclText2')), namespaceprefix_ , eol_))
        if self.AddDeclText3 is not None:
            namespaceprefix_ = self.AddDeclText3_nsprefix_ + ':' if (UseCapturedNS_ and self.AddDeclText3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddDeclText3>%s</%sAddDeclText3>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddDeclText3), input_name='AddDeclText3')), namespaceprefix_ , eol_))
        for ExportLineItem_ in self.ExportLineItem:
            namespaceprefix_ = self.ExportLineItem_nsprefix_ + ':' if (UseCapturedNS_ and self.ExportLineItem_nsprefix_) else ''
            ExportLineItem_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExportLineItem', pretty_print=pretty_print)
        if self.ShipmentDocument is not None:
            namespaceprefix_ = self.ShipmentDocument_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentDocument_nsprefix_) else ''
            self.ShipmentDocument.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ShipmentDocument', pretty_print=pretty_print)
        if self.InvoiceInstructions is not None:
            namespaceprefix_ = self.InvoiceInstructions_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceInstructions_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceInstructions>%s</%sInvoiceInstructions>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InvoiceInstructions), input_name='InvoiceInstructions')), namespaceprefix_ , eol_))
        if self.CustomerDataTextEntries is not None:
            namespaceprefix_ = self.CustomerDataTextEntries_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerDataTextEntries_nsprefix_) else ''
            self.CustomerDataTextEntries.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomerDataTextEntries', pretty_print=pretty_print)
        if self.PlaceOfIncoterm is not None:
            namespaceprefix_ = self.PlaceOfIncoterm_nsprefix_ + ':' if (UseCapturedNS_ and self.PlaceOfIncoterm_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPlaceOfIncoterm>%s</%sPlaceOfIncoterm>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PlaceOfIncoterm), input_name='PlaceOfIncoterm')), namespaceprefix_ , eol_))
        if self.ShipmentPurpose is not None:
            namespaceprefix_ = self.ShipmentPurpose_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentPurpose_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentPurpose>%s</%sShipmentPurpose>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipmentPurpose), input_name='ShipmentPurpose')), namespaceprefix_ , eol_))
        if self.DocumentFunction is not None:
            namespaceprefix_ = self.DocumentFunction_nsprefix_ + ':' if (UseCapturedNS_ and self.DocumentFunction_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDocumentFunction>%s</%sDocumentFunction>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DocumentFunction), input_name='DocumentFunction')), namespaceprefix_ , eol_))
        if self.CustomsDocuments is not None:
            namespaceprefix_ = self.CustomsDocuments_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsDocuments_nsprefix_) else ''
            self.CustomsDocuments.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomsDocuments', pretty_print=pretty_print)
        if self.InvoiceTotalNetWeight is not None:
            namespaceprefix_ = self.InvoiceTotalNetWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceTotalNetWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceTotalNetWeight>%s</%sInvoiceTotalNetWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.InvoiceTotalNetWeight, input_name='InvoiceTotalNetWeight'), namespaceprefix_ , eol_))
        if self.InvoiceTotalGrossWeight is not None:
            namespaceprefix_ = self.InvoiceTotalGrossWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceTotalGrossWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceTotalGrossWeight>%s</%sInvoiceTotalGrossWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.InvoiceTotalGrossWeight, input_name='InvoiceTotalGrossWeight'), namespaceprefix_ , eol_))
        if self.InvoiceReferences is not None:
            namespaceprefix_ = self.InvoiceReferences_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceReferences_nsprefix_) else ''
            self.InvoiceReferences.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InvoiceReferences', pretty_print=pretty_print)
        if self.InvoiceIndicativeCustomsValues is not None:
            namespaceprefix_ = self.InvoiceIndicativeCustomsValues_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceIndicativeCustomsValues_nsprefix_) else ''
            self.InvoiceIndicativeCustomsValues.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InvoiceIndicativeCustomsValues', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InterConsignee':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InterConsignee')
            value_ = self.gds_validate_string(value_, node, 'InterConsignee')
            self.InterConsignee = value_
            self.InterConsignee_nsprefix_ = child_.prefix
            # validate type InterConsigneeType
            self.validate_InterConsigneeType(self.InterConsignee)
        elif nodeName_ == 'IsPartiesRelation':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IsPartiesRelation')
            value_ = self.gds_validate_string(value_, node, 'IsPartiesRelation')
            self.IsPartiesRelation = value_
            self.IsPartiesRelation_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.IsPartiesRelation)
        elif nodeName_ == 'ECCN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ECCN')
            value_ = self.gds_validate_string(value_, node, 'ECCN')
            self.ECCN = value_
            self.ECCN_nsprefix_ = child_.prefix
            # validate type ECCNType
            self.validate_ECCNType(self.ECCN)
        elif nodeName_ == 'SignatureName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SignatureName')
            value_ = self.gds_validate_string(value_, node, 'SignatureName')
            self.SignatureName = value_
            self.SignatureName_nsprefix_ = child_.prefix
            # validate type SignatureName
            self.validate_SignatureName(self.SignatureName)
        elif nodeName_ == 'SignatureTitle':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SignatureTitle')
            value_ = self.gds_validate_string(value_, node, 'SignatureTitle')
            self.SignatureTitle = value_
            self.SignatureTitle_nsprefix_ = child_.prefix
            # validate type SignatureTitle
            self.validate_SignatureTitle(self.SignatureTitle)
        elif nodeName_ == 'ExportReason':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ExportReason')
            value_ = self.gds_validate_string(value_, node, 'ExportReason')
            self.ExportReason = value_
            self.ExportReason_nsprefix_ = child_.prefix
            # validate type ExportReasonType
            self.validate_ExportReasonType(self.ExportReason)
        elif nodeName_ == 'ExportReasonCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ExportReasonCode')
            value_ = self.gds_validate_string(value_, node, 'ExportReasonCode')
            self.ExportReasonCode = value_
            self.ExportReasonCode_nsprefix_ = child_.prefix
            # validate type ExportReasonCode
            self.validate_ExportReasonCode(self.ExportReasonCode)
        elif nodeName_ == 'SedNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SedNumber')
            value_ = self.gds_validate_string(value_, node, 'SedNumber')
            self.SedNumber = value_
            self.SedNumber_nsprefix_ = child_.prefix
            # validate type SEDNumber
            self.validate_SEDNumber(self.SedNumber)
        elif nodeName_ == 'SedNumberType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SedNumberType')
            value_ = self.gds_validate_string(value_, node, 'SedNumberType')
            self.SedNumberType = value_
            self.SedNumberType_nsprefix_ = child_.prefix
            # validate type SEDNumberType
            self.validate_SEDNumberType(self.SedNumberType)
        elif nodeName_ == 'InvoiceNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InvoiceNumber')
            value_ = self.gds_validate_string(value_, node, 'InvoiceNumber')
            self.InvoiceNumber = value_
            self.InvoiceNumber_nsprefix_ = child_.prefix
            # validate type InvoiceNumber
            self.validate_InvoiceNumber(self.InvoiceNumber)
        elif nodeName_ == 'InvoiceDate':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.InvoiceDate = dval_
            self.InvoiceDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Remarks':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Remarks')
            value_ = self.gds_validate_string(value_, node, 'Remarks')
            self.Remarks = value_
            self.Remarks_nsprefix_ = child_.prefix
        elif nodeName_ == 'OtherCharges':
            obj_ = OtherCharges.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OtherCharges = obj_
            obj_.original_tagname_ = 'OtherCharges'
        elif nodeName_ == 'TermsOfPayment':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TermsOfPayment')
            value_ = self.gds_validate_string(value_, node, 'TermsOfPayment')
            self.TermsOfPayment = value_
            self.TermsOfPayment_nsprefix_ = child_.prefix
        elif nodeName_ == 'PayerGSTVAT':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PayerGSTVAT')
            value_ = self.gds_validate_string(value_, node, 'PayerGSTVAT')
            self.PayerGSTVAT = value_
            self.PayerGSTVAT_nsprefix_ = child_.prefix
        elif nodeName_ == 'SignatureImage':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'SignatureImage')
            else:
                bval_ = None
            self.SignatureImage = bval_
            self.SignatureImage_nsprefix_ = child_.prefix
            # validate type SignatureImage
            self.validate_SignatureImage(self.SignatureImage)
        elif nodeName_ == 'ReceiverReference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ReceiverReference')
            value_ = self.gds_validate_string(value_, node, 'ReceiverReference')
            self.ReceiverReference = value_
            self.ReceiverReference_nsprefix_ = child_.prefix
        elif nodeName_ == 'ExporterId':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ExporterId')
            value_ = self.gds_validate_string(value_, node, 'ExporterId')
            self.ExporterId = value_
            self.ExporterId_nsprefix_ = child_.prefix
        elif nodeName_ == 'ExporterCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ExporterCode')
            value_ = self.gds_validate_string(value_, node, 'ExporterCode')
            self.ExporterCode = value_
            self.ExporterCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'PackageMarks':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageMarks')
            value_ = self.gds_validate_string(value_, node, 'PackageMarks')
            self.PackageMarks = value_
            self.PackageMarks_nsprefix_ = child_.prefix
        elif nodeName_ == 'OtherRemarks2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OtherRemarks2')
            value_ = self.gds_validate_string(value_, node, 'OtherRemarks2')
            self.OtherRemarks2 = value_
            self.OtherRemarks2_nsprefix_ = child_.prefix
        elif nodeName_ == 'OtherRemarks3':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OtherRemarks3')
            value_ = self.gds_validate_string(value_, node, 'OtherRemarks3')
            self.OtherRemarks3 = value_
            self.OtherRemarks3_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankINN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankINN')
            value_ = self.gds_validate_string(value_, node, 'RUBankINN')
            self.RUBankINN = value_
            self.RUBankINN_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankKPP':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankKPP')
            value_ = self.gds_validate_string(value_, node, 'RUBankKPP')
            self.RUBankKPP = value_
            self.RUBankKPP_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankOKPO':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankOKPO')
            value_ = self.gds_validate_string(value_, node, 'RUBankOKPO')
            self.RUBankOKPO = value_
            self.RUBankOKPO_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankOGRN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankOGRN')
            value_ = self.gds_validate_string(value_, node, 'RUBankOGRN')
            self.RUBankOGRN = value_
            self.RUBankOGRN_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankSettlementAcctNumUSDEUR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankSettlementAcctNumUSDEUR')
            value_ = self.gds_validate_string(value_, node, 'RUBankSettlementAcctNumUSDEUR')
            self.RUBankSettlementAcctNumUSDEUR = value_
            self.RUBankSettlementAcctNumUSDEUR_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankSettlementAcctNumRUR':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankSettlementAcctNumRUR')
            value_ = self.gds_validate_string(value_, node, 'RUBankSettlementAcctNumRUR')
            self.RUBankSettlementAcctNumRUR = value_
            self.RUBankSettlementAcctNumRUR_nsprefix_ = child_.prefix
        elif nodeName_ == 'RUBankName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RUBankName')
            value_ = self.gds_validate_string(value_, node, 'RUBankName')
            self.RUBankName = value_
            self.RUBankName_nsprefix_ = child_.prefix
        elif nodeName_ == 'AddDeclText1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddDeclText1')
            value_ = self.gds_validate_string(value_, node, 'AddDeclText1')
            self.AddDeclText1 = value_
            self.AddDeclText1_nsprefix_ = child_.prefix
            # validate type AddDeclText1Type
            self.validate_AddDeclText1Type(self.AddDeclText1)
        elif nodeName_ == 'AddDeclText2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddDeclText2')
            value_ = self.gds_validate_string(value_, node, 'AddDeclText2')
            self.AddDeclText2 = value_
            self.AddDeclText2_nsprefix_ = child_.prefix
            # validate type AddDeclText
            self.validate_AddDeclText(self.AddDeclText2)
        elif nodeName_ == 'AddDeclText3':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddDeclText3')
            value_ = self.gds_validate_string(value_, node, 'AddDeclText3')
            self.AddDeclText3 = value_
            self.AddDeclText3_nsprefix_ = child_.prefix
            # validate type AddDeclText
            self.validate_AddDeclText(self.AddDeclText3)
        elif nodeName_ == 'ExportLineItem':
            obj_ = ExportLineItem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExportLineItem.append(obj_)
            obj_.original_tagname_ = 'ExportLineItem'
        elif nodeName_ == 'ShipmentDocument':
            obj_ = ShipmentDocument.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ShipmentDocument = obj_
            obj_.original_tagname_ = 'ShipmentDocument'
        elif nodeName_ == 'InvoiceInstructions':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InvoiceInstructions')
            value_ = self.gds_validate_string(value_, node, 'InvoiceInstructions')
            self.InvoiceInstructions = value_
            self.InvoiceInstructions_nsprefix_ = child_.prefix
            # validate type InvoiceInstructions
            self.validate_InvoiceInstructions(self.InvoiceInstructions)
        elif nodeName_ == 'CustomerDataTextEntries':
            obj_ = CustomerDataTextEntries.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomerDataTextEntries = obj_
            obj_.original_tagname_ = 'CustomerDataTextEntries'
        elif nodeName_ == 'PlaceOfIncoterm':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PlaceOfIncoterm')
            value_ = self.gds_validate_string(value_, node, 'PlaceOfIncoterm')
            self.PlaceOfIncoterm = value_
            self.PlaceOfIncoterm_nsprefix_ = child_.prefix
            # validate type PlaceOfIncoterm
            self.validate_PlaceOfIncoterm(self.PlaceOfIncoterm)
        elif nodeName_ == 'ShipmentPurpose':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'ShipmentPurpose')
            value_ = self.gds_validate_string(value_, node, 'ShipmentPurpose')
            self.ShipmentPurpose = value_
            self.ShipmentPurpose_nsprefix_ = child_.prefix
            # validate type ShipmentPurpose
            self.validate_ShipmentPurpose(self.ShipmentPurpose)
        elif nodeName_ == 'DocumentFunction':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'DocumentFunction')
            value_ = self.gds_validate_string(value_, node, 'DocumentFunction')
            self.DocumentFunction = value_
            self.DocumentFunction_nsprefix_ = child_.prefix
            # validate type DocumentFunction
            self.validate_DocumentFunction(self.DocumentFunction)
        elif nodeName_ == 'CustomsDocuments':
            obj_ = CustomsDocuments.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomsDocuments = obj_
            obj_.original_tagname_ = 'CustomsDocuments'
        elif nodeName_ == 'InvoiceTotalNetWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'InvoiceTotalNetWeight')
            fval_ = self.gds_validate_decimal(fval_, node, 'InvoiceTotalNetWeight')
            self.InvoiceTotalNetWeight = fval_
            self.InvoiceTotalNetWeight_nsprefix_ = child_.prefix
            # validate type Invoice_Weight
            self.validate_Invoice_Weight(self.InvoiceTotalNetWeight)
        elif nodeName_ == 'InvoiceTotalGrossWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'InvoiceTotalGrossWeight')
            fval_ = self.gds_validate_decimal(fval_, node, 'InvoiceTotalGrossWeight')
            self.InvoiceTotalGrossWeight = fval_
            self.InvoiceTotalGrossWeight_nsprefix_ = child_.prefix
            # validate type Invoice_Weight
            self.validate_Invoice_Weight(self.InvoiceTotalGrossWeight)
        elif nodeName_ == 'InvoiceReferences':
            obj_ = InvoiceReferences.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InvoiceReferences = obj_
            obj_.original_tagname_ = 'InvoiceReferences'
        elif nodeName_ == 'InvoiceIndicativeCustomsValues':
            obj_ = InvoiceIndicativeCustomsValues.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InvoiceIndicativeCustomsValues = obj_
            obj_.original_tagname_ = 'InvoiceIndicativeCustomsValues'
# end class ExportDeclaration


class OtherCharges(GeneratedsSuper):
    """OtherCharges -- Other Charges caption and its charges value details
    OtherCharge -- Other Charge caption and its charge value
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, OtherCharge=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if OtherCharge is None:
            self.OtherCharge = []
        else:
            self.OtherCharge = OtherCharge
        self.OtherCharge_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OtherCharges)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OtherCharges.subclass:
            return OtherCharges.subclass(*args_, **kwargs_)
        else:
            return OtherCharges(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_OtherCharge(self):
        return self.OtherCharge
    def set_OtherCharge(self, OtherCharge):
        self.OtherCharge = OtherCharge
    def add_OtherCharge(self, value):
        self.OtherCharge.append(value)
    def insert_OtherCharge_at(self, index, value):
        self.OtherCharge.insert(index, value)
    def replace_OtherCharge_at(self, index, value):
        self.OtherCharge[index] = value
    def _hasContent(self):
        if (
            self.OtherCharge
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OtherCharges', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OtherCharges')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OtherCharges':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OtherCharges')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OtherCharges', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OtherCharges'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OtherCharges', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for OtherCharge_ in self.OtherCharge:
            namespaceprefix_ = self.OtherCharge_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherCharge_nsprefix_) else ''
            OtherCharge_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OtherCharge', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OtherCharge':
            obj_ = OtherCharge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OtherCharge.append(obj_)
            obj_.original_tagname_ = 'OtherCharge'
# end class OtherCharges


class OtherCharge(GeneratedsSuper):
    """OtherCharge -- Other Charge caption and its charge value
    OtherChargeCaption -- Other Charges Caption
    OtherChargeValue -- Other Charges Value
    OtherChargeType -- Charge Type: Other Charges, Freight Cost, Insurance Cost, etc Other Charges Type
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, OtherChargeCaption=None, OtherChargeValue=None, OtherChargeType=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.OtherChargeCaption = OtherChargeCaption
        self.validate_OtherChargeCaption(self.OtherChargeCaption)
        self.OtherChargeCaption_nsprefix_ = None
        self.OtherChargeValue = OtherChargeValue
        self.validate_OtherChargeValue(self.OtherChargeValue)
        self.OtherChargeValue_nsprefix_ = None
        self.OtherChargeType = OtherChargeType
        self.validate_OtherChargeType(self.OtherChargeType)
        self.OtherChargeType_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OtherCharge)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OtherCharge.subclass:
            return OtherCharge.subclass(*args_, **kwargs_)
        else:
            return OtherCharge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_OtherChargeCaption(self):
        return self.OtherChargeCaption
    def set_OtherChargeCaption(self, OtherChargeCaption):
        self.OtherChargeCaption = OtherChargeCaption
    def get_OtherChargeValue(self):
        return self.OtherChargeValue
    def set_OtherChargeValue(self, OtherChargeValue):
        self.OtherChargeValue = OtherChargeValue
    def get_OtherChargeType(self):
        return self.OtherChargeType
    def set_OtherChargeType(self, OtherChargeType):
        self.OtherChargeType = OtherChargeType
    def validate_OtherChargeCaption(self, value):
        result = True
        # Validate type OtherChargeCaption, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def validate_OtherChargeValue(self, value):
        result = True
        # Validate type OtherChargeValue, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on OtherChargeValue' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_OtherChargeType(self, value):
        result = True
        # Validate type OtherChargeType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 5:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on OtherChargeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 5:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on OtherChargeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.OtherChargeCaption is not None or
            self.OtherChargeValue is not None or
            self.OtherChargeType is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OtherCharge', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OtherCharge')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OtherCharge':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OtherCharge')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OtherCharge', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OtherCharge'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OtherCharge', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.OtherChargeCaption is not None:
            namespaceprefix_ = self.OtherChargeCaption_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherChargeCaption_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOtherChargeCaption>%s</%sOtherChargeCaption>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OtherChargeCaption), input_name='OtherChargeCaption')), namespaceprefix_ , eol_))
        if self.OtherChargeValue is not None:
            namespaceprefix_ = self.OtherChargeValue_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherChargeValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOtherChargeValue>%s</%sOtherChargeValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.OtherChargeValue, input_name='OtherChargeValue'), namespaceprefix_ , eol_))
        if self.OtherChargeType is not None:
            namespaceprefix_ = self.OtherChargeType_nsprefix_ + ':' if (UseCapturedNS_ and self.OtherChargeType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOtherChargeType>%s</%sOtherChargeType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OtherChargeType), input_name='OtherChargeType')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OtherChargeCaption':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OtherChargeCaption')
            value_ = self.gds_validate_string(value_, node, 'OtherChargeCaption')
            self.OtherChargeCaption = value_
            self.OtherChargeCaption_nsprefix_ = child_.prefix
            # validate type OtherChargeCaption
            self.validate_OtherChargeCaption(self.OtherChargeCaption)
        elif nodeName_ == 'OtherChargeValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'OtherChargeValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'OtherChargeValue')
            self.OtherChargeValue = fval_
            self.OtherChargeValue_nsprefix_ = child_.prefix
            # validate type OtherChargeValue
            self.validate_OtherChargeValue(self.OtherChargeValue)
        elif nodeName_ == 'OtherChargeType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OtherChargeType')
            value_ = self.gds_validate_string(value_, node, 'OtherChargeType')
            self.OtherChargeType = value_
            self.OtherChargeType_nsprefix_ = child_.prefix
            # validate type OtherChargeType
            self.validate_OtherChargeType(self.OtherChargeType)
# end class OtherCharge


class ExportLineItem(GeneratedsSuper):
    """ExportLineItem -- Specifics about each of the line item
    LineNumber -- The LineNumber element contains the unique serial number for particular item.It
    ’
    s value should not be more than 999. It is a mandatory field
    Quantity -- The Quantity element contains the number of pieces in the line item.It is a mandatory field
    QuantityUnit -- This element contains the measurement unit for quantity.It is a mandatory field
    Description -- This element contains the description of the line item. It is a mandatory field. The maximum length is 75 characters
    Value -- This element identifies the value in money levied for each quantity of the particular line item. It is a mandatory field. Note: Total value of the all quantity per each line item will be calculated automatically by backend system
    IsDomestic -- The IsDomestic element indicates whether shipment is domestic or not. The valid vaues are Y (Yes) and N (No)
    CommodityCode -- The CommodityCode element contains commodity code for shipment contents. Its value should lie in between 2 to 18 characters of string. This field is optional
    ScheduleB -- The ScheduleB element contains the schedule B number.It is an optional field
    ECCN -- This element contains ECCN info
    Weight -- This element contains information about weight of the line item.It is an optional field
    GrossWeight -- This element contains information about gross weight of the line item. It is an mandatory field
    License -- This element contains the shipper export licence information of the paticular item.It is an optional field
    LicenseSymbol -- License excption symbol
    ManufactureCountryCode -- This element allows user to capture Country/Region of Manufacture in Invoice Line item.  It is a conditional field and required for dutiable shipment
    ManufactureCountryName -- This element allows user to capture Country/Region Name of Manufacture in Invoice Line item.  It is a conditional field  and required for dutiable shipment
    AdditionalInformation -- This element allows user to indicates if import tax managed outside or DHL Express. This is an optional field.
    ImportCommodityCode -- Inbound Commodity Classification
    ItemReferences -- This element contain Item References details. This is an optional field.
    CustomsPaperworks -- This element contain Customs Paperworks details. This is an optional field.
    TaxesPaid -- This element allows user to indicates if taxes has been paid, created to replace ImportTaxManagedOutsideDhlExpress. This is an optional field.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, LineNumber=None, Quantity=None, QuantityUnit=None, Description=None, Value=None, IsDomestic=None, CommodityCode=None, ScheduleB=None, ECCN=None, Weight=None, GrossWeight=None, License=None, LicenseSymbol=None, ManufactureCountryCode=None, ManufactureCountryName=None, AdditionalInformation=None, ImportCommodityCode=None, ItemReferences=None, CustomsPaperworks=None, TaxesPaid=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.LineNumber = LineNumber
        self.validate_LineNumber(self.LineNumber)
        self.LineNumber_nsprefix_ = None
        self.Quantity = Quantity
        self.validate_Quantity(self.Quantity)
        self.Quantity_nsprefix_ = None
        self.QuantityUnit = QuantityUnit
        self.validate_QuantityUnit(self.QuantityUnit)
        self.QuantityUnit_nsprefix_ = None
        self.Description = Description
        self.validate_DescriptionType(self.Description)
        self.Description_nsprefix_ = None
        self.Value = Value
        self.validate_ValueType(self.Value)
        self.Value_nsprefix_ = None
        self.IsDomestic = IsDomestic
        self.validate_YesNo(self.IsDomestic)
        self.IsDomestic_nsprefix_ = None
        self.CommodityCode = CommodityCode
        self.validate_CommodityCode(self.CommodityCode)
        self.CommodityCode_nsprefix_ = None
        self.ScheduleB = ScheduleB
        self.validate_ScheduleB(self.ScheduleB)
        self.ScheduleB_nsprefix_ = None
        self.ECCN = ECCN
        self.validate_ECCNType1(self.ECCN)
        self.ECCN_nsprefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.GrossWeight = GrossWeight
        self.GrossWeight_nsprefix_ = None
        self.License = License
        self.License_nsprefix_ = None
        self.LicenseSymbol = LicenseSymbol
        self.validate_LicenseNumber(self.LicenseSymbol)
        self.LicenseSymbol_nsprefix_ = None
        self.ManufactureCountryCode = ManufactureCountryCode
        self.validate_CountryCode(self.ManufactureCountryCode)
        self.ManufactureCountryCode_nsprefix_ = None
        self.ManufactureCountryName = ManufactureCountryName
        self.validate_CountryName(self.ManufactureCountryName)
        self.ManufactureCountryName_nsprefix_ = None
        self.AdditionalInformation = AdditionalInformation
        self.AdditionalInformation_nsprefix_ = None
        self.ImportCommodityCode = ImportCommodityCode
        self.validate_CommodityCode(self.ImportCommodityCode)
        self.ImportCommodityCode_nsprefix_ = None
        self.ItemReferences = ItemReferences
        self.ItemReferences_nsprefix_ = None
        self.CustomsPaperworks = CustomsPaperworks
        self.CustomsPaperworks_nsprefix_ = None
        self.TaxesPaid = TaxesPaid
        self.validate_TaxesPaid(self.TaxesPaid)
        self.TaxesPaid_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExportLineItem)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExportLineItem.subclass:
            return ExportLineItem.subclass(*args_, **kwargs_)
        else:
            return ExportLineItem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_LineNumber(self):
        return self.LineNumber
    def set_LineNumber(self, LineNumber):
        self.LineNumber = LineNumber
    def get_Quantity(self):
        return self.Quantity
    def set_Quantity(self, Quantity):
        self.Quantity = Quantity
    def get_QuantityUnit(self):
        return self.QuantityUnit
    def set_QuantityUnit(self, QuantityUnit):
        self.QuantityUnit = QuantityUnit
    def get_Description(self):
        return self.Description
    def set_Description(self, Description):
        self.Description = Description
    def get_Value(self):
        return self.Value
    def set_Value(self, Value):
        self.Value = Value
    def get_IsDomestic(self):
        return self.IsDomestic
    def set_IsDomestic(self, IsDomestic):
        self.IsDomestic = IsDomestic
    def get_CommodityCode(self):
        return self.CommodityCode
    def set_CommodityCode(self, CommodityCode):
        self.CommodityCode = CommodityCode
    def get_ScheduleB(self):
        return self.ScheduleB
    def set_ScheduleB(self, ScheduleB):
        self.ScheduleB = ScheduleB
    def get_ECCN(self):
        return self.ECCN
    def set_ECCN(self, ECCN):
        self.ECCN = ECCN
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_GrossWeight(self):
        return self.GrossWeight
    def set_GrossWeight(self, GrossWeight):
        self.GrossWeight = GrossWeight
    def get_License(self):
        return self.License
    def set_License(self, License):
        self.License = License
    def get_LicenseSymbol(self):
        return self.LicenseSymbol
    def set_LicenseSymbol(self, LicenseSymbol):
        self.LicenseSymbol = LicenseSymbol
    def get_ManufactureCountryCode(self):
        return self.ManufactureCountryCode
    def set_ManufactureCountryCode(self, ManufactureCountryCode):
        self.ManufactureCountryCode = ManufactureCountryCode
    def get_ManufactureCountryName(self):
        return self.ManufactureCountryName
    def set_ManufactureCountryName(self, ManufactureCountryName):
        self.ManufactureCountryName = ManufactureCountryName
    def get_AdditionalInformation(self):
        return self.AdditionalInformation
    def set_AdditionalInformation(self, AdditionalInformation):
        self.AdditionalInformation = AdditionalInformation
    def get_ImportCommodityCode(self):
        return self.ImportCommodityCode
    def set_ImportCommodityCode(self, ImportCommodityCode):
        self.ImportCommodityCode = ImportCommodityCode
    def get_ItemReferences(self):
        return self.ItemReferences
    def set_ItemReferences(self, ItemReferences):
        self.ItemReferences = ItemReferences
    def get_CustomsPaperworks(self):
        return self.CustomsPaperworks
    def set_CustomsPaperworks(self, CustomsPaperworks):
        self.CustomsPaperworks = CustomsPaperworks
    def get_TaxesPaid(self):
        return self.TaxesPaid
    def set_TaxesPaid(self, TaxesPaid):
        self.TaxesPaid = TaxesPaid
    def validate_LineNumber(self, value):
        result = True
        # Validate type LineNumber, a restriction on xsd:positiveInteger.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value, "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on LineNumber' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on LineNumber' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_Quantity(self, value):
        result = True
        # Validate type Quantity, a restriction on xsd:positiveInteger.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def validate_QuantityUnit(self, value):
        result = True
        # Validate type QuantityUnit, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 8:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on QuantityUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DescriptionType(self, value):
        result = True
        # Validate type DescriptionType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 512:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on DescriptionType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on DescriptionType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ValueType(self, value):
        result = True
        # Validate type ValueType, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ValueType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ValueType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_YesNo(self, value):
        result = True
        # Validate type YesNo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on YesNo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on YesNo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CommodityCode(self, value):
        result = True
        # Validate type CommodityCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CommodityCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CommodityCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ScheduleB(self, value):
        result = True
        # Validate type ScheduleB, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ScheduleB' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ECCNType1(self, value):
        result = True
        # Validate type ECCNType1, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ECCNType1' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ECCNType1' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_LicenseNumber(self, value):
        result = True
        # Validate type LicenseNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 16:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on LicenseNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryCode(self, value):
        result = True
        # Validate type CountryCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CountryCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryName(self, value):
        result = True
        # Validate type CountryName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CountryName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_TaxesPaid(self, value):
        result = True
        # Validate type TaxesPaid, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TaxesPaid' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.LineNumber is not None or
            self.Quantity is not None or
            self.QuantityUnit is not None or
            self.Description is not None or
            self.Value is not None or
            self.IsDomestic is not None or
            self.CommodityCode is not None or
            self.ScheduleB is not None or
            self.ECCN is not None or
            self.Weight is not None or
            self.GrossWeight is not None or
            self.License is not None or
            self.LicenseSymbol is not None or
            self.ManufactureCountryCode is not None or
            self.ManufactureCountryName is not None or
            self.AdditionalInformation is not None or
            self.ImportCommodityCode is not None or
            self.ItemReferences is not None or
            self.CustomsPaperworks is not None or
            self.TaxesPaid is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportLineItem', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExportLineItem')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExportLineItem':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExportLineItem')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExportLineItem', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ExportLineItem'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExportLineItem', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LineNumber is not None:
            namespaceprefix_ = self.LineNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.LineNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLineNumber>%s</%sLineNumber>%s' % (namespaceprefix_ , self.gds_format_integer(self.LineNumber, input_name='LineNumber'), namespaceprefix_ , eol_))
        if self.Quantity is not None:
            namespaceprefix_ = self.Quantity_nsprefix_ + ':' if (UseCapturedNS_ and self.Quantity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sQuantity>%s</%sQuantity>%s' % (namespaceprefix_ , self.gds_format_integer(self.Quantity, input_name='Quantity'), namespaceprefix_ , eol_))
        if self.QuantityUnit is not None:
            namespaceprefix_ = self.QuantityUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.QuantityUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sQuantityUnit>%s</%sQuantityUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.QuantityUnit), input_name='QuantityUnit')), namespaceprefix_ , eol_))
        if self.Description is not None:
            namespaceprefix_ = self.Description_nsprefix_ + ':' if (UseCapturedNS_ and self.Description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Description), input_name='Description')), namespaceprefix_ , eol_))
        if self.Value is not None:
            namespaceprefix_ = self.Value_nsprefix_ + ':' if (UseCapturedNS_ and self.Value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sValue>%s</%sValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Value, input_name='Value'), namespaceprefix_ , eol_))
        if self.IsDomestic is not None:
            namespaceprefix_ = self.IsDomestic_nsprefix_ + ':' if (UseCapturedNS_ and self.IsDomestic_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsDomestic>%s</%sIsDomestic>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IsDomestic), input_name='IsDomestic')), namespaceprefix_ , eol_))
        if self.CommodityCode is not None:
            namespaceprefix_ = self.CommodityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CommodityCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommodityCode>%s</%sCommodityCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CommodityCode), input_name='CommodityCode')), namespaceprefix_ , eol_))
        if self.ScheduleB is not None:
            namespaceprefix_ = self.ScheduleB_nsprefix_ + ':' if (UseCapturedNS_ and self.ScheduleB_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sScheduleB>%s</%sScheduleB>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ScheduleB), input_name='ScheduleB')), namespaceprefix_ , eol_))
        if self.ECCN is not None:
            namespaceprefix_ = self.ECCN_nsprefix_ + ':' if (UseCapturedNS_ and self.ECCN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sECCN>%s</%sECCN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ECCN), input_name='ECCN')), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            self.Weight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Weight', pretty_print=pretty_print)
        if self.GrossWeight is not None:
            namespaceprefix_ = self.GrossWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.GrossWeight_nsprefix_) else ''
            self.GrossWeight.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GrossWeight', pretty_print=pretty_print)
        if self.License is not None:
            namespaceprefix_ = self.License_nsprefix_ + ':' if (UseCapturedNS_ and self.License_nsprefix_) else ''
            self.License.export(outfile, level, namespaceprefix_, namespacedef_='', name_='License', pretty_print=pretty_print)
        if self.LicenseSymbol is not None:
            namespaceprefix_ = self.LicenseSymbol_nsprefix_ + ':' if (UseCapturedNS_ and self.LicenseSymbol_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLicenseSymbol>%s</%sLicenseSymbol>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.LicenseSymbol), input_name='LicenseSymbol')), namespaceprefix_ , eol_))
        if self.ManufactureCountryCode is not None:
            namespaceprefix_ = self.ManufactureCountryCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ManufactureCountryCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManufactureCountryCode>%s</%sManufactureCountryCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManufactureCountryCode), input_name='ManufactureCountryCode')), namespaceprefix_ , eol_))
        if self.ManufactureCountryName is not None:
            namespaceprefix_ = self.ManufactureCountryName_nsprefix_ + ':' if (UseCapturedNS_ and self.ManufactureCountryName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManufactureCountryName>%s</%sManufactureCountryName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManufactureCountryName), input_name='ManufactureCountryName')), namespaceprefix_ , eol_))
        if self.AdditionalInformation is not None:
            namespaceprefix_ = self.AdditionalInformation_nsprefix_ + ':' if (UseCapturedNS_ and self.AdditionalInformation_nsprefix_) else ''
            self.AdditionalInformation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdditionalInformation', pretty_print=pretty_print)
        if self.ImportCommodityCode is not None:
            namespaceprefix_ = self.ImportCommodityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ImportCommodityCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImportCommodityCode>%s</%sImportCommodityCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ImportCommodityCode), input_name='ImportCommodityCode')), namespaceprefix_ , eol_))
        if self.ItemReferences is not None:
            namespaceprefix_ = self.ItemReferences_nsprefix_ + ':' if (UseCapturedNS_ and self.ItemReferences_nsprefix_) else ''
            self.ItemReferences.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ItemReferences', pretty_print=pretty_print)
        if self.CustomsPaperworks is not None:
            namespaceprefix_ = self.CustomsPaperworks_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsPaperworks_nsprefix_) else ''
            self.CustomsPaperworks.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomsPaperworks', pretty_print=pretty_print)
        if self.TaxesPaid is not None:
            namespaceprefix_ = self.TaxesPaid_nsprefix_ + ':' if (UseCapturedNS_ and self.TaxesPaid_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTaxesPaid>%s</%sTaxesPaid>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TaxesPaid), input_name='TaxesPaid')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LineNumber' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'LineNumber')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'LineNumber')
            self.LineNumber = ival_
            self.LineNumber_nsprefix_ = child_.prefix
            # validate type LineNumber
            self.validate_LineNumber(self.LineNumber)
        elif nodeName_ == 'Quantity' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'Quantity')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'Quantity')
            self.Quantity = ival_
            self.Quantity_nsprefix_ = child_.prefix
            # validate type Quantity
            self.validate_Quantity(self.Quantity)
        elif nodeName_ == 'QuantityUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'QuantityUnit')
            value_ = self.gds_validate_string(value_, node, 'QuantityUnit')
            self.QuantityUnit = value_
            self.QuantityUnit_nsprefix_ = child_.prefix
            # validate type QuantityUnit
            self.validate_QuantityUnit(self.QuantityUnit)
        elif nodeName_ == 'Description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Description')
            value_ = self.gds_validate_string(value_, node, 'Description')
            self.Description = value_
            self.Description_nsprefix_ = child_.prefix
            # validate type DescriptionType
            self.validate_DescriptionType(self.Description)
        elif nodeName_ == 'Value' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Value')
            fval_ = self.gds_validate_decimal(fval_, node, 'Value')
            self.Value = fval_
            self.Value_nsprefix_ = child_.prefix
            # validate type ValueType
            self.validate_ValueType(self.Value)
        elif nodeName_ == 'IsDomestic':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IsDomestic')
            value_ = self.gds_validate_string(value_, node, 'IsDomestic')
            self.IsDomestic = value_
            self.IsDomestic_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.IsDomestic)
        elif nodeName_ == 'CommodityCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CommodityCode')
            value_ = self.gds_validate_string(value_, node, 'CommodityCode')
            self.CommodityCode = value_
            self.CommodityCode_nsprefix_ = child_.prefix
            # validate type CommodityCode
            self.validate_CommodityCode(self.CommodityCode)
        elif nodeName_ == 'ScheduleB':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ScheduleB')
            value_ = self.gds_validate_string(value_, node, 'ScheduleB')
            self.ScheduleB = value_
            self.ScheduleB_nsprefix_ = child_.prefix
            # validate type ScheduleB
            self.validate_ScheduleB(self.ScheduleB)
        elif nodeName_ == 'ECCN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ECCN')
            value_ = self.gds_validate_string(value_, node, 'ECCN')
            self.ECCN = value_
            self.ECCN_nsprefix_ = child_.prefix
            # validate type ECCNType1
            self.validate_ECCNType1(self.ECCN)
        elif nodeName_ == 'Weight':
            obj_ = WeightType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Weight = obj_
            obj_.original_tagname_ = 'Weight'
        elif nodeName_ == 'GrossWeight':
            obj_ = GrossWeightType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GrossWeight = obj_
            obj_.original_tagname_ = 'GrossWeight'
        elif nodeName_ == 'License':
            obj_ = LicenseType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.License = obj_
            obj_.original_tagname_ = 'License'
        elif nodeName_ == 'LicenseSymbol':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LicenseSymbol')
            value_ = self.gds_validate_string(value_, node, 'LicenseSymbol')
            self.LicenseSymbol = value_
            self.LicenseSymbol_nsprefix_ = child_.prefix
            # validate type LicenseNumber
            self.validate_LicenseNumber(self.LicenseSymbol)
        elif nodeName_ == 'ManufactureCountryCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManufactureCountryCode')
            value_ = self.gds_validate_string(value_, node, 'ManufactureCountryCode')
            self.ManufactureCountryCode = value_
            self.ManufactureCountryCode_nsprefix_ = child_.prefix
            # validate type CountryCode
            self.validate_CountryCode(self.ManufactureCountryCode)
        elif nodeName_ == 'ManufactureCountryName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManufactureCountryName')
            value_ = self.gds_validate_string(value_, node, 'ManufactureCountryName')
            self.ManufactureCountryName = value_
            self.ManufactureCountryName_nsprefix_ = child_.prefix
            # validate type CountryName
            self.validate_CountryName(self.ManufactureCountryName)
        elif nodeName_ == 'AdditionalInformation':
            obj_ = AdditionalInformationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdditionalInformation = obj_
            obj_.original_tagname_ = 'AdditionalInformation'
        elif nodeName_ == 'ImportCommodityCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ImportCommodityCode')
            value_ = self.gds_validate_string(value_, node, 'ImportCommodityCode')
            self.ImportCommodityCode = value_
            self.ImportCommodityCode_nsprefix_ = child_.prefix
            # validate type CommodityCode
            self.validate_CommodityCode(self.ImportCommodityCode)
        elif nodeName_ == 'ItemReferences':
            obj_ = ItemReferences.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ItemReferences = obj_
            obj_.original_tagname_ = 'ItemReferences'
        elif nodeName_ == 'CustomsPaperworks':
            obj_ = CustomsPaperworks.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomsPaperworks = obj_
            obj_.original_tagname_ = 'CustomsPaperworks'
        elif nodeName_ == 'TaxesPaid':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TaxesPaid')
            value_ = self.gds_validate_string(value_, node, 'TaxesPaid')
            self.TaxesPaid = value_
            self.TaxesPaid_nsprefix_ = child_.prefix
            # validate type TaxesPaid
            self.validate_TaxesPaid(self.TaxesPaid)
# end class ExportLineItem


class AdditionalInformationType(GeneratedsSuper):
    """AdditionalInformationType -- Additional Informations for export line item
    AdditionalInformationText -- Declaration text
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AdditionalInformationText=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if AdditionalInformationText is None:
            self.AdditionalInformationText = []
        else:
            self.AdditionalInformationText = AdditionalInformationText
        self.AdditionalInformationText_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AdditionalInformationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AdditionalInformationType.subclass:
            return AdditionalInformationType.subclass(*args_, **kwargs_)
        else:
            return AdditionalInformationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AdditionalInformationText(self):
        return self.AdditionalInformationText
    def set_AdditionalInformationText(self, AdditionalInformationText):
        self.AdditionalInformationText = AdditionalInformationText
    def add_AdditionalInformationText(self, value):
        self.AdditionalInformationText.append(value)
    def insert_AdditionalInformationText_at(self, index, value):
        self.AdditionalInformationText.insert(index, value)
    def replace_AdditionalInformationText_at(self, index, value):
        self.AdditionalInformationText[index] = value
    def validate_AdditionalInformationText(self, value):
        result = True
        # Validate type AdditionalInformationText, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def _hasContent(self):
        if (
            self.AdditionalInformationText
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AdditionalInformationType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AdditionalInformationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AdditionalInformationType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AdditionalInformationType')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AdditionalInformationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AdditionalInformationType'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AdditionalInformationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for AdditionalInformationText_ in self.AdditionalInformationText:
            namespaceprefix_ = self.AdditionalInformationText_nsprefix_ + ':' if (UseCapturedNS_ and self.AdditionalInformationText_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAdditionalInformationText>%s</%sAdditionalInformationText>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(AdditionalInformationText_), input_name='AdditionalInformationText')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AdditionalInformationText':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AdditionalInformationText')
            value_ = self.gds_validate_string(value_, node, 'AdditionalInformationText')
            self.AdditionalInformationText.append(value_)
            self.AdditionalInformationText_nsprefix_ = child_.prefix
            # validate type AdditionalInformationText
            self.validate_AdditionalInformationText(self.AdditionalInformationText[-1])
# end class AdditionalInformationType


class ItemReferences(GeneratedsSuper):
    """ItemReferences -- Export Declaration Line Item's References
    ItemReference -- Customs Invoice Reference entry
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ItemReference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ItemReference is None:
            self.ItemReference = []
        else:
            self.ItemReference = ItemReference
        self.ItemReference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ItemReferences)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ItemReferences.subclass:
            return ItemReferences.subclass(*args_, **kwargs_)
        else:
            return ItemReferences(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ItemReference(self):
        return self.ItemReference
    def set_ItemReference(self, ItemReference):
        self.ItemReference = ItemReference
    def add_ItemReference(self, value):
        self.ItemReference.append(value)
    def insert_ItemReference_at(self, index, value):
        self.ItemReference.insert(index, value)
    def replace_ItemReference_at(self, index, value):
        self.ItemReference[index] = value
    def _hasContent(self):
        if (
            self.ItemReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ItemReferences', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ItemReferences')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ItemReferences':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ItemReferences')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ItemReferences', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ItemReferences'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ItemReferences', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ItemReference_ in self.ItemReference:
            namespaceprefix_ = self.ItemReference_nsprefix_ + ':' if (UseCapturedNS_ and self.ItemReference_nsprefix_) else ''
            ItemReference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ItemReference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ItemReference':
            obj_ = ItemReference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ItemReference.append(obj_)
            obj_.original_tagname_ = 'ItemReference'
# end class ItemReferences


class ItemReference(GeneratedsSuper):
    """ItemReference -- Customs Invoice Reference entry
    ItemReferenceType -- Export Declaration line items's Reference Type
    (AFE:ECCN,BRD:Brand,DGC:Dangerous Goods Content Identifier,DO:Delivery Order number,ECN:Export Clearance Number,
    INB:In Bond shipment,MAK:Make,MDL:Model,PAN:Movement Reference number,PON:Movement Reference number,
    SKU:Movement Reference number,SNO:Movement Reference number,SON:Movement Reference number),AAM: AWB Ref #
    ItemReferenceNumber -- Export Declaration line items's Reference Number
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ItemReferenceType=None, ItemReferenceNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ItemReferenceType = ItemReferenceType
        self.validate_ItemReferenceType(self.ItemReferenceType)
        self.ItemReferenceType_nsprefix_ = None
        self.ItemReferenceNumber = ItemReferenceNumber
        self.validate_ItemReferenceNumber(self.ItemReferenceNumber)
        self.ItemReferenceNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ItemReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ItemReference.subclass:
            return ItemReference.subclass(*args_, **kwargs_)
        else:
            return ItemReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ItemReferenceType(self):
        return self.ItemReferenceType
    def set_ItemReferenceType(self, ItemReferenceType):
        self.ItemReferenceType = ItemReferenceType
    def get_ItemReferenceNumber(self):
        return self.ItemReferenceNumber
    def set_ItemReferenceNumber(self, ItemReferenceNumber):
        self.ItemReferenceNumber = ItemReferenceNumber
    def validate_ItemReferenceType(self, value):
        result = True
        # Validate type ItemReferenceType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ItemReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ItemReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ItemReferenceNumber(self, value):
        result = True
        # Validate type ItemReferenceNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ItemReferenceNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ItemReferenceType is not None or
            self.ItemReferenceNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ItemReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ItemReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ItemReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ItemReference')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ItemReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ItemReference'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ItemReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ItemReferenceType is not None:
            namespaceprefix_ = self.ItemReferenceType_nsprefix_ + ':' if (UseCapturedNS_ and self.ItemReferenceType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sItemReferenceType>%s</%sItemReferenceType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ItemReferenceType), input_name='ItemReferenceType')), namespaceprefix_ , eol_))
        if self.ItemReferenceNumber is not None:
            namespaceprefix_ = self.ItemReferenceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ItemReferenceNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sItemReferenceNumber>%s</%sItemReferenceNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ItemReferenceNumber), input_name='ItemReferenceNumber')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ItemReferenceType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ItemReferenceType')
            value_ = self.gds_validate_string(value_, node, 'ItemReferenceType')
            self.ItemReferenceType = value_
            self.ItemReferenceType_nsprefix_ = child_.prefix
            # validate type ItemReferenceType
            self.validate_ItemReferenceType(self.ItemReferenceType)
        elif nodeName_ == 'ItemReferenceNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ItemReferenceNumber')
            value_ = self.gds_validate_string(value_, node, 'ItemReferenceNumber')
            self.ItemReferenceNumber = value_
            self.ItemReferenceNumber_nsprefix_ = child_.prefix
            # validate type ItemReferenceNumber
            self.validate_ItemReferenceNumber(self.ItemReferenceNumber)
# end class ItemReference


class CustomsPaperworks(GeneratedsSuper):
    """CustomsPaperworks -- Export Declaration Line Item's Customs Paperworks
    CustomsPaperwork -- Customs Invoice Reference entry
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomsPaperwork=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CustomsPaperwork is None:
            self.CustomsPaperwork = []
        else:
            self.CustomsPaperwork = CustomsPaperwork
        self.CustomsPaperwork_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomsPaperworks)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsPaperworks.subclass:
            return CustomsPaperworks.subclass(*args_, **kwargs_)
        else:
            return CustomsPaperworks(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomsPaperwork(self):
        return self.CustomsPaperwork
    def set_CustomsPaperwork(self, CustomsPaperwork):
        self.CustomsPaperwork = CustomsPaperwork
    def add_CustomsPaperwork(self, value):
        self.CustomsPaperwork.append(value)
    def insert_CustomsPaperwork_at(self, index, value):
        self.CustomsPaperwork.insert(index, value)
    def replace_CustomsPaperwork_at(self, index, value):
        self.CustomsPaperwork[index] = value
    def _hasContent(self):
        if (
            self.CustomsPaperwork
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsPaperworks', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomsPaperworks')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomsPaperworks':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomsPaperworks')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomsPaperworks', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomsPaperworks'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsPaperworks', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CustomsPaperwork_ in self.CustomsPaperwork:
            namespaceprefix_ = self.CustomsPaperwork_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsPaperwork_nsprefix_) else ''
            CustomsPaperwork_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomsPaperwork', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomsPaperwork':
            obj_ = CustomsPaperwork.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomsPaperwork.append(obj_)
            obj_.original_tagname_ = 'CustomsPaperwork'
# end class CustomsPaperworks


class CustomsPaperwork(GeneratedsSuper):
    """CustomsPaperwork -- Customs Invoice Reference entry
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomsPaperworkType=None, CustomsPaperworkID=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CustomsPaperworkType = CustomsPaperworkType
        self.validate_CustomsPaperworkType(self.CustomsPaperworkType)
        self.CustomsPaperworkType_nsprefix_ = None
        self.CustomsPaperworkID = CustomsPaperworkID
        self.validate_CustomsPaperworkID(self.CustomsPaperworkID)
        self.CustomsPaperworkID_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomsPaperwork)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsPaperwork.subclass:
            return CustomsPaperwork.subclass(*args_, **kwargs_)
        else:
            return CustomsPaperwork(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomsPaperworkType(self):
        return self.CustomsPaperworkType
    def set_CustomsPaperworkType(self, CustomsPaperworkType):
        self.CustomsPaperworkType = CustomsPaperworkType
    def get_CustomsPaperworkID(self):
        return self.CustomsPaperworkID
    def set_CustomsPaperworkID(self, CustomsPaperworkID):
        self.CustomsPaperworkID = CustomsPaperworkID
    def validate_CustomsPaperworkType(self, value):
        result = True
        # Validate type CustomsPaperworkType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomsPaperworkType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CustomsPaperworkType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CustomsPaperworkID(self, value):
        result = True
        # Validate type CustomsPaperworkID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomsPaperworkID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CustomsPaperworkType is not None or
            self.CustomsPaperworkID is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsPaperwork', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomsPaperwork')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomsPaperwork':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomsPaperwork')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomsPaperwork', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomsPaperwork'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsPaperwork', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CustomsPaperworkType is not None:
            namespaceprefix_ = self.CustomsPaperworkType_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsPaperworkType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomsPaperworkType>%s</%sCustomsPaperworkType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomsPaperworkType), input_name='CustomsPaperworkType')), namespaceprefix_ , eol_))
        if self.CustomsPaperworkID is not None:
            namespaceprefix_ = self.CustomsPaperworkID_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsPaperworkID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomsPaperworkID>%s</%sCustomsPaperworkID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomsPaperworkID), input_name='CustomsPaperworkID')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomsPaperworkType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomsPaperworkType')
            value_ = self.gds_validate_string(value_, node, 'CustomsPaperworkType')
            self.CustomsPaperworkType = value_
            self.CustomsPaperworkType_nsprefix_ = child_.prefix
            # validate type CustomsPaperworkType
            self.validate_CustomsPaperworkType(self.CustomsPaperworkType)
        elif nodeName_ == 'CustomsPaperworkID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomsPaperworkID')
            value_ = self.gds_validate_string(value_, node, 'CustomsPaperworkID')
            self.CustomsPaperworkID = value_
            self.CustomsPaperworkID_nsprefix_ = child_.prefix
            # validate type CustomsPaperworkID
            self.validate_CustomsPaperworkID(self.CustomsPaperworkID)
# end class CustomsPaperwork


class Piece(GeneratedsSuper):
    """Piece -- Element encapsulating pieces information
    PieceID -- The PieceID element contains the piece number of each piece for this shipment. It is an optional field in the Piece segment.Its value should not be more than 35 characters
    PackageType -- The PackageType element contains the unique ID of the piece for this shipment. It is an optional field in the Piece segment
    Weight -- The Weight element represents the weight of the individual piece or of the shipment. It is an mandatory field in the Piece segment
    Width -- Required if height and depth are specified
    Height -- Required if width and depth are specified
    Depth -- Required if width and height are specified
    PieceContents -- The piece contents element represents the contents or description of the piece of the shipment. It is an optional field in the Piece segment
    PieceReference -- This element identifies the reference information. It is an optional field
    AdditionalInformation -- This element identifies the Additional Information. It is an optional field
    ParentPieceIdentificationNumber -- This element identifies the Parent Shipment Piece ID. It is an optional field
    PieceIdentificationNumber -- This element identifies the Piece ID if UswOwnPieceIdentificationNumber is Y. It is an optional field
    UseOwnPieceIdentificationNumber -- Customer able to provide PID if set to Y. The
    default is N
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceID=None, PackageType=None, Weight=None, Width=None, Height=None, Depth=None, PieceContents=None, PieceReference=None, AdditionalInformation=None, ParentPieceIdentificationNumber=None, PieceIdentificationNumber=None, UseOwnPieceIdentificationNumber='N', PieceIdentificationNumberDataIdentifier=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PieceID = PieceID
        self.validate_PieceID(self.PieceID)
        self.PieceID_nsprefix_ = None
        self.PackageType = PackageType
        self.validate_PackageType(self.PackageType)
        self.PackageType_nsprefix_ = None
        self.Weight = Weight
        self.validate_Piece_Weight(self.Weight)
        self.Weight_nsprefix_ = None
        self.Width = Width
        self.validate_Piece_Dimension(self.Width)
        self.Width_nsprefix_ = None
        self.Height = Height
        self.validate_Piece_Dimension(self.Height)
        self.Height_nsprefix_ = None
        self.Depth = Depth
        self.validate_Piece_Dimension(self.Depth)
        self.Depth_nsprefix_ = None
        self.PieceContents = PieceContents
        self.validate_PieceContents(self.PieceContents)
        self.PieceContents_nsprefix_ = None
        if PieceReference is None:
            self.PieceReference = []
        else:
            self.PieceReference = PieceReference
        self.PieceReference_nsprefix_ = None
        self.AdditionalInformation = AdditionalInformation
        self.AdditionalInformation_nsprefix_ = None
        self.ParentPieceIdentificationNumber = ParentPieceIdentificationNumber
        self.validate_PieceID(self.ParentPieceIdentificationNumber)
        self.ParentPieceIdentificationNumber_nsprefix_ = None
        self.PieceIdentificationNumber = PieceIdentificationNumber
        self.validate_PieceID(self.PieceIdentificationNumber)
        self.PieceIdentificationNumber_nsprefix_ = None
        self.UseOwnPieceIdentificationNumber = UseOwnPieceIdentificationNumber
        self.validate_UseOwnPieceIdentificationNumberType(self.UseOwnPieceIdentificationNumber)
        self.UseOwnPieceIdentificationNumber_nsprefix_ = None
        self.PieceIdentificationNumberDataIdentifier = PieceIdentificationNumberDataIdentifier
        self.validate_PieceIdentificationNumberDataIdentifierType(self.PieceIdentificationNumberDataIdentifier)
        self.PieceIdentificationNumberDataIdentifier_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Piece)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Piece.subclass:
            return Piece.subclass(*args_, **kwargs_)
        else:
            return Piece(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceID(self):
        return self.PieceID
    def set_PieceID(self, PieceID):
        self.PieceID = PieceID
    def get_PackageType(self):
        return self.PackageType
    def set_PackageType(self, PackageType):
        self.PackageType = PackageType
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Depth(self):
        return self.Depth
    def set_Depth(self, Depth):
        self.Depth = Depth
    def get_PieceContents(self):
        return self.PieceContents
    def set_PieceContents(self, PieceContents):
        self.PieceContents = PieceContents
    def get_PieceReference(self):
        return self.PieceReference
    def set_PieceReference(self, PieceReference):
        self.PieceReference = PieceReference
    def add_PieceReference(self, value):
        self.PieceReference.append(value)
    def insert_PieceReference_at(self, index, value):
        self.PieceReference.insert(index, value)
    def replace_PieceReference_at(self, index, value):
        self.PieceReference[index] = value
    def get_AdditionalInformation(self):
        return self.AdditionalInformation
    def set_AdditionalInformation(self, AdditionalInformation):
        self.AdditionalInformation = AdditionalInformation
    def get_ParentPieceIdentificationNumber(self):
        return self.ParentPieceIdentificationNumber
    def set_ParentPieceIdentificationNumber(self, ParentPieceIdentificationNumber):
        self.ParentPieceIdentificationNumber = ParentPieceIdentificationNumber
    def get_PieceIdentificationNumber(self):
        return self.PieceIdentificationNumber
    def set_PieceIdentificationNumber(self, PieceIdentificationNumber):
        self.PieceIdentificationNumber = PieceIdentificationNumber
    def get_UseOwnPieceIdentificationNumber(self):
        return self.UseOwnPieceIdentificationNumber
    def set_UseOwnPieceIdentificationNumber(self, UseOwnPieceIdentificationNumber):
        self.UseOwnPieceIdentificationNumber = UseOwnPieceIdentificationNumber
    def get_PieceIdentificationNumberDataIdentifier(self):
        return self.PieceIdentificationNumberDataIdentifier
    def set_PieceIdentificationNumberDataIdentifier(self, PieceIdentificationNumberDataIdentifier):
        self.PieceIdentificationNumberDataIdentifier = PieceIdentificationNumberDataIdentifier
    def validate_PieceID(self, value):
        result = True
        # Validate type PieceID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PieceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PackageType(self, value):
        result = True
        # Validate type PackageType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Piece_Weight(self, value):
        result = True
        # Validate type Piece_Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on Piece_Weight' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on Piece_Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_Piece_Dimension(self, value):
        result = True
        # Validate type Piece_Dimension, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on Piece_Dimension' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_PieceContents(self, value):
        result = True
        # Validate type PieceContents, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 70:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PieceContents' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_UseOwnPieceIdentificationNumberType(self, value):
        result = True
        # Validate type UseOwnPieceIdentificationNumberType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on UseOwnPieceIdentificationNumberType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on UseOwnPieceIdentificationNumberType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PieceIdentificationNumberDataIdentifierType(self, value):
        result = True
        # Validate type PieceIdentificationNumberDataIdentifierType, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PieceIdentificationNumberDataIdentifierType' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PieceIdentificationNumberDataIdentifierType' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.PieceID is not None or
            self.PackageType is not None or
            self.Weight is not None or
            self.Width is not None or
            self.Height is not None or
            self.Depth is not None or
            self.PieceContents is not None or
            self.PieceReference or
            self.AdditionalInformation is not None or
            self.ParentPieceIdentificationNumber is not None or
            self.PieceIdentificationNumber is not None or
            self.UseOwnPieceIdentificationNumber != "N" or
            self.PieceIdentificationNumberDataIdentifier is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Piece', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Piece')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Piece':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Piece')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Piece', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Piece'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Piece', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PieceID is not None:
            namespaceprefix_ = self.PieceID_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceID>%s</%sPieceID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceID), input_name='PieceID')), namespaceprefix_ , eol_))
        if self.PackageType is not None:
            namespaceprefix_ = self.PackageType_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageType>%s</%sPackageType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageType), input_name='PackageType')), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Width, input_name='Width'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.Depth is not None:
            namespaceprefix_ = self.Depth_nsprefix_ + ':' if (UseCapturedNS_ and self.Depth_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDepth>%s</%sDepth>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Depth, input_name='Depth'), namespaceprefix_ , eol_))
        if self.PieceContents is not None:
            namespaceprefix_ = self.PieceContents_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceContents_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceContents>%s</%sPieceContents>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceContents), input_name='PieceContents')), namespaceprefix_ , eol_))
        for PieceReference_ in self.PieceReference:
            namespaceprefix_ = self.PieceReference_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceReference_nsprefix_) else ''
            PieceReference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceReference', pretty_print=pretty_print)
        if self.AdditionalInformation is not None:
            namespaceprefix_ = self.AdditionalInformation_nsprefix_ + ':' if (UseCapturedNS_ and self.AdditionalInformation_nsprefix_) else ''
            self.AdditionalInformation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdditionalInformation', pretty_print=pretty_print)
        if self.ParentPieceIdentificationNumber is not None:
            namespaceprefix_ = self.ParentPieceIdentificationNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ParentPieceIdentificationNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParentPieceIdentificationNumber>%s</%sParentPieceIdentificationNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ParentPieceIdentificationNumber), input_name='ParentPieceIdentificationNumber')), namespaceprefix_ , eol_))
        if self.PieceIdentificationNumber is not None:
            namespaceprefix_ = self.PieceIdentificationNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceIdentificationNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceIdentificationNumber>%s</%sPieceIdentificationNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceIdentificationNumber), input_name='PieceIdentificationNumber')), namespaceprefix_ , eol_))
        if self.UseOwnPieceIdentificationNumber != "N":
            namespaceprefix_ = self.UseOwnPieceIdentificationNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.UseOwnPieceIdentificationNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUseOwnPieceIdentificationNumber>%s</%sUseOwnPieceIdentificationNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UseOwnPieceIdentificationNumber), input_name='UseOwnPieceIdentificationNumber')), namespaceprefix_ , eol_))
        if self.PieceIdentificationNumberDataIdentifier is not None:
            namespaceprefix_ = self.PieceIdentificationNumberDataIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceIdentificationNumberDataIdentifier_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceIdentificationNumberDataIdentifier>%s</%sPieceIdentificationNumberDataIdentifier>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceIdentificationNumberDataIdentifier), input_name='PieceIdentificationNumberDataIdentifier')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PieceID')
            value_ = self.gds_validate_string(value_, node, 'PieceID')
            self.PieceID = value_
            self.PieceID_nsprefix_ = child_.prefix
            # validate type PieceID
            self.validate_PieceID(self.PieceID)
        elif nodeName_ == 'PackageType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageType')
            value_ = self.gds_validate_string(value_, node, 'PackageType')
            self.PackageType = value_
            self.PackageType_nsprefix_ = child_.prefix
            # validate type PackageType
            self.validate_PackageType(self.PackageType)
        elif nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Weight')
            fval_ = self.gds_validate_decimal(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
            # validate type Piece_Weight
            self.validate_Piece_Weight(self.Weight)
        elif nodeName_ == 'Width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Width')
            fval_ = self.gds_validate_decimal(fval_, node, 'Width')
            self.Width = fval_
            self.Width_nsprefix_ = child_.prefix
            # validate type Piece_Dimension
            self.validate_Piece_Dimension(self.Width)
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Height')
            fval_ = self.gds_validate_decimal(fval_, node, 'Height')
            self.Height = fval_
            self.Height_nsprefix_ = child_.prefix
            # validate type Piece_Dimension
            self.validate_Piece_Dimension(self.Height)
        elif nodeName_ == 'Depth' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Depth')
            fval_ = self.gds_validate_decimal(fval_, node, 'Depth')
            self.Depth = fval_
            self.Depth_nsprefix_ = child_.prefix
            # validate type Piece_Dimension
            self.validate_Piece_Dimension(self.Depth)
        elif nodeName_ == 'PieceContents':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PieceContents')
            value_ = self.gds_validate_string(value_, node, 'PieceContents')
            self.PieceContents = value_
            self.PieceContents_nsprefix_ = child_.prefix
            # validate type PieceContents
            self.validate_PieceContents(self.PieceContents)
        elif nodeName_ == 'PieceReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceReference.append(obj_)
            obj_.original_tagname_ = 'PieceReference'
        elif nodeName_ == 'AdditionalInformation':
            obj_ = AdditionalInformation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdditionalInformation = obj_
            obj_.original_tagname_ = 'AdditionalInformation'
        elif nodeName_ == 'ParentPieceIdentificationNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ParentPieceIdentificationNumber')
            value_ = self.gds_validate_string(value_, node, 'ParentPieceIdentificationNumber')
            self.ParentPieceIdentificationNumber = value_
            self.ParentPieceIdentificationNumber_nsprefix_ = child_.prefix
            # validate type PieceID
            self.validate_PieceID(self.ParentPieceIdentificationNumber)
        elif nodeName_ == 'PieceIdentificationNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PieceIdentificationNumber')
            value_ = self.gds_validate_string(value_, node, 'PieceIdentificationNumber')
            self.PieceIdentificationNumber = value_
            self.PieceIdentificationNumber_nsprefix_ = child_.prefix
            # validate type PieceID
            self.validate_PieceID(self.PieceIdentificationNumber)
        elif nodeName_ == 'UseOwnPieceIdentificationNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UseOwnPieceIdentificationNumber')
            value_ = self.gds_validate_string(value_, node, 'UseOwnPieceIdentificationNumber')
            self.UseOwnPieceIdentificationNumber = value_
            self.UseOwnPieceIdentificationNumber_nsprefix_ = child_.prefix
            # validate type UseOwnPieceIdentificationNumberType
            self.validate_UseOwnPieceIdentificationNumberType(self.UseOwnPieceIdentificationNumber)
        elif nodeName_ == 'PieceIdentificationNumberDataIdentifier':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'PieceIdentificationNumberDataIdentifier')
            value_ = self.gds_validate_string(value_, node, 'PieceIdentificationNumberDataIdentifier')
            self.PieceIdentificationNumberDataIdentifier = value_
            self.PieceIdentificationNumberDataIdentifier_nsprefix_ = child_.prefix
            # validate type PieceIdentificationNumberDataIdentifierType
            self.validate_PieceIdentificationNumberDataIdentifierType(self.PieceIdentificationNumberDataIdentifier)
# end class Piece


class AdditionalInformation(GeneratedsSuper):
    """CustomerBarcodes -- This element identifies the Customer Barcodes. It is an optional field
    CustomerAdditionalInformation -- This element identifies the Customer Additional Information with occurences of 6. It is an optional field
    CustomerDescription -- This element identifies the Customer Description. It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomerBarcodes=None, CustomerAdditionalInformation=None, CustomerDescription=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CustomerBarcodes is None:
            self.CustomerBarcodes = []
        else:
            self.CustomerBarcodes = CustomerBarcodes
        self.CustomerBarcodes_nsprefix_ = None
        if CustomerAdditionalInformation is None:
            self.CustomerAdditionalInformation = []
        else:
            self.CustomerAdditionalInformation = CustomerAdditionalInformation
        self.CustomerAdditionalInformation_nsprefix_ = None
        self.CustomerDescription = CustomerDescription
        self.validate_CustomerDescription(self.CustomerDescription)
        self.CustomerDescription_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AdditionalInformation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AdditionalInformation.subclass:
            return AdditionalInformation.subclass(*args_, **kwargs_)
        else:
            return AdditionalInformation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomerBarcodes(self):
        return self.CustomerBarcodes
    def set_CustomerBarcodes(self, CustomerBarcodes):
        self.CustomerBarcodes = CustomerBarcodes
    def add_CustomerBarcodes(self, value):
        self.CustomerBarcodes.append(value)
    def insert_CustomerBarcodes_at(self, index, value):
        self.CustomerBarcodes.insert(index, value)
    def replace_CustomerBarcodes_at(self, index, value):
        self.CustomerBarcodes[index] = value
    def get_CustomerAdditionalInformation(self):
        return self.CustomerAdditionalInformation
    def set_CustomerAdditionalInformation(self, CustomerAdditionalInformation):
        self.CustomerAdditionalInformation = CustomerAdditionalInformation
    def add_CustomerAdditionalInformation(self, value):
        self.CustomerAdditionalInformation.append(value)
    def insert_CustomerAdditionalInformation_at(self, index, value):
        self.CustomerAdditionalInformation.insert(index, value)
    def replace_CustomerAdditionalInformation_at(self, index, value):
        self.CustomerAdditionalInformation[index] = value
    def get_CustomerDescription(self):
        return self.CustomerDescription
    def set_CustomerDescription(self, CustomerDescription):
        self.CustomerDescription = CustomerDescription
    def validate_CustomerDescription(self, value):
        result = True
        # Validate type CustomerDescription, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 80:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomerDescription' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CustomerBarcodes or
            self.CustomerAdditionalInformation or
            self.CustomerDescription is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AdditionalInformation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AdditionalInformation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AdditionalInformation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AdditionalInformation')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AdditionalInformation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AdditionalInformation'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AdditionalInformation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CustomerBarcodes_ in self.CustomerBarcodes:
            namespaceprefix_ = self.CustomerBarcodes_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerBarcodes_nsprefix_) else ''
            CustomerBarcodes_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomerBarcodes', pretty_print=pretty_print)
        for CustomerAdditionalInformation_ in self.CustomerAdditionalInformation:
            namespaceprefix_ = self.CustomerAdditionalInformation_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerAdditionalInformation_nsprefix_) else ''
            CustomerAdditionalInformation_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomerAdditionalInformation', pretty_print=pretty_print)
        if self.CustomerDescription is not None:
            namespaceprefix_ = self.CustomerDescription_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerDescription_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerDescription>%s</%sCustomerDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerDescription), input_name='CustomerDescription')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomerBarcodes':
            obj_ = CustomerBarcodes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomerBarcodes.append(obj_)
            obj_.original_tagname_ = 'CustomerBarcodes'
        elif nodeName_ == 'CustomerAdditionalInformation':
            obj_ = CustomerAdditionalInformation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomerAdditionalInformation.append(obj_)
            obj_.original_tagname_ = 'CustomerAdditionalInformation'
        elif nodeName_ == 'CustomerDescription':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomerDescription')
            value_ = self.gds_validate_string(value_, node, 'CustomerDescription')
            self.CustomerDescription = value_
            self.CustomerDescription_nsprefix_ = child_.prefix
            # validate type CustomerDescription
            self.validate_CustomerDescription(self.CustomerDescription)
# end class AdditionalInformation


class CustomerAdditionalInformation(GeneratedsSuper):
    """Caption -- This element identifies the Customer Additional Information caption. It is an optional field
    Description -- This element identifies the Customer Additional Informatrion description. It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Caption=None, Description=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Caption = Caption
        self.validate_Caption(self.Caption)
        self.Caption_nsprefix_ = None
        self.Description = Description
        self.validate_Description(self.Description)
        self.Description_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomerAdditionalInformation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomerAdditionalInformation.subclass:
            return CustomerAdditionalInformation.subclass(*args_, **kwargs_)
        else:
            return CustomerAdditionalInformation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Caption(self):
        return self.Caption
    def set_Caption(self, Caption):
        self.Caption = Caption
    def get_Description(self):
        return self.Description
    def set_Description(self, Description):
        self.Description = Description
    def validate_Caption(self, value):
        result = True
        # Validate type Caption, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Caption' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Description(self, value):
        result = True
        # Validate type Description, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 40:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Description' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.Caption is not None or
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerAdditionalInformation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomerAdditionalInformation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomerAdditionalInformation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomerAdditionalInformation')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomerAdditionalInformation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomerAdditionalInformation'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerAdditionalInformation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Caption is not None:
            namespaceprefix_ = self.Caption_nsprefix_ + ':' if (UseCapturedNS_ and self.Caption_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCaption>%s</%sCaption>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Caption), input_name='Caption')), namespaceprefix_ , eol_))
        if self.Description is not None:
            namespaceprefix_ = self.Description_nsprefix_ + ':' if (UseCapturedNS_ and self.Description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Description), input_name='Description')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Caption':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Caption')
            value_ = self.gds_validate_string(value_, node, 'Caption')
            self.Caption = value_
            self.Caption_nsprefix_ = child_.prefix
            # validate type Caption
            self.validate_Caption(self.Caption)
        elif nodeName_ == 'Description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Description')
            value_ = self.gds_validate_string(value_, node, 'Description')
            self.Description = value_
            self.Description_nsprefix_ = child_.prefix
            # validate type Description
            self.validate_Description(self.Description)
# end class CustomerAdditionalInformation


class CustomerBarcodes(GeneratedsSuper):
    """BarcodeType -- This element identifies the Customer barcode type. It is an optional field
    BarcodeContent -- This element identifies the Customer barcode content. It is an optional field
    TextBelowBarcode -- This element identifies the Customer barcode text below barcode. It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, BarcodeType=None, BarcodeContent=None, TextBelowBarcode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.BarcodeType = BarcodeType
        self.BarcodeType_nsprefix_ = None
        self.BarcodeContent = BarcodeContent
        self.BarcodeContent_nsprefix_ = None
        self.TextBelowBarcode = TextBelowBarcode
        self.TextBelowBarcode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomerBarcodes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomerBarcodes.subclass:
            return CustomerBarcodes.subclass(*args_, **kwargs_)
        else:
            return CustomerBarcodes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_BarcodeType(self):
        return self.BarcodeType
    def set_BarcodeType(self, BarcodeType):
        self.BarcodeType = BarcodeType
    def get_BarcodeContent(self):
        return self.BarcodeContent
    def set_BarcodeContent(self, BarcodeContent):
        self.BarcodeContent = BarcodeContent
    def get_TextBelowBarcode(self):
        return self.TextBelowBarcode
    def set_TextBelowBarcode(self, TextBelowBarcode):
        self.TextBelowBarcode = TextBelowBarcode
    def _hasContent(self):
        if (
            self.BarcodeType is not None or
            self.BarcodeContent is not None or
            self.TextBelowBarcode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerBarcodes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomerBarcodes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomerBarcodes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomerBarcodes')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomerBarcodes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomerBarcodes'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerBarcodes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.BarcodeType is not None:
            namespaceprefix_ = self.BarcodeType_nsprefix_ + ':' if (UseCapturedNS_ and self.BarcodeType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBarcodeType>%s</%sBarcodeType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BarcodeType), input_name='BarcodeType')), namespaceprefix_ , eol_))
        if self.BarcodeContent is not None:
            namespaceprefix_ = self.BarcodeContent_nsprefix_ + ':' if (UseCapturedNS_ and self.BarcodeContent_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBarcodeContent>%s</%sBarcodeContent>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BarcodeContent), input_name='BarcodeContent')), namespaceprefix_ , eol_))
        if self.TextBelowBarcode is not None:
            namespaceprefix_ = self.TextBelowBarcode_nsprefix_ + ':' if (UseCapturedNS_ and self.TextBelowBarcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTextBelowBarcode>%s</%sTextBelowBarcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TextBelowBarcode), input_name='TextBelowBarcode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'BarcodeType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BarcodeType')
            value_ = self.gds_validate_string(value_, node, 'BarcodeType')
            self.BarcodeType = value_
            self.BarcodeType_nsprefix_ = child_.prefix
        elif nodeName_ == 'BarcodeContent':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BarcodeContent')
            value_ = self.gds_validate_string(value_, node, 'BarcodeContent')
            self.BarcodeContent = value_
            self.BarcodeContent_nsprefix_ = child_.prefix
        elif nodeName_ == 'TextBelowBarcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TextBelowBarcode')
            value_ = self.gds_validate_string(value_, node, 'TextBelowBarcode')
            self.TextBelowBarcode = value_
            self.TextBelowBarcode_nsprefix_ = child_.prefix
# end class CustomerBarcodes


class Pieces(GeneratedsSuper):
    """Pieces -- Element encapsulating pieces information
    Piece -- Element encapsulating pieces information
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Piece=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Piece is None:
            self.Piece = []
        else:
            self.Piece = Piece
        self.Piece_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Pieces)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Pieces.subclass:
            return Pieces.subclass(*args_, **kwargs_)
        else:
            return Pieces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Piece(self):
        return self.Piece
    def set_Piece(self, Piece):
        self.Piece = Piece
    def add_Piece(self, value):
        self.Piece.append(value)
    def insert_Piece_at(self, index, value):
        self.Piece.insert(index, value)
    def replace_Piece_at(self, index, value):
        self.Piece[index] = value
    def _hasContent(self):
        if (
            self.Piece
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Pieces', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Pieces')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Pieces':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Pieces')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Pieces', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Pieces'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Pieces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Piece_ in self.Piece:
            namespaceprefix_ = self.Piece_nsprefix_ + ':' if (UseCapturedNS_ and self.Piece_nsprefix_) else ''
            Piece_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Piece', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Piece':
            obj_ = Piece.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Piece.append(obj_)
            obj_.original_tagname_ = 'Piece'
# end class Pieces


class ShipValResponsePiece(GeneratedsSuper):
    """ShipValResponsePiece -- The ShipValResponsePiece element contains the piece details along with the License Plate details
    PieceNumber -- Contains the Piece Number
    Depth -- Depth of the piece
    Width -- Width of the piece
    Height -- Height of the piece
    Weight -- Weight of the piece
    PackageType -- Package type of the piece
    DimWeight -- Dimensional Weight of the piece
    PieceContents -- Contents or description of the piece
    PieceReference -- Piece level reference
    DataIdentifier -- Contains the starting letter of the piece data Identifier
    LicensePlate -- The String representation of the License Plate Number
    LicensePlateBarCode -- Barcode representing the License Plate information
    QRCode -- QR Code for labelless shipment if RequestQRCode
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceNumber=None, Depth=None, Width=None, Height=None, Weight=None, PackageType=None, DimWeight=None, PieceContents=None, PieceReference=None, DataIdentifier=None, LicensePlate=None, LicensePlateBarCode=None, QRCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PieceNumber = PieceNumber
        self.validate_PieceNumber(self.PieceNumber)
        self.PieceNumber_nsprefix_ = None
        self.Depth = Depth
        self.Depth_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.Weight = Weight
        self.validate_Weight(self.Weight)
        self.Weight_nsprefix_ = None
        self.PackageType = PackageType
        self.validate_PackageType(self.PackageType)
        self.PackageType_nsprefix_ = None
        self.DimWeight = DimWeight
        self.validate_Weight(self.DimWeight)
        self.DimWeight_nsprefix_ = None
        self.PieceContents = PieceContents
        self.validate_PieceContents(self.PieceContents)
        self.PieceContents_nsprefix_ = None
        if PieceReference is None:
            self.PieceReference = []
        else:
            self.PieceReference = PieceReference
        self.PieceReference_nsprefix_ = None
        self.DataIdentifier = DataIdentifier
        self.DataIdentifier_nsprefix_ = None
        self.LicensePlate = LicensePlate
        self.validate_PieceID(self.LicensePlate)
        self.LicensePlate_nsprefix_ = None
        self.LicensePlateBarCode = LicensePlateBarCode
        self.validate_BarCode(self.LicensePlateBarCode)
        self.LicensePlateBarCode_nsprefix_ = None
        self.QRCode = QRCode
        self.QRCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipValResponsePiece)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipValResponsePiece.subclass:
            return ShipValResponsePiece.subclass(*args_, **kwargs_)
        else:
            return ShipValResponsePiece(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceNumber(self):
        return self.PieceNumber
    def set_PieceNumber(self, PieceNumber):
        self.PieceNumber = PieceNumber
    def get_Depth(self):
        return self.Depth
    def set_Depth(self, Depth):
        self.Depth = Depth
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_PackageType(self):
        return self.PackageType
    def set_PackageType(self, PackageType):
        self.PackageType = PackageType
    def get_DimWeight(self):
        return self.DimWeight
    def set_DimWeight(self, DimWeight):
        self.DimWeight = DimWeight
    def get_PieceContents(self):
        return self.PieceContents
    def set_PieceContents(self, PieceContents):
        self.PieceContents = PieceContents
    def get_PieceReference(self):
        return self.PieceReference
    def set_PieceReference(self, PieceReference):
        self.PieceReference = PieceReference
    def add_PieceReference(self, value):
        self.PieceReference.append(value)
    def insert_PieceReference_at(self, index, value):
        self.PieceReference.insert(index, value)
    def replace_PieceReference_at(self, index, value):
        self.PieceReference[index] = value
    def get_DataIdentifier(self):
        return self.DataIdentifier
    def set_DataIdentifier(self, DataIdentifier):
        self.DataIdentifier = DataIdentifier
    def get_LicensePlate(self):
        return self.LicensePlate
    def set_LicensePlate(self, LicensePlate):
        self.LicensePlate = LicensePlate
    def get_LicensePlateBarCode(self):
        return self.LicensePlateBarCode
    def set_LicensePlateBarCode(self, LicensePlateBarCode):
        self.LicensePlateBarCode = LicensePlateBarCode
    def get_QRCode(self):
        return self.QRCode
    def set_QRCode(self, QRCode):
        self.QRCode = QRCode
    def validate_PieceNumber(self, value):
        result = True
        # Validate type PieceNumber, a restriction on xsd:positiveInteger.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def validate_Weight(self, value):
        result = True
        # Validate type Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_PackageType(self, value):
        result = True
        # Validate type PackageType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PieceContents(self, value):
        result = True
        # Validate type PieceContents, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 70:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PieceContents' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PieceID(self, value):
        result = True
        # Validate type PieceID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PieceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_BarCode(self, value):
        result = True
        # Validate type BarCode, a restriction on xsd:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
        return result
    def _hasContent(self):
        if (
            self.PieceNumber is not None or
            self.Depth is not None or
            self.Width is not None or
            self.Height is not None or
            self.Weight is not None or
            self.PackageType is not None or
            self.DimWeight is not None or
            self.PieceContents is not None or
            self.PieceReference or
            self.DataIdentifier is not None or
            self.LicensePlate is not None or
            self.LicensePlateBarCode is not None or
            self.QRCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipValResponsePiece', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipValResponsePiece')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipValResponsePiece':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipValResponsePiece')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipValResponsePiece', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipValResponsePiece'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipValResponsePiece', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PieceNumber is not None:
            namespaceprefix_ = self.PieceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceNumber>%s</%sPieceNumber>%s' % (namespaceprefix_ , self.gds_format_integer(self.PieceNumber, input_name='PieceNumber'), namespaceprefix_ , eol_))
        if self.Depth is not None:
            namespaceprefix_ = self.Depth_nsprefix_ + ':' if (UseCapturedNS_ and self.Depth_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDepth>%s</%sDepth>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Depth, input_name='Depth'), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Width, input_name='Width'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.PackageType is not None:
            namespaceprefix_ = self.PackageType_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageType>%s</%sPackageType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageType), input_name='PackageType')), namespaceprefix_ , eol_))
        if self.DimWeight is not None:
            namespaceprefix_ = self.DimWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.DimWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimWeight>%s</%sDimWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.DimWeight, input_name='DimWeight'), namespaceprefix_ , eol_))
        if self.PieceContents is not None:
            namespaceprefix_ = self.PieceContents_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceContents_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceContents>%s</%sPieceContents>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceContents), input_name='PieceContents')), namespaceprefix_ , eol_))
        for PieceReference_ in self.PieceReference:
            namespaceprefix_ = self.PieceReference_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceReference_nsprefix_) else ''
            PieceReference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceReference', pretty_print=pretty_print)
        if self.DataIdentifier is not None:
            namespaceprefix_ = self.DataIdentifier_nsprefix_ + ':' if (UseCapturedNS_ and self.DataIdentifier_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDataIdentifier>%s</%sDataIdentifier>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DataIdentifier), input_name='DataIdentifier')), namespaceprefix_ , eol_))
        if self.LicensePlate is not None:
            namespaceprefix_ = self.LicensePlate_nsprefix_ + ':' if (UseCapturedNS_ and self.LicensePlate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLicensePlate>%s</%sLicensePlate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.LicensePlate), input_name='LicensePlate')), namespaceprefix_ , eol_))
        if self.LicensePlateBarCode is not None:
            namespaceprefix_ = self.LicensePlateBarCode_nsprefix_ + ':' if (UseCapturedNS_ and self.LicensePlateBarCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLicensePlateBarCode>%s</%sLicensePlateBarCode>%s' % (namespaceprefix_ , self.gds_format_base64(self.LicensePlateBarCode, input_name='LicensePlateBarCode'), namespaceprefix_ , eol_))
        if self.QRCode is not None:
            namespaceprefix_ = self.QRCode_nsprefix_ + ':' if (UseCapturedNS_ and self.QRCode_nsprefix_) else ''
            self.QRCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='QRCode', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceNumber' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'PieceNumber')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'PieceNumber')
            self.PieceNumber = ival_
            self.PieceNumber_nsprefix_ = child_.prefix
            # validate type PieceNumber
            self.validate_PieceNumber(self.PieceNumber)
        elif nodeName_ == 'Depth' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Depth')
            fval_ = self.gds_validate_decimal(fval_, node, 'Depth')
            self.Depth = fval_
            self.Depth_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Width')
            fval_ = self.gds_validate_decimal(fval_, node, 'Width')
            self.Width = fval_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Height')
            fval_ = self.gds_validate_decimal(fval_, node, 'Height')
            self.Height = fval_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Weight')
            fval_ = self.gds_validate_decimal(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
            # validate type Weight
            self.validate_Weight(self.Weight)
        elif nodeName_ == 'PackageType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageType')
            value_ = self.gds_validate_string(value_, node, 'PackageType')
            self.PackageType = value_
            self.PackageType_nsprefix_ = child_.prefix
            # validate type PackageType
            self.validate_PackageType(self.PackageType)
        elif nodeName_ == 'DimWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'DimWeight')
            fval_ = self.gds_validate_decimal(fval_, node, 'DimWeight')
            self.DimWeight = fval_
            self.DimWeight_nsprefix_ = child_.prefix
            # validate type Weight
            self.validate_Weight(self.DimWeight)
        elif nodeName_ == 'PieceContents':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PieceContents')
            value_ = self.gds_validate_string(value_, node, 'PieceContents')
            self.PieceContents = value_
            self.PieceContents_nsprefix_ = child_.prefix
            # validate type PieceContents
            self.validate_PieceContents(self.PieceContents)
        elif nodeName_ == 'PieceReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceReference.append(obj_)
            obj_.original_tagname_ = 'PieceReference'
        elif nodeName_ == 'DataIdentifier':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DataIdentifier')
            value_ = self.gds_validate_string(value_, node, 'DataIdentifier')
            self.DataIdentifier = value_
            self.DataIdentifier_nsprefix_ = child_.prefix
        elif nodeName_ == 'LicensePlate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LicensePlate')
            value_ = self.gds_validate_string(value_, node, 'LicensePlate')
            self.LicensePlate = value_
            self.LicensePlate_nsprefix_ = child_.prefix
            # validate type PieceID
            self.validate_PieceID(self.LicensePlate)
        elif nodeName_ == 'LicensePlateBarCode':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'LicensePlateBarCode')
            else:
                bval_ = None
            self.LicensePlateBarCode = bval_
            self.LicensePlateBarCode_nsprefix_ = child_.prefix
            # validate type BarCode
            self.validate_BarCode(self.LicensePlateBarCode)
        elif nodeName_ == 'QRCode':
            obj_ = Response_QRCode.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.QRCode = obj_
            obj_.original_tagname_ = 'QRCode'
# end class ShipValResponsePiece


class ShipValResponsePieces(GeneratedsSuper):
    """ShipValResponsePieces -- Element encapsulating pieces information
    Piece -- Piece
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Piece=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if Piece is None:
            self.Piece = []
        else:
            self.Piece = Piece
        self.Piece_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipValResponsePieces)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipValResponsePieces.subclass:
            return ShipValResponsePieces.subclass(*args_, **kwargs_)
        else:
            return ShipValResponsePieces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Piece(self):
        return self.Piece
    def set_Piece(self, Piece):
        self.Piece = Piece
    def add_Piece(self, value):
        self.Piece.append(value)
    def insert_Piece_at(self, index, value):
        self.Piece.insert(index, value)
    def replace_Piece_at(self, index, value):
        self.Piece[index] = value
    def _hasContent(self):
        if (
            self.Piece
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipValResponsePieces', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipValResponsePieces')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipValResponsePieces':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipValResponsePieces')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipValResponsePieces', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipValResponsePieces'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipValResponsePieces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Piece_ in self.Piece:
            namespaceprefix_ = self.Piece_nsprefix_ + ':' if (UseCapturedNS_ and self.Piece_nsprefix_) else ''
            Piece_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Piece', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Piece':
            obj_ = ShipValResponsePiece.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Piece.append(obj_)
            obj_.original_tagname_ = 'Piece'
# end class ShipValResponsePieces


class Response_QRCode(GeneratedsSuper):
    """ImageFormat -- QR Code Image Format
    Image -- QR Code Image in base64 format
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ImageFormat=None, Image=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ImageFormat = ImageFormat
        self.validate_QRCodeImageFormat(self.ImageFormat)
        self.ImageFormat_nsprefix_ = None
        self.Image = Image
        self.Image_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Response_QRCode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Response_QRCode.subclass:
            return Response_QRCode.subclass(*args_, **kwargs_)
        else:
            return Response_QRCode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ImageFormat(self):
        return self.ImageFormat
    def set_ImageFormat(self, ImageFormat):
        self.ImageFormat = ImageFormat
    def get_Image(self):
        return self.Image
    def set_Image(self, Image):
        self.Image = Image
    def validate_QRCodeImageFormat(self, value):
        result = True
        # Validate type QRCodeImageFormat, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PNG']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on QRCodeImageFormat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ImageFormat is not None or
            self.Image is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Response_QRCode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Response_QRCode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Response_QRCode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Response_QRCode')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Response_QRCode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Response_QRCode'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Response_QRCode', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ImageFormat is not None:
            namespaceprefix_ = self.ImageFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.ImageFormat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImageFormat>%s</%sImageFormat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ImageFormat), input_name='ImageFormat')), namespaceprefix_ , eol_))
        if self.Image is not None:
            namespaceprefix_ = self.Image_nsprefix_ + ':' if (UseCapturedNS_ and self.Image_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImage>%s</%sImage>%s' % (namespaceprefix_ , self.gds_format_base64(self.Image, input_name='Image'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ImageFormat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ImageFormat')
            value_ = self.gds_validate_string(value_, node, 'ImageFormat')
            self.ImageFormat = value_
            self.ImageFormat_nsprefix_ = child_.prefix
            # validate type QRCodeImageFormat
            self.validate_QRCodeImageFormat(self.ImageFormat)
        elif nodeName_ == 'Image':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'Image')
            else:
                bval_ = None
            self.Image = bval_
            self.Image_nsprefix_ = child_.prefix
# end class Response_QRCode


class Place(GeneratedsSuper):
    """Place -- The place element contains the address from the shipment has to be picked. This element should be declared once in the request message
    ResidenceOrBusiness -- The Location Type element contains the type of location from where the shipment is to be picked. The element must be declared once in the Place element. The acceptable values are B (Business), R (Residence) C (Business/Residence)
    CompanyName -- The Company Name element contains the name of the company. The element must be declared unless the value specified in the element LocationType is not
    “
    R
    ”
    AddressLine1 -- The AddressLine1 element contains the address line 1 to the pickup place. The AddressLine1 is mandatory.
    AddressLine2 -- The AddressLine2 element contains the address line 2 to the pickup place. The AddressLine2 is optional
    AddressLine3 -- The AddressLine3 element contains the address line 3 to the pickup place. The AddressLine3 is optional
    City -- The City element contains the City of the pick address. It must be declared in the Place element
    CountryCode -- The CountryCode element contains the Country/Region code of the pickup place. It must be of 2 letters. Please refer to the Reference Data (DHL Country/Region) for Country/Region codes
    DivisionCode -- The DivisionCode element contains the division code of the pickup place. Refer to Reference Data (DHL Country/Region) for Country/Region that uses division
    Division -- The Division element contains the division name of the pickup place
    PostalCode -- The PostalCode element contains the postal code of the pickup place. Refer to Reference Data (DHL Country/Region) for Country/Region that uses postal code
    PackageLocation -- The PackageLocation element contains the location to pick up the package
    Suburb -- The suburb element contains the suburb name to pick up the package
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ResidenceOrBusiness=None, CompanyName=None, AddressLine1=None, AddressLine2=None, AddressLine3=None, City=None, CountryCode=None, DivisionCode=None, Division=None, PostalCode=None, PackageLocation=None, Suburb=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ResidenceOrBusiness = ResidenceOrBusiness
        self.validate_ResidenceOrBusiness(self.ResidenceOrBusiness)
        self.ResidenceOrBusiness_nsprefix_ = None
        self.CompanyName = CompanyName
        self.validate_CompanyNameValidator(self.CompanyName)
        self.CompanyName_nsprefix_ = None
        self.AddressLine1 = AddressLine1
        self.validate_AddressLine(self.AddressLine1)
        self.AddressLine1_nsprefix_ = None
        self.AddressLine2 = AddressLine2
        self.validate_AddressLine(self.AddressLine2)
        self.AddressLine2_nsprefix_ = None
        self.AddressLine3 = AddressLine3
        self.validate_AddressLine(self.AddressLine3)
        self.AddressLine3_nsprefix_ = None
        self.City = City
        self.validate_City(self.City)
        self.City_nsprefix_ = None
        self.CountryCode = CountryCode
        self.validate_CountryCode(self.CountryCode)
        self.CountryCode_nsprefix_ = None
        self.DivisionCode = DivisionCode
        self.validate_StateCode(self.DivisionCode)
        self.DivisionCode_nsprefix_ = None
        self.Division = Division
        self.validate_State(self.Division)
        self.Division_nsprefix_ = None
        self.PostalCode = PostalCode
        self.validate_PostalCode(self.PostalCode)
        self.PostalCode_nsprefix_ = None
        self.PackageLocation = PackageLocation
        self.validate_PackageLocation(self.PackageLocation)
        self.PackageLocation_nsprefix_ = None
        self.Suburb = Suburb
        self.validate_Suburb(self.Suburb)
        self.Suburb_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Place)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Place.subclass:
            return Place.subclass(*args_, **kwargs_)
        else:
            return Place(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ResidenceOrBusiness(self):
        return self.ResidenceOrBusiness
    def set_ResidenceOrBusiness(self, ResidenceOrBusiness):
        self.ResidenceOrBusiness = ResidenceOrBusiness
    def get_CompanyName(self):
        return self.CompanyName
    def set_CompanyName(self, CompanyName):
        self.CompanyName = CompanyName
    def get_AddressLine1(self):
        return self.AddressLine1
    def set_AddressLine1(self, AddressLine1):
        self.AddressLine1 = AddressLine1
    def get_AddressLine2(self):
        return self.AddressLine2
    def set_AddressLine2(self, AddressLine2):
        self.AddressLine2 = AddressLine2
    def get_AddressLine3(self):
        return self.AddressLine3
    def set_AddressLine3(self, AddressLine3):
        self.AddressLine3 = AddressLine3
    def get_City(self):
        return self.City
    def set_City(self, City):
        self.City = City
    def get_CountryCode(self):
        return self.CountryCode
    def set_CountryCode(self, CountryCode):
        self.CountryCode = CountryCode
    def get_DivisionCode(self):
        return self.DivisionCode
    def set_DivisionCode(self, DivisionCode):
        self.DivisionCode = DivisionCode
    def get_Division(self):
        return self.Division
    def set_Division(self, Division):
        self.Division = Division
    def get_PostalCode(self):
        return self.PostalCode
    def set_PostalCode(self, PostalCode):
        self.PostalCode = PostalCode
    def get_PackageLocation(self):
        return self.PackageLocation
    def set_PackageLocation(self, PackageLocation):
        self.PackageLocation = PackageLocation
    def get_Suburb(self):
        return self.Suburb
    def set_Suburb(self, Suburb):
        self.Suburb = Suburb
    def validate_ResidenceOrBusiness(self, value):
        result = True
        # Validate type ResidenceOrBusiness, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['B', 'R', 'C']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ResidenceOrBusiness' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ResidenceOrBusiness' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CompanyNameValidator(self, value):
        result = True
        # Validate type CompanyNameValidator, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 100:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CompanyNameValidator' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CompanyNameValidator' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AddressLine(self, value):
        result = True
        # Validate type AddressLine, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AddressLine' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AddressLine' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_City(self, value):
        result = True
        # Validate type City, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on City' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryCode(self, value):
        result = True
        # Validate type CountryCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CountryCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_StateCode(self, value):
        result = True
        # Validate type StateCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StateCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_State(self, value):
        result = True
        # Validate type State, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on State' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PostalCode(self, value):
        result = True
        # Validate type PostalCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 12:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PostalCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PackageLocation(self, value):
        result = True
        # Validate type PackageLocation, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 40:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PackageLocation' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Suburb(self, value):
        result = True
        # Validate type Suburb, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Suburb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ResidenceOrBusiness is not None or
            self.CompanyName is not None or
            self.AddressLine1 is not None or
            self.AddressLine2 is not None or
            self.AddressLine3 is not None or
            self.City is not None or
            self.CountryCode is not None or
            self.DivisionCode is not None or
            self.Division is not None or
            self.PostalCode is not None or
            self.PackageLocation is not None or
            self.Suburb is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Place', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Place')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Place':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Place')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Place', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Place'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Place', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ResidenceOrBusiness is not None:
            namespaceprefix_ = self.ResidenceOrBusiness_nsprefix_ + ':' if (UseCapturedNS_ and self.ResidenceOrBusiness_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sResidenceOrBusiness>%s</%sResidenceOrBusiness>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ResidenceOrBusiness), input_name='ResidenceOrBusiness')), namespaceprefix_ , eol_))
        if self.CompanyName is not None:
            namespaceprefix_ = self.CompanyName_nsprefix_ + ':' if (UseCapturedNS_ and self.CompanyName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompanyName>%s</%sCompanyName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CompanyName), input_name='CompanyName')), namespaceprefix_ , eol_))
        if self.AddressLine1 is not None:
            namespaceprefix_ = self.AddressLine1_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine1>%s</%sAddressLine1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine1), input_name='AddressLine1')), namespaceprefix_ , eol_))
        if self.AddressLine2 is not None:
            namespaceprefix_ = self.AddressLine2_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine2>%s</%sAddressLine2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine2), input_name='AddressLine2')), namespaceprefix_ , eol_))
        if self.AddressLine3 is not None:
            namespaceprefix_ = self.AddressLine3_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine3>%s</%sAddressLine3>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine3), input_name='AddressLine3')), namespaceprefix_ , eol_))
        if self.City is not None:
            namespaceprefix_ = self.City_nsprefix_ + ':' if (UseCapturedNS_ and self.City_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCity>%s</%sCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.City), input_name='City')), namespaceprefix_ , eol_))
        if self.CountryCode is not None:
            namespaceprefix_ = self.CountryCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CountryCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCountryCode>%s</%sCountryCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CountryCode), input_name='CountryCode')), namespaceprefix_ , eol_))
        if self.DivisionCode is not None:
            namespaceprefix_ = self.DivisionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.DivisionCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDivisionCode>%s</%sDivisionCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DivisionCode), input_name='DivisionCode')), namespaceprefix_ , eol_))
        if self.Division is not None:
            namespaceprefix_ = self.Division_nsprefix_ + ':' if (UseCapturedNS_ and self.Division_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDivision>%s</%sDivision>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Division), input_name='Division')), namespaceprefix_ , eol_))
        if self.PostalCode is not None:
            namespaceprefix_ = self.PostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.PostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPostalCode>%s</%sPostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PostalCode), input_name='PostalCode')), namespaceprefix_ , eol_))
        if self.PackageLocation is not None:
            namespaceprefix_ = self.PackageLocation_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageLocation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageLocation>%s</%sPackageLocation>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageLocation), input_name='PackageLocation')), namespaceprefix_ , eol_))
        if self.Suburb is not None:
            namespaceprefix_ = self.Suburb_nsprefix_ + ':' if (UseCapturedNS_ and self.Suburb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSuburb>%s</%sSuburb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Suburb), input_name='Suburb')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ResidenceOrBusiness':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ResidenceOrBusiness')
            value_ = self.gds_validate_string(value_, node, 'ResidenceOrBusiness')
            self.ResidenceOrBusiness = value_
            self.ResidenceOrBusiness_nsprefix_ = child_.prefix
            # validate type ResidenceOrBusiness
            self.validate_ResidenceOrBusiness(self.ResidenceOrBusiness)
        elif nodeName_ == 'CompanyName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CompanyName')
            value_ = self.gds_validate_string(value_, node, 'CompanyName')
            self.CompanyName = value_
            self.CompanyName_nsprefix_ = child_.prefix
            # validate type CompanyNameValidator
            self.validate_CompanyNameValidator(self.CompanyName)
        elif nodeName_ == 'AddressLine1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine1')
            value_ = self.gds_validate_string(value_, node, 'AddressLine1')
            self.AddressLine1 = value_
            self.AddressLine1_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine1)
        elif nodeName_ == 'AddressLine2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine2')
            value_ = self.gds_validate_string(value_, node, 'AddressLine2')
            self.AddressLine2 = value_
            self.AddressLine2_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine2)
        elif nodeName_ == 'AddressLine3':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine3')
            value_ = self.gds_validate_string(value_, node, 'AddressLine3')
            self.AddressLine3 = value_
            self.AddressLine3_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine3)
        elif nodeName_ == 'City':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'City')
            value_ = self.gds_validate_string(value_, node, 'City')
            self.City = value_
            self.City_nsprefix_ = child_.prefix
            # validate type City
            self.validate_City(self.City)
        elif nodeName_ == 'CountryCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CountryCode')
            value_ = self.gds_validate_string(value_, node, 'CountryCode')
            self.CountryCode = value_
            self.CountryCode_nsprefix_ = child_.prefix
            # validate type CountryCode
            self.validate_CountryCode(self.CountryCode)
        elif nodeName_ == 'DivisionCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DivisionCode')
            value_ = self.gds_validate_string(value_, node, 'DivisionCode')
            self.DivisionCode = value_
            self.DivisionCode_nsprefix_ = child_.prefix
            # validate type StateCode
            self.validate_StateCode(self.DivisionCode)
        elif nodeName_ == 'Division':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Division')
            value_ = self.gds_validate_string(value_, node, 'Division')
            self.Division = value_
            self.Division_nsprefix_ = child_.prefix
            # validate type State
            self.validate_State(self.Division)
        elif nodeName_ == 'PostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PostalCode')
            value_ = self.gds_validate_string(value_, node, 'PostalCode')
            self.PostalCode = value_
            self.PostalCode_nsprefix_ = child_.prefix
            # validate type PostalCode
            self.validate_PostalCode(self.PostalCode)
        elif nodeName_ == 'PackageLocation':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageLocation')
            value_ = self.gds_validate_string(value_, node, 'PackageLocation')
            self.PackageLocation = value_
            self.PackageLocation_nsprefix_ = child_.prefix
            # validate type PackageLocation
            self.validate_PackageLocation(self.PackageLocation)
        elif nodeName_ == 'Suburb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Suburb')
            value_ = self.gds_validate_string(value_, node, 'Suburb')
            self.Suburb = value_
            self.Suburb_nsprefix_ = child_.prefix
            # validate type Suburb
            self.validate_Suburb(self.Suburb)
# end class Place


class Reference(GeneratedsSuper):
    """Reference -- This element identifies the reference information. It is an optional field in the shipment validation request. Only the first reference will be taken currently
    ReferenceID -- The ReferenceID element contains the shipper reference ID. It is a mandatory field
    ReferenceType -- The ReferenceType element contains the shipment reference type. It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ReferenceID=None, ReferenceType=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ReferenceID = ReferenceID
        self.validate_ReferenceID(self.ReferenceID)
        self.ReferenceID_nsprefix_ = None
        self.ReferenceType = ReferenceType
        self.validate_ReferenceType(self.ReferenceType)
        self.ReferenceType_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Reference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Reference.subclass:
            return Reference.subclass(*args_, **kwargs_)
        else:
            return Reference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ReferenceID(self):
        return self.ReferenceID
    def set_ReferenceID(self, ReferenceID):
        self.ReferenceID = ReferenceID
    def get_ReferenceType(self):
        return self.ReferenceType
    def set_ReferenceType(self, ReferenceType):
        self.ReferenceType = ReferenceType
    def validate_ReferenceID(self, value):
        result = True
        # Validate type ReferenceID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ReferenceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ReferenceType(self, value):
        result = True
        # Validate type ReferenceType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ReferenceID is not None or
            self.ReferenceType is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Reference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Reference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Reference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Reference')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Reference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Reference'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Reference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ReferenceID is not None:
            namespaceprefix_ = self.ReferenceID_nsprefix_ + ':' if (UseCapturedNS_ and self.ReferenceID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReferenceID>%s</%sReferenceID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ReferenceID), input_name='ReferenceID')), namespaceprefix_ , eol_))
        if self.ReferenceType is not None:
            namespaceprefix_ = self.ReferenceType_nsprefix_ + ':' if (UseCapturedNS_ and self.ReferenceType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReferenceType>%s</%sReferenceType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ReferenceType), input_name='ReferenceType')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ReferenceID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ReferenceID')
            value_ = self.gds_validate_string(value_, node, 'ReferenceID')
            self.ReferenceID = value_
            self.ReferenceID_nsprefix_ = child_.prefix
            # validate type ReferenceID
            self.validate_ReferenceID(self.ReferenceID)
        elif nodeName_ == 'ReferenceType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ReferenceType')
            value_ = self.gds_validate_string(value_, node, 'ReferenceType')
            self.ReferenceType = value_
            self.ReferenceType_nsprefix_ = child_.prefix
            # validate type ReferenceType
            self.validate_ReferenceType(self.ReferenceType)
# end class Reference


class ShipmentDetails(GeneratedsSuper):
    """ShipmentDetails -- The ShipmentDetails element contains the details of the shipment. It must be declared once in the request message
    Pieces -- The Pieces element contains the pieces information of the shipment. It must be declared in the Shipment validation element. It could store maximum 999 pieces information
    WeightUnit -- The Weight Unit element contains the Unit by which the shipment weight is measured. It must be declared in the Weight element of the Pickup. The valid value for this element is K (Kilograms) and L (Pounds). Please refer to Reference Data (DHL Country/Region) for valid weight unit
    GlobalProductCode -- The GlobalProductCode element is global product code for the shipment. It is the mandatory field in the Shipment Details segment. The valid values are A to Z and 0 to 9. Please refer to the Reference Data and use appropriate Global codes enabled for the Country/Region
    LocalProductCode -- The LocalProductCode Element is the Country/Region billing product code for the shipment. It is the mandatory field in the Shipment Details segment
    Date -- The Date element contains the shipment date. Shipment date for when package(s) will be shipped (but usually current date).Value may range from today to ten days after. The date should be in YYYY-MM-DD format
    Contents -- The Contents element contains the shipment description
    DimensionUnit -- The DimensionUnit Element is the unit in which the dimensions are measured. It is an optional field. The valid value is C (Centremetres) and I (Inches). Please refer to Reference Data (DHL Country/Region) for valid dimension unit
    PackageType -- The PackageType element contains the unique ID of the piece for this shipment. It is an optional field
    IsDutiable -- The IsDutiable element indicates whether shipment is dutiable or not
    CurrencyCode -- The CurrencyCode element indentifies how the shipment charge is billed
    CustData -- The CustData element consists of customer data that required to be printed on shipment level in GLS transport label CI template
    ShipmentCharges -- The Shipmentcharges element consists of shipment charges of the shipment details. This element is optional
    ParentShipmentIdentificationNumber -- The ParentShipmentIdentificationNumber element consists of Parent Shipment Identification Number of the shipment details. This element is optional
    ParentShipmentGlobalProductCode -- The ParentShipmentGlobalProductCode element consists of Parent Shipment Global Product Code of the shipment details. This element is optional
    ParentShipmentPackagesCount -- The ParentShipmentPackagesCount element consists of Parent Shipment Number of Packages or Pieces of the shipment details. This element is optional
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Pieces=None, WeightUnit=None, GlobalProductCode=None, LocalProductCode=None, Date=None, Contents=None, DimensionUnit=None, PackageType=None, IsDutiable=None, CurrencyCode=None, CustData=None, ShipmentCharges=None, ParentShipmentIdentificationNumber=None, ParentShipmentGlobalProductCode=None, ParentShipmentPackagesCount=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.validate_WeightUnit(self.WeightUnit)
        self.WeightUnit_nsprefix_ = None
        self.GlobalProductCode = GlobalProductCode
        self.validate_GlobalProductCode(self.GlobalProductCode)
        self.GlobalProductCode_nsprefix_ = None
        self.LocalProductCode = LocalProductCode
        self.validate_LocalProductCode(self.LocalProductCode)
        self.LocalProductCode_nsprefix_ = None
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%d').date()
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.Date_nsprefix_ = None
        self.Contents = Contents
        self.validate_ShipmentContents(self.Contents)
        self.Contents_nsprefix_ = None
        self.DimensionUnit = DimensionUnit
        self.validate_DimensionUnit(self.DimensionUnit)
        self.DimensionUnit_nsprefix_ = None
        self.PackageType = PackageType
        self.validate_PackageType(self.PackageType)
        self.PackageType_nsprefix_ = None
        self.IsDutiable = IsDutiable
        self.validate_YesNo(self.IsDutiable)
        self.IsDutiable_nsprefix_ = None
        self.CurrencyCode = CurrencyCode
        self.validate_CurrencyCode(self.CurrencyCode)
        self.CurrencyCode_nsprefix_ = None
        self.CustData = CustData
        self.validate_CustData(self.CustData)
        self.CustData_nsprefix_ = None
        self.ShipmentCharges = ShipmentCharges
        self.validate_ShipmentCharges(self.ShipmentCharges)
        self.ShipmentCharges_nsprefix_ = None
        self.ParentShipmentIdentificationNumber = ParentShipmentIdentificationNumber
        self.validate_AWBNumber(self.ParentShipmentIdentificationNumber)
        self.ParentShipmentIdentificationNumber_nsprefix_ = None
        self.ParentShipmentGlobalProductCode = ParentShipmentGlobalProductCode
        self.validate_GlobalProductCode(self.ParentShipmentGlobalProductCode)
        self.ParentShipmentGlobalProductCode_nsprefix_ = None
        self.ParentShipmentPackagesCount = ParentShipmentPackagesCount
        self.validate_ParentShipmentPackagesCount(self.ParentShipmentPackagesCount)
        self.ParentShipmentPackagesCount_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipmentDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentDetails.subclass:
            return ShipmentDetails.subclass(*args_, **kwargs_)
        else:
            return ShipmentDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def get_GlobalProductCode(self):
        return self.GlobalProductCode
    def set_GlobalProductCode(self, GlobalProductCode):
        self.GlobalProductCode = GlobalProductCode
    def get_LocalProductCode(self):
        return self.LocalProductCode
    def set_LocalProductCode(self, LocalProductCode):
        self.LocalProductCode = LocalProductCode
    def get_Date(self):
        return self.Date
    def set_Date(self, Date):
        self.Date = Date
    def get_Contents(self):
        return self.Contents
    def set_Contents(self, Contents):
        self.Contents = Contents
    def get_DimensionUnit(self):
        return self.DimensionUnit
    def set_DimensionUnit(self, DimensionUnit):
        self.DimensionUnit = DimensionUnit
    def get_PackageType(self):
        return self.PackageType
    def set_PackageType(self, PackageType):
        self.PackageType = PackageType
    def get_IsDutiable(self):
        return self.IsDutiable
    def set_IsDutiable(self, IsDutiable):
        self.IsDutiable = IsDutiable
    def get_CurrencyCode(self):
        return self.CurrencyCode
    def set_CurrencyCode(self, CurrencyCode):
        self.CurrencyCode = CurrencyCode
    def get_CustData(self):
        return self.CustData
    def set_CustData(self, CustData):
        self.CustData = CustData
    def get_ShipmentCharges(self):
        return self.ShipmentCharges
    def set_ShipmentCharges(self, ShipmentCharges):
        self.ShipmentCharges = ShipmentCharges
    def get_ParentShipmentIdentificationNumber(self):
        return self.ParentShipmentIdentificationNumber
    def set_ParentShipmentIdentificationNumber(self, ParentShipmentIdentificationNumber):
        self.ParentShipmentIdentificationNumber = ParentShipmentIdentificationNumber
    def get_ParentShipmentGlobalProductCode(self):
        return self.ParentShipmentGlobalProductCode
    def set_ParentShipmentGlobalProductCode(self, ParentShipmentGlobalProductCode):
        self.ParentShipmentGlobalProductCode = ParentShipmentGlobalProductCode
    def get_ParentShipmentPackagesCount(self):
        return self.ParentShipmentPackagesCount
    def set_ParentShipmentPackagesCount(self, ParentShipmentPackagesCount):
        self.ParentShipmentPackagesCount = ParentShipmentPackagesCount
    def validate_WeightUnit(self, value):
        result = True
        # Validate type WeightUnit, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['K', 'L']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_GlobalProductCode(self, value):
        result = True
        # Validate type GlobalProductCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on GlobalProductCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on GlobalProductCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_GlobalProductCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_GlobalProductCode_patterns_, ))
                result = False
        return result
    validate_GlobalProductCode_patterns_ = [['^(([A-Z0-9])*)$']]
    def validate_LocalProductCode(self, value):
        result = True
        # Validate type LocalProductCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on LocalProductCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on LocalProductCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_LocalProductCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_LocalProductCode_patterns_, ))
                result = False
        return result
    validate_LocalProductCode_patterns_ = [['^(([A-Z0-9])*)$']]
    def validate_Date(self, value):
        result = True
        # Validate type Date, a restriction on xsd:date.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, datetime_.date):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (datetime_.date)' % {"value": value, "lineno": lineno, })
                return False
            value = str(value)
            if not self.gds_validate_simple_patterns(
                    self.validate_Date_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_Date_patterns_, ))
                result = False
        return result
    validate_Date_patterns_ = [['^([0-9][0-9][0-9][0-9](-)[0-9][0-9](-)[0-9][0-9])$']]
    def validate_ShipmentContents(self, value):
        result = True
        # Validate type ShipmentContents, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 90:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ShipmentContents' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ShipmentContents' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DimensionUnit(self, value):
        result = True
        # Validate type DimensionUnit, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['C', 'I']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DimensionUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on DimensionUnit' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PackageType(self, value):
        result = True
        # Validate type PackageType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_YesNo(self, value):
        result = True
        # Validate type YesNo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on YesNo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on YesNo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CurrencyCode(self, value):
        result = True
        # Validate type CurrencyCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CurrencyCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CurrencyCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CurrencyCode_patterns_, ))
                result = False
        return result
    validate_CurrencyCode_patterns_ = [['^([^ ].*[^ ])$']]
    def validate_CustData(self, value):
        result = True
        # Validate type CustData, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 250:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustData' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CustData' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ShipmentCharges(self, value):
        result = True
        # Validate type ShipmentCharges, a restriction on xsd:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.001:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ShipmentCharges' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ShipmentCharges' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_AWBNumber(self, value):
        result = True
        # Validate type AWBNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AWBNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ParentShipmentPackagesCount(self, value):
        result = True
        # Validate type ParentShipmentPackagesCount, a restriction on xsd:positiveInteger.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value, "lineno": lineno, })
                return False
            if value < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ParentShipmentPackagesCount' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.Pieces is not None or
            self.WeightUnit is not None or
            self.GlobalProductCode is not None or
            self.LocalProductCode is not None or
            self.Date is not None or
            self.Contents is not None or
            self.DimensionUnit is not None or
            self.PackageType is not None or
            self.IsDutiable is not None or
            self.CurrencyCode is not None or
            self.CustData is not None or
            self.ShipmentCharges is not None or
            self.ParentShipmentIdentificationNumber is not None or
            self.ParentShipmentGlobalProductCode is not None or
            self.ParentShipmentPackagesCount is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentDetails', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipmentDetails')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipmentDetails':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipmentDetails')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipmentDetails', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipmentDetails'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            self.Pieces.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pieces', pretty_print=pretty_print)
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
        if self.GlobalProductCode is not None:
            namespaceprefix_ = self.GlobalProductCode_nsprefix_ + ':' if (UseCapturedNS_ and self.GlobalProductCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGlobalProductCode>%s</%sGlobalProductCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.GlobalProductCode), input_name='GlobalProductCode')), namespaceprefix_ , eol_))
        if self.LocalProductCode is not None:
            namespaceprefix_ = self.LocalProductCode_nsprefix_ + ':' if (UseCapturedNS_ and self.LocalProductCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLocalProductCode>%s</%sLocalProductCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.LocalProductCode), input_name='LocalProductCode')), namespaceprefix_ , eol_))
        if self.Date is not None:
            namespaceprefix_ = self.Date_nsprefix_ + ':' if (UseCapturedNS_ and self.Date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDate>%s</%sDate>%s' % (namespaceprefix_ , self.gds_format_date(self.Date, input_name='Date'), namespaceprefix_ , eol_))
        if self.Contents is not None:
            namespaceprefix_ = self.Contents_nsprefix_ + ':' if (UseCapturedNS_ and self.Contents_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContents>%s</%sContents>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contents), input_name='Contents')), namespaceprefix_ , eol_))
        if self.DimensionUnit is not None:
            namespaceprefix_ = self.DimensionUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.DimensionUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimensionUnit>%s</%sDimensionUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DimensionUnit), input_name='DimensionUnit')), namespaceprefix_ , eol_))
        if self.PackageType is not None:
            namespaceprefix_ = self.PackageType_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageType>%s</%sPackageType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageType), input_name='PackageType')), namespaceprefix_ , eol_))
        if self.IsDutiable is not None:
            namespaceprefix_ = self.IsDutiable_nsprefix_ + ':' if (UseCapturedNS_ and self.IsDutiable_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsDutiable>%s</%sIsDutiable>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IsDutiable), input_name='IsDutiable')), namespaceprefix_ , eol_))
        if self.CurrencyCode is not None:
            namespaceprefix_ = self.CurrencyCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CurrencyCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrencyCode>%s</%sCurrencyCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CurrencyCode), input_name='CurrencyCode')), namespaceprefix_ , eol_))
        if self.CustData is not None:
            namespaceprefix_ = self.CustData_nsprefix_ + ':' if (UseCapturedNS_ and self.CustData_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustData>%s</%sCustData>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustData), input_name='CustData')), namespaceprefix_ , eol_))
        if self.ShipmentCharges is not None:
            namespaceprefix_ = self.ShipmentCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentCharges>%s</%sShipmentCharges>%s' % (namespaceprefix_ , self.gds_format_float(self.ShipmentCharges, input_name='ShipmentCharges'), namespaceprefix_ , eol_))
        if self.ParentShipmentIdentificationNumber is not None:
            namespaceprefix_ = self.ParentShipmentIdentificationNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ParentShipmentIdentificationNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParentShipmentIdentificationNumber>%s</%sParentShipmentIdentificationNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ParentShipmentIdentificationNumber), input_name='ParentShipmentIdentificationNumber')), namespaceprefix_ , eol_))
        if self.ParentShipmentGlobalProductCode is not None:
            namespaceprefix_ = self.ParentShipmentGlobalProductCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ParentShipmentGlobalProductCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParentShipmentGlobalProductCode>%s</%sParentShipmentGlobalProductCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ParentShipmentGlobalProductCode), input_name='ParentShipmentGlobalProductCode')), namespaceprefix_ , eol_))
        if self.ParentShipmentPackagesCount is not None:
            namespaceprefix_ = self.ParentShipmentPackagesCount_nsprefix_ + ':' if (UseCapturedNS_ and self.ParentShipmentPackagesCount_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sParentShipmentPackagesCount>%s</%sParentShipmentPackagesCount>%s' % (namespaceprefix_ , self.gds_format_integer(self.ParentShipmentPackagesCount, input_name='ParentShipmentPackagesCount'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Pieces':
            obj_ = Pieces.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Pieces = obj_
            obj_.original_tagname_ = 'Pieces'
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
            # validate type WeightUnit
            self.validate_WeightUnit(self.WeightUnit)
        elif nodeName_ == 'GlobalProductCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'GlobalProductCode')
            value_ = self.gds_validate_string(value_, node, 'GlobalProductCode')
            self.GlobalProductCode = value_
            self.GlobalProductCode_nsprefix_ = child_.prefix
            # validate type GlobalProductCode
            self.validate_GlobalProductCode(self.GlobalProductCode)
        elif nodeName_ == 'LocalProductCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LocalProductCode')
            value_ = self.gds_validate_string(value_, node, 'LocalProductCode')
            self.LocalProductCode = value_
            self.LocalProductCode_nsprefix_ = child_.prefix
            # validate type LocalProductCode
            self.validate_LocalProductCode(self.LocalProductCode)
        elif nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.Date = dval_
            self.Date_nsprefix_ = child_.prefix
            # validate type Date
            self.validate_Date(self.Date)
        elif nodeName_ == 'Contents':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contents')
            value_ = self.gds_validate_string(value_, node, 'Contents')
            self.Contents = value_
            self.Contents_nsprefix_ = child_.prefix
            # validate type ShipmentContents
            self.validate_ShipmentContents(self.Contents)
        elif nodeName_ == 'DimensionUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DimensionUnit')
            value_ = self.gds_validate_string(value_, node, 'DimensionUnit')
            self.DimensionUnit = value_
            self.DimensionUnit_nsprefix_ = child_.prefix
            # validate type DimensionUnit
            self.validate_DimensionUnit(self.DimensionUnit)
        elif nodeName_ == 'PackageType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageType')
            value_ = self.gds_validate_string(value_, node, 'PackageType')
            self.PackageType = value_
            self.PackageType_nsprefix_ = child_.prefix
            # validate type PackageType
            self.validate_PackageType(self.PackageType)
        elif nodeName_ == 'IsDutiable':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IsDutiable')
            value_ = self.gds_validate_string(value_, node, 'IsDutiable')
            self.IsDutiable = value_
            self.IsDutiable_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.IsDutiable)
        elif nodeName_ == 'CurrencyCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CurrencyCode')
            value_ = self.gds_validate_string(value_, node, 'CurrencyCode')
            self.CurrencyCode = value_
            self.CurrencyCode_nsprefix_ = child_.prefix
            # validate type CurrencyCode
            self.validate_CurrencyCode(self.CurrencyCode)
        elif nodeName_ == 'CustData':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustData')
            value_ = self.gds_validate_string(value_, node, 'CustData')
            self.CustData = value_
            self.CustData_nsprefix_ = child_.prefix
            # validate type CustData
            self.validate_CustData(self.CustData)
        elif nodeName_ == 'ShipmentCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'ShipmentCharges')
            fval_ = self.gds_validate_float(fval_, node, 'ShipmentCharges')
            self.ShipmentCharges = fval_
            self.ShipmentCharges_nsprefix_ = child_.prefix
            # validate type ShipmentCharges
            self.validate_ShipmentCharges(self.ShipmentCharges)
        elif nodeName_ == 'ParentShipmentIdentificationNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ParentShipmentIdentificationNumber')
            value_ = self.gds_validate_string(value_, node, 'ParentShipmentIdentificationNumber')
            self.ParentShipmentIdentificationNumber = value_
            self.ParentShipmentIdentificationNumber_nsprefix_ = child_.prefix
            # validate type AWBNumber
            self.validate_AWBNumber(self.ParentShipmentIdentificationNumber)
        elif nodeName_ == 'ParentShipmentGlobalProductCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ParentShipmentGlobalProductCode')
            value_ = self.gds_validate_string(value_, node, 'ParentShipmentGlobalProductCode')
            self.ParentShipmentGlobalProductCode = value_
            self.ParentShipmentGlobalProductCode_nsprefix_ = child_.prefix
            # validate type GlobalProductCode
            self.validate_GlobalProductCode(self.ParentShipmentGlobalProductCode)
        elif nodeName_ == 'ParentShipmentPackagesCount' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'ParentShipmentPackagesCount')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'ParentShipmentPackagesCount')
            self.ParentShipmentPackagesCount = ival_
            self.ParentShipmentPackagesCount_nsprefix_ = child_.prefix
            # validate type ParentShipmentPackagesCount
            self.validate_ParentShipmentPackagesCount(self.ParentShipmentPackagesCount)
# end class ShipmentDetails


class Shipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Weight=None, WeightUnit=None, Pieces=None, DoorTo=None, AirwarBillNumber=None, AccountType=None, ProductType=None, GlobalProductType=None, LocalProductType=None, Commodity=None, DeclaredValue=None, DeclaredCurrency=None, InsuredValue=None, InsuredCurrency=None, DimensionalUnit=None, DimensionalWeight=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Weight = Weight
        self.validate_Weight(self.Weight)
        self.Weight_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.validate_WeightUnit(self.WeightUnit)
        self.WeightUnit_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.DoorTo = DoorTo
        self.validate_DoorTo(self.DoorTo)
        self.DoorTo_nsprefix_ = None
        self.AirwarBillNumber = AirwarBillNumber
        self.validate_AWBNumber(self.AirwarBillNumber)
        self.AirwarBillNumber_nsprefix_ = None
        self.AccountType = AccountType
        self.validate_AccountType(self.AccountType)
        self.AccountType_nsprefix_ = None
        self.ProductType = ProductType
        self.ProductType_nsprefix_ = None
        self.GlobalProductType = GlobalProductType
        self.GlobalProductType_nsprefix_ = None
        self.LocalProductType = LocalProductType
        self.LocalProductType_nsprefix_ = None
        self.Commodity = Commodity
        self.Commodity_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.validate_Money(self.DeclaredValue)
        self.DeclaredValue_nsprefix_ = None
        self.DeclaredCurrency = DeclaredCurrency
        self.validate_CurrencyCode(self.DeclaredCurrency)
        self.DeclaredCurrency_nsprefix_ = None
        self.InsuredValue = InsuredValue
        self.validate_Money(self.InsuredValue)
        self.InsuredValue_nsprefix_ = None
        self.InsuredCurrency = InsuredCurrency
        self.validate_CurrencyCode(self.InsuredCurrency)
        self.InsuredCurrency_nsprefix_ = None
        self.DimensionalUnit = DimensionalUnit
        self.validate_WeightUnit(self.DimensionalUnit)
        self.DimensionalUnit_nsprefix_ = None
        self.DimensionalWeight = DimensionalWeight
        self.validate_Weight(self.DimensionalWeight)
        self.DimensionalWeight_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Shipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Shipment.subclass:
            return Shipment.subclass(*args_, **kwargs_)
        else:
            return Shipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_DoorTo(self):
        return self.DoorTo
    def set_DoorTo(self, DoorTo):
        self.DoorTo = DoorTo
    def get_AirwarBillNumber(self):
        return self.AirwarBillNumber
    def set_AirwarBillNumber(self, AirwarBillNumber):
        self.AirwarBillNumber = AirwarBillNumber
    def get_AccountType(self):
        return self.AccountType
    def set_AccountType(self, AccountType):
        self.AccountType = AccountType
    def get_ProductType(self):
        return self.ProductType
    def set_ProductType(self, ProductType):
        self.ProductType = ProductType
    def get_GlobalProductType(self):
        return self.GlobalProductType
    def set_GlobalProductType(self, GlobalProductType):
        self.GlobalProductType = GlobalProductType
    def get_LocalProductType(self):
        return self.LocalProductType
    def set_LocalProductType(self, LocalProductType):
        self.LocalProductType = LocalProductType
    def get_Commodity(self):
        return self.Commodity
    def set_Commodity(self, Commodity):
        self.Commodity = Commodity
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_DeclaredCurrency(self):
        return self.DeclaredCurrency
    def set_DeclaredCurrency(self, DeclaredCurrency):
        self.DeclaredCurrency = DeclaredCurrency
    def get_InsuredValue(self):
        return self.InsuredValue
    def set_InsuredValue(self, InsuredValue):
        self.InsuredValue = InsuredValue
    def get_InsuredCurrency(self):
        return self.InsuredCurrency
    def set_InsuredCurrency(self, InsuredCurrency):
        self.InsuredCurrency = InsuredCurrency
    def get_DimensionalUnit(self):
        return self.DimensionalUnit
    def set_DimensionalUnit(self, DimensionalUnit):
        self.DimensionalUnit = DimensionalUnit
    def get_DimensionalWeight(self):
        return self.DimensionalWeight
    def set_DimensionalWeight(self, DimensionalWeight):
        self.DimensionalWeight = DimensionalWeight
    def validate_Weight(self, value):
        result = True
        # Validate type Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_WeightUnit(self, value):
        result = True
        # Validate type WeightUnit, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['K', 'L']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DoorTo(self, value):
        result = True
        # Validate type DoorTo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['DD', 'DA', 'AA', 'DC']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DoorTo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on DoorTo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AWBNumber(self, value):
        result = True
        # Validate type AWBNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AWBNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AccountType(self, value):
        result = True
        # Validate type AccountType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['D']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AccountType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Money(self, value):
        result = True
        # Validate type Money, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on Money' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_CurrencyCode(self, value):
        result = True
        # Validate type CurrencyCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CurrencyCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CurrencyCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CurrencyCode_patterns_, ))
                result = False
        return result
    validate_CurrencyCode_patterns_ = [['^([^ ].*[^ ])$']]
    def _hasContent(self):
        if (
            self.Weight is not None or
            self.WeightUnit is not None or
            self.Pieces is not None or
            self.DoorTo is not None or
            self.AirwarBillNumber is not None or
            self.AccountType is not None or
            self.ProductType is not None or
            self.GlobalProductType is not None or
            self.LocalProductType is not None or
            self.Commodity is not None or
            self.DeclaredValue is not None or
            self.DeclaredCurrency is not None or
            self.InsuredValue is not None or
            self.InsuredCurrency is not None or
            self.DimensionalUnit is not None or
            self.DimensionalWeight is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Shipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Shipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Shipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Shipment')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Shipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Shipment'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Shipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            self.Pieces.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pieces', pretty_print=pretty_print)
        if self.DoorTo is not None:
            namespaceprefix_ = self.DoorTo_nsprefix_ + ':' if (UseCapturedNS_ and self.DoorTo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDoorTo>%s</%sDoorTo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DoorTo), input_name='DoorTo')), namespaceprefix_ , eol_))
        if self.AirwarBillNumber is not None:
            namespaceprefix_ = self.AirwarBillNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.AirwarBillNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAirwarBillNumber>%s</%sAirwarBillNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AirwarBillNumber), input_name='AirwarBillNumber')), namespaceprefix_ , eol_))
        if self.AccountType is not None:
            namespaceprefix_ = self.AccountType_nsprefix_ + ':' if (UseCapturedNS_ and self.AccountType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccountType>%s</%sAccountType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AccountType), input_name='AccountType')), namespaceprefix_ , eol_))
        if self.ProductType is not None:
            namespaceprefix_ = self.ProductType_nsprefix_ + ':' if (UseCapturedNS_ and self.ProductType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProductType>%s</%sProductType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ProductType), input_name='ProductType')), namespaceprefix_ , eol_))
        if self.GlobalProductType is not None:
            namespaceprefix_ = self.GlobalProductType_nsprefix_ + ':' if (UseCapturedNS_ and self.GlobalProductType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGlobalProductType>%s</%sGlobalProductType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.GlobalProductType), input_name='GlobalProductType')), namespaceprefix_ , eol_))
        if self.LocalProductType is not None:
            namespaceprefix_ = self.LocalProductType_nsprefix_ + ':' if (UseCapturedNS_ and self.LocalProductType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLocalProductType>%s</%sLocalProductType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.LocalProductType), input_name='LocalProductType')), namespaceprefix_ , eol_))
        if self.Commodity is not None:
            namespaceprefix_ = self.Commodity_nsprefix_ + ':' if (UseCapturedNS_ and self.Commodity_nsprefix_) else ''
            self.Commodity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Commodity', pretty_print=pretty_print)
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
        if self.DeclaredCurrency is not None:
            namespaceprefix_ = self.DeclaredCurrency_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredCurrency_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredCurrency>%s</%sDeclaredCurrency>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DeclaredCurrency), input_name='DeclaredCurrency')), namespaceprefix_ , eol_))
        if self.InsuredValue is not None:
            namespaceprefix_ = self.InsuredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuredValue>%s</%sInsuredValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.InsuredValue, input_name='InsuredValue'), namespaceprefix_ , eol_))
        if self.InsuredCurrency is not None:
            namespaceprefix_ = self.InsuredCurrency_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuredCurrency_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuredCurrency>%s</%sInsuredCurrency>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InsuredCurrency), input_name='InsuredCurrency')), namespaceprefix_ , eol_))
        if self.DimensionalUnit is not None:
            namespaceprefix_ = self.DimensionalUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.DimensionalUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimensionalUnit>%s</%sDimensionalUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DimensionalUnit), input_name='DimensionalUnit')), namespaceprefix_ , eol_))
        if self.DimensionalWeight is not None:
            namespaceprefix_ = self.DimensionalWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.DimensionalWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimensionalWeight>%s</%sDimensionalWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.DimensionalWeight, input_name='DimensionalWeight'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Weight')
            fval_ = self.gds_validate_decimal(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
            # validate type Weight
            self.validate_Weight(self.Weight)
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
            # validate type WeightUnit
            self.validate_WeightUnit(self.WeightUnit)
        elif nodeName_ == 'Pieces':
            obj_ = Pieces.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Pieces = obj_
            obj_.original_tagname_ = 'Pieces'
        elif nodeName_ == 'DoorTo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DoorTo')
            value_ = self.gds_validate_string(value_, node, 'DoorTo')
            self.DoorTo = value_
            self.DoorTo_nsprefix_ = child_.prefix
            # validate type DoorTo
            self.validate_DoorTo(self.DoorTo)
        elif nodeName_ == 'AirwarBillNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AirwarBillNumber')
            value_ = self.gds_validate_string(value_, node, 'AirwarBillNumber')
            self.AirwarBillNumber = value_
            self.AirwarBillNumber_nsprefix_ = child_.prefix
            # validate type AWBNumber
            self.validate_AWBNumber(self.AirwarBillNumber)
        elif nodeName_ == 'AccountType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AccountType')
            value_ = self.gds_validate_string(value_, node, 'AccountType')
            self.AccountType = value_
            self.AccountType_nsprefix_ = child_.prefix
            # validate type AccountType
            self.validate_AccountType(self.AccountType)
        elif nodeName_ == 'ProductType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ProductType')
            value_ = self.gds_validate_string(value_, node, 'ProductType')
            self.ProductType = value_
            self.ProductType_nsprefix_ = child_.prefix
        elif nodeName_ == 'GlobalProductType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'GlobalProductType')
            value_ = self.gds_validate_string(value_, node, 'GlobalProductType')
            self.GlobalProductType = value_
            self.GlobalProductType_nsprefix_ = child_.prefix
        elif nodeName_ == 'LocalProductType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LocalProductType')
            value_ = self.gds_validate_string(value_, node, 'LocalProductType')
            self.LocalProductType = value_
            self.LocalProductType_nsprefix_ = child_.prefix
        elif nodeName_ == 'Commodity':
            obj_ = Commodity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Commodity = obj_
            obj_.original_tagname_ = 'Commodity'
        elif nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
            # validate type Money
            self.validate_Money(self.DeclaredValue)
        elif nodeName_ == 'DeclaredCurrency':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DeclaredCurrency')
            value_ = self.gds_validate_string(value_, node, 'DeclaredCurrency')
            self.DeclaredCurrency = value_
            self.DeclaredCurrency_nsprefix_ = child_.prefix
            # validate type CurrencyCode
            self.validate_CurrencyCode(self.DeclaredCurrency)
        elif nodeName_ == 'InsuredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'InsuredValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'InsuredValue')
            self.InsuredValue = fval_
            self.InsuredValue_nsprefix_ = child_.prefix
            # validate type Money
            self.validate_Money(self.InsuredValue)
        elif nodeName_ == 'InsuredCurrency':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InsuredCurrency')
            value_ = self.gds_validate_string(value_, node, 'InsuredCurrency')
            self.InsuredCurrency = value_
            self.InsuredCurrency_nsprefix_ = child_.prefix
            # validate type CurrencyCode
            self.validate_CurrencyCode(self.InsuredCurrency)
        elif nodeName_ == 'DimensionalUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DimensionalUnit')
            value_ = self.gds_validate_string(value_, node, 'DimensionalUnit')
            self.DimensionalUnit = value_
            self.DimensionalUnit_nsprefix_ = child_.prefix
            # validate type WeightUnit
            self.validate_WeightUnit(self.DimensionalUnit)
        elif nodeName_ == 'DimensionalWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'DimensionalWeight')
            fval_ = self.gds_validate_decimal(fval_, node, 'DimensionalWeight')
            self.DimensionalWeight = fval_
            self.DimensionalWeight_nsprefix_ = child_.prefix
            # validate type Weight
            self.validate_Weight(self.DimensionalWeight)
# end class Shipment


class Shipper(GeneratedsSuper):
    """Shipper -- Shipper element contains the details of the Shipper. This element should be declared once in the Shipment validation Request message
    ShipperID -- Shipper's Account Number
    CompanyName -- The Company Name element contains the name of the company. The element must be declared unless the value specified in the element ResidenceOrBusiness is not
    “
    R
    ”
    SuiteDepartmentName -- The SuiteDepartmentName element contains the suite or department name of the shipper
    RegisteredAccount -- The RegisteredAccount element contains the registered account of the shipper
    AddressLine1 -- The AddressLine1 element contains the address of the shipper location. There are three elements for address.
    AddressLine2 -- The AddressLine2 element contains the address of the shipper location. There are three elements for address.
    AddressLine3 -- The AddressLine3 element contains the address of the shipper location. There are three elements for address.
    City -- The City element contains the City of the pickup address. It must be declared in the Shipper element for Country/Region that use city, please refer to the Reference Data (DHL Country/Region) for Country/Region location type
    Division -- The Division element contains the state or county name of the shipper location. Please refer to the Reference Data (DHL Country/Region) for Country/Region location type
    DivisionCode -- The DivisionCode element contains the state or county code of the shipper location. Please refer to the Reference Data (DHL Country/Region) for Country/Region location type
    PostalCode -- The PostalCode element contains the postal code of the pickup place. Please refer to the Reference Data (DHL Country/Region) for Country/Region location type
    OriginServiceAreaCode -- The OriginServiceAreaCode element contains the service area code of the pickup place. It is required for re-upload option of PLT shipment supporting documents image
    OriginFacilityCode -- The OriginFacilityCode element contains the facility area code of the pickup place. It is required for re-upload option of PLT shipment supporting documents image
    CountryCode -- The CountryCode element contains the Country/Region code of the pickup place. It must be of 2 letters. Please refer to the Reference Data (DHL Country/Region) for Country/Region codes
    CountryName -- The CountryName element contains Country/Region name of the shipper. Its value should be valid DHL Country/Region name. This element must be declared once in the Shipper element. Please refer to the Reference Data (DHL Country/Region) for Country/Region names
    Contact -- The Contact element contains the information about the contact at the shipper
    ’
    s location. It must be declared in the shipper element
    Suburb -- The suburb element contains suburb name of the shipper. It is optional field
    StreetName -- The Contact element contains the Exporter
    ’
    s street name.It is an optional field
    BuildingName -- The Contact element contains the Exporter
    ’
    s Building Name.It is an optional field
    StreetNumber -- The Contact element contains the Exporter
    ’
    s It is an optional field. It is an optional field
    RegistrationNumbers -- The Contact element contains the Exporter
    ’
    s contact information.
    BusinessPartyTypeCode -- The Contact element contains the Exporter
    ’
    s Business Party Type Code.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ShipperID=None, CompanyName=None, SuiteDepartmentName=None, RegisteredAccount=None, AddressLine1=None, AddressLine2=None, AddressLine3=None, City=None, Division=None, DivisionCode=None, PostalCode=None, OriginServiceAreaCode=None, OriginFacilityCode=None, CountryCode=None, CountryName=None, FederalTaxId=None, StateTaxId=None, EORI_No=None, Contact=None, Suburb=None, StreetName=None, BuildingName=None, StreetNumber=None, RegistrationNumbers=None, BusinessPartyTypeCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ShipperID = ShipperID
        self.validate_ShipperID(self.ShipperID)
        self.ShipperID_nsprefix_ = None
        self.CompanyName = CompanyName
        self.validate_CompanyNameValidator(self.CompanyName)
        self.CompanyName_nsprefix_ = None
        self.SuiteDepartmentName = SuiteDepartmentName
        self.validate_SuiteDepartmentName(self.SuiteDepartmentName)
        self.SuiteDepartmentName_nsprefix_ = None
        self.RegisteredAccount = RegisteredAccount
        self.validate_AccountNumber(self.RegisteredAccount)
        self.RegisteredAccount_nsprefix_ = None
        self.AddressLine1 = AddressLine1
        self.validate_AddressLine(self.AddressLine1)
        self.AddressLine1_nsprefix_ = None
        self.AddressLine2 = AddressLine2
        self.validate_AddressLine(self.AddressLine2)
        self.AddressLine2_nsprefix_ = None
        self.AddressLine3 = AddressLine3
        self.validate_AddressLine(self.AddressLine3)
        self.AddressLine3_nsprefix_ = None
        self.City = City
        self.validate_City(self.City)
        self.City_nsprefix_ = None
        self.Division = Division
        self.validate_Division(self.Division)
        self.Division_nsprefix_ = None
        self.DivisionCode = DivisionCode
        self.validate_DivisionCode(self.DivisionCode)
        self.DivisionCode_nsprefix_ = None
        self.PostalCode = PostalCode
        self.validate_PostalCode(self.PostalCode)
        self.PostalCode_nsprefix_ = None
        self.OriginServiceAreaCode = OriginServiceAreaCode
        self.validate_OriginServiceAreaCode(self.OriginServiceAreaCode)
        self.OriginServiceAreaCode_nsprefix_ = None
        self.OriginFacilityCode = OriginFacilityCode
        self.validate_OriginFacilityCode(self.OriginFacilityCode)
        self.OriginFacilityCode_nsprefix_ = None
        self.CountryCode = CountryCode
        self.validate_CountryCode(self.CountryCode)
        self.CountryCode_nsprefix_ = None
        self.CountryName = CountryName
        self.validate_CountryName(self.CountryName)
        self.CountryName_nsprefix_ = None
        self.FederalTaxId = FederalTaxId
        self.validate_FederalTaxIdType2(self.FederalTaxId)
        self.FederalTaxId_nsprefix_ = None
        self.StateTaxId = StateTaxId
        self.validate_StateTaxIdType3(self.StateTaxId)
        self.StateTaxId_nsprefix_ = None
        self.EORI_No = EORI_No
        self.validate_EORI_NoType(self.EORI_No)
        self.EORI_No_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Suburb = Suburb
        self.validate_Suburb(self.Suburb)
        self.Suburb_nsprefix_ = None
        self.StreetName = StreetName
        self.validate_StreetName(self.StreetName)
        self.StreetName_nsprefix_ = None
        self.BuildingName = BuildingName
        self.validate_BuildingName(self.BuildingName)
        self.BuildingName_nsprefix_ = None
        self.StreetNumber = StreetNumber
        self.validate_StreetNumber(self.StreetNumber)
        self.StreetNumber_nsprefix_ = None
        self.RegistrationNumbers = RegistrationNumbers
        self.RegistrationNumbers_nsprefix_ = None
        self.BusinessPartyTypeCode = BusinessPartyTypeCode
        self.validate_BusinessPartyTypeCode(self.BusinessPartyTypeCode)
        self.BusinessPartyTypeCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Shipper)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Shipper.subclass:
            return Shipper.subclass(*args_, **kwargs_)
        else:
            return Shipper(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ShipperID(self):
        return self.ShipperID
    def set_ShipperID(self, ShipperID):
        self.ShipperID = ShipperID
    def get_CompanyName(self):
        return self.CompanyName
    def set_CompanyName(self, CompanyName):
        self.CompanyName = CompanyName
    def get_SuiteDepartmentName(self):
        return self.SuiteDepartmentName
    def set_SuiteDepartmentName(self, SuiteDepartmentName):
        self.SuiteDepartmentName = SuiteDepartmentName
    def get_RegisteredAccount(self):
        return self.RegisteredAccount
    def set_RegisteredAccount(self, RegisteredAccount):
        self.RegisteredAccount = RegisteredAccount
    def get_AddressLine1(self):
        return self.AddressLine1
    def set_AddressLine1(self, AddressLine1):
        self.AddressLine1 = AddressLine1
    def get_AddressLine2(self):
        return self.AddressLine2
    def set_AddressLine2(self, AddressLine2):
        self.AddressLine2 = AddressLine2
    def get_AddressLine3(self):
        return self.AddressLine3
    def set_AddressLine3(self, AddressLine3):
        self.AddressLine3 = AddressLine3
    def get_City(self):
        return self.City
    def set_City(self, City):
        self.City = City
    def get_Division(self):
        return self.Division
    def set_Division(self, Division):
        self.Division = Division
    def get_DivisionCode(self):
        return self.DivisionCode
    def set_DivisionCode(self, DivisionCode):
        self.DivisionCode = DivisionCode
    def get_PostalCode(self):
        return self.PostalCode
    def set_PostalCode(self, PostalCode):
        self.PostalCode = PostalCode
    def get_OriginServiceAreaCode(self):
        return self.OriginServiceAreaCode
    def set_OriginServiceAreaCode(self, OriginServiceAreaCode):
        self.OriginServiceAreaCode = OriginServiceAreaCode
    def get_OriginFacilityCode(self):
        return self.OriginFacilityCode
    def set_OriginFacilityCode(self, OriginFacilityCode):
        self.OriginFacilityCode = OriginFacilityCode
    def get_CountryCode(self):
        return self.CountryCode
    def set_CountryCode(self, CountryCode):
        self.CountryCode = CountryCode
    def get_CountryName(self):
        return self.CountryName
    def set_CountryName(self, CountryName):
        self.CountryName = CountryName
    def get_FederalTaxId(self):
        return self.FederalTaxId
    def set_FederalTaxId(self, FederalTaxId):
        self.FederalTaxId = FederalTaxId
    def get_StateTaxId(self):
        return self.StateTaxId
    def set_StateTaxId(self, StateTaxId):
        self.StateTaxId = StateTaxId
    def get_EORI_No(self):
        return self.EORI_No
    def set_EORI_No(self, EORI_No):
        self.EORI_No = EORI_No
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Suburb(self):
        return self.Suburb
    def set_Suburb(self, Suburb):
        self.Suburb = Suburb
    def get_StreetName(self):
        return self.StreetName
    def set_StreetName(self, StreetName):
        self.StreetName = StreetName
    def get_BuildingName(self):
        return self.BuildingName
    def set_BuildingName(self, BuildingName):
        self.BuildingName = BuildingName
    def get_StreetNumber(self):
        return self.StreetNumber
    def set_StreetNumber(self, StreetNumber):
        self.StreetNumber = StreetNumber
    def get_RegistrationNumbers(self):
        return self.RegistrationNumbers
    def set_RegistrationNumbers(self, RegistrationNumbers):
        self.RegistrationNumbers = RegistrationNumbers
    def get_BusinessPartyTypeCode(self):
        return self.BusinessPartyTypeCode
    def set_BusinessPartyTypeCode(self, BusinessPartyTypeCode):
        self.BusinessPartyTypeCode = BusinessPartyTypeCode
    def validate_ShipperID(self, value):
        result = True
        # Validate type ShipperID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ShipperID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CompanyNameValidator(self, value):
        result = True
        # Validate type CompanyNameValidator, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 100:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CompanyNameValidator' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CompanyNameValidator' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SuiteDepartmentName(self, value):
        result = True
        # Validate type SuiteDepartmentName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SuiteDepartmentName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AccountNumber(self, value):
        result = True
        # Validate type AccountNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AccountNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AddressLine(self, value):
        result = True
        # Validate type AddressLine, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AddressLine' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AddressLine' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_City(self, value):
        result = True
        # Validate type City, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on City' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Division(self, value):
        result = True
        # Validate type Division, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Division' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DivisionCode(self, value):
        result = True
        # Validate type DivisionCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on DivisionCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PostalCode(self, value):
        result = True
        # Validate type PostalCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 12:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PostalCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_OriginServiceAreaCode(self, value):
        result = True
        # Validate type OriginServiceAreaCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on OriginServiceAreaCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_OriginFacilityCode(self, value):
        result = True
        # Validate type OriginFacilityCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on OriginFacilityCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryCode(self, value):
        result = True
        # Validate type CountryCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CountryCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CountryName(self, value):
        result = True
        # Validate type CountryName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CountryName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_FederalTaxIdType2(self, value):
        result = True
        # Validate type FederalTaxIdType2, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on FederalTaxIdType2' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on FederalTaxIdType2' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_StateTaxIdType3(self, value):
        result = True
        # Validate type StateTaxIdType3, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StateTaxIdType3' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on StateTaxIdType3' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_EORI_NoType(self, value):
        result = True
        # Validate type EORI_NoType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on EORI_NoType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on EORI_NoType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Suburb(self, value):
        result = True
        # Validate type Suburb, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Suburb' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_StreetName(self, value):
        result = True
        # Validate type StreetName, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 250:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StreetName' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on StreetName' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def validate_BuildingName(self, value):
        result = True
        # Validate type BuildingName, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 50:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on BuildingName' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BuildingName' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def validate_StreetNumber(self, value):
        result = True
        # Validate type StreetNumber, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 50:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on StreetNumber' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on StreetNumber' % {"value" : value, "lineno": lineno} )
                result = False
        return result
    def validate_BusinessPartyTypeCode(self, value):
        result = True
        # Validate type BusinessPartyTypeCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on BusinessPartyTypeCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BusinessPartyTypeCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ShipperID is not None or
            self.CompanyName is not None or
            self.SuiteDepartmentName is not None or
            self.RegisteredAccount is not None or
            self.AddressLine1 is not None or
            self.AddressLine2 is not None or
            self.AddressLine3 is not None or
            self.City is not None or
            self.Division is not None or
            self.DivisionCode is not None or
            self.PostalCode is not None or
            self.OriginServiceAreaCode is not None or
            self.OriginFacilityCode is not None or
            self.CountryCode is not None or
            self.CountryName is not None or
            self.FederalTaxId is not None or
            self.StateTaxId is not None or
            self.EORI_No is not None or
            self.Contact is not None or
            self.Suburb is not None or
            self.StreetName is not None or
            self.BuildingName is not None or
            self.StreetNumber is not None or
            self.RegistrationNumbers is not None or
            self.BusinessPartyTypeCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Shipper', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Shipper')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Shipper':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Shipper')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Shipper', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Shipper'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Shipper', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ShipperID is not None:
            namespaceprefix_ = self.ShipperID_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperID>%s</%sShipperID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperID), input_name='ShipperID')), namespaceprefix_ , eol_))
        if self.CompanyName is not None:
            namespaceprefix_ = self.CompanyName_nsprefix_ + ':' if (UseCapturedNS_ and self.CompanyName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompanyName>%s</%sCompanyName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CompanyName), input_name='CompanyName')), namespaceprefix_ , eol_))
        if self.SuiteDepartmentName is not None:
            namespaceprefix_ = self.SuiteDepartmentName_nsprefix_ + ':' if (UseCapturedNS_ and self.SuiteDepartmentName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSuiteDepartmentName>%s</%sSuiteDepartmentName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SuiteDepartmentName), input_name='SuiteDepartmentName')), namespaceprefix_ , eol_))
        if self.RegisteredAccount is not None:
            namespaceprefix_ = self.RegisteredAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.RegisteredAccount_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRegisteredAccount>%s</%sRegisteredAccount>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RegisteredAccount), input_name='RegisteredAccount')), namespaceprefix_ , eol_))
        if self.AddressLine1 is not None:
            namespaceprefix_ = self.AddressLine1_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine1>%s</%sAddressLine1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine1), input_name='AddressLine1')), namespaceprefix_ , eol_))
        if self.AddressLine2 is not None:
            namespaceprefix_ = self.AddressLine2_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine2>%s</%sAddressLine2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine2), input_name='AddressLine2')), namespaceprefix_ , eol_))
        if self.AddressLine3 is not None:
            namespaceprefix_ = self.AddressLine3_nsprefix_ + ':' if (UseCapturedNS_ and self.AddressLine3_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddressLine3>%s</%sAddressLine3>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AddressLine3), input_name='AddressLine3')), namespaceprefix_ , eol_))
        if self.City is not None:
            namespaceprefix_ = self.City_nsprefix_ + ':' if (UseCapturedNS_ and self.City_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCity>%s</%sCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.City), input_name='City')), namespaceprefix_ , eol_))
        if self.Division is not None:
            namespaceprefix_ = self.Division_nsprefix_ + ':' if (UseCapturedNS_ and self.Division_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDivision>%s</%sDivision>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Division), input_name='Division')), namespaceprefix_ , eol_))
        if self.DivisionCode is not None:
            namespaceprefix_ = self.DivisionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.DivisionCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDivisionCode>%s</%sDivisionCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DivisionCode), input_name='DivisionCode')), namespaceprefix_ , eol_))
        if self.PostalCode is not None:
            namespaceprefix_ = self.PostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.PostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPostalCode>%s</%sPostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PostalCode), input_name='PostalCode')), namespaceprefix_ , eol_))
        if self.OriginServiceAreaCode is not None:
            namespaceprefix_ = self.OriginServiceAreaCode_nsprefix_ + ':' if (UseCapturedNS_ and self.OriginServiceAreaCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOriginServiceAreaCode>%s</%sOriginServiceAreaCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OriginServiceAreaCode), input_name='OriginServiceAreaCode')), namespaceprefix_ , eol_))
        if self.OriginFacilityCode is not None:
            namespaceprefix_ = self.OriginFacilityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.OriginFacilityCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOriginFacilityCode>%s</%sOriginFacilityCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OriginFacilityCode), input_name='OriginFacilityCode')), namespaceprefix_ , eol_))
        if self.CountryCode is not None:
            namespaceprefix_ = self.CountryCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CountryCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCountryCode>%s</%sCountryCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CountryCode), input_name='CountryCode')), namespaceprefix_ , eol_))
        if self.CountryName is not None:
            namespaceprefix_ = self.CountryName_nsprefix_ + ':' if (UseCapturedNS_ and self.CountryName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCountryName>%s</%sCountryName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CountryName), input_name='CountryName')), namespaceprefix_ , eol_))
        if self.FederalTaxId is not None:
            namespaceprefix_ = self.FederalTaxId_nsprefix_ + ':' if (UseCapturedNS_ and self.FederalTaxId_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFederalTaxId>%s</%sFederalTaxId>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FederalTaxId), input_name='FederalTaxId')), namespaceprefix_ , eol_))
        if self.StateTaxId is not None:
            namespaceprefix_ = self.StateTaxId_nsprefix_ + ':' if (UseCapturedNS_ and self.StateTaxId_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStateTaxId>%s</%sStateTaxId>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StateTaxId), input_name='StateTaxId')), namespaceprefix_ , eol_))
        if self.EORI_No is not None:
            namespaceprefix_ = self.EORI_No_nsprefix_ + ':' if (UseCapturedNS_ and self.EORI_No_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEORI_No>%s</%sEORI_No>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.EORI_No), input_name='EORI_No')), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            self.Contact.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Contact', pretty_print=pretty_print)
        if self.Suburb is not None:
            namespaceprefix_ = self.Suburb_nsprefix_ + ':' if (UseCapturedNS_ and self.Suburb_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSuburb>%s</%sSuburb>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Suburb), input_name='Suburb')), namespaceprefix_ , eol_))
        if self.StreetName is not None:
            namespaceprefix_ = self.StreetName_nsprefix_ + ':' if (UseCapturedNS_ and self.StreetName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStreetName>%s</%sStreetName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StreetName), input_name='StreetName')), namespaceprefix_ , eol_))
        if self.BuildingName is not None:
            namespaceprefix_ = self.BuildingName_nsprefix_ + ':' if (UseCapturedNS_ and self.BuildingName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBuildingName>%s</%sBuildingName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BuildingName), input_name='BuildingName')), namespaceprefix_ , eol_))
        if self.StreetNumber is not None:
            namespaceprefix_ = self.StreetNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.StreetNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStreetNumber>%s</%sStreetNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StreetNumber), input_name='StreetNumber')), namespaceprefix_ , eol_))
        if self.RegistrationNumbers is not None:
            namespaceprefix_ = self.RegistrationNumbers_nsprefix_ + ':' if (UseCapturedNS_ and self.RegistrationNumbers_nsprefix_) else ''
            self.RegistrationNumbers.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RegistrationNumbers', pretty_print=pretty_print)
        if self.BusinessPartyTypeCode is not None:
            namespaceprefix_ = self.BusinessPartyTypeCode_nsprefix_ + ':' if (UseCapturedNS_ and self.BusinessPartyTypeCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBusinessPartyTypeCode>%s</%sBusinessPartyTypeCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BusinessPartyTypeCode), input_name='BusinessPartyTypeCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ShipperID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperID')
            value_ = self.gds_validate_string(value_, node, 'ShipperID')
            self.ShipperID = value_
            self.ShipperID_nsprefix_ = child_.prefix
            # validate type ShipperID
            self.validate_ShipperID(self.ShipperID)
        elif nodeName_ == 'CompanyName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CompanyName')
            value_ = self.gds_validate_string(value_, node, 'CompanyName')
            self.CompanyName = value_
            self.CompanyName_nsprefix_ = child_.prefix
            # validate type CompanyNameValidator
            self.validate_CompanyNameValidator(self.CompanyName)
        elif nodeName_ == 'SuiteDepartmentName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SuiteDepartmentName')
            value_ = self.gds_validate_string(value_, node, 'SuiteDepartmentName')
            self.SuiteDepartmentName = value_
            self.SuiteDepartmentName_nsprefix_ = child_.prefix
            # validate type SuiteDepartmentName
            self.validate_SuiteDepartmentName(self.SuiteDepartmentName)
        elif nodeName_ == 'RegisteredAccount':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RegisteredAccount')
            value_ = self.gds_validate_string(value_, node, 'RegisteredAccount')
            self.RegisteredAccount = value_
            self.RegisteredAccount_nsprefix_ = child_.prefix
            # validate type AccountNumber
            self.validate_AccountNumber(self.RegisteredAccount)
        elif nodeName_ == 'AddressLine1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine1')
            value_ = self.gds_validate_string(value_, node, 'AddressLine1')
            self.AddressLine1 = value_
            self.AddressLine1_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine1)
        elif nodeName_ == 'AddressLine2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine2')
            value_ = self.gds_validate_string(value_, node, 'AddressLine2')
            self.AddressLine2 = value_
            self.AddressLine2_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine2)
        elif nodeName_ == 'AddressLine3':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AddressLine3')
            value_ = self.gds_validate_string(value_, node, 'AddressLine3')
            self.AddressLine3 = value_
            self.AddressLine3_nsprefix_ = child_.prefix
            # validate type AddressLine
            self.validate_AddressLine(self.AddressLine3)
        elif nodeName_ == 'City':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'City')
            value_ = self.gds_validate_string(value_, node, 'City')
            self.City = value_
            self.City_nsprefix_ = child_.prefix
            # validate type City
            self.validate_City(self.City)
        elif nodeName_ == 'Division':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Division')
            value_ = self.gds_validate_string(value_, node, 'Division')
            self.Division = value_
            self.Division_nsprefix_ = child_.prefix
            # validate type Division
            self.validate_Division(self.Division)
        elif nodeName_ == 'DivisionCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DivisionCode')
            value_ = self.gds_validate_string(value_, node, 'DivisionCode')
            self.DivisionCode = value_
            self.DivisionCode_nsprefix_ = child_.prefix
            # validate type DivisionCode
            self.validate_DivisionCode(self.DivisionCode)
        elif nodeName_ == 'PostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PostalCode')
            value_ = self.gds_validate_string(value_, node, 'PostalCode')
            self.PostalCode = value_
            self.PostalCode_nsprefix_ = child_.prefix
            # validate type PostalCode
            self.validate_PostalCode(self.PostalCode)
        elif nodeName_ == 'OriginServiceAreaCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OriginServiceAreaCode')
            value_ = self.gds_validate_string(value_, node, 'OriginServiceAreaCode')
            self.OriginServiceAreaCode = value_
            self.OriginServiceAreaCode_nsprefix_ = child_.prefix
            # validate type OriginServiceAreaCode
            self.validate_OriginServiceAreaCode(self.OriginServiceAreaCode)
        elif nodeName_ == 'OriginFacilityCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OriginFacilityCode')
            value_ = self.gds_validate_string(value_, node, 'OriginFacilityCode')
            self.OriginFacilityCode = value_
            self.OriginFacilityCode_nsprefix_ = child_.prefix
            # validate type OriginFacilityCode
            self.validate_OriginFacilityCode(self.OriginFacilityCode)
        elif nodeName_ == 'CountryCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CountryCode')
            value_ = self.gds_validate_string(value_, node, 'CountryCode')
            self.CountryCode = value_
            self.CountryCode_nsprefix_ = child_.prefix
            # validate type CountryCode
            self.validate_CountryCode(self.CountryCode)
        elif nodeName_ == 'CountryName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CountryName')
            value_ = self.gds_validate_string(value_, node, 'CountryName')
            self.CountryName = value_
            self.CountryName_nsprefix_ = child_.prefix
            # validate type CountryName
            self.validate_CountryName(self.CountryName)
        elif nodeName_ == 'FederalTaxId':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FederalTaxId')
            value_ = self.gds_validate_string(value_, node, 'FederalTaxId')
            self.FederalTaxId = value_
            self.FederalTaxId_nsprefix_ = child_.prefix
            # validate type FederalTaxIdType2
            self.validate_FederalTaxIdType2(self.FederalTaxId)
        elif nodeName_ == 'StateTaxId':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'StateTaxId')
            value_ = self.gds_validate_string(value_, node, 'StateTaxId')
            self.StateTaxId = value_
            self.StateTaxId_nsprefix_ = child_.prefix
            # validate type StateTaxIdType3
            self.validate_StateTaxIdType3(self.StateTaxId)
        elif nodeName_ == 'EORI_No':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'EORI_No')
            value_ = self.gds_validate_string(value_, node, 'EORI_No')
            self.EORI_No = value_
            self.EORI_No_nsprefix_ = child_.prefix
            # validate type EORI_NoType
            self.validate_EORI_NoType(self.EORI_No)
        elif nodeName_ == 'Contact':
            obj_ = Contact.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Contact = obj_
            obj_.original_tagname_ = 'Contact'
        elif nodeName_ == 'Suburb':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Suburb')
            value_ = self.gds_validate_string(value_, node, 'Suburb')
            self.Suburb = value_
            self.Suburb_nsprefix_ = child_.prefix
            # validate type Suburb
            self.validate_Suburb(self.Suburb)
        elif nodeName_ == 'StreetName':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'StreetName')
            value_ = self.gds_validate_string(value_, node, 'StreetName')
            self.StreetName = value_
            self.StreetName_nsprefix_ = child_.prefix
            # validate type StreetName
            self.validate_StreetName(self.StreetName)
        elif nodeName_ == 'BuildingName':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'BuildingName')
            value_ = self.gds_validate_string(value_, node, 'BuildingName')
            self.BuildingName = value_
            self.BuildingName_nsprefix_ = child_.prefix
            # validate type BuildingName
            self.validate_BuildingName(self.BuildingName)
        elif nodeName_ == 'StreetNumber':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'StreetNumber')
            value_ = self.gds_validate_string(value_, node, 'StreetNumber')
            self.StreetNumber = value_
            self.StreetNumber_nsprefix_ = child_.prefix
            # validate type StreetNumber
            self.validate_StreetNumber(self.StreetNumber)
        elif nodeName_ == 'RegistrationNumbers':
            obj_ = RegistrationNumbers.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RegistrationNumbers = obj_
            obj_.original_tagname_ = 'RegistrationNumbers'
        elif nodeName_ == 'BusinessPartyTypeCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BusinessPartyTypeCode')
            value_ = self.gds_validate_string(value_, node, 'BusinessPartyTypeCode')
            self.BusinessPartyTypeCode = value_
            self.BusinessPartyTypeCode_nsprefix_ = child_.prefix
            # validate type BusinessPartyTypeCode
            self.validate_BusinessPartyTypeCode(self.BusinessPartyTypeCode)
# end class Shipper


class SpecialService(GeneratedsSuper):
    """SpecialService -- The SpecialService Element provides various special services for the shipment. It is an optional field. Please refer to the Reference Data and use appropriate Service codes enabled for the Country/Region
    SpecialServiceType -- The SpecialServiceType element contains the code for special services provided for shipment. Please refer to the Reference Data and use appropriate Service codes enabled for the Country/Region
    SpecialServiceDesc -- Special Servce Description
    CommunicationAddress -- The CommunicationAddress element contains the communication line number :fax number or phone number. It is an optional element in the SpecialService Element
    CommunicationType -- The CommunicationType element contains the communication line type :fax or phone. It is an optional element in the SpecialService Element
    ChargeValue -- The ChargeValue element contains the chargeable amount for the special service. It is an optional element in the SpecialService Element
    CurrencyCode -- The CurrencyCode element identifies how the shipment is billed
    IsWaived -- This element tells whether special service is waived or not. It is an optional element in the special service segment. The value is either Y (Yes) or N (No)
    PaymentMethods -- This element indicates the Payment Method if it is COD service. It is an optional element in the special service segment. The value is either Y (Yes) or N (No)
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, SpecialServiceType=None, SpecialServiceDesc=None, CommunicationAddress=None, CommunicationType=None, ChargeValue=None, CurrencyCode=None, IsWaived=None, PaymentMethods=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.SpecialServiceType = SpecialServiceType
        self.validate_SpecialServiceType(self.SpecialServiceType)
        self.SpecialServiceType_nsprefix_ = None
        self.SpecialServiceDesc = SpecialServiceDesc
        self.SpecialServiceDesc_nsprefix_ = None
        self.CommunicationAddress = CommunicationAddress
        self.validate_CommunicationAddress(self.CommunicationAddress)
        self.CommunicationAddress_nsprefix_ = None
        self.CommunicationType = CommunicationType
        self.validate_CommunicationType(self.CommunicationType)
        self.CommunicationType_nsprefix_ = None
        self.ChargeValue = ChargeValue
        self.validate_ChargeValue_Money(self.ChargeValue)
        self.ChargeValue_nsprefix_ = None
        self.CurrencyCode = CurrencyCode
        self.validate_CurrencyCode(self.CurrencyCode)
        self.CurrencyCode_nsprefix_ = None
        self.IsWaived = IsWaived
        self.validate_YesNo(self.IsWaived)
        self.IsWaived_nsprefix_ = None
        self.PaymentMethods = PaymentMethods
        self.PaymentMethods_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpecialService)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpecialService.subclass:
            return SpecialService.subclass(*args_, **kwargs_)
        else:
            return SpecialService(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_SpecialServiceType(self):
        return self.SpecialServiceType
    def set_SpecialServiceType(self, SpecialServiceType):
        self.SpecialServiceType = SpecialServiceType
    def get_SpecialServiceDesc(self):
        return self.SpecialServiceDesc
    def set_SpecialServiceDesc(self, SpecialServiceDesc):
        self.SpecialServiceDesc = SpecialServiceDesc
    def get_CommunicationAddress(self):
        return self.CommunicationAddress
    def set_CommunicationAddress(self, CommunicationAddress):
        self.CommunicationAddress = CommunicationAddress
    def get_CommunicationType(self):
        return self.CommunicationType
    def set_CommunicationType(self, CommunicationType):
        self.CommunicationType = CommunicationType
    def get_ChargeValue(self):
        return self.ChargeValue
    def set_ChargeValue(self, ChargeValue):
        self.ChargeValue = ChargeValue
    def get_CurrencyCode(self):
        return self.CurrencyCode
    def set_CurrencyCode(self, CurrencyCode):
        self.CurrencyCode = CurrencyCode
    def get_IsWaived(self):
        return self.IsWaived
    def set_IsWaived(self, IsWaived):
        self.IsWaived = IsWaived
    def get_PaymentMethods(self):
        return self.PaymentMethods
    def set_PaymentMethods(self, PaymentMethods):
        self.PaymentMethods = PaymentMethods
    def validate_SpecialServiceType(self, value):
        result = True
        # Validate type SpecialServiceType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SpecialServiceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CommunicationAddress(self, value):
        result = True
        # Validate type CommunicationAddress, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 50:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CommunicationAddress' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CommunicationType(self, value):
        result = True
        # Validate type CommunicationType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['P', 'F']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CommunicationType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CommunicationType' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ChargeValue_Money(self, value):
        result = True
        # Validate type ChargeValue_Money, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ChargeValue_Money' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ChargeValue_Money' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_CurrencyCode(self, value):
        result = True
        # Validate type CurrencyCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CurrencyCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CurrencyCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CurrencyCode_patterns_, ))
                result = False
        return result
    validate_CurrencyCode_patterns_ = [['^([^ ].*[^ ])$']]
    def validate_YesNo(self, value):
        result = True
        # Validate type YesNo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on YesNo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on YesNo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.SpecialServiceType is not None or
            self.SpecialServiceDesc is not None or
            self.CommunicationAddress is not None or
            self.CommunicationType is not None or
            self.ChargeValue is not None or
            self.CurrencyCode is not None or
            self.IsWaived is not None or
            self.PaymentMethods is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SpecialService', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SpecialService')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SpecialService':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SpecialService')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SpecialService', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SpecialService'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SpecialService', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SpecialServiceType is not None:
            namespaceprefix_ = self.SpecialServiceType_nsprefix_ + ':' if (UseCapturedNS_ and self.SpecialServiceType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSpecialServiceType>%s</%sSpecialServiceType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SpecialServiceType), input_name='SpecialServiceType')), namespaceprefix_ , eol_))
        if self.SpecialServiceDesc is not None:
            namespaceprefix_ = self.SpecialServiceDesc_nsprefix_ + ':' if (UseCapturedNS_ and self.SpecialServiceDesc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSpecialServiceDesc>%s</%sSpecialServiceDesc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SpecialServiceDesc), input_name='SpecialServiceDesc')), namespaceprefix_ , eol_))
        if self.CommunicationAddress is not None:
            namespaceprefix_ = self.CommunicationAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.CommunicationAddress_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommunicationAddress>%s</%sCommunicationAddress>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CommunicationAddress), input_name='CommunicationAddress')), namespaceprefix_ , eol_))
        if self.CommunicationType is not None:
            namespaceprefix_ = self.CommunicationType_nsprefix_ + ':' if (UseCapturedNS_ and self.CommunicationType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCommunicationType>%s</%sCommunicationType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CommunicationType), input_name='CommunicationType')), namespaceprefix_ , eol_))
        if self.ChargeValue is not None:
            namespaceprefix_ = self.ChargeValue_nsprefix_ + ':' if (UseCapturedNS_ and self.ChargeValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sChargeValue>%s</%sChargeValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.ChargeValue, input_name='ChargeValue'), namespaceprefix_ , eol_))
        if self.CurrencyCode is not None:
            namespaceprefix_ = self.CurrencyCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CurrencyCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrencyCode>%s</%sCurrencyCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CurrencyCode), input_name='CurrencyCode')), namespaceprefix_ , eol_))
        if self.IsWaived is not None:
            namespaceprefix_ = self.IsWaived_nsprefix_ + ':' if (UseCapturedNS_ and self.IsWaived_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsWaived>%s</%sIsWaived>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IsWaived), input_name='IsWaived')), namespaceprefix_ , eol_))
        if self.PaymentMethods is not None:
            namespaceprefix_ = self.PaymentMethods_nsprefix_ + ':' if (UseCapturedNS_ and self.PaymentMethods_nsprefix_) else ''
            self.PaymentMethods.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PaymentMethods', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SpecialServiceType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SpecialServiceType')
            value_ = self.gds_validate_string(value_, node, 'SpecialServiceType')
            self.SpecialServiceType = value_
            self.SpecialServiceType_nsprefix_ = child_.prefix
            # validate type SpecialServiceType
            self.validate_SpecialServiceType(self.SpecialServiceType)
        elif nodeName_ == 'SpecialServiceDesc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SpecialServiceDesc')
            value_ = self.gds_validate_string(value_, node, 'SpecialServiceDesc')
            self.SpecialServiceDesc = value_
            self.SpecialServiceDesc_nsprefix_ = child_.prefix
        elif nodeName_ == 'CommunicationAddress':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CommunicationAddress')
            value_ = self.gds_validate_string(value_, node, 'CommunicationAddress')
            self.CommunicationAddress = value_
            self.CommunicationAddress_nsprefix_ = child_.prefix
            # validate type CommunicationAddress
            self.validate_CommunicationAddress(self.CommunicationAddress)
        elif nodeName_ == 'CommunicationType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CommunicationType')
            value_ = self.gds_validate_string(value_, node, 'CommunicationType')
            self.CommunicationType = value_
            self.CommunicationType_nsprefix_ = child_.prefix
            # validate type CommunicationType
            self.validate_CommunicationType(self.CommunicationType)
        elif nodeName_ == 'ChargeValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'ChargeValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'ChargeValue')
            self.ChargeValue = fval_
            self.ChargeValue_nsprefix_ = child_.prefix
            # validate type ChargeValue_Money
            self.validate_ChargeValue_Money(self.ChargeValue)
        elif nodeName_ == 'CurrencyCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CurrencyCode')
            value_ = self.gds_validate_string(value_, node, 'CurrencyCode')
            self.CurrencyCode = value_
            self.CurrencyCode_nsprefix_ = child_.prefix
            # validate type CurrencyCode
            self.validate_CurrencyCode(self.CurrencyCode)
        elif nodeName_ == 'IsWaived':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IsWaived')
            value_ = self.gds_validate_string(value_, node, 'IsWaived')
            self.IsWaived = value_
            self.IsWaived_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.IsWaived)
        elif nodeName_ == 'PaymentMethods':
            obj_ = PaymentMethods.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PaymentMethods = obj_
            obj_.original_tagname_ = 'PaymentMethods'
# end class SpecialService


class PaymentMethods(GeneratedsSuper):
    """PaymentMethods -- Payment methods
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PaymentMethod=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PaymentMethod = PaymentMethod
        self.validate_PaymentMethod(self.PaymentMethod)
        self.PaymentMethod_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PaymentMethods)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PaymentMethods.subclass:
            return PaymentMethods.subclass(*args_, **kwargs_)
        else:
            return PaymentMethods(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PaymentMethod(self):
        return self.PaymentMethod
    def set_PaymentMethod(self, PaymentMethod):
        self.PaymentMethod = PaymentMethod
    def validate_PaymentMethod(self, value):
        result = True
        # Validate type PaymentMethod, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PaymentMethod' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PaymentMethod' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.PaymentMethod is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PaymentMethods', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PaymentMethods')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PaymentMethods':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PaymentMethods')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PaymentMethods', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PaymentMethods'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PaymentMethods', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PaymentMethod is not None:
            namespaceprefix_ = self.PaymentMethod_nsprefix_ + ':' if (UseCapturedNS_ and self.PaymentMethod_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPaymentMethod>%s</%sPaymentMethod>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PaymentMethod), input_name='PaymentMethod')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PaymentMethod':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PaymentMethod')
            value_ = self.gds_validate_string(value_, node, 'PaymentMethod')
            self.PaymentMethod = value_
            self.PaymentMethod_nsprefix_ = child_.prefix
            # validate type PaymentMethod
            self.validate_PaymentMethod(self.PaymentMethod)
# end class PaymentMethods


class WeightSeg(GeneratedsSuper):
    """WeightSeg -- The weight element contains the weight information
    Weight -- The Weight element contains the weight of the pickup. It must be declared in the Weight element of Pickup
    WeightUnit -- The Weight Unit element contains the Unit by which the shipment weight is measured. It must be declared in the Weight element of the Pickup. The valid value for this element is K (Kilograms) and L (pounds). Please refer to Reference Data - DHL Country/Region for valid weight unit
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Weight=None, WeightUnit=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Weight = Weight
        self.validate_Weight(self.Weight)
        self.Weight_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.validate_WeightUnit(self.WeightUnit)
        self.WeightUnit_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, WeightSeg)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if WeightSeg.subclass:
            return WeightSeg.subclass(*args_, **kwargs_)
        else:
            return WeightSeg(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def validate_Weight(self, value):
        result = True
        # Validate type Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_WeightUnit(self, value):
        result = True
        # Validate type WeightUnit, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['K', 'L']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on WeightUnit' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.Weight is not None or
            self.WeightUnit is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='WeightSeg', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('WeightSeg')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'WeightSeg':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='WeightSeg')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='WeightSeg', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='WeightSeg'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='WeightSeg', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Weight')
            fval_ = self.gds_validate_decimal(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
            # validate type Weight
            self.validate_Weight(self.Weight)
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
            # validate type WeightUnit
            self.validate_WeightUnit(self.WeightUnit)
# end class WeightSeg


class Request(GeneratedsSuper):
    """Request -- Generic request header
    ServiceHeader -- The Service Header element contains the header information about the request message. This element must be declared only once in the Request element
    MetaData -- The Metadata element is used to identify the software name and software version used by customer or third party vendor. It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ServiceHeader=None, MetaData=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ServiceHeader = ServiceHeader
        self.ServiceHeader_nsprefix_ = None
        self.MetaData = MetaData
        self.MetaData_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Request)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Request.subclass:
            return Request.subclass(*args_, **kwargs_)
        else:
            return Request(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ServiceHeader(self):
        return self.ServiceHeader
    def set_ServiceHeader(self, ServiceHeader):
        self.ServiceHeader = ServiceHeader
    def get_MetaData(self):
        return self.MetaData
    def set_MetaData(self, MetaData):
        self.MetaData = MetaData
    def _hasContent(self):
        if (
            self.ServiceHeader is not None or
            self.MetaData is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Request', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Request')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Request':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Request')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Request', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Request'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Request', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ServiceHeader is not None:
            namespaceprefix_ = self.ServiceHeader_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceHeader_nsprefix_) else ''
            self.ServiceHeader.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceHeader', pretty_print=pretty_print)
        if self.MetaData is not None:
            namespaceprefix_ = self.MetaData_nsprefix_ + ':' if (UseCapturedNS_ and self.MetaData_nsprefix_) else ''
            self.MetaData.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MetaData', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ServiceHeader':
            obj_ = ServiceHeader.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceHeader = obj_
            obj_.original_tagname_ = 'ServiceHeader'
        elif nodeName_ == 'MetaData':
            obj_ = MetaData.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MetaData = obj_
            obj_.original_tagname_ = 'MetaData'
# end class Request


class ServiceHeader(GeneratedsSuper):
    """ServiceHeader -- Standard routing header
    MessageTime -- Time this message is sent
    GMTOffset -- The GMToffset element is a simple type of element which gives the time difference between the service areas time and GMT
    MessageReference -- A string, peferably number, to uniquely identify individual messages. Minimum length must be 28 and maximum length is 32
    SiteID -- The site id element is used to identify the requestor of the message. Each partner/customer is provided with the site id and password. Each request message received is validated with this before proceeding forward
    Password -- The password element is used to identify the requestor of the message. Each partner/customer is provided with the site id and password. Each request message received is validated with this before proceeding forward
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, MessageTime=None, GMTOffset=None, MessageReference=None, SiteID=None, Password=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(MessageTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(MessageTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = MessageTime
        self.MessageTime = initvalue_
        self.MessageTime_nsprefix_ = None
        self.GMTOffset = GMTOffset
        self.GMTOffset_nsprefix_ = None
        self.MessageReference = MessageReference
        self.validate_MessageReference(self.MessageReference)
        self.MessageReference_nsprefix_ = None
        self.SiteID = SiteID
        self.validate_SiteID(self.SiteID)
        self.SiteID_nsprefix_ = None
        self.Password = Password
        self.validate_Password(self.Password)
        self.Password_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ServiceHeader)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceHeader.subclass:
            return ServiceHeader.subclass(*args_, **kwargs_)
        else:
            return ServiceHeader(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_MessageTime(self):
        return self.MessageTime
    def set_MessageTime(self, MessageTime):
        self.MessageTime = MessageTime
    def get_GMTOffset(self):
        return self.GMTOffset
    def set_GMTOffset(self, GMTOffset):
        self.GMTOffset = GMTOffset
    def get_MessageReference(self):
        return self.MessageReference
    def set_MessageReference(self, MessageReference):
        self.MessageReference = MessageReference
    def get_SiteID(self):
        return self.SiteID
    def set_SiteID(self, SiteID):
        self.SiteID = SiteID
    def get_Password(self):
        return self.Password
    def set_Password(self, Password):
        self.Password = Password
    def validate_MessageReference(self, value):
        result = True
        # Validate type MessageReference, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 32:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on MessageReference' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 28:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on MessageReference' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SiteID(self, value):
        result = True
        # Validate type SiteID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SiteID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on SiteID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Password(self, value):
        result = True
        # Validate type Password, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Password' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 8:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on Password' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.MessageTime is not None or
            self.GMTOffset is not None or
            self.MessageReference is not None or
            self.SiteID is not None or
            self.Password is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ServiceHeader', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ServiceHeader')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ServiceHeader':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ServiceHeader')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ServiceHeader', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ServiceHeader'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ServiceHeader', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MessageTime is not None:
            namespaceprefix_ = self.MessageTime_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageTime_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMessageTime>%s</%sMessageTime>%s' % (namespaceprefix_ , self.gds_format_datetime(self.MessageTime, input_name='MessageTime'), namespaceprefix_ , eol_))
        if self.GMTOffset is not None:
            namespaceprefix_ = self.GMTOffset_nsprefix_ + ':' if (UseCapturedNS_ and self.GMTOffset_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sGMTOffset>%s</%sGMTOffset>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.GMTOffset), input_name='GMTOffset')), namespaceprefix_ , eol_))
        if self.MessageReference is not None:
            namespaceprefix_ = self.MessageReference_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageReference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMessageReference>%s</%sMessageReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.MessageReference), input_name='MessageReference')), namespaceprefix_ , eol_))
        if self.SiteID is not None:
            namespaceprefix_ = self.SiteID_nsprefix_ + ':' if (UseCapturedNS_ and self.SiteID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSiteID>%s</%sSiteID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SiteID), input_name='SiteID')), namespaceprefix_ , eol_))
        if self.Password is not None:
            namespaceprefix_ = self.Password_nsprefix_ + ':' if (UseCapturedNS_ and self.Password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPassword>%s</%sPassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Password), input_name='Password')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'MessageTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.MessageTime = dval_
            self.MessageTime_nsprefix_ = child_.prefix
        elif nodeName_ == 'GMTOffset':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'GMTOffset')
            value_ = self.gds_validate_string(value_, node, 'GMTOffset')
            self.GMTOffset = value_
            self.GMTOffset_nsprefix_ = child_.prefix
        elif nodeName_ == 'MessageReference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'MessageReference')
            value_ = self.gds_validate_string(value_, node, 'MessageReference')
            self.MessageReference = value_
            self.MessageReference_nsprefix_ = child_.prefix
            # validate type MessageReference
            self.validate_MessageReference(self.MessageReference)
        elif nodeName_ == 'SiteID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SiteID')
            value_ = self.gds_validate_string(value_, node, 'SiteID')
            self.SiteID = value_
            self.SiteID_nsprefix_ = child_.prefix
            # validate type SiteID
            self.validate_SiteID(self.SiteID)
        elif nodeName_ == 'Password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Password')
            value_ = self.gds_validate_string(value_, node, 'Password')
            self.Password = value_
            self.Password_nsprefix_ = child_.prefix
            # validate type Password
            self.validate_Password(self.Password)
# end class ServiceHeader


class MetaData(GeneratedsSuper):
    """MetaData -- MetaData header
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, SoftwareName=None, SoftwareVersion=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.SoftwareName = SoftwareName
        self.validate_SoftwareNameType(self.SoftwareName)
        self.SoftwareName_nsprefix_ = None
        self.SoftwareVersion = SoftwareVersion
        self.validate_SoftwareVersionType(self.SoftwareVersion)
        self.SoftwareVersion_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MetaData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MetaData.subclass:
            return MetaData.subclass(*args_, **kwargs_)
        else:
            return MetaData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_SoftwareName(self):
        return self.SoftwareName
    def set_SoftwareName(self, SoftwareName):
        self.SoftwareName = SoftwareName
    def get_SoftwareVersion(self):
        return self.SoftwareVersion
    def set_SoftwareVersion(self, SoftwareVersion):
        self.SoftwareVersion = SoftwareVersion
    def validate_SoftwareNameType(self, value):
        result = True
        # Validate type SoftwareNameType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SoftwareNameType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SoftwareVersionType(self, value):
        result = True
        # Validate type SoftwareVersionType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SoftwareVersionType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.SoftwareName is not None or
            self.SoftwareVersion is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='MetaData', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MetaData')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MetaData':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MetaData')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MetaData', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MetaData'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='MetaData', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SoftwareName is not None:
            namespaceprefix_ = self.SoftwareName_nsprefix_ + ':' if (UseCapturedNS_ and self.SoftwareName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSoftwareName>%s</%sSoftwareName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SoftwareName), input_name='SoftwareName')), namespaceprefix_ , eol_))
        if self.SoftwareVersion is not None:
            namespaceprefix_ = self.SoftwareVersion_nsprefix_ + ':' if (UseCapturedNS_ and self.SoftwareVersion_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSoftwareVersion>%s</%sSoftwareVersion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SoftwareVersion), input_name='SoftwareVersion')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SoftwareName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SoftwareName')
            value_ = self.gds_validate_string(value_, node, 'SoftwareName')
            self.SoftwareName = value_
            self.SoftwareName_nsprefix_ = child_.prefix
            # validate type SoftwareNameType
            self.validate_SoftwareNameType(self.SoftwareName)
        elif nodeName_ == 'SoftwareVersion':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SoftwareVersion')
            value_ = self.gds_validate_string(value_, node, 'SoftwareVersion')
            self.SoftwareVersion = value_
            self.SoftwareVersion_nsprefix_ = child_.prefix
            # validate type SoftwareVersionType
            self.validate_SoftwareVersionType(self.SoftwareVersion)
# end class MetaData


class Response(GeneratedsSuper):
    """Response -- Generic response header
    ServiceHeader -- The ServiceHeader element contains the header information about the request message. This element must be declared only once in the Request element
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ServiceHeader=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ServiceHeader = ServiceHeader
        self.ServiceHeader_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Response)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Response.subclass:
            return Response.subclass(*args_, **kwargs_)
        else:
            return Response(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ServiceHeader(self):
        return self.ServiceHeader
    def set_ServiceHeader(self, ServiceHeader):
        self.ServiceHeader = ServiceHeader
    def _hasContent(self):
        if (
            self.ServiceHeader is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Response', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Response')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Response':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Response')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Response', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Response'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Response', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ServiceHeader is not None:
            namespaceprefix_ = self.ServiceHeader_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceHeader_nsprefix_) else ''
            self.ServiceHeader.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceHeader', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ServiceHeader':
            obj_ = ResponseServiceHeader.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceHeader = obj_
            obj_.original_tagname_ = 'ServiceHeader'
# end class Response


class ResponseServiceHeader(GeneratedsSuper):
    """ResponseServiceHeader -- Standard routing header
    MessageTime -- Time this message is sent
    MessageReference -- A string, peferably number, to uniquely identify individual messages. Minimum length must be 28 and maximum length is 32
    SiteID -- The site id element is used to identify the requestor of the message. Each partner/customer is provided with the site id and password. Each request message received is validated with this before proceeding forward
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, MessageTime=None, MessageReference=None, SiteID=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(MessageTime, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(MessageTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = MessageTime
        self.MessageTime = initvalue_
        self.MessageTime_nsprefix_ = None
        self.MessageReference = MessageReference
        self.validate_MessageReference(self.MessageReference)
        self.MessageReference_nsprefix_ = None
        self.SiteID = SiteID
        self.validate_SiteID(self.SiteID)
        self.SiteID_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseServiceHeader)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseServiceHeader.subclass:
            return ResponseServiceHeader.subclass(*args_, **kwargs_)
        else:
            return ResponseServiceHeader(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_MessageTime(self):
        return self.MessageTime
    def set_MessageTime(self, MessageTime):
        self.MessageTime = MessageTime
    def get_MessageReference(self):
        return self.MessageReference
    def set_MessageReference(self, MessageReference):
        self.MessageReference = MessageReference
    def get_SiteID(self):
        return self.SiteID
    def set_SiteID(self, SiteID):
        self.SiteID = SiteID
    def validate_MessageReference(self, value):
        result = True
        # Validate type MessageReference, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 32:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on MessageReference' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 28:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on MessageReference' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_SiteID(self, value):
        result = True
        # Validate type SiteID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on SiteID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 6:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on SiteID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.MessageTime is not None or
            self.MessageReference is not None or
            self.SiteID is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseServiceHeader', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseServiceHeader')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseServiceHeader':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseServiceHeader')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseServiceHeader', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseServiceHeader'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseServiceHeader', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.MessageTime is not None:
            namespaceprefix_ = self.MessageTime_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageTime_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMessageTime>%s</%sMessageTime>%s' % (namespaceprefix_ , self.gds_format_datetime(self.MessageTime, input_name='MessageTime'), namespaceprefix_ , eol_))
        if self.MessageReference is not None:
            namespaceprefix_ = self.MessageReference_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageReference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMessageReference>%s</%sMessageReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.MessageReference), input_name='MessageReference')), namespaceprefix_ , eol_))
        if self.SiteID is not None:
            namespaceprefix_ = self.SiteID_nsprefix_ + ':' if (UseCapturedNS_ and self.SiteID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSiteID>%s</%sSiteID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SiteID), input_name='SiteID')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'MessageTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.MessageTime = dval_
            self.MessageTime_nsprefix_ = child_.prefix
        elif nodeName_ == 'MessageReference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'MessageReference')
            value_ = self.gds_validate_string(value_, node, 'MessageReference')
            self.MessageReference = value_
            self.MessageReference_nsprefix_ = child_.prefix
            # validate type MessageReference
            self.validate_MessageReference(self.MessageReference)
        elif nodeName_ == 'SiteID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SiteID')
            value_ = self.gds_validate_string(value_, node, 'SiteID')
            self.SiteID = value_
            self.SiteID_nsprefix_ = child_.prefix
            # validate type SiteID
            self.validate_SiteID(self.SiteID)
# end class ResponseServiceHeader


class Status(GeneratedsSuper):
    """Status -- Status/Exception signal element
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ActionStatus=None, Condition=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ActionStatus = ActionStatus
        self.ActionStatus_nsprefix_ = None
        if Condition is None:
            self.Condition = []
        else:
            self.Condition = Condition
        self.Condition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Status)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Status.subclass:
            return Status.subclass(*args_, **kwargs_)
        else:
            return Status(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ActionStatus(self):
        return self.ActionStatus
    def set_ActionStatus(self, ActionStatus):
        self.ActionStatus = ActionStatus
    def get_Condition(self):
        return self.Condition
    def set_Condition(self, Condition):
        self.Condition = Condition
    def add_Condition(self, value):
        self.Condition.append(value)
    def insert_Condition_at(self, index, value):
        self.Condition.insert(index, value)
    def replace_Condition_at(self, index, value):
        self.Condition[index] = value
    def _hasContent(self):
        if (
            self.ActionStatus is not None or
            self.Condition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Status', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Status')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Status':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Status')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Status', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Status'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Status', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ActionStatus is not None:
            namespaceprefix_ = self.ActionStatus_nsprefix_ + ':' if (UseCapturedNS_ and self.ActionStatus_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sActionStatus>%s</%sActionStatus>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ActionStatus), input_name='ActionStatus')), namespaceprefix_ , eol_))
        for Condition_ in self.Condition:
            namespaceprefix_ = self.Condition_nsprefix_ + ':' if (UseCapturedNS_ and self.Condition_nsprefix_) else ''
            Condition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Condition', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ActionStatus':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ActionStatus')
            value_ = self.gds_validate_string(value_, node, 'ActionStatus')
            self.ActionStatus = value_
            self.ActionStatus_nsprefix_ = child_.prefix
        elif nodeName_ == 'Condition':
            obj_ = Condition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Condition.append(obj_)
            obj_.original_tagname_ = 'Condition'
# end class Status


class Note(GeneratedsSuper):
    """Note -- Note/Warning
    ActionNote -- The Action note is returned by the eCom backend in response to the Pickup Request send to it. It is a mandatory field in the Note Segment
    Condition -- The Condition note element is an optional field. It is a complex element which consists of ConditionCode and ConditionData
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ActionNote=None, Condition=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ActionNote = ActionNote
        self.ActionNote_nsprefix_ = None
        if Condition is None:
            self.Condition = []
        else:
            self.Condition = Condition
        self.Condition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Note)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Note.subclass:
            return Note.subclass(*args_, **kwargs_)
        else:
            return Note(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ActionNote(self):
        return self.ActionNote
    def set_ActionNote(self, ActionNote):
        self.ActionNote = ActionNote
    def get_Condition(self):
        return self.Condition
    def set_Condition(self, Condition):
        self.Condition = Condition
    def add_Condition(self, value):
        self.Condition.append(value)
    def insert_Condition_at(self, index, value):
        self.Condition.insert(index, value)
    def replace_Condition_at(self, index, value):
        self.Condition[index] = value
    def _hasContent(self):
        if (
            self.ActionNote is not None or
            self.Condition
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Note', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Note')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Note':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Note')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Note', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Note'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Note', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ActionNote is not None:
            namespaceprefix_ = self.ActionNote_nsprefix_ + ':' if (UseCapturedNS_ and self.ActionNote_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sActionNote>%s</%sActionNote>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ActionNote), input_name='ActionNote')), namespaceprefix_ , eol_))
        for Condition_ in self.Condition:
            namespaceprefix_ = self.Condition_nsprefix_ + ':' if (UseCapturedNS_ and self.Condition_nsprefix_) else ''
            Condition_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Condition', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ActionNote':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ActionNote')
            value_ = self.gds_validate_string(value_, node, 'ActionNote')
            self.ActionNote = value_
            self.ActionNote_nsprefix_ = child_.prefix
        elif nodeName_ == 'Condition':
            obj_ = Condition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Condition.append(obj_)
            obj_.original_tagname_ = 'Condition'
# end class Note


class Condition(GeneratedsSuper):
    """Condition -- The Condition note element is an optional field. It is a complex element which consists of ConditionCode and ConditionData
    ConditionCode -- The condition code element contains the code for the condtion. It is a mandatory field in the Condtion segment
    ConditionData -- The Condition Data element contains the data for the condition. It is an optional field in the Condition segment
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ConditionCode=None, ConditionData=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ConditionCode = ConditionCode
        self.ConditionCode_nsprefix_ = None
        self.ConditionData = ConditionData
        self.ConditionData_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Condition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Condition.subclass:
            return Condition.subclass(*args_, **kwargs_)
        else:
            return Condition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ConditionCode(self):
        return self.ConditionCode
    def set_ConditionCode(self, ConditionCode):
        self.ConditionCode = ConditionCode
    def get_ConditionData(self):
        return self.ConditionData
    def set_ConditionData(self, ConditionData):
        self.ConditionData = ConditionData
    def _hasContent(self):
        if (
            self.ConditionCode is not None or
            self.ConditionData is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Condition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Condition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Condition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Condition')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Condition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Condition'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Condition', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ConditionCode is not None:
            namespaceprefix_ = self.ConditionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ConditionCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConditionCode>%s</%sConditionCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConditionCode), input_name='ConditionCode')), namespaceprefix_ , eol_))
        if self.ConditionData is not None:
            namespaceprefix_ = self.ConditionData_nsprefix_ + ':' if (UseCapturedNS_ and self.ConditionData_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConditionData>%s</%sConditionData>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConditionData), input_name='ConditionData')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ConditionCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConditionCode')
            value_ = self.gds_validate_string(value_, node, 'ConditionCode')
            self.ConditionCode = value_
            self.ConditionCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConditionData':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConditionData')
            value_ = self.gds_validate_string(value_, node, 'ConditionData')
            self.ConditionData = value_
            self.ConditionData_nsprefix_ = child_.prefix
# end class Condition


class Customer(GeneratedsSuper):
    """Customer -- Customer
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomerID=None, Name=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CustomerID = CustomerID
        self.CustomerID_nsprefix_ = None
        self.Name = Name
        self.Name_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Customer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Customer.subclass:
            return Customer.subclass(*args_, **kwargs_)
        else:
            return Customer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomerID(self):
        return self.CustomerID
    def set_CustomerID(self, CustomerID):
        self.CustomerID = CustomerID
    def get_Name(self):
        return self.Name
    def set_Name(self, Name):
        self.Name = Name
    def _hasContent(self):
        if (
            self.CustomerID is not None or
            self.Name is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Customer', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Customer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Customer':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Customer')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Customer', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Customer'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Customer', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CustomerID is not None:
            namespaceprefix_ = self.CustomerID_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerID>%s</%sCustomerID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerID), input_name='CustomerID')), namespaceprefix_ , eol_))
        if self.Name is not None:
            namespaceprefix_ = self.Name_nsprefix_ + ':' if (UseCapturedNS_ and self.Name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomerID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomerID')
            value_ = self.gds_validate_string(value_, node, 'CustomerID')
            self.CustomerID = value_
            self.CustomerID_nsprefix_ = child_.prefix
        elif nodeName_ == 'Name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Name')
            value_ = self.gds_validate_string(value_, node, 'Name')
            self.Name = value_
            self.Name_nsprefix_ = child_.prefix
# end class Customer


class BarCodes(GeneratedsSuper):
    """BarCodes -- Element containing BarCode data
    BarCode -- Contains barcodes as Base64 encoded binary data
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, BarCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if BarCode is None:
            self.BarCode = []
        else:
            self.BarCode = BarCode
        self.BarCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BarCodes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BarCodes.subclass:
            return BarCodes.subclass(*args_, **kwargs_)
        else:
            return BarCodes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_BarCode(self):
        return self.BarCode
    def set_BarCode(self, BarCode):
        self.BarCode = BarCode
    def add_BarCode(self, value):
        self.BarCode.append(value)
    def insert_BarCode_at(self, index, value):
        self.BarCode.insert(index, value)
    def replace_BarCode_at(self, index, value):
        self.BarCode[index] = value
    def validate_BarCode(self, value):
        result = True
        # Validate type BarCode, a restriction on xsd:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
        return result
    def _hasContent(self):
        if (
            self.BarCode
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BarCodes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BarCodes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BarCodes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BarCodes')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BarCodes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BarCodes'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BarCodes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for BarCode_ in self.BarCode:
            namespaceprefix_ = self.BarCode_nsprefix_ + ':' if (UseCapturedNS_ and self.BarCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBarCode>%s</%sBarCode>%s' % (namespaceprefix_ , self.gds_format_base64(BarCode_, input_name='BarCode'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'BarCode':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'BarCode')
            else:
                bval_ = None
            self.BarCode.append(bval_)
            self.BarCode_nsprefix_ = child_.prefix
            # validate type BarCode
            self.validate_BarCode(self.BarCode[-1])
# end class BarCodes


class DestinationServiceArea(GeneratedsSuper):
    """DestinationServiceArea -- The DestinationServiceArea element contains the information of the shipment
    ’
    s destination along with the facility code and the inbound sort code information
    ServiceAreaCode -- Three letter service area code
    Description -- Detailed description for the Area code such as city, state,country etc
    FacilityCode -- Destination Facility Code
    InboundSortCode -- InBound Sort Code
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ServiceAreaCode=None, Description=None, FacilityCode=None, InboundSortCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ServiceAreaCode = ServiceAreaCode
        self.validate_ServiceAreaCode(self.ServiceAreaCode)
        self.ServiceAreaCode_nsprefix_ = None
        self.Description = Description
        self.Description_nsprefix_ = None
        self.FacilityCode = FacilityCode
        self.validate_FacilityCode(self.FacilityCode)
        self.FacilityCode_nsprefix_ = None
        self.InboundSortCode = InboundSortCode
        self.validate_InboundSortCode(self.InboundSortCode)
        self.InboundSortCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DestinationServiceArea)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DestinationServiceArea.subclass:
            return DestinationServiceArea.subclass(*args_, **kwargs_)
        else:
            return DestinationServiceArea(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ServiceAreaCode(self):
        return self.ServiceAreaCode
    def set_ServiceAreaCode(self, ServiceAreaCode):
        self.ServiceAreaCode = ServiceAreaCode
    def get_Description(self):
        return self.Description
    def set_Description(self, Description):
        self.Description = Description
    def get_FacilityCode(self):
        return self.FacilityCode
    def set_FacilityCode(self, FacilityCode):
        self.FacilityCode = FacilityCode
    def get_InboundSortCode(self):
        return self.InboundSortCode
    def set_InboundSortCode(self, InboundSortCode):
        self.InboundSortCode = InboundSortCode
    def validate_ServiceAreaCode(self, value):
        result = True
        # Validate type ServiceAreaCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ServiceAreaCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_FacilityCode(self, value):
        result = True
        # Validate type FacilityCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on FacilityCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_InboundSortCode(self, value):
        result = True
        # Validate type InboundSortCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on InboundSortCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on InboundSortCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ServiceAreaCode is not None or
            self.Description is not None or
            self.FacilityCode is not None or
            self.InboundSortCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DestinationServiceArea', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DestinationServiceArea')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DestinationServiceArea':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DestinationServiceArea')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DestinationServiceArea', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DestinationServiceArea'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DestinationServiceArea', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ServiceAreaCode is not None:
            namespaceprefix_ = self.ServiceAreaCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceAreaCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sServiceAreaCode>%s</%sServiceAreaCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ServiceAreaCode), input_name='ServiceAreaCode')), namespaceprefix_ , eol_))
        if self.Description is not None:
            namespaceprefix_ = self.Description_nsprefix_ + ':' if (UseCapturedNS_ and self.Description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Description), input_name='Description')), namespaceprefix_ , eol_))
        if self.FacilityCode is not None:
            namespaceprefix_ = self.FacilityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.FacilityCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFacilityCode>%s</%sFacilityCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FacilityCode), input_name='FacilityCode')), namespaceprefix_ , eol_))
        if self.InboundSortCode is not None:
            namespaceprefix_ = self.InboundSortCode_nsprefix_ + ':' if (UseCapturedNS_ and self.InboundSortCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInboundSortCode>%s</%sInboundSortCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InboundSortCode), input_name='InboundSortCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ServiceAreaCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ServiceAreaCode')
            value_ = self.gds_validate_string(value_, node, 'ServiceAreaCode')
            self.ServiceAreaCode = value_
            self.ServiceAreaCode_nsprefix_ = child_.prefix
            # validate type ServiceAreaCode
            self.validate_ServiceAreaCode(self.ServiceAreaCode)
        elif nodeName_ == 'Description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Description')
            value_ = self.gds_validate_string(value_, node, 'Description')
            self.Description = value_
            self.Description_nsprefix_ = child_.prefix
        elif nodeName_ == 'FacilityCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FacilityCode')
            value_ = self.gds_validate_string(value_, node, 'FacilityCode')
            self.FacilityCode = value_
            self.FacilityCode_nsprefix_ = child_.prefix
            # validate type FacilityCode
            self.validate_FacilityCode(self.FacilityCode)
        elif nodeName_ == 'InboundSortCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InboundSortCode')
            value_ = self.gds_validate_string(value_, node, 'InboundSortCode')
            self.InboundSortCode = value_
            self.InboundSortCode_nsprefix_ = child_.prefix
            # validate type InboundSortCode
            self.validate_InboundSortCode(self.InboundSortCode)
# end class DestinationServiceArea


class OriginServiceArea(GeneratedsSuper):
    """OriginServiceArea -- The OriginServiceArea element contains the information of the shipment
    ’
    s origin along with the outbound sort code info
    ServiceAreaCode -- Three letter service area code
    Description -- Detailed description for the Area code such as city, state,country etc
    FacilityCode -- Origin Facility Code
    OutboundSortCode -- OutBound Sort Code
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ServiceAreaCode=None, Description=None, FacilityCode=None, OutboundSortCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ServiceAreaCode = ServiceAreaCode
        self.validate_ServiceAreaCode(self.ServiceAreaCode)
        self.ServiceAreaCode_nsprefix_ = None
        self.Description = Description
        self.Description_nsprefix_ = None
        self.FacilityCode = FacilityCode
        self.validate_FacilityCode(self.FacilityCode)
        self.FacilityCode_nsprefix_ = None
        self.OutboundSortCode = OutboundSortCode
        self.validate_OutboundSortCode(self.OutboundSortCode)
        self.OutboundSortCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OriginServiceArea)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OriginServiceArea.subclass:
            return OriginServiceArea.subclass(*args_, **kwargs_)
        else:
            return OriginServiceArea(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ServiceAreaCode(self):
        return self.ServiceAreaCode
    def set_ServiceAreaCode(self, ServiceAreaCode):
        self.ServiceAreaCode = ServiceAreaCode
    def get_Description(self):
        return self.Description
    def set_Description(self, Description):
        self.Description = Description
    def get_FacilityCode(self):
        return self.FacilityCode
    def set_FacilityCode(self, FacilityCode):
        self.FacilityCode = FacilityCode
    def get_OutboundSortCode(self):
        return self.OutboundSortCode
    def set_OutboundSortCode(self, OutboundSortCode):
        self.OutboundSortCode = OutboundSortCode
    def validate_ServiceAreaCode(self, value):
        result = True
        # Validate type ServiceAreaCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ServiceAreaCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_FacilityCode(self, value):
        result = True
        # Validate type FacilityCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on FacilityCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_OutboundSortCode(self, value):
        result = True
        # Validate type OutboundSortCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 4:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on OutboundSortCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on OutboundSortCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ServiceAreaCode is not None or
            self.Description is not None or
            self.FacilityCode is not None or
            self.OutboundSortCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OriginServiceArea', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OriginServiceArea')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OriginServiceArea':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OriginServiceArea')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OriginServiceArea', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OriginServiceArea'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OriginServiceArea', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ServiceAreaCode is not None:
            namespaceprefix_ = self.ServiceAreaCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceAreaCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sServiceAreaCode>%s</%sServiceAreaCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ServiceAreaCode), input_name='ServiceAreaCode')), namespaceprefix_ , eol_))
        if self.Description is not None:
            namespaceprefix_ = self.Description_nsprefix_ + ':' if (UseCapturedNS_ and self.Description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Description), input_name='Description')), namespaceprefix_ , eol_))
        if self.FacilityCode is not None:
            namespaceprefix_ = self.FacilityCode_nsprefix_ + ':' if (UseCapturedNS_ and self.FacilityCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFacilityCode>%s</%sFacilityCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FacilityCode), input_name='FacilityCode')), namespaceprefix_ , eol_))
        if self.OutboundSortCode is not None:
            namespaceprefix_ = self.OutboundSortCode_nsprefix_ + ':' if (UseCapturedNS_ and self.OutboundSortCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOutboundSortCode>%s</%sOutboundSortCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OutboundSortCode), input_name='OutboundSortCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ServiceAreaCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ServiceAreaCode')
            value_ = self.gds_validate_string(value_, node, 'ServiceAreaCode')
            self.ServiceAreaCode = value_
            self.ServiceAreaCode_nsprefix_ = child_.prefix
            # validate type ServiceAreaCode
            self.validate_ServiceAreaCode(self.ServiceAreaCode)
        elif nodeName_ == 'Description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Description')
            value_ = self.gds_validate_string(value_, node, 'Description')
            self.Description = value_
            self.Description_nsprefix_ = child_.prefix
        elif nodeName_ == 'FacilityCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FacilityCode')
            value_ = self.gds_validate_string(value_, node, 'FacilityCode')
            self.FacilityCode = value_
            self.FacilityCode_nsprefix_ = child_.prefix
            # validate type FacilityCode
            self.validate_FacilityCode(self.FacilityCode)
        elif nodeName_ == 'OutboundSortCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OutboundSortCode')
            value_ = self.gds_validate_string(value_, node, 'OutboundSortCode')
            self.OutboundSortCode = value_
            self.OutboundSortCode_nsprefix_ = child_.prefix
            # validate type OutboundSortCode
            self.validate_OutboundSortCode(self.OutboundSortCode)
# end class OriginServiceArea


class ServiceArea(GeneratedsSuper):
    """ServiceAreaCode -- three letter service area code
    Description -- Detailed description for the Area code such as city, state,country etc
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ServiceAreaCode=None, Description=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ServiceAreaCode = ServiceAreaCode
        self.validate_ServiceAreaCode(self.ServiceAreaCode)
        self.ServiceAreaCode_nsprefix_ = None
        self.Description = Description
        self.Description_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ServiceArea)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceArea.subclass:
            return ServiceArea.subclass(*args_, **kwargs_)
        else:
            return ServiceArea(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ServiceAreaCode(self):
        return self.ServiceAreaCode
    def set_ServiceAreaCode(self, ServiceAreaCode):
        self.ServiceAreaCode = ServiceAreaCode
    def get_Description(self):
        return self.Description
    def set_Description(self, Description):
        self.Description = Description
    def validate_ServiceAreaCode(self, value):
        result = True
        # Validate type ServiceAreaCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on ServiceAreaCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ServiceAreaCode is not None or
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ServiceArea', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ServiceArea')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ServiceArea':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ServiceArea')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ServiceArea', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ServiceArea'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ServiceArea', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ServiceAreaCode is not None:
            namespaceprefix_ = self.ServiceAreaCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceAreaCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sServiceAreaCode>%s</%sServiceAreaCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ServiceAreaCode), input_name='ServiceAreaCode')), namespaceprefix_ , eol_))
        if self.Description is not None:
            namespaceprefix_ = self.Description_nsprefix_ + ':' if (UseCapturedNS_ and self.Description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Description), input_name='Description')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ServiceAreaCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ServiceAreaCode')
            value_ = self.gds_validate_string(value_, node, 'ServiceAreaCode')
            self.ServiceAreaCode = value_
            self.ServiceAreaCode_nsprefix_ = child_.prefix
            # validate type ServiceAreaCode
            self.validate_ServiceAreaCode(self.ServiceAreaCode)
        elif nodeName_ == 'Description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Description')
            value_ = self.gds_validate_string(value_, node, 'Description')
            self.Description = value_
            self.Description_nsprefix_ = child_.prefix
# end class ServiceArea


class ServiceEvent(GeneratedsSuper):
    """ServiceEvent -- Complex type to describe a service event. Eg Pickup, Delivery
    EventCode -- Two letter Code denoting a specific service event
    Description -- Description of the service event code
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, EventCode=None, Description=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.EventCode = EventCode
        self.validate_EventCodeType(self.EventCode)
        self.EventCode_nsprefix_ = None
        self.Description = Description
        self.Description_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ServiceEvent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ServiceEvent.subclass:
            return ServiceEvent.subclass(*args_, **kwargs_)
        else:
            return ServiceEvent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_EventCode(self):
        return self.EventCode
    def set_EventCode(self, EventCode):
        self.EventCode = EventCode
    def get_Description(self):
        return self.Description
    def set_Description(self, Description):
        self.Description = Description
    def validate_EventCodeType(self, value):
        result = True
        # Validate type EventCodeType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on EventCodeType' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.EventCode is not None or
            self.Description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ServiceEvent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ServiceEvent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ServiceEvent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ServiceEvent')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ServiceEvent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ServiceEvent'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ServiceEvent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.EventCode is not None:
            namespaceprefix_ = self.EventCode_nsprefix_ + ':' if (UseCapturedNS_ and self.EventCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEventCode>%s</%sEventCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.EventCode), input_name='EventCode')), namespaceprefix_ , eol_))
        if self.Description is not None:
            namespaceprefix_ = self.Description_nsprefix_ + ':' if (UseCapturedNS_ and self.Description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDescription>%s</%sDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Description), input_name='Description')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'EventCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'EventCode')
            value_ = self.gds_validate_string(value_, node, 'EventCode')
            self.EventCode = value_
            self.EventCode_nsprefix_ = child_.prefix
            # validate type EventCodeType
            self.validate_EventCodeType(self.EventCode)
        elif nodeName_ == 'Description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Description')
            value_ = self.gds_validate_string(value_, node, 'Description')
            self.Description = value_
            self.Description_nsprefix_ = child_.prefix
# end class ServiceEvent


class ShipmentDate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ShipmentDateFrom=None, ShipmentDateTo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(ShipmentDateFrom, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(ShipmentDateFrom, '%Y-%m-%d').date()
        else:
            initvalue_ = ShipmentDateFrom
        self.ShipmentDateFrom = initvalue_
        self.ShipmentDateFrom_nsprefix_ = None
        if isinstance(ShipmentDateTo, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(ShipmentDateTo, '%Y-%m-%d').date()
        else:
            initvalue_ = ShipmentDateTo
        self.ShipmentDateTo = initvalue_
        self.ShipmentDateTo_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipmentDate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentDate.subclass:
            return ShipmentDate.subclass(*args_, **kwargs_)
        else:
            return ShipmentDate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ShipmentDateFrom(self):
        return self.ShipmentDateFrom
    def set_ShipmentDateFrom(self, ShipmentDateFrom):
        self.ShipmentDateFrom = ShipmentDateFrom
    def get_ShipmentDateTo(self):
        return self.ShipmentDateTo
    def set_ShipmentDateTo(self, ShipmentDateTo):
        self.ShipmentDateTo = ShipmentDateTo
    def validate_Date(self, value):
        result = True
        # Validate type Date, a restriction on xsd:date.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, datetime_.date):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (datetime_.date)' % {"value": value, "lineno": lineno, })
                return False
            value = str(value)
            if not self.gds_validate_simple_patterns(
                    self.validate_Date_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_Date_patterns_, ))
                result = False
        return result
    validate_Date_patterns_ = [['^([0-9][0-9][0-9][0-9](-)[0-9][0-9](-)[0-9][0-9])$']]
    def _hasContent(self):
        if (
            self.ShipmentDateFrom is not None or
            self.ShipmentDateTo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentDate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipmentDate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipmentDate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipmentDate')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipmentDate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipmentDate'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentDate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ShipmentDateFrom is not None:
            namespaceprefix_ = self.ShipmentDateFrom_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentDateFrom_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentDateFrom>%s</%sShipmentDateFrom>%s' % (namespaceprefix_ , self.gds_format_date(self.ShipmentDateFrom, input_name='ShipmentDateFrom'), namespaceprefix_ , eol_))
        if self.ShipmentDateTo is not None:
            namespaceprefix_ = self.ShipmentDateTo_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentDateTo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentDateTo>%s</%sShipmentDateTo>%s' % (namespaceprefix_ , self.gds_format_date(self.ShipmentDateTo, input_name='ShipmentDateTo'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ShipmentDateFrom':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.ShipmentDateFrom = dval_
            self.ShipmentDateFrom_nsprefix_ = child_.prefix
            # validate type Date
            self.validate_Date(self.ShipmentDateFrom)
        elif nodeName_ == 'ShipmentDateTo':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.ShipmentDateTo = dval_
            self.ShipmentDateTo_nsprefix_ = child_.prefix
            # validate type Date
            self.validate_Date(self.ShipmentDateTo)
# end class ShipmentDate


class AWBInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AWBNumber=None, Status=None, ShipmentInfo=None, PieceInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AWBNumber = AWBNumber
        self.validate_AWBNumber(self.AWBNumber)
        self.AWBNumber_nsprefix_ = None
        self.Status = Status
        self.Status_nsprefix_ = None
        self.ShipmentInfo = ShipmentInfo
        self.ShipmentInfo_nsprefix_ = None
        if PieceInfo is None:
            self.PieceInfo = []
        else:
            self.PieceInfo = PieceInfo
        self.PieceInfo_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AWBInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AWBInfo.subclass:
            return AWBInfo.subclass(*args_, **kwargs_)
        else:
            return AWBInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AWBNumber(self):
        return self.AWBNumber
    def set_AWBNumber(self, AWBNumber):
        self.AWBNumber = AWBNumber
    def get_Status(self):
        return self.Status
    def set_Status(self, Status):
        self.Status = Status
    def get_ShipmentInfo(self):
        return self.ShipmentInfo
    def set_ShipmentInfo(self, ShipmentInfo):
        self.ShipmentInfo = ShipmentInfo
    def get_PieceInfo(self):
        return self.PieceInfo
    def set_PieceInfo(self, PieceInfo):
        self.PieceInfo = PieceInfo
    def add_PieceInfo(self, value):
        self.PieceInfo.append(value)
    def insert_PieceInfo_at(self, index, value):
        self.PieceInfo.insert(index, value)
    def replace_PieceInfo_at(self, index, value):
        self.PieceInfo[index] = value
    def validate_AWBNumber(self, value):
        result = True
        # Validate type AWBNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AWBNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.AWBNumber is not None or
            self.Status is not None or
            self.ShipmentInfo is not None or
            self.PieceInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AWBInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AWBInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AWBInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AWBInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AWBInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AWBInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AWBInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AWBNumber is not None:
            namespaceprefix_ = self.AWBNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.AWBNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAWBNumber>%s</%sAWBNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AWBNumber), input_name='AWBNumber')), namespaceprefix_ , eol_))
        if self.Status is not None:
            namespaceprefix_ = self.Status_nsprefix_ + ':' if (UseCapturedNS_ and self.Status_nsprefix_) else ''
            self.Status.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Status', pretty_print=pretty_print)
        if self.ShipmentInfo is not None:
            namespaceprefix_ = self.ShipmentInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentInfo_nsprefix_) else ''
            self.ShipmentInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ShipmentInfo', pretty_print=pretty_print)
        for PieceInfo_ in self.PieceInfo:
            namespaceprefix_ = self.PieceInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceInfo_nsprefix_) else ''
            PieceInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AWBNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AWBNumber')
            value_ = self.gds_validate_string(value_, node, 'AWBNumber')
            self.AWBNumber = value_
            self.AWBNumber_nsprefix_ = child_.prefix
            # validate type AWBNumber
            self.validate_AWBNumber(self.AWBNumber)
        elif nodeName_ == 'Status':
            obj_ = Status.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Status = obj_
            obj_.original_tagname_ = 'Status'
        elif nodeName_ == 'ShipmentInfo':
            obj_ = ShipmentInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ShipmentInfo = obj_
            obj_.original_tagname_ = 'ShipmentInfo'
        elif nodeName_ == 'PieceInfo':
            obj_ = PieceInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceInfo.append(obj_)
            obj_.original_tagname_ = 'PieceInfo'
# end class AWBInfo


class ShipmentInfo(GeneratedsSuper):
    """WeightUnit -- Weight Unit Details
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, OriginServiceArea=None, DestinationServiceArea=None, ShipperName=None, ShipperAccountNumber=None, ConsigneeName=None, ShipmentDate=None, Pieces=None, Weight=None, WeightUnit=None, EstDlvyDate=None, ShipmentEvent=None, ShipperReference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.OriginServiceArea = OriginServiceArea
        self.OriginServiceArea_nsprefix_ = None
        self.DestinationServiceArea = DestinationServiceArea
        self.DestinationServiceArea_nsprefix_ = None
        self.ShipperName = ShipperName
        self.validate_PersonName(self.ShipperName)
        self.ShipperName_nsprefix_ = None
        self.ShipperAccountNumber = ShipperAccountNumber
        self.validate_AccountNumber(self.ShipperAccountNumber)
        self.ShipperAccountNumber_nsprefix_ = None
        self.ConsigneeName = ConsigneeName
        self.validate_PersonName(self.ConsigneeName)
        self.ConsigneeName_nsprefix_ = None
        if isinstance(ShipmentDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(ShipmentDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = ShipmentDate
        self.ShipmentDate = initvalue_
        self.ShipmentDate_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.validate_WeightUnitType(self.WeightUnit)
        self.WeightUnit_nsprefix_ = None
        if isinstance(EstDlvyDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(EstDlvyDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = EstDlvyDate
        self.EstDlvyDate = initvalue_
        self.EstDlvyDate_nsprefix_ = None
        if ShipmentEvent is None:
            self.ShipmentEvent = []
        else:
            self.ShipmentEvent = ShipmentEvent
        self.ShipmentEvent_nsprefix_ = None
        self.ShipperReference = ShipperReference
        self.ShipperReference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipmentInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentInfo.subclass:
            return ShipmentInfo.subclass(*args_, **kwargs_)
        else:
            return ShipmentInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_OriginServiceArea(self):
        return self.OriginServiceArea
    def set_OriginServiceArea(self, OriginServiceArea):
        self.OriginServiceArea = OriginServiceArea
    def get_DestinationServiceArea(self):
        return self.DestinationServiceArea
    def set_DestinationServiceArea(self, DestinationServiceArea):
        self.DestinationServiceArea = DestinationServiceArea
    def get_ShipperName(self):
        return self.ShipperName
    def set_ShipperName(self, ShipperName):
        self.ShipperName = ShipperName
    def get_ShipperAccountNumber(self):
        return self.ShipperAccountNumber
    def set_ShipperAccountNumber(self, ShipperAccountNumber):
        self.ShipperAccountNumber = ShipperAccountNumber
    def get_ConsigneeName(self):
        return self.ConsigneeName
    def set_ConsigneeName(self, ConsigneeName):
        self.ConsigneeName = ConsigneeName
    def get_ShipmentDate(self):
        return self.ShipmentDate
    def set_ShipmentDate(self, ShipmentDate):
        self.ShipmentDate = ShipmentDate
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def get_EstDlvyDate(self):
        return self.EstDlvyDate
    def set_EstDlvyDate(self, EstDlvyDate):
        self.EstDlvyDate = EstDlvyDate
    def get_ShipmentEvent(self):
        return self.ShipmentEvent
    def set_ShipmentEvent(self, ShipmentEvent):
        self.ShipmentEvent = ShipmentEvent
    def add_ShipmentEvent(self, value):
        self.ShipmentEvent.append(value)
    def insert_ShipmentEvent_at(self, index, value):
        self.ShipmentEvent.insert(index, value)
    def replace_ShipmentEvent_at(self, index, value):
        self.ShipmentEvent[index] = value
    def get_ShipperReference(self):
        return self.ShipperReference
    def set_ShipperReference(self, ShipperReference):
        self.ShipperReference = ShipperReference
    def validate_PersonName(self, value):
        result = True
        # Validate type PersonName, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 255:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PersonName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PersonName' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_AccountNumber(self, value):
        result = True
        # Validate type AccountNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 9:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on AccountNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_WeightUnitType(self, value):
        result = True
        # Validate type WeightUnitType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['L', 'K', 'G']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on WeightUnitType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.OriginServiceArea is not None or
            self.DestinationServiceArea is not None or
            self.ShipperName is not None or
            self.ShipperAccountNumber is not None or
            self.ConsigneeName is not None or
            self.ShipmentDate is not None or
            self.Pieces is not None or
            self.Weight is not None or
            self.WeightUnit is not None or
            self.EstDlvyDate is not None or
            self.ShipmentEvent or
            self.ShipperReference is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipmentInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipmentInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipmentInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipmentInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipmentInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.OriginServiceArea is not None:
            namespaceprefix_ = self.OriginServiceArea_nsprefix_ + ':' if (UseCapturedNS_ and self.OriginServiceArea_nsprefix_) else ''
            self.OriginServiceArea.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OriginServiceArea', pretty_print=pretty_print)
        if self.DestinationServiceArea is not None:
            namespaceprefix_ = self.DestinationServiceArea_nsprefix_ + ':' if (UseCapturedNS_ and self.DestinationServiceArea_nsprefix_) else ''
            self.DestinationServiceArea.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DestinationServiceArea', pretty_print=pretty_print)
        if self.ShipperName is not None:
            namespaceprefix_ = self.ShipperName_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperName>%s</%sShipperName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperName), input_name='ShipperName')), namespaceprefix_ , eol_))
        if self.ShipperAccountNumber is not None:
            namespaceprefix_ = self.ShipperAccountNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperAccountNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperAccountNumber>%s</%sShipperAccountNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperAccountNumber), input_name='ShipperAccountNumber')), namespaceprefix_ , eol_))
        if self.ConsigneeName is not None:
            namespaceprefix_ = self.ConsigneeName_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeName>%s</%sConsigneeName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeName), input_name='ConsigneeName')), namespaceprefix_ , eol_))
        if self.ShipmentDate is not None:
            namespaceprefix_ = self.ShipmentDate_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentDate>%s</%sShipmentDate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.ShipmentDate, input_name='ShipmentDate'), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            self.Pieces.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pieces', pretty_print=pretty_print)
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Weight), input_name='Weight')), namespaceprefix_ , eol_))
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
        if self.EstDlvyDate is not None:
            namespaceprefix_ = self.EstDlvyDate_nsprefix_ + ':' if (UseCapturedNS_ and self.EstDlvyDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEstDlvyDate>%s</%sEstDlvyDate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.EstDlvyDate, input_name='EstDlvyDate'), namespaceprefix_ , eol_))
        for ShipmentEvent_ in self.ShipmentEvent:
            namespaceprefix_ = self.ShipmentEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentEvent_nsprefix_) else ''
            ShipmentEvent_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ShipmentEvent', pretty_print=pretty_print)
        if self.ShipperReference is not None:
            namespaceprefix_ = self.ShipperReference_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperReference_nsprefix_) else ''
            self.ShipperReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ShipperReference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OriginServiceArea':
            obj_ = ServiceArea.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OriginServiceArea = obj_
            obj_.original_tagname_ = 'OriginServiceArea'
        elif nodeName_ == 'DestinationServiceArea':
            obj_ = ServiceArea.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DestinationServiceArea = obj_
            obj_.original_tagname_ = 'DestinationServiceArea'
        elif nodeName_ == 'ShipperName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperName')
            value_ = self.gds_validate_string(value_, node, 'ShipperName')
            self.ShipperName = value_
            self.ShipperName_nsprefix_ = child_.prefix
            # validate type PersonName
            self.validate_PersonName(self.ShipperName)
        elif nodeName_ == 'ShipperAccountNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperAccountNumber')
            value_ = self.gds_validate_string(value_, node, 'ShipperAccountNumber')
            self.ShipperAccountNumber = value_
            self.ShipperAccountNumber_nsprefix_ = child_.prefix
            # validate type AccountNumber
            self.validate_AccountNumber(self.ShipperAccountNumber)
        elif nodeName_ == 'ConsigneeName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeName')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeName')
            self.ConsigneeName = value_
            self.ConsigneeName_nsprefix_ = child_.prefix
            # validate type PersonName
            self.validate_PersonName(self.ConsigneeName)
        elif nodeName_ == 'ShipmentDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.ShipmentDate = dval_
            self.ShipmentDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            obj_ = Pieces.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Pieces = obj_
            obj_.original_tagname_ = 'Pieces'
        elif nodeName_ == 'Weight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Weight')
            value_ = self.gds_validate_string(value_, node, 'Weight')
            self.Weight = value_
            self.Weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
            # validate type WeightUnitType
            self.validate_WeightUnitType(self.WeightUnit)
        elif nodeName_ == 'EstDlvyDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.EstDlvyDate = dval_
            self.EstDlvyDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipmentEvent':
            obj_ = ShipmentEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ShipmentEvent.append(obj_)
            obj_.original_tagname_ = 'ShipmentEvent'
        elif nodeName_ == 'ShipperReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ShipperReference = obj_
            obj_.original_tagname_ = 'ShipperReference'
# end class ShipmentInfo


class ErrorResponse(GeneratedsSuper):
    """ErrorResponse -- Generic response header
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ServiceHeader=None, Status=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ServiceHeader = ServiceHeader
        self.ServiceHeader_nsprefix_ = None
        self.Status = Status
        self.Status_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ErrorResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ErrorResponse.subclass:
            return ErrorResponse.subclass(*args_, **kwargs_)
        else:
            return ErrorResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ServiceHeader(self):
        return self.ServiceHeader
    def set_ServiceHeader(self, ServiceHeader):
        self.ServiceHeader = ServiceHeader
    def get_Status(self):
        return self.Status
    def set_Status(self, Status):
        self.Status = Status
    def _hasContent(self):
        if (
            self.ServiceHeader is not None or
            self.Status is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ErrorResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ErrorResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ErrorResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ErrorResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ErrorResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ErrorResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ErrorResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ServiceHeader is not None:
            namespaceprefix_ = self.ServiceHeader_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceHeader_nsprefix_) else ''
            self.ServiceHeader.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceHeader', pretty_print=pretty_print)
        if self.Status is not None:
            namespaceprefix_ = self.Status_nsprefix_ + ':' if (UseCapturedNS_ and self.Status_nsprefix_) else ''
            self.Status.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Status', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ServiceHeader':
            obj_ = ServiceHeader.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceHeader = obj_
            obj_.original_tagname_ = 'ServiceHeader'
        elif nodeName_ == 'Status':
            obj_ = Status.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Status = obj_
            obj_.original_tagname_ = 'Status'
# end class ErrorResponse


class ShipmentEvent(GeneratedsSuper):
    """ShipmentEvent -- Describes the checkpoint information
    Signatory -- Signatory
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Date=None, Time=None, ServiceEvent=None, Signatory=None, ServiceArea=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%d').date()
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.Date_nsprefix_ = None
        if isinstance(Time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Time, '%H:%M:%S').time()
        else:
            initvalue_ = Time
        self.Time = initvalue_
        self.Time_nsprefix_ = None
        self.ServiceEvent = ServiceEvent
        self.ServiceEvent_nsprefix_ = None
        self.Signatory = Signatory
        self.validate_SignatoryType(self.Signatory)
        self.Signatory_nsprefix_ = None
        self.ServiceArea = ServiceArea
        self.ServiceArea_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipmentEvent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentEvent.subclass:
            return ShipmentEvent.subclass(*args_, **kwargs_)
        else:
            return ShipmentEvent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Date(self):
        return self.Date
    def set_Date(self, Date):
        self.Date = Date
    def get_Time(self):
        return self.Time
    def set_Time(self, Time):
        self.Time = Time
    def get_ServiceEvent(self):
        return self.ServiceEvent
    def set_ServiceEvent(self, ServiceEvent):
        self.ServiceEvent = ServiceEvent
    def get_Signatory(self):
        return self.Signatory
    def set_Signatory(self, Signatory):
        self.Signatory = Signatory
    def get_ServiceArea(self):
        return self.ServiceArea
    def set_ServiceArea(self, ServiceArea):
        self.ServiceArea = ServiceArea
    def validate_SignatoryType(self, value):
        result = True
        # Validate type SignatoryType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def _hasContent(self):
        if (
            self.Date is not None or
            self.Time is not None or
            self.ServiceEvent is not None or
            self.Signatory is not None or
            self.ServiceArea is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentEvent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipmentEvent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipmentEvent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipmentEvent')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipmentEvent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipmentEvent'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentEvent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Date is not None:
            namespaceprefix_ = self.Date_nsprefix_ + ':' if (UseCapturedNS_ and self.Date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDate>%s</%sDate>%s' % (namespaceprefix_ , self.gds_format_date(self.Date, input_name='Date'), namespaceprefix_ , eol_))
        if self.Time is not None:
            namespaceprefix_ = self.Time_nsprefix_ + ':' if (UseCapturedNS_ and self.Time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTime>%s</%sTime>%s' % (namespaceprefix_ , self.gds_format_time(self.Time, input_name='Time'), namespaceprefix_ , eol_))
        if self.ServiceEvent is not None:
            namespaceprefix_ = self.ServiceEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceEvent_nsprefix_) else ''
            self.ServiceEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceEvent', pretty_print=pretty_print)
        if self.Signatory is not None:
            namespaceprefix_ = self.Signatory_nsprefix_ + ':' if (UseCapturedNS_ and self.Signatory_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignatory>%s</%sSignatory>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Signatory), input_name='Signatory')), namespaceprefix_ , eol_))
        if self.ServiceArea is not None:
            namespaceprefix_ = self.ServiceArea_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceArea_nsprefix_) else ''
            self.ServiceArea.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceArea', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.Date = dval_
            self.Date_nsprefix_ = child_.prefix
        elif nodeName_ == 'Time':
            sval_ = child_.text
            dval_ = self.gds_parse_time(sval_)
            self.Time = dval_
            self.Time_nsprefix_ = child_.prefix
        elif nodeName_ == 'ServiceEvent':
            obj_ = ServiceEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceEvent = obj_
            obj_.original_tagname_ = 'ServiceEvent'
        elif nodeName_ == 'Signatory':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Signatory')
            value_ = self.gds_validate_string(value_, node, 'Signatory')
            self.Signatory = value_
            self.Signatory_nsprefix_ = child_.prefix
            # validate type SignatoryType
            self.validate_SignatoryType(self.Signatory)
        elif nodeName_ == 'ServiceArea':
            obj_ = ServiceArea.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceArea = obj_
            obj_.original_tagname_ = 'ServiceArea'
# end class ShipmentEvent


class PieceInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceDetails=None, PieceEvent=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PieceDetails = PieceDetails
        self.PieceDetails_nsprefix_ = None
        if PieceEvent is None:
            self.PieceEvent = []
        else:
            self.PieceEvent = PieceEvent
        self.PieceEvent_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PieceInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PieceInfo.subclass:
            return PieceInfo.subclass(*args_, **kwargs_)
        else:
            return PieceInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceDetails(self):
        return self.PieceDetails
    def set_PieceDetails(self, PieceDetails):
        self.PieceDetails = PieceDetails
    def get_PieceEvent(self):
        return self.PieceEvent
    def set_PieceEvent(self, PieceEvent):
        self.PieceEvent = PieceEvent
    def add_PieceEvent(self, value):
        self.PieceEvent.append(value)
    def insert_PieceEvent_at(self, index, value):
        self.PieceEvent.insert(index, value)
    def replace_PieceEvent_at(self, index, value):
        self.PieceEvent[index] = value
    def _hasContent(self):
        if (
            self.PieceDetails is not None or
            self.PieceEvent
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PieceInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PieceInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PieceInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PieceInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PieceInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PieceDetails is not None:
            namespaceprefix_ = self.PieceDetails_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceDetails_nsprefix_) else ''
            self.PieceDetails.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceDetails', pretty_print=pretty_print)
        for PieceEvent_ in self.PieceEvent:
            namespaceprefix_ = self.PieceEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceEvent_nsprefix_) else ''
            PieceEvent_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceEvent', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceDetails':
            obj_ = PieceDetails.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceDetails = obj_
            obj_.original_tagname_ = 'PieceDetails'
        elif nodeName_ == 'PieceEvent':
            obj_ = PieceEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceEvent.append(obj_)
            obj_.original_tagname_ = 'PieceEvent'
# end class PieceInfo


class PieceEvent(GeneratedsSuper):
    """PieceEvent -- Describes the checkpoint information
    Signatory -- Signatory
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Date=None, Time=None, ServiceEvent=None, Signatory=None, ServiceArea=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if isinstance(Date, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Date, '%Y-%m-%d').date()
        else:
            initvalue_ = Date
        self.Date = initvalue_
        self.Date_nsprefix_ = None
        if isinstance(Time, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(Time, '%H:%M:%S').time()
        else:
            initvalue_ = Time
        self.Time = initvalue_
        self.Time_nsprefix_ = None
        self.ServiceEvent = ServiceEvent
        self.ServiceEvent_nsprefix_ = None
        self.Signatory = Signatory
        self.validate_SignatoryType4(self.Signatory)
        self.Signatory_nsprefix_ = None
        self.ServiceArea = ServiceArea
        self.ServiceArea_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PieceEvent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PieceEvent.subclass:
            return PieceEvent.subclass(*args_, **kwargs_)
        else:
            return PieceEvent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Date(self):
        return self.Date
    def set_Date(self, Date):
        self.Date = Date
    def get_Time(self):
        return self.Time
    def set_Time(self, Time):
        self.Time = Time
    def get_ServiceEvent(self):
        return self.ServiceEvent
    def set_ServiceEvent(self, ServiceEvent):
        self.ServiceEvent = ServiceEvent
    def get_Signatory(self):
        return self.Signatory
    def set_Signatory(self, Signatory):
        self.Signatory = Signatory
    def get_ServiceArea(self):
        return self.ServiceArea
    def set_ServiceArea(self, ServiceArea):
        self.ServiceArea = ServiceArea
    def validate_SignatoryType4(self, value):
        result = True
        # Validate type SignatoryType4, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            pass
        return result
    def _hasContent(self):
        if (
            self.Date is not None or
            self.Time is not None or
            self.ServiceEvent is not None or
            self.Signatory is not None or
            self.ServiceArea is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceEvent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PieceEvent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PieceEvent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PieceEvent')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PieceEvent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PieceEvent'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceEvent', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Date is not None:
            namespaceprefix_ = self.Date_nsprefix_ + ':' if (UseCapturedNS_ and self.Date_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDate>%s</%sDate>%s' % (namespaceprefix_ , self.gds_format_date(self.Date, input_name='Date'), namespaceprefix_ , eol_))
        if self.Time is not None:
            namespaceprefix_ = self.Time_nsprefix_ + ':' if (UseCapturedNS_ and self.Time_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTime>%s</%sTime>%s' % (namespaceprefix_ , self.gds_format_time(self.Time, input_name='Time'), namespaceprefix_ , eol_))
        if self.ServiceEvent is not None:
            namespaceprefix_ = self.ServiceEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceEvent_nsprefix_) else ''
            self.ServiceEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceEvent', pretty_print=pretty_print)
        if self.Signatory is not None:
            namespaceprefix_ = self.Signatory_nsprefix_ + ':' if (UseCapturedNS_ and self.Signatory_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignatory>%s</%sSignatory>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Signatory), input_name='Signatory')), namespaceprefix_ , eol_))
        if self.ServiceArea is not None:
            namespaceprefix_ = self.ServiceArea_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceArea_nsprefix_) else ''
            self.ServiceArea.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceArea', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Date':
            sval_ = child_.text
            dval_ = self.gds_parse_date(sval_)
            self.Date = dval_
            self.Date_nsprefix_ = child_.prefix
        elif nodeName_ == 'Time':
            sval_ = child_.text
            dval_ = self.gds_parse_time(sval_)
            self.Time = dval_
            self.Time_nsprefix_ = child_.prefix
        elif nodeName_ == 'ServiceEvent':
            obj_ = ServiceEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceEvent = obj_
            obj_.original_tagname_ = 'ServiceEvent'
        elif nodeName_ == 'Signatory':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Signatory')
            value_ = self.gds_validate_string(value_, node, 'Signatory')
            self.Signatory = value_
            self.Signatory_nsprefix_ = child_.prefix
            # validate type SignatoryType4
            self.validate_SignatoryType4(self.Signatory)
        elif nodeName_ == 'ServiceArea':
            obj_ = ServiceArea.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceArea = obj_
            obj_.original_tagname_ = 'ServiceArea'
# end class PieceEvent


class PieceDetails(GeneratedsSuper):
    """Width -- required if height and depth are specified
    Height -- required if width and depth are specified
    Depth -- required if width and height are specified
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceID=None, PackageType=None, Weight=None, DimWeight=None, Width=None, Height=None, Depth=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PieceID = PieceID
        self.validate_TrackingPieceID(self.PieceID)
        self.PieceID_nsprefix_ = None
        self.PackageType = PackageType
        self.validate_PackageType(self.PackageType)
        self.PackageType_nsprefix_ = None
        self.Weight = Weight
        self.validate_Piece_Weight(self.Weight)
        self.Weight_nsprefix_ = None
        self.DimWeight = DimWeight
        self.DimWeight_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.Depth = Depth
        self.Depth_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PieceDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PieceDetails.subclass:
            return PieceDetails.subclass(*args_, **kwargs_)
        else:
            return PieceDetails(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceID(self):
        return self.PieceID
    def set_PieceID(self, PieceID):
        self.PieceID = PieceID
    def get_PackageType(self):
        return self.PackageType
    def set_PackageType(self, PackageType):
        self.PackageType = PackageType
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_DimWeight(self):
        return self.DimWeight
    def set_DimWeight(self, DimWeight):
        self.DimWeight = DimWeight
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Depth(self):
        return self.Depth
    def set_Depth(self, Depth):
        self.Depth = Depth
    def validate_TrackingPieceID(self, value):
        result = True
        # Validate type TrackingPieceID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TrackingPieceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TrackingPieceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PackageType(self, value):
        result = True
        # Validate type PackageType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PackageType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Piece_Weight(self, value):
        result = True
        # Validate type Piece_Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on Piece_Weight' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on Piece_Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.PieceID is not None or
            self.PackageType is not None or
            self.Weight is not None or
            self.DimWeight is not None or
            self.Width is not None or
            self.Height is not None or
            self.Depth is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceDetails', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PieceDetails')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PieceDetails':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PieceDetails')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PieceDetails', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PieceDetails'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceDetails', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PieceID is not None:
            namespaceprefix_ = self.PieceID_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceID>%s</%sPieceID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceID), input_name='PieceID')), namespaceprefix_ , eol_))
        if self.PackageType is not None:
            namespaceprefix_ = self.PackageType_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageType>%s</%sPackageType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageType), input_name='PackageType')), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.DimWeight is not None:
            namespaceprefix_ = self.DimWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.DimWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimWeight>%s</%sDimWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DimWeight), input_name='DimWeight')), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_format_integer(self.Width, input_name='Width'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_integer(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.Depth is not None:
            namespaceprefix_ = self.Depth_nsprefix_ + ':' if (UseCapturedNS_ and self.Depth_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDepth>%s</%sDepth>%s' % (namespaceprefix_ , self.gds_format_integer(self.Depth, input_name='Depth'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PieceID')
            value_ = self.gds_validate_string(value_, node, 'PieceID')
            self.PieceID = value_
            self.PieceID_nsprefix_ = child_.prefix
            # validate type TrackingPieceID
            self.validate_TrackingPieceID(self.PieceID)
        elif nodeName_ == 'PackageType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageType')
            value_ = self.gds_validate_string(value_, node, 'PackageType')
            self.PackageType = value_
            self.PackageType_nsprefix_ = child_.prefix
            # validate type PackageType
            self.validate_PackageType(self.PackageType)
        elif nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'Weight')
            fval_ = self.gds_validate_decimal(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
            # validate type Piece_Weight
            self.validate_Piece_Weight(self.Weight)
        elif nodeName_ == 'DimWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DimWeight')
            value_ = self.gds_validate_string(value_, node, 'DimWeight')
            self.DimWeight = value_
            self.DimWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'Width')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'Width')
            self.Width = ival_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'Height')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'Height')
            self.Height = ival_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'Depth' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'Depth')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'Depth')
            self.Depth = ival_
            self.Depth_nsprefix_ = child_.prefix
# end class PieceDetails


class TrackingPieces(GeneratedsSuper):
    """TrackingPieces -- Piece Info
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if PieceInfo is None:
            self.PieceInfo = []
        else:
            self.PieceInfo = PieceInfo
        self.PieceInfo_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingPieces)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingPieces.subclass:
            return TrackingPieces.subclass(*args_, **kwargs_)
        else:
            return TrackingPieces(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceInfo(self):
        return self.PieceInfo
    def set_PieceInfo(self, PieceInfo):
        self.PieceInfo = PieceInfo
    def add_PieceInfo(self, value):
        self.PieceInfo.append(value)
    def insert_PieceInfo_at(self, index, value):
        self.PieceInfo.insert(index, value)
    def replace_PieceInfo_at(self, index, value):
        self.PieceInfo[index] = value
    def _hasContent(self):
        if (
            self.PieceInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingPieces', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingPieces')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingPieces':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingPieces')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingPieces', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingPieces'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingPieces', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for PieceInfo_ in self.PieceInfo:
            namespaceprefix_ = self.PieceInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceInfo_nsprefix_) else ''
            PieceInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceInfo':
            obj_ = PieceInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceInfo.append(obj_)
            obj_.original_tagname_ = 'PieceInfo'
# end class TrackingPieces


class Fault(GeneratedsSuper):
    """Fault -- Piece Fault
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceFault=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if PieceFault is None:
            self.PieceFault = []
        else:
            self.PieceFault = PieceFault
        self.PieceFault_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Fault)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Fault.subclass:
            return Fault.subclass(*args_, **kwargs_)
        else:
            return Fault(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceFault(self):
        return self.PieceFault
    def set_PieceFault(self, PieceFault):
        self.PieceFault = PieceFault
    def add_PieceFault(self, value):
        self.PieceFault.append(value)
    def insert_PieceFault_at(self, index, value):
        self.PieceFault.insert(index, value)
    def replace_PieceFault_at(self, index, value):
        self.PieceFault[index] = value
    def _hasContent(self):
        if (
            self.PieceFault
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Fault', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Fault')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Fault':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Fault')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Fault', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Fault'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Fault', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for PieceFault_ in self.PieceFault:
            namespaceprefix_ = self.PieceFault_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceFault_nsprefix_) else ''
            PieceFault_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceFault', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceFault':
            obj_ = PieceFault.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceFault.append(obj_)
            obj_.original_tagname_ = 'PieceFault'
# end class Fault


class PieceFault(GeneratedsSuper):
    """PieceID -- The License Plate identifier.
    ConditionCode -- Condition Code
    ConditionData -- Condition Data
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceID=None, ConditionCode=None, ConditionData=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PieceID = PieceID
        self.validate_TrackingPieceID(self.PieceID)
        self.PieceID_nsprefix_ = None
        self.ConditionCode = ConditionCode
        self.ConditionCode_nsprefix_ = None
        self.ConditionData = ConditionData
        self.ConditionData_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PieceFault)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PieceFault.subclass:
            return PieceFault.subclass(*args_, **kwargs_)
        else:
            return PieceFault(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceID(self):
        return self.PieceID
    def set_PieceID(self, PieceID):
        self.PieceID = PieceID
    def get_ConditionCode(self):
        return self.ConditionCode
    def set_ConditionCode(self, ConditionCode):
        self.ConditionCode = ConditionCode
    def get_ConditionData(self):
        return self.ConditionData
    def set_ConditionData(self, ConditionData):
        self.ConditionData = ConditionData
    def validate_TrackingPieceID(self, value):
        result = True
        # Validate type TrackingPieceID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on TrackingPieceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 20:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TrackingPieceID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.PieceID is not None or
            self.ConditionCode is not None or
            self.ConditionData is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceFault', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PieceFault')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PieceFault':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PieceFault')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PieceFault', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PieceFault'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceFault', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PieceID is not None:
            namespaceprefix_ = self.PieceID_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieceID>%s</%sPieceID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PieceID), input_name='PieceID')), namespaceprefix_ , eol_))
        if self.ConditionCode is not None:
            namespaceprefix_ = self.ConditionCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ConditionCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConditionCode>%s</%sConditionCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConditionCode), input_name='ConditionCode')), namespaceprefix_ , eol_))
        if self.ConditionData is not None:
            namespaceprefix_ = self.ConditionData_nsprefix_ + ':' if (UseCapturedNS_ and self.ConditionData_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConditionData>%s</%sConditionData>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConditionData), input_name='ConditionData')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PieceID')
            value_ = self.gds_validate_string(value_, node, 'PieceID')
            self.PieceID = value_
            self.PieceID_nsprefix_ = child_.prefix
            # validate type TrackingPieceID
            self.validate_TrackingPieceID(self.PieceID)
        elif nodeName_ == 'ConditionCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConditionCode')
            value_ = self.gds_validate_string(value_, node, 'ConditionCode')
            self.ConditionCode = value_
            self.ConditionCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConditionData':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConditionData')
            value_ = self.gds_validate_string(value_, node, 'ConditionData')
            self.ConditionData = value_
            self.ConditionData_nsprefix_ = child_.prefix
# end class PieceFault


class DocImages(GeneratedsSuper):
    """DocImages -- DocImages
    DocImage -- DocImages
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, DocImage=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DocImage is None:
            self.DocImage = []
        else:
            self.DocImage = DocImage
        self.DocImage_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocImages)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocImages.subclass:
            return DocImages.subclass(*args_, **kwargs_)
        else:
            return DocImages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DocImage(self):
        return self.DocImage
    def set_DocImage(self, DocImage):
        self.DocImage = DocImage
    def add_DocImage(self, value):
        self.DocImage.append(value)
    def insert_DocImage_at(self, index, value):
        self.DocImage.insert(index, value)
    def replace_DocImage_at(self, index, value):
        self.DocImage[index] = value
    def _hasContent(self):
        if (
            self.DocImage
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DocImages', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DocImages')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DocImages':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DocImages')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DocImages', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DocImages'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DocImages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DocImage_ in self.DocImage:
            namespaceprefix_ = self.DocImage_nsprefix_ + ':' if (UseCapturedNS_ and self.DocImage_nsprefix_) else ''
            DocImage_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DocImage', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DocImage':
            obj_ = DocImage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DocImage.append(obj_)
            obj_.original_tagname_ = 'DocImage'
# end class DocImages


class DocImage(GeneratedsSuper):
    """DocImage -- DocImage
    Type -- The Type element indicates supporting document image type
    Image -- The Image element contains the supporting document image in base64
    ImageFormat -- The ImageFormat element indicates the supporting document image format
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Type=None, Image=None, ImageFormat=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Type = Type
        self.validate_Type(self.Type)
        self.Type_nsprefix_ = None
        self.Image = Image
        self.validate_Image(self.Image)
        self.Image_nsprefix_ = None
        self.ImageFormat = ImageFormat
        self.validate_ImageFormat(self.ImageFormat)
        self.ImageFormat_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DocImage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DocImage.subclass:
            return DocImage.subclass(*args_, **kwargs_)
        else:
            return DocImage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Type(self):
        return self.Type
    def set_Type(self, Type):
        self.Type = Type
    def get_Image(self):
        return self.Image
    def set_Image(self, Image):
        self.Image = Image
    def get_ImageFormat(self):
        return self.ImageFormat
    def set_ImageFormat(self, ImageFormat):
        self.ImageFormat = ImageFormat
    def validate_Type(self, value):
        result = True
        # Validate type Type, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['HWB', 'INV', 'PNV', 'COO', 'NAF', 'CIN', 'DCL']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on Type' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Image(self, value):
        result = True
        # Validate type Image, a restriction on xsd:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
        return result
    def validate_ImageFormat(self, value):
        result = True
        # Validate type ImageFormat, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PDF', 'PNG', 'TIFF', 'GIF', 'JPEG']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ImageFormat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 5:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ImageFormat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.Type is not None or
            self.Image is not None or
            self.ImageFormat is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DocImage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DocImage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DocImage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DocImage')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DocImage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DocImage'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DocImage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Type is not None:
            namespaceprefix_ = self.Type_nsprefix_ + ':' if (UseCapturedNS_ and self.Type_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sType>%s</%sType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Type), input_name='Type')), namespaceprefix_ , eol_))
        if self.Image is not None:
            namespaceprefix_ = self.Image_nsprefix_ + ':' if (UseCapturedNS_ and self.Image_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImage>%s</%sImage>%s' % (namespaceprefix_ , self.gds_format_base64(self.Image, input_name='Image'), namespaceprefix_ , eol_))
        if self.ImageFormat is not None:
            namespaceprefix_ = self.ImageFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.ImageFormat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImageFormat>%s</%sImageFormat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ImageFormat), input_name='ImageFormat')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Type':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Type')
            value_ = self.gds_validate_string(value_, node, 'Type')
            self.Type = value_
            self.Type_nsprefix_ = child_.prefix
            # validate type Type
            self.validate_Type(self.Type)
        elif nodeName_ == 'Image':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'Image')
            else:
                bval_ = None
            self.Image = bval_
            self.Image_nsprefix_ = child_.prefix
            # validate type Image
            self.validate_Image(self.Image)
        elif nodeName_ == 'ImageFormat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ImageFormat')
            value_ = self.gds_validate_string(value_, node, 'ImageFormat')
            self.ImageFormat = value_
            self.ImageFormat_nsprefix_ = child_.prefix
            # validate type ImageFormat
            self.validate_ImageFormat(self.ImageFormat)
# end class DocImage


class QtdSInAdCur(GeneratedsSuper):
    """QtdSInAdCur -- QtdSInAdCur
    CurrencyCode -- The CurrencyCode element indicates the currency code of the shipment
    CurrencyRoleTypeCode -- The CurrencyRoleTypeCode element indicates the role of the currency in billing details
    PackageCharge -- The PackageCharge element contains the package charge of the shipment
    ShippingCharge -- The ShippingCharge element contains the total shipping charges of the shipment
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CurrencyCode=None, CurrencyRoleTypeCode=None, PackageCharge=None, ShippingCharge=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CurrencyCode = CurrencyCode
        self.validate_CurrencyCode(self.CurrencyCode)
        self.CurrencyCode_nsprefix_ = None
        self.CurrencyRoleTypeCode = CurrencyRoleTypeCode
        self.validate_CurrencyRoleTypeCode(self.CurrencyRoleTypeCode)
        self.CurrencyRoleTypeCode_nsprefix_ = None
        self.PackageCharge = PackageCharge
        self.validate_PackageCharge(self.PackageCharge)
        self.PackageCharge_nsprefix_ = None
        self.ShippingCharge = ShippingCharge
        self.validate_ShippingCharge(self.ShippingCharge)
        self.ShippingCharge_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, QtdSInAdCur)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if QtdSInAdCur.subclass:
            return QtdSInAdCur.subclass(*args_, **kwargs_)
        else:
            return QtdSInAdCur(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CurrencyCode(self):
        return self.CurrencyCode
    def set_CurrencyCode(self, CurrencyCode):
        self.CurrencyCode = CurrencyCode
    def get_CurrencyRoleTypeCode(self):
        return self.CurrencyRoleTypeCode
    def set_CurrencyRoleTypeCode(self, CurrencyRoleTypeCode):
        self.CurrencyRoleTypeCode = CurrencyRoleTypeCode
    def get_PackageCharge(self):
        return self.PackageCharge
    def set_PackageCharge(self, PackageCharge):
        self.PackageCharge = PackageCharge
    def get_ShippingCharge(self):
        return self.ShippingCharge
    def set_ShippingCharge(self, ShippingCharge):
        self.ShippingCharge = ShippingCharge
    def validate_CurrencyCode(self, value):
        result = True
        # Validate type CurrencyCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) != 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on CurrencyCode' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CurrencyCode_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CurrencyCode_patterns_, ))
                result = False
        return result
    validate_CurrencyCode_patterns_ = [['^([^ ].*[^ ])$']]
    def validate_CurrencyRoleTypeCode(self, value):
        result = True
        # Validate type CurrencyRoleTypeCode, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['BILLC', 'PULCL', 'INVCU', 'BASEC']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CurrencyRoleTypeCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 5:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CurrencyRoleTypeCode' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_PackageCharge(self, value):
        result = True
        # Validate type PackageCharge, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on PackageCharge' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_ShippingCharge(self, value):
        result = True
        # Validate type ShippingCharge, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 18:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on ShippingCharge' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CurrencyCode is not None or
            self.CurrencyRoleTypeCode is not None or
            self.PackageCharge is not None or
            self.ShippingCharge is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='QtdSInAdCur', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('QtdSInAdCur')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'QtdSInAdCur':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='QtdSInAdCur')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='QtdSInAdCur', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='QtdSInAdCur'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='QtdSInAdCur', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CurrencyCode is not None:
            namespaceprefix_ = self.CurrencyCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CurrencyCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrencyCode>%s</%sCurrencyCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CurrencyCode), input_name='CurrencyCode')), namespaceprefix_ , eol_))
        if self.CurrencyRoleTypeCode is not None:
            namespaceprefix_ = self.CurrencyRoleTypeCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CurrencyRoleTypeCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCurrencyRoleTypeCode>%s</%sCurrencyRoleTypeCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CurrencyRoleTypeCode), input_name='CurrencyRoleTypeCode')), namespaceprefix_ , eol_))
        if self.PackageCharge is not None:
            namespaceprefix_ = self.PackageCharge_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageCharge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageCharge>%s</%sPackageCharge>%s' % (namespaceprefix_ , self.gds_format_decimal(self.PackageCharge, input_name='PackageCharge'), namespaceprefix_ , eol_))
        if self.ShippingCharge is not None:
            namespaceprefix_ = self.ShippingCharge_nsprefix_ + ':' if (UseCapturedNS_ and self.ShippingCharge_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShippingCharge>%s</%sShippingCharge>%s' % (namespaceprefix_ , self.gds_format_decimal(self.ShippingCharge, input_name='ShippingCharge'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CurrencyCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CurrencyCode')
            value_ = self.gds_validate_string(value_, node, 'CurrencyCode')
            self.CurrencyCode = value_
            self.CurrencyCode_nsprefix_ = child_.prefix
            # validate type CurrencyCode
            self.validate_CurrencyCode(self.CurrencyCode)
        elif nodeName_ == 'CurrencyRoleTypeCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CurrencyRoleTypeCode')
            value_ = self.gds_validate_string(value_, node, 'CurrencyRoleTypeCode')
            self.CurrencyRoleTypeCode = value_
            self.CurrencyRoleTypeCode_nsprefix_ = child_.prefix
            # validate type CurrencyRoleTypeCode
            self.validate_CurrencyRoleTypeCode(self.CurrencyRoleTypeCode)
        elif nodeName_ == 'PackageCharge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'PackageCharge')
            fval_ = self.gds_validate_decimal(fval_, node, 'PackageCharge')
            self.PackageCharge = fval_
            self.PackageCharge_nsprefix_ = child_.prefix
            # validate type PackageCharge
            self.validate_PackageCharge(self.PackageCharge)
        elif nodeName_ == 'ShippingCharge' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'ShippingCharge')
            fval_ = self.gds_validate_decimal(fval_, node, 'ShippingCharge')
            self.ShippingCharge = fval_
            self.ShippingCharge_nsprefix_ = child_.prefix
            # validate type ShippingCharge
            self.validate_ShippingCharge(self.ShippingCharge)
# end class QtdSInAdCur


class LabelImage(GeneratedsSuper):
    """LabelImage -- LabelImage
    OutputFormat -- The OutputFormat element indicates the GLS
    ’
    s supported label output format
    OutputImage -- The OutputImage element contains the GLS
    ’
    s label image of Transport Label and Archive Document for the required output format
    MultiLabels -- The OutputImage element contains the GLS
    ’
    s label image of Transport Label, Archive Document, Custom Invoice and Shipment Receipt document for the required output format if there are more than one base64 image
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, OutputFormat=None, OutputImage=None, MultiLabels=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.OutputFormat = OutputFormat
        self.validate_OutputFormat(self.OutputFormat)
        self.OutputFormat_nsprefix_ = None
        self.OutputImage = OutputImage
        self.validate_OutputImage(self.OutputImage)
        self.OutputImage_nsprefix_ = None
        self.MultiLabels = MultiLabels
        self.MultiLabels_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LabelImage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LabelImage.subclass:
            return LabelImage.subclass(*args_, **kwargs_)
        else:
            return LabelImage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_OutputFormat(self):
        return self.OutputFormat
    def set_OutputFormat(self, OutputFormat):
        self.OutputFormat = OutputFormat
    def get_OutputImage(self):
        return self.OutputImage
    def set_OutputImage(self, OutputImage):
        self.OutputImage = OutputImage
    def get_MultiLabels(self):
        return self.MultiLabels
    def set_MultiLabels(self, MultiLabels):
        self.MultiLabels = MultiLabels
    def validate_OutputFormat(self, value):
        result = True
        # Validate type OutputFormat, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PDF', 'PL2', 'ZPL2', 'JPG', 'PNG', 'EPL2', 'EPLN', 'ZPLN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on OutputFormat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_OutputImage(self, value):
        result = True
        # Validate type OutputImage, a restriction on xsd:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            pass
        return result
    def _hasContent(self):
        if (
            self.OutputFormat is not None or
            self.OutputImage is not None or
            self.MultiLabels is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LabelImage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LabelImage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LabelImage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LabelImage')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LabelImage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LabelImage'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LabelImage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.OutputFormat is not None:
            namespaceprefix_ = self.OutputFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.OutputFormat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOutputFormat>%s</%sOutputFormat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.OutputFormat), input_name='OutputFormat')), namespaceprefix_ , eol_))
        if self.OutputImage is not None:
            namespaceprefix_ = self.OutputImage_nsprefix_ + ':' if (UseCapturedNS_ and self.OutputImage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sOutputImage>%s</%sOutputImage>%s' % (namespaceprefix_ , self.gds_format_base64(self.OutputImage, input_name='OutputImage'), namespaceprefix_ , eol_))
        if self.MultiLabels is not None:
            namespaceprefix_ = self.MultiLabels_nsprefix_ + ':' if (UseCapturedNS_ and self.MultiLabels_nsprefix_) else ''
            self.MultiLabels.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MultiLabels', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OutputFormat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'OutputFormat')
            value_ = self.gds_validate_string(value_, node, 'OutputFormat')
            self.OutputFormat = value_
            self.OutputFormat_nsprefix_ = child_.prefix
            # validate type OutputFormat
            self.validate_OutputFormat(self.OutputFormat)
        elif nodeName_ == 'OutputImage':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'OutputImage')
            else:
                bval_ = None
            self.OutputImage = bval_
            self.OutputImage_nsprefix_ = child_.prefix
            # validate type OutputImage
            self.validate_OutputImage(self.OutputImage)
        elif nodeName_ == 'MultiLabels':
            obj_ = MultiLabels.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MultiLabels = obj_
            obj_.original_tagname_ = 'MultiLabels'
# end class LabelImage


class MultiLabels(GeneratedsSuper):
    """MultiLabels -- The OutputImage element contains the GLS
    ’
    s label image of Transport Label, Archive Document, Custom Invoice and Shipment Receipt document for the required output format if there are more than one base64 image
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, MultiLabel=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if MultiLabel is None:
            self.MultiLabel = []
        else:
            self.MultiLabel = MultiLabel
        self.MultiLabel_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MultiLabels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MultiLabels.subclass:
            return MultiLabels.subclass(*args_, **kwargs_)
        else:
            return MultiLabels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_MultiLabel(self):
        return self.MultiLabel
    def set_MultiLabel(self, MultiLabel):
        self.MultiLabel = MultiLabel
    def add_MultiLabel(self, value):
        self.MultiLabel.append(value)
    def insert_MultiLabel_at(self, index, value):
        self.MultiLabel.insert(index, value)
    def replace_MultiLabel_at(self, index, value):
        self.MultiLabel[index] = value
    def _hasContent(self):
        if (
            self.MultiLabel
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='MultiLabels', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('MultiLabels')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'MultiLabels':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='MultiLabels')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='MultiLabels', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='MultiLabels'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='MultiLabels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for MultiLabel_ in self.MultiLabel:
            namespaceprefix_ = self.MultiLabel_nsprefix_ + ':' if (UseCapturedNS_ and self.MultiLabel_nsprefix_) else ''
            MultiLabel_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MultiLabel', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'MultiLabel':
            obj_ = MultiLabelType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MultiLabel.append(obj_)
            obj_.original_tagname_ = 'MultiLabel'
# end class MultiLabels


class Notification(GeneratedsSuper):
    """Notification -- The Notification element contains the notification address and customized message to the designated recipient address for the shipment
    EmailAddress -- The EmailAddress element indicates the multiple email address of the recipient that will receive the email notification message in Message element
    Message -- The Message element indicates the notification message that will be sent to the designated email address in EmailAddress element
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, EmailAddress=None, Message=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.EmailAddress = EmailAddress
        self.validate_Message(self.EmailAddress)
        self.EmailAddress_nsprefix_ = None
        self.Message = Message
        self.validate_Message(self.Message)
        self.Message_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Notification)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Notification.subclass:
            return Notification.subclass(*args_, **kwargs_)
        else:
            return Notification(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_EmailAddress(self):
        return self.EmailAddress
    def set_EmailAddress(self, EmailAddress):
        self.EmailAddress = EmailAddress
    def get_Message(self):
        return self.Message
    def set_Message(self, Message):
        self.Message = Message
    def validate_Message(self, value):
        result = True
        # Validate type Message, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 250:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on Message' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.EmailAddress is not None or
            self.Message is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Notification', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Notification')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Notification':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Notification')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Notification', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Notification'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Notification', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.EmailAddress is not None:
            namespaceprefix_ = self.EmailAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.EmailAddress_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sEmailAddress>%s</%sEmailAddress>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.EmailAddress), input_name='EmailAddress')), namespaceprefix_ , eol_))
        if self.Message is not None:
            namespaceprefix_ = self.Message_nsprefix_ + ':' if (UseCapturedNS_ and self.Message_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sMessage>%s</%sMessage>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Message), input_name='Message')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'EmailAddress':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'EmailAddress')
            value_ = self.gds_validate_string(value_, node, 'EmailAddress')
            self.EmailAddress = value_
            self.EmailAddress_nsprefix_ = child_.prefix
            # validate type Message
            self.validate_Message(self.EmailAddress)
        elif nodeName_ == 'Message':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Message')
            value_ = self.gds_validate_string(value_, node, 'Message')
            self.Message = value_
            self.Message_nsprefix_ = child_.prefix
            # validate type Message
            self.validate_Message(self.Message)
# end class Notification


class Label(GeneratedsSuper):
    """Label -- Label
    HideAccount -- The HideAccount element to to enable XML Services client to display the visibility of the Account number on the label
    LabelTemplate -- The LabelTemplate element indicates GLS transport label templates
    ReceiptTemplate -- The ReceiptTemplate element indicates shipment receipt template. Note: This is only applicable for Country/Region Russia (RU) usage
    ShipmentReceiptWithLabels -- The ShipmentReceiptWithLabels element indicates whether the shipment receipt should be generated in a separate document. Note: This is only applicable for Country/Region Russia (RU) usage, 8X4_RU_A4_PDF and SHIP_RECPT_A4_RU_PDF template
    CustomsInvoiceTemplate -- The CustomsInvoiceTemplate element indicates the Customs Invoice templated used.
    Logo -- The Logo element determines DHL logo to be printed in thermal label printout
    CustomerLogo -- The CustomerLogo element consists of customer
    ’
    s company logo image in base64 and its image size format to be printed in Transport label
    Resolution -- The Resolution element indicates the DPI resolution required for label output on selected printer
    CustomerBarcodeType -- The CustomerBarcodeType element consists of customer
    ’
    s barcode type to be printed in Transport label using these 8X4_CustBarCode_PDF and 8X4_CustBarCode_thermal templates
    CustomerBarcodeCode -- The CustomerBarcodeCode element consists of customer
    ’
    s barcode code to be printed in Transport label using these 8X4_CustBarCode_PDF and 8X4_CustBarCode_thermal templates
    CustomerBarcodeText -- The CustomerBarcodeText element consists of customer
    ’
    s barcode text to be printed in Transport label using these 8X4_CustBarCode_PDF and 8X4_CustBarCode_thermal templates
    QRCodeTemplate -- The QRCodeTemplate element consists of QR Code Template if RequestQRCode option is selected.
    QRCodeImageFormat -- The QRCodeImageFormat element consists of QR Code Image Format if RequestQRCode option is selected.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, HideAccount=None, LabelTemplate=None, ReceiptTemplate=None, ShipmentReceiptWithLabels=None, CustomsInvoiceTemplate=None, Logo=None, CustomerLogo=None, Resolution=None, CustomerBarcodeType=None, CustomerBarcodeCode=None, CustomerBarcodeText=None, QRCodeTemplate=None, QRCodeImageFormat=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.HideAccount = HideAccount
        self.validate_YesNo(self.HideAccount)
        self.HideAccount_nsprefix_ = None
        self.LabelTemplate = LabelTemplate
        self.validate_LabelTemplate(self.LabelTemplate)
        self.LabelTemplate_nsprefix_ = None
        self.ReceiptTemplate = ReceiptTemplate
        self.validate_ReceiptTemplate(self.ReceiptTemplate)
        self.ReceiptTemplate_nsprefix_ = None
        self.ShipmentReceiptWithLabels = ShipmentReceiptWithLabels
        self.validate_YesNo(self.ShipmentReceiptWithLabels)
        self.ShipmentReceiptWithLabels_nsprefix_ = None
        self.CustomsInvoiceTemplate = CustomsInvoiceTemplate
        self.validate_CustomsInvoiceTemplate(self.CustomsInvoiceTemplate)
        self.CustomsInvoiceTemplate_nsprefix_ = None
        self.Logo = Logo
        self.validate_YesNo(self.Logo)
        self.Logo_nsprefix_ = None
        self.CustomerLogo = CustomerLogo
        self.CustomerLogo_nsprefix_ = None
        self.Resolution = Resolution
        self.validate_Resolution(self.Resolution)
        self.Resolution_nsprefix_ = None
        self.CustomerBarcodeType = CustomerBarcodeType
        self.CustomerBarcodeType_nsprefix_ = None
        self.CustomerBarcodeCode = CustomerBarcodeCode
        self.CustomerBarcodeCode_nsprefix_ = None
        self.CustomerBarcodeText = CustomerBarcodeText
        self.CustomerBarcodeText_nsprefix_ = None
        self.QRCodeTemplate = QRCodeTemplate
        self.validate_QRCodeTemplate(self.QRCodeTemplate)
        self.QRCodeTemplate_nsprefix_ = None
        self.QRCodeImageFormat = QRCodeImageFormat
        self.validate_QRCodeImageFormat(self.QRCodeImageFormat)
        self.QRCodeImageFormat_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Label)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Label.subclass:
            return Label.subclass(*args_, **kwargs_)
        else:
            return Label(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_HideAccount(self):
        return self.HideAccount
    def set_HideAccount(self, HideAccount):
        self.HideAccount = HideAccount
    def get_LabelTemplate(self):
        return self.LabelTemplate
    def set_LabelTemplate(self, LabelTemplate):
        self.LabelTemplate = LabelTemplate
    def get_ReceiptTemplate(self):
        return self.ReceiptTemplate
    def set_ReceiptTemplate(self, ReceiptTemplate):
        self.ReceiptTemplate = ReceiptTemplate
    def get_ShipmentReceiptWithLabels(self):
        return self.ShipmentReceiptWithLabels
    def set_ShipmentReceiptWithLabels(self, ShipmentReceiptWithLabels):
        self.ShipmentReceiptWithLabels = ShipmentReceiptWithLabels
    def get_CustomsInvoiceTemplate(self):
        return self.CustomsInvoiceTemplate
    def set_CustomsInvoiceTemplate(self, CustomsInvoiceTemplate):
        self.CustomsInvoiceTemplate = CustomsInvoiceTemplate
    def get_Logo(self):
        return self.Logo
    def set_Logo(self, Logo):
        self.Logo = Logo
    def get_CustomerLogo(self):
        return self.CustomerLogo
    def set_CustomerLogo(self, CustomerLogo):
        self.CustomerLogo = CustomerLogo
    def get_Resolution(self):
        return self.Resolution
    def set_Resolution(self, Resolution):
        self.Resolution = Resolution
    def get_CustomerBarcodeType(self):
        return self.CustomerBarcodeType
    def set_CustomerBarcodeType(self, CustomerBarcodeType):
        self.CustomerBarcodeType = CustomerBarcodeType
    def get_CustomerBarcodeCode(self):
        return self.CustomerBarcodeCode
    def set_CustomerBarcodeCode(self, CustomerBarcodeCode):
        self.CustomerBarcodeCode = CustomerBarcodeCode
    def get_CustomerBarcodeText(self):
        return self.CustomerBarcodeText
    def set_CustomerBarcodeText(self, CustomerBarcodeText):
        self.CustomerBarcodeText = CustomerBarcodeText
    def get_QRCodeTemplate(self):
        return self.QRCodeTemplate
    def set_QRCodeTemplate(self, QRCodeTemplate):
        self.QRCodeTemplate = QRCodeTemplate
    def get_QRCodeImageFormat(self):
        return self.QRCodeImageFormat
    def set_QRCodeImageFormat(self, QRCodeImageFormat):
        self.QRCodeImageFormat = QRCodeImageFormat
    def validate_YesNo(self, value):
        result = True
        # Validate type YesNo, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['Y', 'N']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on YesNo' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) != 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd length restriction on YesNo' % {"value": encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_LabelTemplate(self, value):
        result = True
        # Validate type LabelTemplate, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['8X4_A4_PDF', '8X4_thermal', '8X4_A4_TC_PDF', '6X4_thermal', '6X4_A4_PDF', '8X4_CI_PDF', '8X4_CI_thermal', '8X4_RU_A4_PDF', '6X4_PDF', '8X4_PDF', '8X4_CustBarCode_PDF', '8X4_CustBarCode_thermal', '8X4_CustBarCode_AdditionalInfo_PDF', '8X4_CustBarCode_AdditionalInfo_thermal', '8X4_LBBX_PDF', '8X4_LBBX_thermal', '7X11_thermal', 'ECOM26_64_001', 'ECOM26_64_002', 'ECOM26_64_004', 'ECOM26_74CI_001', 'ECOM26_84_002', 'ECOM26_84_002_CL', 'ECOM26_84_002_CO', 'ECOM26_84_003', 'ECOM26_A4_001', 'ECOM26_A6_001', 'ECOM26_A6_003']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on LabelTemplate' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_ReceiptTemplate(self, value):
        result = True
        # Validate type ReceiptTemplate, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['SHIP_RECPT_A4_RU_PDF']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ReceiptTemplate' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) > 30:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ReceiptTemplate' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CustomsInvoiceTemplate(self, value):
        result = True
        # Validate type CustomsInvoiceTemplate, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['COMMERCIAL_INVOICE_04', 'COMMERCIAL_INVOICE_P_10', 'COMMERCIAL_INVOICE_L_10', 'RET_COM_INVOICE_A4_01']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CustomsInvoiceTemplate' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Resolution(self, value):
        result = True
        # Validate type Resolution, a restriction on xsd:positiveInteger.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (int)' % {"value": value, "lineno": lineno, })
                return False
            if value < 200:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on Resolution' % {"value": value, "lineno": lineno} )
                result = False
            if value > 300:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on Resolution' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_QRCodeTemplate(self, value):
        result = True
        # Validate type QRCodeTemplate, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['QR_1_00_LL_PNG_001']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on QRCodeTemplate' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_QRCodeImageFormat(self, value):
        result = True
        # Validate type QRCodeImageFormat, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PNG']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on QRCodeImageFormat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.HideAccount is not None or
            self.LabelTemplate is not None or
            self.ReceiptTemplate is not None or
            self.ShipmentReceiptWithLabels is not None or
            self.CustomsInvoiceTemplate is not None or
            self.Logo is not None or
            self.CustomerLogo is not None or
            self.Resolution is not None or
            self.CustomerBarcodeType is not None or
            self.CustomerBarcodeCode is not None or
            self.CustomerBarcodeText is not None or
            self.QRCodeTemplate is not None or
            self.QRCodeImageFormat is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Label', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Label')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Label':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Label')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Label', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Label'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Label', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HideAccount is not None:
            namespaceprefix_ = self.HideAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.HideAccount_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHideAccount>%s</%sHideAccount>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.HideAccount), input_name='HideAccount')), namespaceprefix_ , eol_))
        if self.LabelTemplate is not None:
            namespaceprefix_ = self.LabelTemplate_nsprefix_ + ':' if (UseCapturedNS_ and self.LabelTemplate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLabelTemplate>%s</%sLabelTemplate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.LabelTemplate), input_name='LabelTemplate')), namespaceprefix_ , eol_))
        if self.ReceiptTemplate is not None:
            namespaceprefix_ = self.ReceiptTemplate_nsprefix_ + ':' if (UseCapturedNS_ and self.ReceiptTemplate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReceiptTemplate>%s</%sReceiptTemplate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ReceiptTemplate), input_name='ReceiptTemplate')), namespaceprefix_ , eol_))
        if self.ShipmentReceiptWithLabels is not None:
            namespaceprefix_ = self.ShipmentReceiptWithLabels_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentReceiptWithLabels_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentReceiptWithLabels>%s</%sShipmentReceiptWithLabels>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipmentReceiptWithLabels), input_name='ShipmentReceiptWithLabels')), namespaceprefix_ , eol_))
        if self.CustomsInvoiceTemplate is not None:
            namespaceprefix_ = self.CustomsInvoiceTemplate_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsInvoiceTemplate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomsInvoiceTemplate>%s</%sCustomsInvoiceTemplate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomsInvoiceTemplate), input_name='CustomsInvoiceTemplate')), namespaceprefix_ , eol_))
        if self.Logo is not None:
            namespaceprefix_ = self.Logo_nsprefix_ + ':' if (UseCapturedNS_ and self.Logo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLogo>%s</%sLogo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Logo), input_name='Logo')), namespaceprefix_ , eol_))
        if self.CustomerLogo is not None:
            namespaceprefix_ = self.CustomerLogo_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerLogo_nsprefix_) else ''
            self.CustomerLogo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomerLogo', pretty_print=pretty_print)
        if self.Resolution is not None:
            namespaceprefix_ = self.Resolution_nsprefix_ + ':' if (UseCapturedNS_ and self.Resolution_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sResolution>%s</%sResolution>%s' % (namespaceprefix_ , self.gds_format_integer(self.Resolution, input_name='Resolution'), namespaceprefix_ , eol_))
        if self.CustomerBarcodeType is not None:
            namespaceprefix_ = self.CustomerBarcodeType_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerBarcodeType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerBarcodeType>%s</%sCustomerBarcodeType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerBarcodeType), input_name='CustomerBarcodeType')), namespaceprefix_ , eol_))
        if self.CustomerBarcodeCode is not None:
            namespaceprefix_ = self.CustomerBarcodeCode_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerBarcodeCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerBarcodeCode>%s</%sCustomerBarcodeCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerBarcodeCode), input_name='CustomerBarcodeCode')), namespaceprefix_ , eol_))
        if self.CustomerBarcodeText is not None:
            namespaceprefix_ = self.CustomerBarcodeText_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerBarcodeText_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerBarcodeText>%s</%sCustomerBarcodeText>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerBarcodeText), input_name='CustomerBarcodeText')), namespaceprefix_ , eol_))
        if self.QRCodeTemplate is not None:
            namespaceprefix_ = self.QRCodeTemplate_nsprefix_ + ':' if (UseCapturedNS_ and self.QRCodeTemplate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sQRCodeTemplate>%s</%sQRCodeTemplate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.QRCodeTemplate), input_name='QRCodeTemplate')), namespaceprefix_ , eol_))
        if self.QRCodeImageFormat is not None:
            namespaceprefix_ = self.QRCodeImageFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.QRCodeImageFormat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sQRCodeImageFormat>%s</%sQRCodeImageFormat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.QRCodeImageFormat), input_name='QRCodeImageFormat')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'HideAccount':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'HideAccount')
            value_ = self.gds_validate_string(value_, node, 'HideAccount')
            self.HideAccount = value_
            self.HideAccount_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.HideAccount)
        elif nodeName_ == 'LabelTemplate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LabelTemplate')
            value_ = self.gds_validate_string(value_, node, 'LabelTemplate')
            self.LabelTemplate = value_
            self.LabelTemplate_nsprefix_ = child_.prefix
            # validate type LabelTemplate
            self.validate_LabelTemplate(self.LabelTemplate)
        elif nodeName_ == 'ReceiptTemplate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ReceiptTemplate')
            value_ = self.gds_validate_string(value_, node, 'ReceiptTemplate')
            self.ReceiptTemplate = value_
            self.ReceiptTemplate_nsprefix_ = child_.prefix
            # validate type ReceiptTemplate
            self.validate_ReceiptTemplate(self.ReceiptTemplate)
        elif nodeName_ == 'ShipmentReceiptWithLabels':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipmentReceiptWithLabels')
            value_ = self.gds_validate_string(value_, node, 'ShipmentReceiptWithLabels')
            self.ShipmentReceiptWithLabels = value_
            self.ShipmentReceiptWithLabels_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.ShipmentReceiptWithLabels)
        elif nodeName_ == 'CustomsInvoiceTemplate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomsInvoiceTemplate')
            value_ = self.gds_validate_string(value_, node, 'CustomsInvoiceTemplate')
            self.CustomsInvoiceTemplate = value_
            self.CustomsInvoiceTemplate_nsprefix_ = child_.prefix
            # validate type CustomsInvoiceTemplate
            self.validate_CustomsInvoiceTemplate(self.CustomsInvoiceTemplate)
        elif nodeName_ == 'Logo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Logo')
            value_ = self.gds_validate_string(value_, node, 'Logo')
            self.Logo = value_
            self.Logo_nsprefix_ = child_.prefix
            # validate type YesNo
            self.validate_YesNo(self.Logo)
        elif nodeName_ == 'CustomerLogo':
            obj_ = CustomerLogo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomerLogo = obj_
            obj_.original_tagname_ = 'CustomerLogo'
        elif nodeName_ == 'Resolution' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'Resolution')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'Resolution')
            self.Resolution = ival_
            self.Resolution_nsprefix_ = child_.prefix
            # validate type Resolution
            self.validate_Resolution(self.Resolution)
        elif nodeName_ == 'CustomerBarcodeType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomerBarcodeType')
            value_ = self.gds_validate_string(value_, node, 'CustomerBarcodeType')
            self.CustomerBarcodeType = value_
            self.CustomerBarcodeType_nsprefix_ = child_.prefix
        elif nodeName_ == 'CustomerBarcodeCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomerBarcodeCode')
            value_ = self.gds_validate_string(value_, node, 'CustomerBarcodeCode')
            self.CustomerBarcodeCode = value_
            self.CustomerBarcodeCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'CustomerBarcodeText':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomerBarcodeText')
            value_ = self.gds_validate_string(value_, node, 'CustomerBarcodeText')
            self.CustomerBarcodeText = value_
            self.CustomerBarcodeText_nsprefix_ = child_.prefix
        elif nodeName_ == 'QRCodeTemplate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'QRCodeTemplate')
            value_ = self.gds_validate_string(value_, node, 'QRCodeTemplate')
            self.QRCodeTemplate = value_
            self.QRCodeTemplate_nsprefix_ = child_.prefix
            # validate type QRCodeTemplate
            self.validate_QRCodeTemplate(self.QRCodeTemplate)
        elif nodeName_ == 'QRCodeImageFormat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'QRCodeImageFormat')
            value_ = self.gds_validate_string(value_, node, 'QRCodeImageFormat')
            self.QRCodeImageFormat = value_
            self.QRCodeImageFormat_nsprefix_ = child_.prefix
            # validate type QRCodeImageFormat
            self.validate_QRCodeImageFormat(self.QRCodeImageFormat)
# end class Label


class CustomerLogo(GeneratedsSuper):
    """CustomerLogo -- CustomerLogo
    LogoImage -- The LogoImage element indicates customer
    ’
    s logo image in base64 format
    LogoImageFormat -- The LogoImageFormat element indicates customer
    ’
    s logo image format
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, LogoImage=None, LogoImageFormat=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.LogoImage = LogoImage
        self.validate_LogoImage(self.LogoImage)
        self.LogoImage_nsprefix_ = None
        self.LogoImageFormat = LogoImageFormat
        self.validate_LogoImageFormat(self.LogoImageFormat)
        self.LogoImageFormat_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomerLogo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomerLogo.subclass:
            return CustomerLogo.subclass(*args_, **kwargs_)
        else:
            return CustomerLogo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_LogoImage(self):
        return self.LogoImage
    def set_LogoImage(self, LogoImage):
        self.LogoImage = LogoImage
    def get_LogoImageFormat(self):
        return self.LogoImageFormat
    def set_LogoImageFormat(self, LogoImageFormat):
        self.LogoImageFormat = LogoImageFormat
    def validate_LogoImage(self, value):
        result = True
        # Validate type LogoImage, a restriction on xsd:base64Binary.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if len(value) > 1048576:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on LogoImage' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_LogoImageFormat(self, value):
        result = True
        # Validate type LogoImageFormat, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['PNG', 'GIF', 'JPEG', 'JPG']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on LogoImageFormat' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.LogoImage is not None or
            self.LogoImageFormat is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerLogo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomerLogo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomerLogo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomerLogo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomerLogo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomerLogo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerLogo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.LogoImage is not None:
            namespaceprefix_ = self.LogoImage_nsprefix_ + ':' if (UseCapturedNS_ and self.LogoImage_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLogoImage>%s</%sLogoImage>%s' % (namespaceprefix_ , self.gds_format_base64(self.LogoImage, input_name='LogoImage'), namespaceprefix_ , eol_))
        if self.LogoImageFormat is not None:
            namespaceprefix_ = self.LogoImageFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.LogoImageFormat_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLogoImageFormat>%s</%sLogoImageFormat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.LogoImageFormat), input_name='LogoImageFormat')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LogoImage':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'LogoImage')
            else:
                bval_ = None
            self.LogoImage = bval_
            self.LogoImage_nsprefix_ = child_.prefix
            # validate type LogoImage
            self.validate_LogoImage(self.LogoImage)
        elif nodeName_ == 'LogoImageFormat':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'LogoImageFormat')
            value_ = self.gds_validate_string(value_, node, 'LogoImageFormat')
            self.LogoImageFormat = value_
            self.LogoImageFormat_nsprefix_ = child_.prefix
            # validate type LogoImageFormat
            self.validate_LogoImageFormat(self.LogoImageFormat)
# end class CustomerLogo


class DGs(GeneratedsSuper):
    """DGs -- Multiple Dangerous Goods Item
    DG -- The DG element contains the details of each Danagerous Goods item that included in the shipment
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, DG=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DG is None:
            self.DG = []
        else:
            self.DG = DG
        self.DG_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DGs)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DGs.subclass:
            return DGs.subclass(*args_, **kwargs_)
        else:
            return DGs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DG(self):
        return self.DG
    def set_DG(self, DG):
        self.DG = DG
    def add_DG(self, value):
        self.DG.append(value)
    def insert_DG_at(self, index, value):
        self.DG.insert(index, value)
    def replace_DG_at(self, index, value):
        self.DG[index] = value
    def _hasContent(self):
        if (
            self.DG
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DGs', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DGs')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DGs':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DGs')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DGs', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DGs'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DGs', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DG_ in self.DG:
            namespaceprefix_ = self.DG_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_nsprefix_) else ''
            DG_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DG', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DG':
            obj_ = DG.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DG.append(obj_)
            obj_.original_tagname_ = 'DG'
# end class DGs


class DG(GeneratedsSuper):
    """DG -- Dangerous Goods
    DG_ContentID -- The DG_ContentID element contains the Dangerous Goods Content ID that included in the shipment
    DG_LabelDesc -- The DG_LabelDesc element contains the Dangerous Goods Label Description that included in the shipment. It is recommended to leave it empty and it will be lookup via label rendering for the updated description
    DG_NetWeight -- The DG_NetWeight element contains the Dangerous Goods Net Weight that included in the shipment. It is required for Dry Ice with Unit of Measurement details also
    DG_UOM -- The DG_UOM element contains the Dangerous Goods Unit of Measurement that included in the shipment. It is required for Dry Ice with Net Weight details also
    DG_UNCodes -- The DG_UNCodes element contains child elements of DG_UNCode
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, DG_ContentID=None, DG_LabelDesc=None, DG_NetWeight=None, DG_UOM=None, DG_UNCodes=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.DG_ContentID = DG_ContentID
        self.DG_ContentID_nsprefix_ = None
        self.DG_LabelDesc = DG_LabelDesc
        self.validate_DG_LabelDescType(self.DG_LabelDesc)
        self.DG_LabelDesc_nsprefix_ = None
        self.DG_NetWeight = DG_NetWeight
        self.validate_Weight(self.DG_NetWeight)
        self.DG_NetWeight_nsprefix_ = None
        self.DG_UOM = DG_UOM
        self.validate_DG_UOM(self.DG_UOM)
        self.DG_UOM_nsprefix_ = None
        self.DG_UNCodes = DG_UNCodes
        self.DG_UNCodes_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DG)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DG.subclass:
            return DG.subclass(*args_, **kwargs_)
        else:
            return DG(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DG_ContentID(self):
        return self.DG_ContentID
    def set_DG_ContentID(self, DG_ContentID):
        self.DG_ContentID = DG_ContentID
    def get_DG_LabelDesc(self):
        return self.DG_LabelDesc
    def set_DG_LabelDesc(self, DG_LabelDesc):
        self.DG_LabelDesc = DG_LabelDesc
    def get_DG_NetWeight(self):
        return self.DG_NetWeight
    def set_DG_NetWeight(self, DG_NetWeight):
        self.DG_NetWeight = DG_NetWeight
    def get_DG_UOM(self):
        return self.DG_UOM
    def set_DG_UOM(self, DG_UOM):
        self.DG_UOM = DG_UOM
    def get_DG_UNCodes(self):
        return self.DG_UNCodes
    def set_DG_UNCodes(self, DG_UNCodes):
        self.DG_UNCodes = DG_UNCodes
    def validate_DG_LabelDescType(self, value):
        result = True
        # Validate type DG_LabelDescType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 200:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on DG_LabelDescType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_Weight(self, value):
        result = True
        # Validate type Weight, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if len(str(value)) >= 15:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd totalDigits restriction on Weight' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_DG_UOM(self, value):
        result = True
        # Validate type DG_UOM, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['KG', 'LB']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DG_UOM' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.DG_ContentID is not None or
            self.DG_LabelDesc is not None or
            self.DG_NetWeight is not None or
            self.DG_UOM is not None or
            self.DG_UNCodes is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DG', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DG')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DG':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DG')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DG', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DG'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DG', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.DG_ContentID is not None:
            namespaceprefix_ = self.DG_ContentID_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_ContentID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDG_ContentID>%s</%sDG_ContentID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DG_ContentID), input_name='DG_ContentID')), namespaceprefix_ , eol_))
        if self.DG_LabelDesc is not None:
            namespaceprefix_ = self.DG_LabelDesc_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_LabelDesc_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDG_LabelDesc>%s</%sDG_LabelDesc>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DG_LabelDesc), input_name='DG_LabelDesc')), namespaceprefix_ , eol_))
        if self.DG_NetWeight is not None:
            namespaceprefix_ = self.DG_NetWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_NetWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDG_NetWeight>%s</%sDG_NetWeight>%s' % (namespaceprefix_ , self.gds_format_decimal(self.DG_NetWeight, input_name='DG_NetWeight'), namespaceprefix_ , eol_))
        if self.DG_UOM is not None:
            namespaceprefix_ = self.DG_UOM_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_UOM_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDG_UOM>%s</%sDG_UOM>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DG_UOM), input_name='DG_UOM')), namespaceprefix_ , eol_))
        if self.DG_UNCodes is not None:
            namespaceprefix_ = self.DG_UNCodes_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_UNCodes_nsprefix_) else ''
            self.DG_UNCodes.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DG_UNCodes', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DG_ContentID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DG_ContentID')
            value_ = self.gds_validate_string(value_, node, 'DG_ContentID')
            self.DG_ContentID = value_
            self.DG_ContentID_nsprefix_ = child_.prefix
        elif nodeName_ == 'DG_LabelDesc':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DG_LabelDesc')
            value_ = self.gds_validate_string(value_, node, 'DG_LabelDesc')
            self.DG_LabelDesc = value_
            self.DG_LabelDesc_nsprefix_ = child_.prefix
            # validate type DG_LabelDescType
            self.validate_DG_LabelDescType(self.DG_LabelDesc)
        elif nodeName_ == 'DG_NetWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'DG_NetWeight')
            fval_ = self.gds_validate_decimal(fval_, node, 'DG_NetWeight')
            self.DG_NetWeight = fval_
            self.DG_NetWeight_nsprefix_ = child_.prefix
            # validate type Weight
            self.validate_Weight(self.DG_NetWeight)
        elif nodeName_ == 'DG_UOM':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DG_UOM')
            value_ = self.gds_validate_string(value_, node, 'DG_UOM')
            self.DG_UOM = value_
            self.DG_UOM_nsprefix_ = child_.prefix
            # validate type DG_UOM
            self.validate_DG_UOM(self.DG_UOM)
        elif nodeName_ == 'DG_UNCodes':
            obj_ = DG_UNCodes.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DG_UNCodes = obj_
            obj_.original_tagname_ = 'DG_UNCodes'
# end class DG


class DG_UNCodes(GeneratedsSuper):
    """DG_UNCodes -- Multiple Dangerous Goods UN numbers
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, DG_UNCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if DG_UNCode is None:
            self.DG_UNCode = []
        else:
            self.DG_UNCode = DG_UNCode
        self.DG_UNCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DG_UNCodes)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DG_UNCodes.subclass:
            return DG_UNCodes.subclass(*args_, **kwargs_)
        else:
            return DG_UNCodes(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_DG_UNCode(self):
        return self.DG_UNCode
    def set_DG_UNCode(self, DG_UNCode):
        self.DG_UNCode = DG_UNCode
    def add_DG_UNCode(self, value):
        self.DG_UNCode.append(value)
    def insert_DG_UNCode_at(self, index, value):
        self.DG_UNCode.insert(index, value)
    def replace_DG_UNCode_at(self, index, value):
        self.DG_UNCode[index] = value
    def validate_DG_UNCodeType(self, value):
        result = True
        # Validate type DG_UNCodeType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 10:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on DG_UNCodeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on DG_UNCodeType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.DG_UNCode
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DG_UNCodes', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DG_UNCodes')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DG_UNCodes':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DG_UNCodes')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DG_UNCodes', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DG_UNCodes'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DG_UNCodes', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for DG_UNCode_ in self.DG_UNCode:
            namespaceprefix_ = self.DG_UNCode_nsprefix_ + ':' if (UseCapturedNS_ and self.DG_UNCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDG_UNCode>%s</%sDG_UNCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(DG_UNCode_), input_name='DG_UNCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'DG_UNCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DG_UNCode')
            value_ = self.gds_validate_string(value_, node, 'DG_UNCode')
            self.DG_UNCode.append(value_)
            self.DG_UNCode_nsprefix_ = child_.prefix
            # validate type DG_UNCodeType
            self.validate_DG_UNCodeType(self.DG_UNCode[-1])
# end class DG_UNCodes


class ShipmentDocument(GeneratedsSuper):
    """ShipmentDocument -- Shipment Document
    ShipmentDocumentReference -- This element contains export declaration
    ’
    s shipment document reference value.It is an optional field
    DocumentTypeName -- This element contains export declaration
    ’
    s shipment document type name value.It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ShipmentDocumentReference=None, DocumentTypeName=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ShipmentDocumentReference = ShipmentDocumentReference
        self.validate_ShipmentDocumentReferenceType(self.ShipmentDocumentReference)
        self.ShipmentDocumentReference_nsprefix_ = None
        self.DocumentTypeName = DocumentTypeName
        self.validate_DocumentTypeNameType(self.DocumentTypeName)
        self.DocumentTypeName_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ShipmentDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ShipmentDocument.subclass:
            return ShipmentDocument.subclass(*args_, **kwargs_)
        else:
            return ShipmentDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ShipmentDocumentReference(self):
        return self.ShipmentDocumentReference
    def set_ShipmentDocumentReference(self, ShipmentDocumentReference):
        self.ShipmentDocumentReference = ShipmentDocumentReference
    def get_DocumentTypeName(self):
        return self.DocumentTypeName
    def set_DocumentTypeName(self, DocumentTypeName):
        self.DocumentTypeName = DocumentTypeName
    def validate_ShipmentDocumentReferenceType(self, value):
        result = True
        # Validate type ShipmentDocumentReferenceType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on ShipmentDocumentReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ShipmentDocumentReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_DocumentTypeNameType(self, value):
        result = True
        # Validate type DocumentTypeNameType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on DocumentTypeNameType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on DocumentTypeNameType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ShipmentDocumentReference is not None or
            self.DocumentTypeName is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ShipmentDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ShipmentDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ShipmentDocument')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ShipmentDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ShipmentDocument'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ShipmentDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ShipmentDocumentReference is not None:
            namespaceprefix_ = self.ShipmentDocumentReference_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipmentDocumentReference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipmentDocumentReference>%s</%sShipmentDocumentReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipmentDocumentReference), input_name='ShipmentDocumentReference')), namespaceprefix_ , eol_))
        if self.DocumentTypeName is not None:
            namespaceprefix_ = self.DocumentTypeName_nsprefix_ + ':' if (UseCapturedNS_ and self.DocumentTypeName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDocumentTypeName>%s</%sDocumentTypeName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DocumentTypeName), input_name='DocumentTypeName')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ShipmentDocumentReference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipmentDocumentReference')
            value_ = self.gds_validate_string(value_, node, 'ShipmentDocumentReference')
            self.ShipmentDocumentReference = value_
            self.ShipmentDocumentReference_nsprefix_ = child_.prefix
            # validate type ShipmentDocumentReferenceType
            self.validate_ShipmentDocumentReferenceType(self.ShipmentDocumentReference)
        elif nodeName_ == 'DocumentTypeName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DocumentTypeName')
            value_ = self.gds_validate_string(value_, node, 'DocumentTypeName')
            self.DocumentTypeName = value_
            self.DocumentTypeName_nsprefix_ = child_.prefix
            # validate type DocumentTypeNameType
            self.validate_DocumentTypeNameType(self.DocumentTypeName)
# end class ShipmentDocument


class CustomerDataTextEntries(GeneratedsSuper):
    """CustomerDataTextEntries -- Customer Data Texts that would like to be printed in COMMERCIAL_INVOICE_04 template
    CustomerDataTextEntry -- Customer Data Texts that would like to be printed in COMMERCIAL_INVOICE_04 template
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomerDataTextEntry=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CustomerDataTextEntry is None:
            self.CustomerDataTextEntry = []
        else:
            self.CustomerDataTextEntry = CustomerDataTextEntry
        self.CustomerDataTextEntry_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomerDataTextEntries)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomerDataTextEntries.subclass:
            return CustomerDataTextEntries.subclass(*args_, **kwargs_)
        else:
            return CustomerDataTextEntries(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomerDataTextEntry(self):
        return self.CustomerDataTextEntry
    def set_CustomerDataTextEntry(self, CustomerDataTextEntry):
        self.CustomerDataTextEntry = CustomerDataTextEntry
    def add_CustomerDataTextEntry(self, value):
        self.CustomerDataTextEntry.append(value)
    def insert_CustomerDataTextEntry_at(self, index, value):
        self.CustomerDataTextEntry.insert(index, value)
    def replace_CustomerDataTextEntry_at(self, index, value):
        self.CustomerDataTextEntry[index] = value
    def _hasContent(self):
        if (
            self.CustomerDataTextEntry
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerDataTextEntries', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomerDataTextEntries')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomerDataTextEntries':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomerDataTextEntries')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomerDataTextEntries', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomerDataTextEntries'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerDataTextEntries', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CustomerDataTextEntry_ in self.CustomerDataTextEntry:
            namespaceprefix_ = self.CustomerDataTextEntry_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerDataTextEntry_nsprefix_) else ''
            CustomerDataTextEntry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomerDataTextEntry', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomerDataTextEntry':
            obj_ = CustomerDataTextEntry.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomerDataTextEntry.append(obj_)
            obj_.original_tagname_ = 'CustomerDataTextEntry'
# end class CustomerDataTextEntries


class CustomerDataTextEntry(GeneratedsSuper):
    """CustomerDataTextEntry -- Customer Data Texts that would like to be printed in COMMERCIAL_INVOICE_04 template
    CustomerDataTextNumber -- Customer Data Texts Number
    CustomerDataText -- Customs Invoice - Customer Data Text in COMMERCIAL_INVOICE_04 template
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomerDataTextNumber=None, CustomerDataText=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CustomerDataTextNumber = CustomerDataTextNumber
        self.validate_CustomerDataTextNumber(self.CustomerDataTextNumber)
        self.CustomerDataTextNumber_nsprefix_ = None
        self.CustomerDataText = CustomerDataText
        self.validate_CustomerDataText(self.CustomerDataText)
        self.CustomerDataText_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomerDataTextEntry)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomerDataTextEntry.subclass:
            return CustomerDataTextEntry.subclass(*args_, **kwargs_)
        else:
            return CustomerDataTextEntry(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomerDataTextNumber(self):
        return self.CustomerDataTextNumber
    def set_CustomerDataTextNumber(self, CustomerDataTextNumber):
        self.CustomerDataTextNumber = CustomerDataTextNumber
    def get_CustomerDataText(self):
        return self.CustomerDataText
    def set_CustomerDataText(self, CustomerDataText):
        self.CustomerDataText = CustomerDataText
    def validate_CustomerDataTextNumber(self, value):
        result = True
        # Validate type CustomerDataTextNumber, a restriction on xsd:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomerDataTextNumber' % {"value": value, "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CustomerDataTextNumber' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CustomerDataTextNumber_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CustomerDataTextNumber_patterns_, ))
                result = False
        return result
    validate_CustomerDataTextNumber_patterns_ = [['^(([1-6])*)$']]
    def validate_CustomerDataText(self, value):
        result = True
        # Validate type CustomerDataText, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 45:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomerDataText' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CustomerDataTextNumber is not None or
            self.CustomerDataText is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerDataTextEntry', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomerDataTextEntry')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomerDataTextEntry':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomerDataTextEntry')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomerDataTextEntry', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomerDataTextEntry'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomerDataTextEntry', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CustomerDataTextNumber is not None:
            namespaceprefix_ = self.CustomerDataTextNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerDataTextNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerDataTextNumber>%s</%sCustomerDataTextNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerDataTextNumber), input_name='CustomerDataTextNumber')), namespaceprefix_ , eol_))
        if self.CustomerDataText is not None:
            namespaceprefix_ = self.CustomerDataText_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomerDataText_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomerDataText>%s</%sCustomerDataText>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomerDataText), input_name='CustomerDataText')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomerDataTextNumber':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'CustomerDataTextNumber')
            value_ = self.gds_validate_string(value_, node, 'CustomerDataTextNumber')
            self.CustomerDataTextNumber = value_
            self.CustomerDataTextNumber_nsprefix_ = child_.prefix
            # validate type CustomerDataTextNumber
            self.validate_CustomerDataTextNumber(self.CustomerDataTextNumber)
        elif nodeName_ == 'CustomerDataText':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomerDataText')
            value_ = self.gds_validate_string(value_, node, 'CustomerDataText')
            self.CustomerDataText = value_
            self.CustomerDataText_nsprefix_ = child_.prefix
            # validate type CustomerDataText
            self.validate_CustomerDataText(self.CustomerDataText)
# end class CustomerDataTextEntry


class CustomsDocuments(GeneratedsSuper):
    """CustomsDocuments -- Export Declaration's level Customs Document details.Document type required for the clearance of goods at Invoice level
    CustomsDocument -- Export Declaration's level Customs Document entry
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomsDocument=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CustomsDocument is None:
            self.CustomsDocument = []
        else:
            self.CustomsDocument = CustomsDocument
        self.CustomsDocument_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomsDocuments)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsDocuments.subclass:
            return CustomsDocuments.subclass(*args_, **kwargs_)
        else:
            return CustomsDocuments(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomsDocument(self):
        return self.CustomsDocument
    def set_CustomsDocument(self, CustomsDocument):
        self.CustomsDocument = CustomsDocument
    def add_CustomsDocument(self, value):
        self.CustomsDocument.append(value)
    def insert_CustomsDocument_at(self, index, value):
        self.CustomsDocument.insert(index, value)
    def replace_CustomsDocument_at(self, index, value):
        self.CustomsDocument[index] = value
    def _hasContent(self):
        if (
            self.CustomsDocument
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsDocuments', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomsDocuments')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomsDocuments':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomsDocuments')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomsDocuments', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomsDocuments'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsDocuments', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CustomsDocument_ in self.CustomsDocument:
            namespaceprefix_ = self.CustomsDocument_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsDocument_nsprefix_) else ''
            CustomsDocument_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CustomsDocument', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomsDocument':
            obj_ = CustomsDocument.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CustomsDocument.append(obj_)
            obj_.original_tagname_ = 'CustomsDocument'
# end class CustomsDocuments


class CustomsDocument(GeneratedsSuper):
    """CustomsDocument -- Export Declaration's level Customs Document entry
    CustomsDocumentType -- Export Declaration line's Customs Document Type (CHA:Power of Attorney,
    POA:Power of Attorney (Customer-based),PPY:Proof Of Payment,ROD:Receipt on Delivery,
    T2M:T2M Transport Accompanying Document,TAD:TAD Transport Accompanying Document T1,
    TCS:Transportation Charges Statement, ELP:Export Licenses and Permits, MTO:Military Transport Orders)
    CustomsDocumentID -- Export Declaration line's Customs Document ID
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CustomsDocumentType=None, CustomsDocumentID=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CustomsDocumentType = CustomsDocumentType
        self.validate_CustomsDocumentType(self.CustomsDocumentType)
        self.CustomsDocumentType_nsprefix_ = None
        self.CustomsDocumentID = CustomsDocumentID
        self.validate_CustomsDocumentID(self.CustomsDocumentID)
        self.CustomsDocumentID_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CustomsDocument)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CustomsDocument.subclass:
            return CustomsDocument.subclass(*args_, **kwargs_)
        else:
            return CustomsDocument(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CustomsDocumentType(self):
        return self.CustomsDocumentType
    def set_CustomsDocumentType(self, CustomsDocumentType):
        self.CustomsDocumentType = CustomsDocumentType
    def get_CustomsDocumentID(self):
        return self.CustomsDocumentID
    def set_CustomsDocumentID(self, CustomsDocumentID):
        self.CustomsDocumentID = CustomsDocumentID
    def validate_CustomsDocumentType(self, value):
        result = True
        # Validate type CustomsDocumentType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomsDocumentType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CustomsDocumentType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_CustomsDocumentID(self, value):
        result = True
        # Validate type CustomsDocumentID, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on CustomsDocumentID' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.CustomsDocumentType is not None or
            self.CustomsDocumentID is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsDocument', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CustomsDocument')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CustomsDocument':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CustomsDocument')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CustomsDocument', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CustomsDocument'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CustomsDocument', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CustomsDocumentType is not None:
            namespaceprefix_ = self.CustomsDocumentType_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsDocumentType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomsDocumentType>%s</%sCustomsDocumentType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomsDocumentType), input_name='CustomsDocumentType')), namespaceprefix_ , eol_))
        if self.CustomsDocumentID is not None:
            namespaceprefix_ = self.CustomsDocumentID_nsprefix_ + ':' if (UseCapturedNS_ and self.CustomsDocumentID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCustomsDocumentID>%s</%sCustomsDocumentID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CustomsDocumentID), input_name='CustomsDocumentID')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CustomsDocumentType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomsDocumentType')
            value_ = self.gds_validate_string(value_, node, 'CustomsDocumentType')
            self.CustomsDocumentType = value_
            self.CustomsDocumentType_nsprefix_ = child_.prefix
            # validate type CustomsDocumentType
            self.validate_CustomsDocumentType(self.CustomsDocumentType)
        elif nodeName_ == 'CustomsDocumentID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CustomsDocumentID')
            value_ = self.gds_validate_string(value_, node, 'CustomsDocumentID')
            self.CustomsDocumentID = value_
            self.CustomsDocumentID_nsprefix_ = child_.prefix
            # validate type CustomsDocumentID
            self.validate_CustomsDocumentID(self.CustomsDocumentID)
# end class CustomsDocument


class InvoiceReferences(GeneratedsSuper):
    """InvoiceReferences -- Customs Invoice References
    InvoiceReference -- Customs Invoice Reference entry
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, InvoiceReference=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if InvoiceReference is None:
            self.InvoiceReference = []
        else:
            self.InvoiceReference = InvoiceReference
        self.InvoiceReference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InvoiceReferences)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InvoiceReferences.subclass:
            return InvoiceReferences.subclass(*args_, **kwargs_)
        else:
            return InvoiceReferences(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_InvoiceReference(self):
        return self.InvoiceReference
    def set_InvoiceReference(self, InvoiceReference):
        self.InvoiceReference = InvoiceReference
    def add_InvoiceReference(self, value):
        self.InvoiceReference.append(value)
    def insert_InvoiceReference_at(self, index, value):
        self.InvoiceReference.insert(index, value)
    def replace_InvoiceReference_at(self, index, value):
        self.InvoiceReference[index] = value
    def _hasContent(self):
        if (
            self.InvoiceReference
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InvoiceReferences', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InvoiceReferences')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InvoiceReferences':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InvoiceReferences')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InvoiceReferences', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InvoiceReferences'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InvoiceReferences', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for InvoiceReference_ in self.InvoiceReference:
            namespaceprefix_ = self.InvoiceReference_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceReference_nsprefix_) else ''
            InvoiceReference_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InvoiceReference', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InvoiceReference':
            obj_ = InvoiceReference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InvoiceReference.append(obj_)
            obj_.original_tagname_ = 'InvoiceReference'
# end class InvoiceReferences


class InvoiceReference(GeneratedsSuper):
    """InvoiceReference -- Customs Invoice Reference entry
    InvoiceReferenceType -- Invoice Reference Type
    InvoiceReferenceNumber -- Invoice Reference Number
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, InvoiceReferenceType=None, InvoiceReferenceNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.InvoiceReferenceType = InvoiceReferenceType
        self.validate_InvoiceReferenceType(self.InvoiceReferenceType)
        self.InvoiceReferenceType_nsprefix_ = None
        self.InvoiceReferenceNumber = InvoiceReferenceNumber
        self.validate_InvoiceReferenceNumber(self.InvoiceReferenceNumber)
        self.InvoiceReferenceNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InvoiceReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InvoiceReference.subclass:
            return InvoiceReference.subclass(*args_, **kwargs_)
        else:
            return InvoiceReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_InvoiceReferenceType(self):
        return self.InvoiceReferenceType
    def set_InvoiceReferenceType(self, InvoiceReferenceType):
        self.InvoiceReferenceType = InvoiceReferenceType
    def get_InvoiceReferenceNumber(self):
        return self.InvoiceReferenceNumber
    def set_InvoiceReferenceNumber(self, InvoiceReferenceNumber):
        self.InvoiceReferenceNumber = InvoiceReferenceNumber
    def validate_InvoiceReferenceType(self, value):
        result = True
        # Validate type InvoiceReferenceType, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 3:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on InvoiceReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 2:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on InvoiceReferenceType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_InvoiceReferenceNumber(self, value):
        result = True
        # Validate type InvoiceReferenceNumber, a restriction on xsd:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) > 35:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxLength restriction on InvoiceReferenceNumber' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.InvoiceReferenceType is not None or
            self.InvoiceReferenceNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InvoiceReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InvoiceReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InvoiceReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InvoiceReference')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InvoiceReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InvoiceReference'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InvoiceReference', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.InvoiceReferenceType is not None:
            namespaceprefix_ = self.InvoiceReferenceType_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceReferenceType_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceReferenceType>%s</%sInvoiceReferenceType>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InvoiceReferenceType), input_name='InvoiceReferenceType')), namespaceprefix_ , eol_))
        if self.InvoiceReferenceNumber is not None:
            namespaceprefix_ = self.InvoiceReferenceNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.InvoiceReferenceNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInvoiceReferenceNumber>%s</%sInvoiceReferenceNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InvoiceReferenceNumber), input_name='InvoiceReferenceNumber')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'InvoiceReferenceType':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InvoiceReferenceType')
            value_ = self.gds_validate_string(value_, node, 'InvoiceReferenceType')
            self.InvoiceReferenceType = value_
            self.InvoiceReferenceType_nsprefix_ = child_.prefix
            # validate type InvoiceReferenceType
            self.validate_InvoiceReferenceType(self.InvoiceReferenceType)
        elif nodeName_ == 'InvoiceReferenceNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InvoiceReferenceNumber')
            value_ = self.gds_validate_string(value_, node, 'InvoiceReferenceNumber')
            self.InvoiceReferenceNumber = value_
            self.InvoiceReferenceNumber_nsprefix_ = child_.prefix
            # validate type InvoiceReferenceNumber
            self.validate_InvoiceReferenceNumber(self.InvoiceReferenceNumber)
# end class InvoiceReference


class InvoiceIndicativeCustomsValues(GeneratedsSuper):
    """InvoiceIndicativeCustomsValues -- Indicative Customs Values
    ImportCustomsDutyValue -- The pre-calculated import customs duties value for the shipment. It is an optional field
    ImportTaxesValue -- The pre-calculated import taxes (VAT/GST) value for the shipment. It is an optional field
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ImportCustomsDutyValue=None, ImportTaxesValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ImportCustomsDutyValue = ImportCustomsDutyValue
        self.validate_ImportCustomsDutyValueType(self.ImportCustomsDutyValue)
        self.ImportCustomsDutyValue_nsprefix_ = None
        self.ImportTaxesValue = ImportTaxesValue
        self.validate_ImportTaxesValueType(self.ImportTaxesValue)
        self.ImportTaxesValue_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InvoiceIndicativeCustomsValues)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InvoiceIndicativeCustomsValues.subclass:
            return InvoiceIndicativeCustomsValues.subclass(*args_, **kwargs_)
        else:
            return InvoiceIndicativeCustomsValues(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ImportCustomsDutyValue(self):
        return self.ImportCustomsDutyValue
    def set_ImportCustomsDutyValue(self, ImportCustomsDutyValue):
        self.ImportCustomsDutyValue = ImportCustomsDutyValue
    def get_ImportTaxesValue(self):
        return self.ImportTaxesValue
    def set_ImportTaxesValue(self, ImportTaxesValue):
        self.ImportTaxesValue = ImportTaxesValue
    def validate_ImportCustomsDutyValueType(self, value):
        result = True
        # Validate type ImportCustomsDutyValueType, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ImportCustomsDutyValueType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ImportCustomsDutyValueType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def validate_ImportTaxesValueType(self, value):
        result = True
        # Validate type ImportTaxesValueType, a restriction on xsd:decimal.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, decimal_.Decimal):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (decimal_.Decimal)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.000:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ImportTaxesValueType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 999999999999999.999:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ImportTaxesValueType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def _hasContent(self):
        if (
            self.ImportCustomsDutyValue is not None or
            self.ImportTaxesValue is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InvoiceIndicativeCustomsValues', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('InvoiceIndicativeCustomsValues')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'InvoiceIndicativeCustomsValues':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='InvoiceIndicativeCustomsValues')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='InvoiceIndicativeCustomsValues', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='InvoiceIndicativeCustomsValues'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='InvoiceIndicativeCustomsValues', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ImportCustomsDutyValue is not None:
            namespaceprefix_ = self.ImportCustomsDutyValue_nsprefix_ + ':' if (UseCapturedNS_ and self.ImportCustomsDutyValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImportCustomsDutyValue>%s</%sImportCustomsDutyValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.ImportCustomsDutyValue, input_name='ImportCustomsDutyValue'), namespaceprefix_ , eol_))
        if self.ImportTaxesValue is not None:
            namespaceprefix_ = self.ImportTaxesValue_nsprefix_ + ':' if (UseCapturedNS_ and self.ImportTaxesValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sImportTaxesValue>%s</%sImportTaxesValue>%s' % (namespaceprefix_ , self.gds_format_decimal(self.ImportTaxesValue, input_name='ImportTaxesValue'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ImportCustomsDutyValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'ImportCustomsDutyValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'ImportCustomsDutyValue')
            self.ImportCustomsDutyValue = fval_
            self.ImportCustomsDutyValue_nsprefix_ = child_.prefix
            # validate type ImportCustomsDutyValueType
            self.validate_ImportCustomsDutyValueType(self.ImportCustomsDutyValue)
        elif nodeName_ == 'ImportTaxesValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_decimal(sval_, node, 'ImportTaxesValue')
            fval_ = self.gds_validate_decimal(fval_, node, 'ImportTaxesValue')
            self.ImportTaxesValue = fval_
            self.ImportTaxesValue_nsprefix_ = child_.prefix
            # validate type ImportTaxesValueType
            self.validate_ImportTaxesValueType(self.ImportTaxesValue)
# end class InvoiceIndicativeCustomsValues


class Importer(GeneratedsSuper):
    """CompanyName -- The CompanyName element contains the name of the company
    SuiteDepartmentName -- The SuiteDepartmentName element contains the suite or department name of the company
    AddressLine1 -- The AddressLine 1 element contains the address line 1 to the Importer. It is mandatory field.
    AddressLine2 -- The AddressLine 2 element contains the address line 2 to the Importer.
    AddressLine3 -- The AddressLine 3 element contains the address line 3 to the Importer.
    City -- The City element contains the City of the Importer address. It must be declared in the Importer element for Country/Region that used city
    Division -- The Division name of the Importer location, for instance State, County, Prefecture, etc
    DivisionCode -- The division code of the Importer location
    PostalCode -- The Postal Code element contains the postal code of the Importer location
    CountryCode -- The Country Code element contains the Country/Region code of the Importer location. It must be 2 letters. Please refer to the Reference Data (DHL Country/Region) for country/region codes
    CountryName -- The CountryName element contains Country/Region name of the Importer. Its value should be a valid DHL Country/Region name. This element must be declared once in the Importer element. Please refer to the Reference Data (DHL Country/Region) for a list of valid Country/Region names
    Contact -- The Contact element contains the Importer's contact information. It must be declared in the Importer element
    Suburb -- The suburb element contains Importer
    ’
    s suburb name. It is an optional field
    StreetName -- The Contact element contains the Importer
    ’
    s street name.It is an optional field
    BuildingName -- The Contact element contains the Importer
    ’
    s Building Name.It is an optional field
    StreetNumber -- The Contact element contains the Importer
    ’
    s It is an optional field. It is an optional field
    RegistrationNumbers -- The Contact element contains the Importer
    ’
    s contact information.
    BusinessPartyTypeCode -- The Contact element contains the Importer
    ’
    s Business Party Type Code.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CompanyName=None, SuiteDepartmentName=None, AddressLine1=None, AddressLine2=None, AddressLine3=None, City=None, Division=None, DivisionCode=None, PostalCode=None, CountryCode=None, CountryName=None, Contact=None, Suburb=None, StreetName=None, BuildingName=None, StreetNumber=None, RegistrationNumbers=None, BusinessPartyTypeCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CompanyName = CompanyName
        self.validate_CompanyNameValidator(self.CompanyName)
        self.CompanyName_nsprefix_ = None
        self.SuiteDepartmentName = SuiteDepartmentName
        self.validate_SuiteDepartmentName(self.SuiteDepartmentName)
        self.SuiteDepartmentName_nsprefix_ = None
        self.AddressLine1 = AddressLine1
        self.validate_AddressLine(self.AddressLine1)
        self.AddressLine1_nsprefix_ = None
        self.AddressLine2 = AddressLine2
        self.validate_AddressLine(self.AddressLine2)
        self.AddressLine2_nsprefix_ = None
        self.AddressLine3 = AddressLine3
        self.validate_AddressLine(self.AddressLine3)
        self.AddressLine3_nsprefix_ = None
        self.City = City
        self.validate_City(self.City)
        self.City_nsprefix_ = None
        self.Division = Division
        self.validate_Division(self.Division)
        self.Division_nsprefix_ = None
        self.DivisionCode = DivisionCode
        self.validate_DivisionCode(self.DivisionCode)
        self.DivisionCode_nsprefix_ = None
        self.PostalCode = PostalCode
        self.validate_PostalCode(self.PostalCode)
        self.PostalCode_nsprefix_ = None
        self.CountryCode = CountryCode
        self.validate_CountryCode(self.CountryCode)
        self.CountryCode_nsprefix_ = None
        self.CountryName = CountryName
        self.validate_CountryName(self.CountryName)
        self.CountryName_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Suburb = Suburb
        self.validate_Suburb(self.Suburb)
        self.Suburb_nsprefix_ = None
        self.StreetName = Str