# Filename: test_agent_selected_simulate_richvisual.py

from textual.app import App, ComposeResult
from textual.widgets import Label
from textual.events import Event
from textual import on
from rich.text import Text

class AgentSelected(Event):
    def __init__(self, agent_name):
        self.agent_name = agent_name
        super().__init__()

# Simulate the RichVisual-like object
class SimulatedAgentName:
    def __init__(self, widget):
        self.widget = widget

    def __str__(self):
        return f"SimulatedAgentName({str(self.widget)}, {repr(self.widget.renderable)})"

class TestApp(App):

    def compose(self) -> ComposeResult:
        # Create labels to display the results
        self.label_method1 = Label()
        self.label_method2 = Label()
        self.label_method3 = Label()
        self.label_method4 = Label()
        # Yield labels to be displayed
        yield self.label_method1
        yield self.label_method2
        yield self.label_method3
        yield self.label_method4

    @on(AgentSelected)
    def on_agent_selected(self, event: AgentSelected):
        # Attempt to extract agent name in various ways

        # Method 1: Access event.agent_name.widget.text
        try:
            agent_name_str = event.agent_name.widget.text
            self.label_method1.update(f"Method 1 - widget.text: {agent_name_str}")
        except AttributeError as e:
            self.label_method1.update(f"Method 1 failed: {e}")

        # Method 2: Access event.agent_name.widget.renderable.plain
        try:
            agent_name_str = event.agent_name.widget.renderable.plain
            self.label_method2.update(f"Method 2 - renderable.plain: {agent_name_str}")
        except AttributeError as e:
            self.label_method2.update(f"Method 2 failed: {e}")

        # Method 3: Use str(event.agent_name)
        agent_name_str = str(event.agent_name)
        self.label_method3.update(f"Method 3 - str(agent_name): {agent_name_str}")

        # Method 4: Access event.agent_name.widget.renderable
        try:
            agent_name_str = str(event.agent_name.widget.renderable)
            self.label_method4.update(f"Method 4 - renderable: {agent_name_str}")
        except AttributeError as e:
            self.label_method4.update(f"Method 4 failed: {e}")

    def on_mount(self):
        # Create a Label widget with the agent name
        agent_label = Label("Agent007")
        # Wrap the Label in a SimulatedAgentName object
        simulated_agent_name = SimulatedAgentName(agent_label)
        # Post the AgentSelected event with agent_name as the simulated object
        self.post_message(AgentSelected(agent_name=simulated_agent_name))

if __name__ == "__main__":
    app = TestApp()
    app.run()
