# Generated by Django 3.0.8 on 2020-07-24 09:19

from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('city', models.CharField(max_length=128)),
                ('country', django_countries.fields.CountryField(default='DE', max_length=2)),
                ('zip_code', models.CharField(max_length=16)),
                ('street', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=128)),
                ('last_name', models.CharField(max_length=128)),
                ('display_name', models.CharField(max_length=255)),
                ('gender', models.PositiveSmallIntegerField(choices=[(0, 'female'), (1, 'male'), (2, 'diverse')])),
                ('date_of_birth', models.DateField()),
                ('email', models.EmailField(blank=True, default='', max_length=254)),
                ('address', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='subjects.Address')),
            ],
        ),
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='subjects.Contact')),
                ('guardians', models.ManyToManyField(blank=True, related_name='subjects', to='subjects.Contact')),
            ],
        ),
        migrations.CreateModel(
            name='Phone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.PositiveSmallIntegerField(choices=[(0, 'mobile'), (1, 'home'), (2, 'work'), (3, 'emergency'), (255, 'other')])),
                ('number', phonenumber_field.modelfields.PhoneNumberField(max_length=128, region=None)),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='phones', to='subjects.Contact')),
            ],
        ),
        migrations.CreateModel(
            name='Patient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subjects.Subject')),
            ],
        ),
        migrations.CreateModel(
            name='Inactivity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('until', models.DateField(null=True)),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subjects.Subject')),
            ],
        ),
        migrations.CreateModel(
            name='Child',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='subjects.Subject')),
            ],
        ),
    ]
