/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public abstract class RawParameterMetaData {
    private RawPreparedStatement pstmt = null;
    private int numberOfParameters = 1;

    public RawParameterMetaData(RawPreparedStatement rawPreparedStatement) throws SQLException {
        this.pstmt = rawPreparedStatement;
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > this.numberOfParameters) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    public String getParameterClassName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "[B";
    }

    public int getParameterCount() throws SQLException {
        this.pstmt.abortIfClosed();
        return this.numberOfParameters;
    }

    public int getParameterMode(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public int getParameterType(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return -3;
    }

    public String getParameterTypeName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "VARBYTE";
    }

    public int getPrecision(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public int getScale(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public int isNullable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }
}

