# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-22T15:11:33+00:00

from __future__ import annotations

from fastapi import FastAPI

from .routers import (
    agents,
    authentication,
    control,
    enforcement,
    health,
    info,
    inventory,
    logging,
    onboarding,
    operations,
)

app = FastAPI(
    title='Centra Integration API',
    description='Centra Integration API is used by Integration Controller as base interface to integrate with 3rd party platforms.\n\nSome useful links:\n- [Contracts OpenApi spec](https://github.com/guardicore/contracts)',
    license={
        'name': 'Apache 2.0',
        'url': 'https://www.apache.org/licenses/LICENSE-2.0.html',
    },
    version='1.10.0',
    servers=[{'url': 'http://127.0.0.1:8000'}],
)

app.include_router(agents.router)
app.include_router(authentication.router)
app.include_router(control.router)
app.include_router(enforcement.router)
app.include_router(health.router)
app.include_router(info.router)
app.include_router(inventory.router)
app.include_router(logging.router)
app.include_router(onboarding.router)
app.include_router(operations.router)


@app.get("/")
async def root():
    return {"message": "Gateway of the App"}
