# generated by fastapi-codegen:
#   filename:  /home/circleci/project/guardicore/connector
#   timestamp: 2025-08-22T15:11:33+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from centra_sdk.gc_serializer import GcSerializer
from pydantic import BaseModel, ConfigDict, Field, RootModel

from ..common.common import Connector


class GeneralInfo(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    general: Optional[Dict[str, Any]] = None


class Hierarchy(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    name: str
    children: Optional[List[Hierarchy]] = None


class EnvUnit(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    name: str
    parent: str = Field(
        ...,
        description='the location in the organization Hierarchy specified by the Hierarchy id. can be empty string if integration does not have a Hierarchy structure.',
    )


class OrganizationTreeInfo(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    org_tree: Hierarchy = Field(
        ...,
        alias='org-tree',
        description='describing integration organization hierarchy structure if such structure exist. e.g. azure management groups',
    )


class EnvUnits(RootModel[List[EnvUnit]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[EnvUnit]

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class IntegrationEnvInfo(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    connector_type: Connector = Field(..., alias='connector-type')
    connector_id: UUID = Field(..., alias='connector-id')
    info: Union[OrganizationTreeInfo, GeneralInfo]


Hierarchy.model_rebuild()
