# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-22T15:11:33+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Authentication'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class AuthenticationHandler:
    def __init__(self):
        pass

    def login_user_json(self, body: LoginRequest) -> LoginResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"login_user_json not implemented")

    def login_user_form(self, request: Request) -> LoginResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"login_user_form not implemented")


@router.post(
    '/v1/login',
    response_model=LoginResponse,
    responses={'401': {'model': UnauthorizedError}, '400': {'model': BadRequestError}},
    tags=['Authentication'],
)
def login_user_json(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: LoginRequest,
) -> Union[LoginResponse, UnauthorizedError, BadRequestError]:
    """
    User login (JSON)
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(login_user_json.__name__, token, body)


@router.post(
    '/v1/login-form',
    response_model=LoginResponse,
    responses={'401': {'model': UnauthorizedError}, '400': {'model': BadRequestError}},
    tags=['Authentication'],
)
def login_user_form(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    request: Request,
) -> Union[LoginResponse, UnauthorizedError, BadRequestError]:
    """
    User login (Form)
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(login_user_form.__name__, token, request)
