# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-22T15:11:33+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Logging'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class LoggingHandler:
    def __init__(self):
        pass

    def get_logs(self, id: Optional[UUID] = None) -> bytes:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"get_logs not implemented")

    def start_logging(self, body: LogStart) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"start_logging not implemented")

    def get_logging_status(self, id: Optional[UUID] = None) -> LogStatus:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_logging_status not implemented"
        )

    def stop_logging(self, id: Optional[UUID] = None) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"stop_logging not implemented")


@router.get('/v1/operations/log/download', response_model=bytes, tags=['Logging'])
def get_logs(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: Optional[UUID] = None,
) -> bytes:
    """
    Endpoint to retrieve component logs
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(get_logs.__name__, token, id)


@router.post('/v1/operations/log/start', response_model=None, tags=['Logging'])
def start_logging(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: LogStart,
) -> None:
    """
    Endpoint for instructing component to gather logs
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(start_logging.__name__, token, body)


@router.get('/v1/operations/log/status', response_model=LogStatus, tags=['Logging'])
def get_logging_status(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: Optional[UUID] = None,
) -> LogStatus:
    """
    Endpoint to query component on logs gathering status
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(get_logging_status.__name__, token, id)


@router.get('/v1/operations/log/stop', response_model=None, tags=['Logging'])
def stop_logging(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    id: Optional[UUID] = None,
) -> None:
    """
    Endpoint to abort logs gathering
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(stop_logging.__name__, token, id)
