# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-22T15:11:33+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Operations'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class OperationsHandler:
    def __init__(self):
        pass

    def get_integration_configuration_options(
        self,
    ) -> InternalConfigMetadata:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404,
            detail=f"get_integration_configuration_options not implemented",
        )

    def set_integration_configuration(self, body: InternalConfig) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"set_integration_configuration not implemented"
        )


@router.get(
    '/v1/operations/internal/config_metadata',
    response_model=InternalConfigMetadata,
    tags=['Operations'],
)
def get_integration_configuration_options(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
) -> InternalConfigMetadata:
    """
    Endpoint to retrieve internal configuration options
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(
        get_integration_configuration_options.__name__,
        token,
    )


@router.post(
    '/v1/operations/internal/internal_config', response_model=None, tags=['Operations']
)
def set_integration_configuration(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: InternalConfig,
) -> None:
    """
    Endpoint to set internal services configuration
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(set_integration_configuration.__name__, token, body)
