# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GvcArgs', 'Gvc']

@pulumi.input_type
class GvcArgs:
    def __init__(__self__, *,
                 controlplane_tracing: Optional[pulumi.Input['GvcControlplaneTracingArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_naming_format: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lightstep_tracing: Optional[pulumi.Input['GvcLightstepTracingArgs']] = None,
                 load_balancer: Optional[pulumi.Input['GvcLoadBalancerArgs']] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 otel_tracing: Optional[pulumi.Input['GvcOtelTracingArgs']] = None,
                 pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sidecar: Optional[pulumi.Input['GvcSidecarArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Gvc resource.
        :param pulumi.Input[builtins.str] description: Description of the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] domain: Custom domain name used by associated workloads.
        :param pulumi.Input[builtins.str] endpoint_naming_format: Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
               '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: Key-value array of resource environment variables.
        :param pulumi.Input['GvcLoadBalancerArgs'] load_balancer: Dedicated load balancer configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] name: Name of the Global Virtual Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pull_secrets: A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
               private image repository referenced by Workloads within the GVC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if controlplane_tracing is not None:
            pulumi.set(__self__, "controlplane_tracing", controlplane_tracing)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            warnings.warn("""Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""", DeprecationWarning)
            pulumi.log.warn("""domain is deprecated: Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""")
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if endpoint_naming_format is not None:
            pulumi.set(__self__, "endpoint_naming_format", endpoint_naming_format)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if lightstep_tracing is not None:
            pulumi.set(__self__, "lightstep_tracing", lightstep_tracing)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if otel_tracing is not None:
            pulumi.set(__self__, "otel_tracing", otel_tracing)
        if pull_secrets is not None:
            pulumi.set(__self__, "pull_secrets", pull_secrets)
        if sidecar is not None:
            pulumi.set(__self__, "sidecar", sidecar)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="controlplaneTracing")
    def controlplane_tracing(self) -> Optional[pulumi.Input['GvcControlplaneTracingArgs']]:
        return pulumi.get(self, "controlplane_tracing")

    @controlplane_tracing.setter
    def controlplane_tracing(self, value: Optional[pulumi.Input['GvcControlplaneTracingArgs']]):
        pulumi.set(self, "controlplane_tracing", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Global Virtual Cloud.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""")
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom domain name used by associated workloads.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="endpointNamingFormat")
    def endpoint_naming_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
        '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        """
        return pulumi.get(self, "endpoint_naming_format")

    @endpoint_naming_format.setter
    def endpoint_naming_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_naming_format", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value array of resource environment variables.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="lightstepTracing")
    def lightstep_tracing(self) -> Optional[pulumi.Input['GvcLightstepTracingArgs']]:
        return pulumi.get(self, "lightstep_tracing")

    @lightstep_tracing.setter
    def lightstep_tracing(self, value: Optional[pulumi.Input['GvcLightstepTracingArgs']]):
        pulumi.set(self, "lightstep_tracing", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['GvcLoadBalancerArgs']]:
        """
        Dedicated load balancer configuration.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['GvcLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Global Virtual Cloud.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="otelTracing")
    def otel_tracing(self) -> Optional[pulumi.Input['GvcOtelTracingArgs']]:
        return pulumi.get(self, "otel_tracing")

    @otel_tracing.setter
    def otel_tracing(self, value: Optional[pulumi.Input['GvcOtelTracingArgs']]):
        pulumi.set(self, "otel_tracing", value)

    @property
    @pulumi.getter(name="pullSecrets")
    def pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
        private image repository referenced by Workloads within the GVC.
        """
        return pulumi.get(self, "pull_secrets")

    @pull_secrets.setter
    def pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pull_secrets", value)

    @property
    @pulumi.getter
    def sidecar(self) -> Optional[pulumi.Input['GvcSidecarArgs']]:
        return pulumi.get(self, "sidecar")

    @sidecar.setter
    def sidecar(self, value: Optional[pulumi.Input['GvcSidecarArgs']]):
        pulumi.set(self, "sidecar", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GvcState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[builtins.str]] = None,
                 controlplane_tracing: Optional[pulumi.Input['GvcControlplaneTracingArgs']] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_naming_format: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lightstep_tracing: Optional[pulumi.Input['GvcLightstepTracingArgs']] = None,
                 load_balancer: Optional[pulumi.Input['GvcLoadBalancerArgs']] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 otel_tracing: Optional[pulumi.Input['GvcOtelTracingArgs']] = None,
                 pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 sidecar: Optional[pulumi.Input['GvcSidecarArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Gvc resources.
        :param pulumi.Input[builtins.str] alias: The alias name of the GVC.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] description: Description of the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] domain: Custom domain name used by associated workloads.
        :param pulumi.Input[builtins.str] endpoint_naming_format: Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
               '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: Key-value array of resource environment variables.
        :param pulumi.Input['GvcLoadBalancerArgs'] load_balancer: Dedicated load balancer configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] name: Name of the Global Virtual Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pull_secrets: A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
               private image repository referenced by Workloads within the GVC.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if controlplane_tracing is not None:
            pulumi.set(__self__, "controlplane_tracing", controlplane_tracing)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            warnings.warn("""Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""", DeprecationWarning)
            pulumi.log.warn("""domain is deprecated: Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""")
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if endpoint_naming_format is not None:
            pulumi.set(__self__, "endpoint_naming_format", endpoint_naming_format)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if lightstep_tracing is not None:
            pulumi.set(__self__, "lightstep_tracing", lightstep_tracing)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if otel_tracing is not None:
            pulumi.set(__self__, "otel_tracing", otel_tracing)
        if pull_secrets is not None:
            pulumi.set(__self__, "pull_secrets", pull_secrets)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if sidecar is not None:
            pulumi.set(__self__, "sidecar", sidecar)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The alias name of the GVC.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="controlplaneTracing")
    def controlplane_tracing(self) -> Optional[pulumi.Input['GvcControlplaneTracingArgs']]:
        return pulumi.get(self, "controlplane_tracing")

    @controlplane_tracing.setter
    def controlplane_tracing(self, value: Optional[pulumi.Input['GvcControlplaneTracingArgs']]):
        pulumi.set(self, "controlplane_tracing", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the Global Virtual Cloud.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Global Virtual Cloud.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""")
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom domain name used by associated workloads.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="endpointNamingFormat")
    def endpoint_naming_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
        '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        """
        return pulumi.get(self, "endpoint_naming_format")

    @endpoint_naming_format.setter
    def endpoint_naming_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_naming_format", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value array of resource environment variables.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="lightstepTracing")
    def lightstep_tracing(self) -> Optional[pulumi.Input['GvcLightstepTracingArgs']]:
        return pulumi.get(self, "lightstep_tracing")

    @lightstep_tracing.setter
    def lightstep_tracing(self, value: Optional[pulumi.Input['GvcLightstepTracingArgs']]):
        pulumi.set(self, "lightstep_tracing", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['GvcLoadBalancerArgs']]:
        """
        Dedicated load balancer configuration.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['GvcLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Global Virtual Cloud.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="otelTracing")
    def otel_tracing(self) -> Optional[pulumi.Input['GvcOtelTracingArgs']]:
        return pulumi.get(self, "otel_tracing")

    @otel_tracing.setter
    def otel_tracing(self, value: Optional[pulumi.Input['GvcOtelTracingArgs']]):
        pulumi.set(self, "otel_tracing", value)

    @property
    @pulumi.getter(name="pullSecrets")
    def pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
        private image repository referenced by Workloads within the GVC.
        """
        return pulumi.get(self, "pull_secrets")

    @pull_secrets.setter
    def pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pull_secrets", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def sidecar(self) -> Optional[pulumi.Input['GvcSidecarArgs']]:
        return pulumi.get(self, "sidecar")

    @sidecar.setter
    def sidecar(self, value: Optional[pulumi.Input['GvcSidecarArgs']]):
        pulumi.set(self, "sidecar", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("cpln:index/gvc:Gvc")
class Gvc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 controlplane_tracing: Optional[pulumi.Input[Union['GvcControlplaneTracingArgs', 'GvcControlplaneTracingArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_naming_format: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lightstep_tracing: Optional[pulumi.Input[Union['GvcLightstepTracingArgs', 'GvcLightstepTracingArgsDict']]] = None,
                 load_balancer: Optional[pulumi.Input[Union['GvcLoadBalancerArgs', 'GvcLoadBalancerArgsDict']]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 otel_tracing: Optional[pulumi.Input[Union['GvcOtelTracingArgs', 'GvcOtelTracingArgsDict']]] = None,
                 pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sidecar: Optional[pulumi.Input[Union['GvcSidecarArgs', 'GvcSidecarArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a Gvc resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] domain: Custom domain name used by associated workloads.
        :param pulumi.Input[builtins.str] endpoint_naming_format: Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
               '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: Key-value array of resource environment variables.
        :param pulumi.Input[Union['GvcLoadBalancerArgs', 'GvcLoadBalancerArgsDict']] load_balancer: Dedicated load balancer configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] name: Name of the Global Virtual Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pull_secrets: A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
               private image repository referenced by Workloads within the GVC.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GvcArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Gvc resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param GvcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GvcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 controlplane_tracing: Optional[pulumi.Input[Union['GvcControlplaneTracingArgs', 'GvcControlplaneTracingArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_naming_format: Optional[pulumi.Input[builtins.str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lightstep_tracing: Optional[pulumi.Input[Union['GvcLightstepTracingArgs', 'GvcLightstepTracingArgsDict']]] = None,
                 load_balancer: Optional[pulumi.Input[Union['GvcLoadBalancerArgs', 'GvcLoadBalancerArgsDict']]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 otel_tracing: Optional[pulumi.Input[Union['GvcOtelTracingArgs', 'GvcOtelTracingArgsDict']]] = None,
                 pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sidecar: Optional[pulumi.Input[Union['GvcSidecarArgs', 'GvcSidecarArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GvcArgs.__new__(GvcArgs)

            __props__.__dict__["controlplane_tracing"] = controlplane_tracing
            __props__.__dict__["description"] = description
            __props__.__dict__["domain"] = domain
            __props__.__dict__["endpoint_naming_format"] = endpoint_naming_format
            __props__.__dict__["env"] = env
            __props__.__dict__["lightstep_tracing"] = lightstep_tracing
            __props__.__dict__["load_balancer"] = load_balancer
            __props__.__dict__["locations"] = locations
            __props__.__dict__["name"] = name
            __props__.__dict__["otel_tracing"] = otel_tracing
            __props__.__dict__["pull_secrets"] = pull_secrets
            __props__.__dict__["sidecar"] = sidecar
            __props__.__dict__["tags"] = tags
            __props__.__dict__["alias"] = None
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["self_link"] = None
        super(Gvc, __self__).__init__(
            'cpln:index/gvc:Gvc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[builtins.str]] = None,
            controlplane_tracing: Optional[pulumi.Input[Union['GvcControlplaneTracingArgs', 'GvcControlplaneTracingArgsDict']]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            endpoint_naming_format: Optional[pulumi.Input[builtins.str]] = None,
            env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lightstep_tracing: Optional[pulumi.Input[Union['GvcLightstepTracingArgs', 'GvcLightstepTracingArgsDict']]] = None,
            load_balancer: Optional[pulumi.Input[Union['GvcLoadBalancerArgs', 'GvcLoadBalancerArgsDict']]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            otel_tracing: Optional[pulumi.Input[Union['GvcOtelTracingArgs', 'GvcOtelTracingArgsDict']]] = None,
            pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            sidecar: Optional[pulumi.Input[Union['GvcSidecarArgs', 'GvcSidecarArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Gvc':
        """
        Get an existing Gvc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alias: The alias name of the GVC.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] description: Description of the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] domain: Custom domain name used by associated workloads.
        :param pulumi.Input[builtins.str] endpoint_naming_format: Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
               '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] env: Key-value array of resource environment variables.
        :param pulumi.Input[Union['GvcLoadBalancerArgs', 'GvcLoadBalancerArgsDict']] load_balancer: Dedicated load balancer configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] locations: A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        :param pulumi.Input[builtins.str] name: Name of the Global Virtual Cloud.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pull_secrets: A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
               private image repository referenced by Workloads within the GVC.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GvcState.__new__(_GvcState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["controlplane_tracing"] = controlplane_tracing
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["endpoint_naming_format"] = endpoint_naming_format
        __props__.__dict__["env"] = env
        __props__.__dict__["lightstep_tracing"] = lightstep_tracing
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["locations"] = locations
        __props__.__dict__["name"] = name
        __props__.__dict__["otel_tracing"] = otel_tracing
        __props__.__dict__["pull_secrets"] = pull_secrets
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["sidecar"] = sidecar
        __props__.__dict__["tags"] = tags
        return Gvc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[builtins.str]:
        """
        The alias name of the GVC.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="controlplaneTracing")
    def controlplane_tracing(self) -> pulumi.Output[Optional['outputs.GvcControlplaneTracing']]:
        return pulumi.get(self, "controlplane_tracing")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the Global Virtual Cloud.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the Global Virtual Cloud.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    @_utilities.deprecated("""Selecting a domain on a GVC will be deprecated in the future. Use the 'cpln_domain resource' instead.""")
    def domain(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Custom domain name used by associated workloads.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="endpointNamingFormat")
    def endpoint_naming_format(self) -> pulumi.Output[builtins.str]:
        """
        Customizes the subdomain format for the canonical workload endpoint. `default` leaves it as
        '${workloadName}-${gvcName}.cpln.app'. `org` follows the scheme '${workloadName}-${gvcName}.${org}.cpln.app'.
        """
        return pulumi.get(self, "endpoint_naming_format")

    @property
    @pulumi.getter
    def env(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value array of resource environment variables.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="lightstepTracing")
    def lightstep_tracing(self) -> pulumi.Output[Optional['outputs.GvcLightstepTracing']]:
        return pulumi.get(self, "lightstep_tracing")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output[Optional['outputs.GvcLoadBalancer']]:
        """
        Dedicated load balancer configuration.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of [locations](https://docs.controlplane.com/reference/location#current) making up the Global Virtual Cloud.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Global Virtual Cloud.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="otelTracing")
    def otel_tracing(self) -> pulumi.Output[Optional['outputs.GvcOtelTracing']]:
        return pulumi.get(self, "otel_tracing")

    @property
    @pulumi.getter(name="pullSecrets")
    def pull_secrets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of [pull secret](https://docs.controlplane.com/reference/gvc#pull-secrets) names used to authenticate to any
        private image repository referenced by Workloads within the GVC.
        """
        return pulumi.get(self, "pull_secrets")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def sidecar(self) -> pulumi.Output[Optional['outputs.GvcSidecar']]:
        return pulumi.get(self, "sidecar")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

