# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeSetArgs', 'VolumeSet']

@pulumi.input_type
class VolumeSetArgs:
    def __init__(__self__, *,
                 gvc: pulumi.Input[builtins.str],
                 initial_capacity: pulumi.Input[builtins.int],
                 performance_class: pulumi.Input[builtins.str],
                 autoscaling: Optional[pulumi.Input['VolumeSetAutoscalingArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[builtins.str]] = None,
                 mount_options: Optional[pulumi.Input['VolumeSetMountOptionsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 snapshots: Optional[pulumi.Input['VolumeSetSnapshotsArgs']] = None,
                 storage_class_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VolumeSet resource.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.int] initial_capacity: The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
               is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        :param pulumi.Input[builtins.str] performance_class: Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
               `high-throughput-ssd`.
        :param pulumi.Input['VolumeSetAutoscalingArgs'] autoscaling: Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        :param pulumi.Input[builtins.str] description: Description of the volume set.
        :param pulumi.Input[builtins.str] file_system_type: Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        :param pulumi.Input['VolumeSetMountOptionsArgs'] mount_options: A list of mount options to use when mounting volumes in this set.
        :param pulumi.Input[builtins.str] name: Name of the volume set.
        :param pulumi.Input['VolumeSetSnapshotsArgs'] snapshots: Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        :param pulumi.Input[builtins.str] storage_class_suffix: For self-hosted locations only. The storage class used for volumes in this set will be
               {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
               {performanceClass}-{fileSystemType}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        pulumi.set(__self__, "gvc", gvc)
        pulumi.set(__self__, "initial_capacity", initial_capacity)
        pulumi.set(__self__, "performance_class", performance_class)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snapshots is not None:
            pulumi.set(__self__, "snapshots", snapshots)
        if storage_class_suffix is not None:
            pulumi.set(__self__, "storage_class_suffix", storage_class_suffix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Input[builtins.str]:
        """
        Name of the associated GVC.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter(name="initialCapacity")
    def initial_capacity(self) -> pulumi.Input[builtins.int]:
        """
        The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
        is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        """
        return pulumi.get(self, "initial_capacity")

    @initial_capacity.setter
    def initial_capacity(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "initial_capacity", value)

    @property
    @pulumi.getter(name="performanceClass")
    def performance_class(self) -> pulumi.Input[builtins.str]:
        """
        Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
        `high-throughput-ssd`.
        """
        return pulumi.get(self, "performance_class")

    @performance_class.setter
    def performance_class(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "performance_class", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['VolumeSetAutoscalingArgs']]:
        """
        Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['VolumeSetAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the volume set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['VolumeSetMountOptionsArgs']]:
        """
        A list of mount options to use when mounting volumes in this set.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['VolumeSetMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the volume set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def snapshots(self) -> Optional[pulumi.Input['VolumeSetSnapshotsArgs']]:
        """
        Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        """
        return pulumi.get(self, "snapshots")

    @snapshots.setter
    def snapshots(self, value: Optional[pulumi.Input['VolumeSetSnapshotsArgs']]):
        pulumi.set(self, "snapshots", value)

    @property
    @pulumi.getter(name="storageClassSuffix")
    def storage_class_suffix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For self-hosted locations only. The storage class used for volumes in this set will be
        {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
        {performanceClass}-{fileSystemType}
        """
        return pulumi.get(self, "storage_class_suffix")

    @storage_class_suffix.setter
    def storage_class_suffix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_class_suffix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VolumeSetState:
    def __init__(__self__, *,
                 autoscaling: Optional[pulumi.Input['VolumeSetAutoscalingArgs']] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 initial_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 mount_options: Optional[pulumi.Input['VolumeSetMountOptionsArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_class: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 snapshots: Optional[pulumi.Input['VolumeSetSnapshotsArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSetStatusArgs']]]] = None,
                 storage_class_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 volumeset_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VolumeSet resources.
        :param pulumi.Input['VolumeSetAutoscalingArgs'] autoscaling: Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the volume set.
        :param pulumi.Input[builtins.str] description: Description of the volume set.
        :param pulumi.Input[builtins.str] file_system_type: Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.int] initial_capacity: The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
               is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        :param pulumi.Input['VolumeSetMountOptionsArgs'] mount_options: A list of mount options to use when mounting volumes in this set.
        :param pulumi.Input[builtins.str] name: Name of the volume set.
        :param pulumi.Input[builtins.str] performance_class: Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
               `high-throughput-ssd`.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input['VolumeSetSnapshotsArgs'] snapshots: Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeSetStatusArgs']]] statuses: Status of the Volume Set.
        :param pulumi.Input[builtins.str] storage_class_suffix: For self-hosted locations only. The storage class used for volumes in this set will be
               {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
               {performanceClass}-{fileSystemType}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] volumeset_link: Output used when linking a volume set to a workload.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if file_system_type is not None:
            pulumi.set(__self__, "file_system_type", file_system_type)
        if gvc is not None:
            pulumi.set(__self__, "gvc", gvc)
        if initial_capacity is not None:
            pulumi.set(__self__, "initial_capacity", initial_capacity)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_class is not None:
            pulumi.set(__self__, "performance_class", performance_class)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if snapshots is not None:
            pulumi.set(__self__, "snapshots", snapshots)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if storage_class_suffix is not None:
            pulumi.set(__self__, "storage_class_suffix", storage_class_suffix)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volumeset_link is not None:
            pulumi.set(__self__, "volumeset_link", volumeset_link)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['VolumeSetAutoscalingArgs']]:
        """
        Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['VolumeSetAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the volume set.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the volume set.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        """
        return pulumi.get(self, "file_system_type")

    @file_system_type.setter
    def file_system_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_type", value)

    @property
    @pulumi.getter
    def gvc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the associated GVC.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter(name="initialCapacity")
    def initial_capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
        is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        """
        return pulumi.get(self, "initial_capacity")

    @initial_capacity.setter
    def initial_capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "initial_capacity", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input['VolumeSetMountOptionsArgs']]:
        """
        A list of mount options to use when mounting volumes in this set.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input['VolumeSetMountOptionsArgs']]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the volume set.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceClass")
    def performance_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
        `high-throughput-ssd`.
        """
        return pulumi.get(self, "performance_class")

    @performance_class.setter
    def performance_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "performance_class", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def snapshots(self) -> Optional[pulumi.Input['VolumeSetSnapshotsArgs']]:
        """
        Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        """
        return pulumi.get(self, "snapshots")

    @snapshots.setter
    def snapshots(self, value: Optional[pulumi.Input['VolumeSetSnapshotsArgs']]):
        pulumi.set(self, "snapshots", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSetStatusArgs']]]]:
        """
        Status of the Volume Set.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeSetStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter(name="storageClassSuffix")
    def storage_class_suffix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For self-hosted locations only. The storage class used for volumes in this set will be
        {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
        {performanceClass}-{fileSystemType}
        """
        return pulumi.get(self, "storage_class_suffix")

    @storage_class_suffix.setter
    def storage_class_suffix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_class_suffix", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumesetLink")
    def volumeset_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output used when linking a volume set to a workload.
        """
        return pulumi.get(self, "volumeset_link")

    @volumeset_link.setter
    def volumeset_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volumeset_link", value)


@pulumi.type_token("cpln:index/volumeSet:VolumeSet")
class VolumeSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling: Optional[pulumi.Input[Union['VolumeSetAutoscalingArgs', 'VolumeSetAutoscalingArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 initial_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 mount_options: Optional[pulumi.Input[Union['VolumeSetMountOptionsArgs', 'VolumeSetMountOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_class: Optional[pulumi.Input[builtins.str]] = None,
                 snapshots: Optional[pulumi.Input[Union['VolumeSetSnapshotsArgs', 'VolumeSetSnapshotsArgsDict']]] = None,
                 storage_class_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Create a VolumeSet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VolumeSetAutoscalingArgs', 'VolumeSetAutoscalingArgsDict']] autoscaling: Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        :param pulumi.Input[builtins.str] description: Description of the volume set.
        :param pulumi.Input[builtins.str] file_system_type: Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.int] initial_capacity: The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
               is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        :param pulumi.Input[Union['VolumeSetMountOptionsArgs', 'VolumeSetMountOptionsArgsDict']] mount_options: A list of mount options to use when mounting volumes in this set.
        :param pulumi.Input[builtins.str] name: Name of the volume set.
        :param pulumi.Input[builtins.str] performance_class: Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
               `high-throughput-ssd`.
        :param pulumi.Input[Union['VolumeSetSnapshotsArgs', 'VolumeSetSnapshotsArgsDict']] snapshots: Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        :param pulumi.Input[builtins.str] storage_class_suffix: For self-hosted locations only. The storage class used for volumes in this set will be
               {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
               {performanceClass}-{fileSystemType}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a VolumeSet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param VolumeSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling: Optional[pulumi.Input[Union['VolumeSetAutoscalingArgs', 'VolumeSetAutoscalingArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 file_system_type: Optional[pulumi.Input[builtins.str]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 initial_capacity: Optional[pulumi.Input[builtins.int]] = None,
                 mount_options: Optional[pulumi.Input[Union['VolumeSetMountOptionsArgs', 'VolumeSetMountOptionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_class: Optional[pulumi.Input[builtins.str]] = None,
                 snapshots: Optional[pulumi.Input[Union['VolumeSetSnapshotsArgs', 'VolumeSetSnapshotsArgsDict']]] = None,
                 storage_class_suffix: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeSetArgs.__new__(VolumeSetArgs)

            __props__.__dict__["autoscaling"] = autoscaling
            __props__.__dict__["description"] = description
            __props__.__dict__["file_system_type"] = file_system_type
            if gvc is None and not opts.urn:
                raise TypeError("Missing required property 'gvc'")
            __props__.__dict__["gvc"] = gvc
            if initial_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'initial_capacity'")
            __props__.__dict__["initial_capacity"] = initial_capacity
            __props__.__dict__["mount_options"] = mount_options
            __props__.__dict__["name"] = name
            if performance_class is None and not opts.urn:
                raise TypeError("Missing required property 'performance_class'")
            __props__.__dict__["performance_class"] = performance_class
            __props__.__dict__["snapshots"] = snapshots
            __props__.__dict__["storage_class_suffix"] = storage_class_suffix
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["statuses"] = None
            __props__.__dict__["volumeset_link"] = None
        super(VolumeSet, __self__).__init__(
            'cpln:index/volumeSet:VolumeSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaling: Optional[pulumi.Input[Union['VolumeSetAutoscalingArgs', 'VolumeSetAutoscalingArgsDict']]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            file_system_type: Optional[pulumi.Input[builtins.str]] = None,
            gvc: Optional[pulumi.Input[builtins.str]] = None,
            initial_capacity: Optional[pulumi.Input[builtins.int]] = None,
            mount_options: Optional[pulumi.Input[Union['VolumeSetMountOptionsArgs', 'VolumeSetMountOptionsArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            performance_class: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            snapshots: Optional[pulumi.Input[Union['VolumeSetSnapshotsArgs', 'VolumeSetSnapshotsArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeSetStatusArgs', 'VolumeSetStatusArgsDict']]]]] = None,
            storage_class_suffix: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            volumeset_link: Optional[pulumi.Input[builtins.str]] = None) -> 'VolumeSet':
        """
        Get an existing VolumeSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VolumeSetAutoscalingArgs', 'VolumeSetAutoscalingArgsDict']] autoscaling: Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the volume set.
        :param pulumi.Input[builtins.str] description: Description of the volume set.
        :param pulumi.Input[builtins.str] file_system_type: Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.int] initial_capacity: The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
               is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        :param pulumi.Input[Union['VolumeSetMountOptionsArgs', 'VolumeSetMountOptionsArgsDict']] mount_options: A list of mount options to use when mounting volumes in this set.
        :param pulumi.Input[builtins.str] name: Name of the volume set.
        :param pulumi.Input[builtins.str] performance_class: Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
               `high-throughput-ssd`.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Union['VolumeSetSnapshotsArgs', 'VolumeSetSnapshotsArgsDict']] snapshots: Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeSetStatusArgs', 'VolumeSetStatusArgsDict']]]] statuses: Status of the Volume Set.
        :param pulumi.Input[builtins.str] storage_class_suffix: For self-hosted locations only. The storage class used for volumes in this set will be
               {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
               {performanceClass}-{fileSystemType}
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] volumeset_link: Output used when linking a volume set to a workload.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeSetState.__new__(_VolumeSetState)

        __props__.__dict__["autoscaling"] = autoscaling
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["file_system_type"] = file_system_type
        __props__.__dict__["gvc"] = gvc
        __props__.__dict__["initial_capacity"] = initial_capacity
        __props__.__dict__["mount_options"] = mount_options
        __props__.__dict__["name"] = name
        __props__.__dict__["performance_class"] = performance_class
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["snapshots"] = snapshots
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["storage_class_suffix"] = storage_class_suffix
        __props__.__dict__["tags"] = tags
        __props__.__dict__["volumeset_link"] = volumeset_link
        return VolumeSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Output[Optional['outputs.VolumeSetAutoscaling']]:
        """
        Automated adjustment of the volume set's capacity based on predefined metrics or conditions.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the volume set.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the volume set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> pulumi.Output[builtins.str]:
        """
        Each volume set has a single, immutable file system. Valid types: `xfs` or `ext4`.
        """
        return pulumi.get(self, "file_system_type")

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Output[builtins.str]:
        """
        Name of the associated GVC.
        """
        return pulumi.get(self, "gvc")

    @property
    @pulumi.getter(name="initialCapacity")
    def initial_capacity(self) -> pulumi.Output[builtins.int]:
        """
        The initial volume size in this set, specified in GB. The minimum size for the performance class `general-purpose-ssd`
        is `10 GB`, while `high-throughput-ssd` requires at least `200 GB`.
        """
        return pulumi.get(self, "initial_capacity")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Output[Optional['outputs.VolumeSetMountOptions']]:
        """
        A list of mount options to use when mounting volumes in this set.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the volume set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceClass")
    def performance_class(self) -> pulumi.Output[builtins.str]:
        """
        Each volume set has a single, immutable, performance class. Valid classes: `general-purpose-ssd` or
        `high-throughput-ssd`.
        """
        return pulumi.get(self, "performance_class")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def snapshots(self) -> pulumi.Output[Optional['outputs.VolumeSetSnapshots']]:
        """
        Point-in-time copies of data stored within the volume set, capturing the state of the data at a specific moment.
        """
        return pulumi.get(self, "snapshots")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.VolumeSetStatus']]:
        """
        Status of the Volume Set.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="storageClassSuffix")
    def storage_class_suffix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For self-hosted locations only. The storage class used for volumes in this set will be
        {performanceClass}-{fileSystemType}-{storageClassSuffix} if it exists, otherwise it will be
        {performanceClass}-{fileSystemType}
        """
        return pulumi.get(self, "storage_class_suffix")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumesetLink")
    def volumeset_link(self) -> pulumi.Output[builtins.str]:
        """
        Output used when linking a volume set to a workload.
        """
        return pulumi.get(self, "volumeset_link")

