# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkloadArgs', 'Workload']

@pulumi.input_type
class WorkloadArgs:
    def __init__(__self__, *,
                 gvc: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extras: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_spec: Optional[pulumi.Input['WorkloadFirewallSpecArgs']] = None,
                 identity_link: Optional[pulumi.Input[builtins.str]] = None,
                 jobs: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]]] = None,
                 load_balancer: Optional[pulumi.Input['WorkloadLoadBalancerArgs']] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input['WorkloadOptionsArgs']] = None,
                 request_retry_policy: Optional[pulumi.Input['WorkloadRequestRetryPolicyArgs']] = None,
                 rollout_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]]] = None,
                 security_options: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']] = None,
                 sidecar: Optional[pulumi.Input['WorkloadSidecarArgs']] = None,
                 support_dynamic_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workload resource.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.str] type: Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]] containers: An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        :param pulumi.Input[builtins.str] description: Description of the workload.
        :param pulumi.Input[builtins.str] extras: Extra Kubernetes modifications. Only used for BYOK.
        :param pulumi.Input['WorkloadFirewallSpecArgs'] firewall_spec: Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
               Access is restricted by default.
        :param pulumi.Input[builtins.str] identity_link: The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
               multiple cloud providers.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]] jobs: [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]] local_options: Override defaultOptions for the workload in specific Control Plane Locations.
        :param pulumi.Input[builtins.str] name: Name of the workload.
        :param pulumi.Input['WorkloadOptionsArgs'] options: Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
               characteristics of the workload.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]] rollout_options: Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
               replicas, surge replicas, and scaling policies.
        :param pulumi.Input['WorkloadSecurityOptionsArgs'] security_options: Allows for the configuration of the `file system group id` and `geo location`.
        :param pulumi.Input[builtins.bool] support_dynamic_tags: Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
               false.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        """
        pulumi.set(__self__, "gvc", gvc)
        pulumi.set(__self__, "type", type)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extras is not None:
            pulumi.set(__self__, "extras", extras)
        if firewall_spec is not None:
            pulumi.set(__self__, "firewall_spec", firewall_spec)
        if identity_link is not None:
            pulumi.set(__self__, "identity_link", identity_link)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if local_options is not None:
            pulumi.set(__self__, "local_options", local_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if request_retry_policy is not None:
            pulumi.set(__self__, "request_retry_policy", request_retry_policy)
        if rollout_options is not None:
            pulumi.set(__self__, "rollout_options", rollout_options)
        if security_options is not None:
            pulumi.set(__self__, "security_options", security_options)
        if sidecar is not None:
            pulumi.set(__self__, "sidecar", sidecar)
        if support_dynamic_tags is not None:
            pulumi.set(__self__, "support_dynamic_tags", support_dynamic_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Input[builtins.str]:
        """
        Name of the associated GVC.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]]:
        """
        An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the workload.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def extras(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Extra Kubernetes modifications. Only used for BYOK.
        """
        return pulumi.get(self, "extras")

    @extras.setter
    def extras(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extras", value)

    @property
    @pulumi.getter(name="firewallSpec")
    def firewall_spec(self) -> Optional[pulumi.Input['WorkloadFirewallSpecArgs']]:
        """
        Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
        Access is restricted by default.
        """
        return pulumi.get(self, "firewall_spec")

    @firewall_spec.setter
    def firewall_spec(self, value: Optional[pulumi.Input['WorkloadFirewallSpecArgs']]):
        pulumi.set(self, "firewall_spec", value)

    @property
    @pulumi.getter(name="identityLink")
    def identity_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
        multiple cloud providers.
        """
        return pulumi.get(self, "identity_link")

    @identity_link.setter
    def identity_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_link", value)

    @property
    @pulumi.getter
    def jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]]]:
        """
        [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        """
        return pulumi.get(self, "jobs")

    @jobs.setter
    def jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]]]):
        pulumi.set(self, "jobs", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['WorkloadLoadBalancerArgs']]:
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['WorkloadLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="localOptions")
    def local_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]:
        """
        Override defaultOptions for the workload in specific Control Plane Locations.
        """
        return pulumi.get(self, "local_options")

    @local_options.setter
    def local_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]):
        pulumi.set(self, "local_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the workload.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['WorkloadOptionsArgs']]:
        """
        Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
        characteristics of the workload.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['WorkloadOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="requestRetryPolicy")
    def request_retry_policy(self) -> Optional[pulumi.Input['WorkloadRequestRetryPolicyArgs']]:
        return pulumi.get(self, "request_retry_policy")

    @request_retry_policy.setter
    def request_retry_policy(self, value: Optional[pulumi.Input['WorkloadRequestRetryPolicyArgs']]):
        pulumi.set(self, "request_retry_policy", value)

    @property
    @pulumi.getter(name="rolloutOptions")
    def rollout_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]]]:
        """
        Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
        replicas, surge replicas, and scaling policies.
        """
        return pulumi.get(self, "rollout_options")

    @rollout_options.setter
    def rollout_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]]]):
        pulumi.set(self, "rollout_options", value)

    @property
    @pulumi.getter(name="securityOptions")
    def security_options(self) -> Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]:
        """
        Allows for the configuration of the `file system group id` and `geo location`.
        """
        return pulumi.get(self, "security_options")

    @security_options.setter
    def security_options(self, value: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]):
        pulumi.set(self, "security_options", value)

    @property
    @pulumi.getter
    def sidecar(self) -> Optional[pulumi.Input['WorkloadSidecarArgs']]:
        return pulumi.get(self, "sidecar")

    @sidecar.setter
    def sidecar(self, value: Optional[pulumi.Input['WorkloadSidecarArgs']]):
        pulumi.set(self, "sidecar", value)

    @property
    @pulumi.getter(name="supportDynamicTags")
    def support_dynamic_tags(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
        false.
        """
        return pulumi.get(self, "support_dynamic_tags")

    @support_dynamic_tags.setter
    def support_dynamic_tags(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "support_dynamic_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkloadState:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]] = None,
                 cpln_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extras: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_spec: Optional[pulumi.Input['WorkloadFirewallSpecArgs']] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 identity_link: Optional[pulumi.Input[builtins.str]] = None,
                 jobs: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]]] = None,
                 load_balancer: Optional[pulumi.Input['WorkloadLoadBalancerArgs']] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input['WorkloadOptionsArgs']] = None,
                 request_retry_policy: Optional[pulumi.Input['WorkloadRequestRetryPolicyArgs']] = None,
                 rollout_options: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]]] = None,
                 security_options: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 sidecar: Optional[pulumi.Input['WorkloadSidecarArgs']] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]] = None,
                 support_dynamic_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workload resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]] containers: An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the workload.
        :param pulumi.Input[builtins.str] description: Description of the workload.
        :param pulumi.Input[builtins.str] extras: Extra Kubernetes modifications. Only used for BYOK.
        :param pulumi.Input['WorkloadFirewallSpecArgs'] firewall_spec: Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
               Access is restricted by default.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.str] identity_link: The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
               multiple cloud providers.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]] jobs: [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]] local_options: Override defaultOptions for the workload in specific Control Plane Locations.
        :param pulumi.Input[builtins.str] name: Name of the workload.
        :param pulumi.Input['WorkloadOptionsArgs'] options: Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
               characteristics of the workload.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]] rollout_options: Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
               replicas, surge replicas, and scaling policies.
        :param pulumi.Input['WorkloadSecurityOptionsArgs'] security_options: Allows for the configuration of the `file system group id` and `geo location`.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]] statuses: Status of the workload.
        :param pulumi.Input[builtins.bool] support_dynamic_tags: Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
               false.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] type: Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpln_id is not None:
            pulumi.set(__self__, "cpln_id", cpln_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if extras is not None:
            pulumi.set(__self__, "extras", extras)
        if firewall_spec is not None:
            pulumi.set(__self__, "firewall_spec", firewall_spec)
        if gvc is not None:
            pulumi.set(__self__, "gvc", gvc)
        if identity_link is not None:
            pulumi.set(__self__, "identity_link", identity_link)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if local_options is not None:
            pulumi.set(__self__, "local_options", local_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if request_retry_policy is not None:
            pulumi.set(__self__, "request_retry_policy", request_retry_policy)
        if rollout_options is not None:
            pulumi.set(__self__, "rollout_options", rollout_options)
        if security_options is not None:
            pulumi.set(__self__, "security_options", security_options)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if sidecar is not None:
            pulumi.set(__self__, "sidecar", sidecar)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if support_dynamic_tags is not None:
            pulumi.set(__self__, "support_dynamic_tags", support_dynamic_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]]:
        """
        An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID, in GUID format, of the workload.
        """
        return pulumi.get(self, "cpln_id")

    @cpln_id.setter
    def cpln_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpln_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the workload.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def extras(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Extra Kubernetes modifications. Only used for BYOK.
        """
        return pulumi.get(self, "extras")

    @extras.setter
    def extras(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extras", value)

    @property
    @pulumi.getter(name="firewallSpec")
    def firewall_spec(self) -> Optional[pulumi.Input['WorkloadFirewallSpecArgs']]:
        """
        Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
        Access is restricted by default.
        """
        return pulumi.get(self, "firewall_spec")

    @firewall_spec.setter
    def firewall_spec(self, value: Optional[pulumi.Input['WorkloadFirewallSpecArgs']]):
        pulumi.set(self, "firewall_spec", value)

    @property
    @pulumi.getter
    def gvc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the associated GVC.
        """
        return pulumi.get(self, "gvc")

    @gvc.setter
    def gvc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gvc", value)

    @property
    @pulumi.getter(name="identityLink")
    def identity_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
        multiple cloud providers.
        """
        return pulumi.get(self, "identity_link")

    @identity_link.setter
    def identity_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_link", value)

    @property
    @pulumi.getter
    def jobs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]]]:
        """
        [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        """
        return pulumi.get(self, "jobs")

    @jobs.setter
    def jobs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadJobArgs']]]]):
        pulumi.set(self, "jobs", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['WorkloadLoadBalancerArgs']]:
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['WorkloadLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="localOptions")
    def local_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]:
        """
        Override defaultOptions for the workload in specific Control Plane Locations.
        """
        return pulumi.get(self, "local_options")

    @local_options.setter
    def local_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadLocalOptionArgs']]]]):
        pulumi.set(self, "local_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the workload.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['WorkloadOptionsArgs']]:
        """
        Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
        characteristics of the workload.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['WorkloadOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="requestRetryPolicy")
    def request_retry_policy(self) -> Optional[pulumi.Input['WorkloadRequestRetryPolicyArgs']]:
        return pulumi.get(self, "request_retry_policy")

    @request_retry_policy.setter
    def request_retry_policy(self, value: Optional[pulumi.Input['WorkloadRequestRetryPolicyArgs']]):
        pulumi.set(self, "request_retry_policy", value)

    @property
    @pulumi.getter(name="rolloutOptions")
    def rollout_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]]]:
        """
        Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
        replicas, surge replicas, and scaling policies.
        """
        return pulumi.get(self, "rollout_options")

    @rollout_options.setter
    def rollout_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadRolloutOptionArgs']]]]):
        pulumi.set(self, "rollout_options", value)

    @property
    @pulumi.getter(name="securityOptions")
    def security_options(self) -> Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]:
        """
        Allows for the configuration of the `file system group id` and `geo location`.
        """
        return pulumi.get(self, "security_options")

    @security_options.setter
    def security_options(self, value: Optional[pulumi.Input['WorkloadSecurityOptionsArgs']]):
        pulumi.set(self, "security_options", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def sidecar(self) -> Optional[pulumi.Input['WorkloadSidecarArgs']]:
        return pulumi.get(self, "sidecar")

    @sidecar.setter
    def sidecar(self, value: Optional[pulumi.Input['WorkloadSidecarArgs']]):
        pulumi.set(self, "sidecar", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]]:
        """
        Status of the workload.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkloadStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter(name="supportDynamicTags")
    def support_dynamic_tags(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
        false.
        """
        return pulumi.get(self, "support_dynamic_tags")

    @support_dynamic_tags.setter
    def support_dynamic_tags(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "support_dynamic_tags", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("cpln:index/workload:Workload")
class Workload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadContainerArgs', 'WorkloadContainerArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extras: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_spec: Optional[pulumi.Input[Union['WorkloadFirewallSpecArgs', 'WorkloadFirewallSpecArgsDict']]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 identity_link: Optional[pulumi.Input[builtins.str]] = None,
                 jobs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadJobArgs', 'WorkloadJobArgsDict']]]]] = None,
                 load_balancer: Optional[pulumi.Input[Union['WorkloadLoadBalancerArgs', 'WorkloadLoadBalancerArgsDict']]] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadLocalOptionArgs', 'WorkloadLocalOptionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['WorkloadOptionsArgs', 'WorkloadOptionsArgsDict']]] = None,
                 request_retry_policy: Optional[pulumi.Input[Union['WorkloadRequestRetryPolicyArgs', 'WorkloadRequestRetryPolicyArgsDict']]] = None,
                 rollout_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadRolloutOptionArgs', 'WorkloadRolloutOptionArgsDict']]]]] = None,
                 security_options: Optional[pulumi.Input[Union['WorkloadSecurityOptionsArgs', 'WorkloadSecurityOptionsArgsDict']]] = None,
                 sidecar: Optional[pulumi.Input[Union['WorkloadSidecarArgs', 'WorkloadSidecarArgsDict']]] = None,
                 support_dynamic_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a Workload resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadContainerArgs', 'WorkloadContainerArgsDict']]]] containers: An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        :param pulumi.Input[builtins.str] description: Description of the workload.
        :param pulumi.Input[builtins.str] extras: Extra Kubernetes modifications. Only used for BYOK.
        :param pulumi.Input[Union['WorkloadFirewallSpecArgs', 'WorkloadFirewallSpecArgsDict']] firewall_spec: Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
               Access is restricted by default.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.str] identity_link: The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
               multiple cloud providers.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadJobArgs', 'WorkloadJobArgsDict']]]] jobs: [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadLocalOptionArgs', 'WorkloadLocalOptionArgsDict']]]] local_options: Override defaultOptions for the workload in specific Control Plane Locations.
        :param pulumi.Input[builtins.str] name: Name of the workload.
        :param pulumi.Input[Union['WorkloadOptionsArgs', 'WorkloadOptionsArgsDict']] options: Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
               characteristics of the workload.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadRolloutOptionArgs', 'WorkloadRolloutOptionArgsDict']]]] rollout_options: Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
               replicas, surge replicas, and scaling policies.
        :param pulumi.Input[Union['WorkloadSecurityOptionsArgs', 'WorkloadSecurityOptionsArgsDict']] security_options: Allows for the configuration of the `file system group id` and `geo location`.
        :param pulumi.Input[builtins.bool] support_dynamic_tags: Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
               false.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] type: Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkloadArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Workload resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param WorkloadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkloadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadContainerArgs', 'WorkloadContainerArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 extras: Optional[pulumi.Input[builtins.str]] = None,
                 firewall_spec: Optional[pulumi.Input[Union['WorkloadFirewallSpecArgs', 'WorkloadFirewallSpecArgsDict']]] = None,
                 gvc: Optional[pulumi.Input[builtins.str]] = None,
                 identity_link: Optional[pulumi.Input[builtins.str]] = None,
                 jobs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadJobArgs', 'WorkloadJobArgsDict']]]]] = None,
                 load_balancer: Optional[pulumi.Input[Union['WorkloadLoadBalancerArgs', 'WorkloadLoadBalancerArgsDict']]] = None,
                 local_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadLocalOptionArgs', 'WorkloadLocalOptionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['WorkloadOptionsArgs', 'WorkloadOptionsArgsDict']]] = None,
                 request_retry_policy: Optional[pulumi.Input[Union['WorkloadRequestRetryPolicyArgs', 'WorkloadRequestRetryPolicyArgsDict']]] = None,
                 rollout_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadRolloutOptionArgs', 'WorkloadRolloutOptionArgsDict']]]]] = None,
                 security_options: Optional[pulumi.Input[Union['WorkloadSecurityOptionsArgs', 'WorkloadSecurityOptionsArgsDict']]] = None,
                 sidecar: Optional[pulumi.Input[Union['WorkloadSidecarArgs', 'WorkloadSidecarArgsDict']]] = None,
                 support_dynamic_tags: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkloadArgs.__new__(WorkloadArgs)

            __props__.__dict__["containers"] = containers
            __props__.__dict__["description"] = description
            __props__.__dict__["extras"] = extras
            __props__.__dict__["firewall_spec"] = firewall_spec
            if gvc is None and not opts.urn:
                raise TypeError("Missing required property 'gvc'")
            __props__.__dict__["gvc"] = gvc
            __props__.__dict__["identity_link"] = identity_link
            __props__.__dict__["jobs"] = jobs
            __props__.__dict__["load_balancer"] = load_balancer
            __props__.__dict__["local_options"] = local_options
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["request_retry_policy"] = request_retry_policy
            __props__.__dict__["rollout_options"] = rollout_options
            __props__.__dict__["security_options"] = security_options
            __props__.__dict__["sidecar"] = sidecar
            __props__.__dict__["support_dynamic_tags"] = support_dynamic_tags
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["cpln_id"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["statuses"] = None
        super(Workload, __self__).__init__(
            'cpln:index/workload:Workload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadContainerArgs', 'WorkloadContainerArgsDict']]]]] = None,
            cpln_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            extras: Optional[pulumi.Input[builtins.str]] = None,
            firewall_spec: Optional[pulumi.Input[Union['WorkloadFirewallSpecArgs', 'WorkloadFirewallSpecArgsDict']]] = None,
            gvc: Optional[pulumi.Input[builtins.str]] = None,
            identity_link: Optional[pulumi.Input[builtins.str]] = None,
            jobs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadJobArgs', 'WorkloadJobArgsDict']]]]] = None,
            load_balancer: Optional[pulumi.Input[Union['WorkloadLoadBalancerArgs', 'WorkloadLoadBalancerArgsDict']]] = None,
            local_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadLocalOptionArgs', 'WorkloadLocalOptionArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            options: Optional[pulumi.Input[Union['WorkloadOptionsArgs', 'WorkloadOptionsArgsDict']]] = None,
            request_retry_policy: Optional[pulumi.Input[Union['WorkloadRequestRetryPolicyArgs', 'WorkloadRequestRetryPolicyArgsDict']]] = None,
            rollout_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadRolloutOptionArgs', 'WorkloadRolloutOptionArgsDict']]]]] = None,
            security_options: Optional[pulumi.Input[Union['WorkloadSecurityOptionsArgs', 'WorkloadSecurityOptionsArgsDict']]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            sidecar: Optional[pulumi.Input[Union['WorkloadSidecarArgs', 'WorkloadSidecarArgsDict']]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkloadStatusArgs', 'WorkloadStatusArgsDict']]]]] = None,
            support_dynamic_tags: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Workload':
        """
        Get an existing Workload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadContainerArgs', 'WorkloadContainerArgsDict']]]] containers: An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        :param pulumi.Input[builtins.str] cpln_id: The ID, in GUID format, of the workload.
        :param pulumi.Input[builtins.str] description: Description of the workload.
        :param pulumi.Input[builtins.str] extras: Extra Kubernetes modifications. Only used for BYOK.
        :param pulumi.Input[Union['WorkloadFirewallSpecArgs', 'WorkloadFirewallSpecArgsDict']] firewall_spec: Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
               Access is restricted by default.
        :param pulumi.Input[builtins.str] gvc: Name of the associated GVC.
        :param pulumi.Input[builtins.str] identity_link: The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
               multiple cloud providers.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadJobArgs', 'WorkloadJobArgsDict']]]] jobs: [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadLocalOptionArgs', 'WorkloadLocalOptionArgsDict']]]] local_options: Override defaultOptions for the workload in specific Control Plane Locations.
        :param pulumi.Input[builtins.str] name: Name of the workload.
        :param pulumi.Input[Union['WorkloadOptionsArgs', 'WorkloadOptionsArgsDict']] options: Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
               characteristics of the workload.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadRolloutOptionArgs', 'WorkloadRolloutOptionArgsDict']]]] rollout_options: Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
               replicas, surge replicas, and scaling policies.
        :param pulumi.Input[Union['WorkloadSecurityOptionsArgs', 'WorkloadSecurityOptionsArgsDict']] security_options: Allows for the configuration of the `file system group id` and `geo location`.
        :param pulumi.Input[builtins.str] self_link: Full link to this resource. Can be referenced by other resources.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkloadStatusArgs', 'WorkloadStatusArgsDict']]]] statuses: Status of the workload.
        :param pulumi.Input[builtins.bool] support_dynamic_tags: Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
               false.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags.
        :param pulumi.Input[builtins.str] type: Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkloadState.__new__(_WorkloadState)

        __props__.__dict__["containers"] = containers
        __props__.__dict__["cpln_id"] = cpln_id
        __props__.__dict__["description"] = description
        __props__.__dict__["extras"] = extras
        __props__.__dict__["firewall_spec"] = firewall_spec
        __props__.__dict__["gvc"] = gvc
        __props__.__dict__["identity_link"] = identity_link
        __props__.__dict__["jobs"] = jobs
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["local_options"] = local_options
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["request_retry_policy"] = request_retry_policy
        __props__.__dict__["rollout_options"] = rollout_options
        __props__.__dict__["security_options"] = security_options
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["sidecar"] = sidecar
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["support_dynamic_tags"] = support_dynamic_tags
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Workload(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadContainer']]]:
        """
        An isolated and lightweight runtime environment that encapsulates an application and its dependencies.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID, in GUID format, of the workload.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the workload.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def extras(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Extra Kubernetes modifications. Only used for BYOK.
        """
        return pulumi.get(self, "extras")

    @property
    @pulumi.getter(name="firewallSpec")
    def firewall_spec(self) -> pulumi.Output[Optional['outputs.WorkloadFirewallSpec']]:
        """
        Control of inbound and outbound access to the workload for external (public) and internal (service to service) traffic.
        Access is restricted by default.
        """
        return pulumi.get(self, "firewall_spec")

    @property
    @pulumi.getter
    def gvc(self) -> pulumi.Output[builtins.str]:
        """
        Name of the associated GVC.
        """
        return pulumi.get(self, "gvc")

    @property
    @pulumi.getter(name="identityLink")
    def identity_link(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identityLink is used as the access scope for 3rd party cloud resources. A single identity can provide access to
        multiple cloud providers.
        """
        return pulumi.get(self, "identity_link")

    @property
    @pulumi.getter
    def jobs(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadJob']]]:
        """
        [Cron Job Reference Page](https://docs.controlplane.com/reference/workload#cron).
        """
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output[Optional['outputs.WorkloadLoadBalancer']]:
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter(name="localOptions")
    def local_options(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadLocalOption']]]:
        """
        Override defaultOptions for the workload in specific Control Plane Locations.
        """
        return pulumi.get(self, "local_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the workload.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.WorkloadOptions']]:
        """
        Configurable settings or parameters that allow fine-tuning and customization of the behavior, performance, and
        characteristics of the workload.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="requestRetryPolicy")
    def request_retry_policy(self) -> pulumi.Output[Optional['outputs.WorkloadRequestRetryPolicy']]:
        return pulumi.get(self, "request_retry_policy")

    @property
    @pulumi.getter(name="rolloutOptions")
    def rollout_options(self) -> pulumi.Output[Optional[Sequence['outputs.WorkloadRolloutOption']]]:
        """
        Defines the parameters for updating applications and services, including settings for minimum readiness, unavailable
        replicas, surge replicas, and scaling policies.
        """
        return pulumi.get(self, "rollout_options")

    @property
    @pulumi.getter(name="securityOptions")
    def security_options(self) -> pulumi.Output[Optional['outputs.WorkloadSecurityOptions']]:
        """
        Allows for the configuration of the `file system group id` and `geo location`.
        """
        return pulumi.get(self, "security_options")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def sidecar(self) -> pulumi.Output[Optional['outputs.WorkloadSidecar']]:
        return pulumi.get(self, "sidecar")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.WorkloadStatus']]:
        """
        Status of the workload.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="supportDynamicTags")
    def support_dynamic_tags(self) -> pulumi.Output[builtins.bool]:
        """
        Workload will automatically redeploy when one of the container images is updated in the container registry. Default:
        false.
        """
        return pulumi.get(self, "support_dynamic_tags")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Workload Type. Either `serverless`, `standard`, `stateful`, or `cron`.
        """
        return pulumi.get(self, "type")

