from setuptools import setup, find_packages
excluded_packages = [
    'core', 'core.*', 
    'linkzone', 'linkzone.*', 
]
setup(
    name='stela_publishing',
    version='0.1.3',
    packages=find_packages(exclude=excluded_packages),
    include_package_data=True,
    license='MIT',
    description='All apps in one for business.',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    install_requires=[
        'Babel',
        'beautifulsoup4',
        'bleach',
        'boto3',
        'cryptography',
        'Django',
        'django-cities-light',
        'django-ckeditor',
        'django-crispy-forms',
        'django-cron',
        'django-environ',
        'django-hosts',
        'django-restframework',
        'django-storages',
        'google-api-python-client',
        'facebook-business',
        'gunicorn',
        'jwt',
        'openai',
        'paypal-checkout-serversdk',
        'paypalrestsdk',
        'phonenumbers',
        'Pillow',
        'python-amazon-paapi',
        'stripe',
    ],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
    ],
)