# Generated by Django 5.0 on 2023-12-21 18:40

import datetime
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('stela_control', '0017_modules_slug_alter_billingrecipt_option_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='JobApplication',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=50, verbose_name='First Name')),
                ('last_name', models.CharField(max_length=50, verbose_name='Last Name')),
                ('email', models.EmailField(max_length=254, verbose_name='Email Address')),
                ('phone', models.CharField(max_length=15, verbose_name='Phone Number')),
                ('address', models.TextField(verbose_name='Address')),
                ('position_applied', models.CharField(max_length=100, verbose_name='Position Applied For')),
                ('salary_expectations', models.DecimalField(decimal_places=2, max_digits=10, verbose_name='Salary Expectations')),
                ('available_start_date', models.DateField(verbose_name='Available Start Date')),
                ('comments', models.TextField(blank=True, null=True, verbose_name='Additional Comments')),
                ('created', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Job Application',
                'verbose_name_plural': 'Job Applications',
            },
        ),
        migrations.AlterField(
            model_name='billingrecipt',
            name='option',
            field=models.CharField(choices=[('Others', 'Others'), ('budget_design', 'Budget Design'), ('Billing receipt', 'Billing receipt'), ('Monthly charge', 'Monthly charge'), ('budget_development', 'Budget Development'), ('budget_marketing', 'Budget Marketing')], max_length=60, null=True, verbose_name='Case'),
        ),
        migrations.AlterField(
            model_name='company',
            name='business',
            field=models.CharField(blank=True, choices=[('Consulting', 'Consulting'), ('E-commerce', 'E-commerce'), ('Repair and Maintenance Services', 'Repair and Maintenance Services'), ('Education and Training', 'Education and Training'), ('IT Development Services', 'IT Development Services'), ('Marketing and Advertising Services', 'Marketing and Advertising Services'), ('Logistics and Transportation Services', 'Logistics and Transportation Services'), ('Health and Wellness', 'Health and Wellness'), ('Beauty and Personal Care Services', 'Beauty and Personal Care Services'), ('Restaurants and Food Services', 'Restaurants and Food Services'), ('Media Creators', 'Media Creators')], max_length=100, null=True, verbose_name='Business Type'),
        ),
        migrations.AlterField(
            model_name='content',
            name='card',
            field=models.CharField(blank=True, choices=[('card-tale', 'card-tale'), ('card-light-blue', 'card-light-blue'), ('card-dark-blue', 'card-dark-blue'), ('card-light-danger', 'card-light-danger')], max_length=50, null=True, verbose_name='Color Card'),
        ),
        migrations.AlterField(
            model_name='content',
            name='category',
            field=models.CharField(blank=True, choices=[('News', 'News'), ('Events and Conferences', 'Events and Conferences'), ('Guides and Manuals', 'Guides and Manuals'), ('Interviews', 'Interviews'), ('Inspiration', 'Inspiration'), ('Tutorials', 'Tutorials'), ('Tips and Tricks', 'Tips and Tricks')], default='News', max_length=100),
        ),
        migrations.AlterField(
            model_name='facebookpagecomments',
            name='update_rate',
            field=models.DateTimeField(default=datetime.datetime(2023, 12, 21, 15, 39, 45, 606957)),
        ),
        migrations.AlterField(
            model_name='itemdiscount',
            name='field',
            field=models.CharField(choices=[('No Selected', 'No Selected'), ('Stela Payment Free Suscription', 'Stela Payment Free Suscription'), ('Initial Payment', 'Initial Payment'), ('Promotional Discount', 'Promotional Discount')], max_length=60),
        ),
        migrations.AlterField(
            model_name='newsletter',
            name='status',
            field=models.CharField(choices=[('Draft', 'Draft'), ('Send', 'Send')], max_length=20),
        ),
        migrations.AlterField(
            model_name='newsletter',
            name='template',
            field=models.CharField(choices=[('Style Template 3', 'Style Template 3'), ('Style Template 2', 'Style Template 2'), ('Style Template 1', 'Style Template 1'), ('Style Template 4', 'Style Template 4')], max_length=60, null=True, verbose_name='Style'),
        ),
        migrations.AlterField(
            model_name='order',
            name='section',
            field=models.CharField(choices=[('No Selected', 'No Selected'), ('Stela Design', 'Stela Design'), ('Stela Marketing', 'Stela Marketing'), ('Stela Websites', 'Stela Websites'), ('Store', 'Store'), ('Cloud Domains', 'Cloud Domains'), ('Cloud Elastic Instance', 'Cloud Elastic Instance')], default='No Selected', max_length=50),
        ),
        migrations.AlterField(
            model_name='pathcontrol',
            name='step',
            field=models.CharField(choices=[('Step 3', 'Step 3'), ('Step 4', 'Step 4'), ('Step 2', 'Step 2')], default='No Selected', max_length=50),
        ),
        migrations.AlterField(
            model_name='sitepolicy',
            name='section',
            field=models.CharField(blank=True, choices=[('Cookie Policy', 'Cookie Policy'), ('Terms and Conditions', 'Terms and Conditions'), ('monthly_terms', 'Billing Terms'), ('budget_marketing_terms', 'Budget Marketing Terms'), ('Privacy Policy', 'Privacy Policy'), ('billing_terms', 'Monthly Billing Terms'), ('budget_design_terms', 'Budget Design Terms'), ('Disclaimer', 'Disclaimer'), ('Return Policy', 'Return Policy'), ('budget_development_terms', 'Budget Development Terms')], default='Terms and Conditions', max_length=150),
        ),
        migrations.AlterField(
            model_name='sociallinks',
            name='social',
            field=models.CharField(choices=[('Instagram', 'Instagram'), ('Github', 'Github'), ('Facebook', 'Facebook'), ('Youtube', 'Youtube'), ('Wikipedia', 'Wikipedia'), ('X', 'X'), ('Linkedin', 'Linkedin'), ('Tiktok', 'Tiktok')], default='No Selected', max_length=50),
        ),
        migrations.AlterField(
            model_name='support',
            name='option',
            field=models.CharField(choices=[('Others', 'Others'), ('I have a problem with my project', 'I have a problem with my project'), ('My account has an error', 'My account has an error'), ('Payments Issue', 'Payments Issue'), ('My delivery has been delayed', 'My delivery has been delayed'), ('I have a problem with my subscription', 'I have a problem with my subscription')], max_length=60, verbose_name='Case'),
        ),
        migrations.AlterField(
            model_name='wallet',
            name='type',
            field=models.CharField(choices=[('Binance', 'Binance'), ('Zelle', 'Zelle'), ('Paypal', 'Paypal')], max_length=100, verbose_name='Type of Wallet'),
        ),
        migrations.CreateModel(
            name='EmploymentHistory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('employer', models.CharField(max_length=100, verbose_name='Employer')),
                ('job_title', models.CharField(max_length=100, verbose_name='Job Title')),
                ('employment_period_from', models.DateField(verbose_name='Employment Period From')),
                ('employment_period_to', models.DateField(blank=True, null=True, verbose_name='Employment Period To')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Job Description')),
                ('job_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='employment_history', to='stela_control.jobapplication')),
            ],
        ),
        migrations.CreateModel(
            name='Education',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('institution_name', models.CharField(max_length=100, verbose_name='Institution Name')),
                ('degree_obtained', models.CharField(blank=True, max_length=100, null=True, verbose_name='Degree Obtained')),
                ('study_period_from', models.DateField(blank=True, null=True, verbose_name='Study Period From')),
                ('study_period_to', models.DateField(blank=True, null=True, verbose_name='Study Period To')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Description of Study')),
                ('job_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='education', to='stela_control.jobapplication')),
            ],
        ),
        migrations.CreateModel(
            name='Reference',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('contact_info', models.TextField(verbose_name='Contact Information')),
                ('relationship', models.CharField(blank=True, max_length=100, null=True, verbose_name='Relationship')),
                ('job_application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='references', to='stela_control.jobapplication')),
            ],
        ),
    ]
