# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateAuthorityArgs', 'CertificateAuthority']

@pulumi.input_type
class CertificateAuthorityArgs:
    def __init__(__self__, *,
                 certificate_authority_config: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs'],
                 compartment_id: pulumi.Input[str],
                 kms_key_id: pulumi.Input[str],
                 certificate_authority_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]]] = None,
                 certificate_revocation_list_details: Optional[pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CertificateAuthority resource.
        :param pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs'] certificate_authority_config: (Updatable) The configuration details for creating a certificate authority (CA).
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment in which you want to create the CA.
        :param pulumi.Input[str] kms_key_id: The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]] certificate_authority_rules: (Updatable) A list of rules that control how the CA is used and managed.
        :param pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs'] certificate_revocation_list_details: (Updatable) The details of the certificate revocation list (CRL).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the CA.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] name: A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "certificate_authority_config", certificate_authority_config)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if certificate_authority_rules is not None:
            pulumi.set(__self__, "certificate_authority_rules", certificate_authority_rules)
        if certificate_revocation_list_details is not None:
            pulumi.set(__self__, "certificate_revocation_list_details", certificate_revocation_list_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs']:
        """
        (Updatable) The configuration details for creating a certificate authority (CA).
        """
        return pulumi.get(self, "certificate_authority_config")

    @certificate_authority_config.setter
    def certificate_authority_config(self, value: pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs']):
        pulumi.set(self, "certificate_authority_config", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The compartment in which you want to create the CA.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Input[str]:
        """
        The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="certificateAuthorityRules")
    def certificate_authority_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]]]:
        """
        (Updatable) A list of rules that control how the CA is used and managed.
        """
        return pulumi.get(self, "certificate_authority_rules")

    @certificate_authority_rules.setter
    def certificate_authority_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]]]):
        pulumi.set(self, "certificate_authority_rules", value)

    @property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> Optional[pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs']]:
        """
        (Updatable) The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @certificate_revocation_list_details.setter
    def certificate_revocation_list_details(self, value: Optional[pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs']]):
        pulumi.set(self, "certificate_revocation_list_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A brief description of the CA.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CertificateAuthorityState:
    def __init__(__self__, *,
                 certificate_authority_config: Optional[pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs']] = None,
                 certificate_authority_rules: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]]] = None,
                 certificate_revocation_list_details: Optional[pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 config_type: Optional[pulumi.Input[str]] = None,
                 current_versions: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCurrentVersionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 issuer_certificate_authority_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subjects: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthoritySubjectArgs']]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_of_deletion: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CertificateAuthority resources.
        :param pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs'] certificate_authority_config: (Updatable) The configuration details for creating a certificate authority (CA).
        :param pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]] certificate_authority_rules: (Updatable) A list of rules that control how the CA is used and managed.
        :param pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs'] certificate_revocation_list_details: (Updatable) The details of the certificate revocation list (CRL).
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment in which you want to create the CA.
        :param pulumi.Input[str] config_type: The origin of the CA.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCurrentVersionArgs']]] current_versions: The metadata details of the certificate authority (CA) version. This summary object does not contain the CA contents.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the CA.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] issuer_certificate_authority_id: The OCID of the parent CA that issued this CA. If this is the root CA, then this value is null.
        :param pulumi.Input[str] kms_key_id: The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current CA lifecycle state.
        :param pulumi.Input[str] name: A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] signing_algorithm: The algorithm used to sign public key certificates that the CA issues.
        :param pulumi.Input[str] state: The current lifecycle state of the certificate authority.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateAuthoritySubjectArgs']]] subjects: The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        :param pulumi.Input[str] time_created: A property indicating when the CA was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[str] time_of_deletion: An optional property indicating when to delete the CA version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        if certificate_authority_config is not None:
            pulumi.set(__self__, "certificate_authority_config", certificate_authority_config)
        if certificate_authority_rules is not None:
            pulumi.set(__self__, "certificate_authority_rules", certificate_authority_rules)
        if certificate_revocation_list_details is not None:
            pulumi.set(__self__, "certificate_revocation_list_details", certificate_revocation_list_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if config_type is not None:
            pulumi.set(__self__, "config_type", config_type)
        if current_versions is not None:
            pulumi.set(__self__, "current_versions", current_versions)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if issuer_certificate_authority_id is not None:
            pulumi.set(__self__, "issuer_certificate_authority_id", issuer_certificate_authority_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> Optional[pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs']]:
        """
        (Updatable) The configuration details for creating a certificate authority (CA).
        """
        return pulumi.get(self, "certificate_authority_config")

    @certificate_authority_config.setter
    def certificate_authority_config(self, value: Optional[pulumi.Input['CertificateAuthorityCertificateAuthorityConfigArgs']]):
        pulumi.set(self, "certificate_authority_config", value)

    @property
    @pulumi.getter(name="certificateAuthorityRules")
    def certificate_authority_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]]]:
        """
        (Updatable) A list of rules that control how the CA is used and managed.
        """
        return pulumi.get(self, "certificate_authority_rules")

    @certificate_authority_rules.setter
    def certificate_authority_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCertificateAuthorityRuleArgs']]]]):
        pulumi.set(self, "certificate_authority_rules", value)

    @property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> Optional[pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs']]:
        """
        (Updatable) The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @certificate_revocation_list_details.setter
    def certificate_revocation_list_details(self, value: Optional[pulumi.Input['CertificateAuthorityCertificateRevocationListDetailsArgs']]):
        pulumi.set(self, "certificate_revocation_list_details", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compartment in which you want to create the CA.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> Optional[pulumi.Input[str]]:
        """
        The origin of the CA.
        """
        return pulumi.get(self, "config_type")

    @config_type.setter
    def config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_type", value)

    @property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCurrentVersionArgs']]]]:
        """
        The metadata details of the certificate authority (CA) version. This summary object does not contain the CA contents.
        """
        return pulumi.get(self, "current_versions")

    @current_versions.setter
    def current_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthorityCurrentVersionArgs']]]]):
        pulumi.set(self, "current_versions", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A brief description of the CA.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the parent CA that issued this CA. If this is the root CA, then this value is null.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @issuer_certificate_authority_id.setter
    def issuer_certificate_authority_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_certificate_authority_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current CA lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm used to sign public key certificates that the CA issues.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_algorithm", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the certificate authority.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthoritySubjectArgs']]]]:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @subjects.setter
    def subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateAuthoritySubjectArgs']]]]):
        pulumi.set(self, "subjects", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        A property indicating when the CA was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[str]]:
        """
        An optional property indicating when to delete the CA version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_deletion", value)


class CertificateAuthority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_config: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigArgs']]] = None,
                 certificate_authority_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityRuleArgs']]]]] = None,
                 certificate_revocation_list_details: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateRevocationListDetailsArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Certificate Authority resource in Oracle Cloud Infrastructure Certificates Management service.

        Creates a new certificate authority (CA) according to the details of the request.

        ## Import

        CertificateAuthorities can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CertificatesManagement/certificateAuthority:CertificateAuthority test_certificate_authority "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigArgs']] certificate_authority_config: (Updatable) The configuration details for creating a certificate authority (CA).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityRuleArgs']]]] certificate_authority_rules: (Updatable) A list of rules that control how the CA is used and managed.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateRevocationListDetailsArgs']] certificate_revocation_list_details: (Updatable) The details of the certificate revocation list (CRL).
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment in which you want to create the CA.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the CA.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] kms_key_id: The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        :param pulumi.Input[str] name: A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateAuthorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Certificate Authority resource in Oracle Cloud Infrastructure Certificates Management service.

        Creates a new certificate authority (CA) according to the details of the request.

        ## Import

        CertificateAuthorities can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:CertificatesManagement/certificateAuthority:CertificateAuthority test_certificate_authority "id"
        ```

        :param str resource_name: The name of the resource.
        :param CertificateAuthorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateAuthorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_config: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigArgs']]] = None,
                 certificate_authority_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityRuleArgs']]]]] = None,
                 certificate_revocation_list_details: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateRevocationListDetailsArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateAuthorityArgs.__new__(CertificateAuthorityArgs)

            if certificate_authority_config is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_config'")
            __props__.__dict__["certificate_authority_config"] = certificate_authority_config
            __props__.__dict__["certificate_authority_rules"] = certificate_authority_rules
            __props__.__dict__["certificate_revocation_list_details"] = certificate_revocation_list_details
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            if kms_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'kms_key_id'")
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["config_type"] = None
            __props__.__dict__["current_versions"] = None
            __props__.__dict__["issuer_certificate_authority_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["signing_algorithm"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subjects"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_deletion"] = None
        super(CertificateAuthority, __self__).__init__(
            'oci:CertificatesManagement/certificateAuthority:CertificateAuthority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_authority_config: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigArgs']]] = None,
            certificate_authority_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityRuleArgs']]]]] = None,
            certificate_revocation_list_details: Optional[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateRevocationListDetailsArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            config_type: Optional[pulumi.Input[str]] = None,
            current_versions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCurrentVersionArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            issuer_certificate_authority_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            signing_algorithm: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subjects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthoritySubjectArgs']]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_of_deletion: Optional[pulumi.Input[str]] = None) -> 'CertificateAuthority':
        """
        Get an existing CertificateAuthority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityConfigArgs']] certificate_authority_config: (Updatable) The configuration details for creating a certificate authority (CA).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateAuthorityRuleArgs']]]] certificate_authority_rules: (Updatable) A list of rules that control how the CA is used and managed.
        :param pulumi.Input[pulumi.InputType['CertificateAuthorityCertificateRevocationListDetailsArgs']] certificate_revocation_list_details: (Updatable) The details of the certificate revocation list (CRL).
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment in which you want to create the CA.
        :param pulumi.Input[str] config_type: The origin of the CA.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthorityCurrentVersionArgs']]]] current_versions: The metadata details of the certificate authority (CA) version. This summary object does not contain the CA contents.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] description: (Updatable) A brief description of the CA.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] issuer_certificate_authority_id: The OCID of the parent CA that issued this CA. If this is the root CA, then this value is null.
        :param pulumi.Input[str] kms_key_id: The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current CA lifecycle state.
        :param pulumi.Input[str] name: A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] signing_algorithm: The algorithm used to sign public key certificates that the CA issues.
        :param pulumi.Input[str] state: The current lifecycle state of the certificate authority.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CertificateAuthoritySubjectArgs']]]] subjects: The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        :param pulumi.Input[str] time_created: A property indicating when the CA was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        :param pulumi.Input[str] time_of_deletion: An optional property indicating when to delete the CA version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateAuthorityState.__new__(_CertificateAuthorityState)

        __props__.__dict__["certificate_authority_config"] = certificate_authority_config
        __props__.__dict__["certificate_authority_rules"] = certificate_authority_rules
        __props__.__dict__["certificate_revocation_list_details"] = certificate_revocation_list_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["config_type"] = config_type
        __props__.__dict__["current_versions"] = current_versions
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["issuer_certificate_authority_id"] = issuer_certificate_authority_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["signing_algorithm"] = signing_algorithm
        __props__.__dict__["state"] = state
        __props__.__dict__["subjects"] = subjects
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        return CertificateAuthority(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateAuthorityConfig")
    def certificate_authority_config(self) -> pulumi.Output['outputs.CertificateAuthorityCertificateAuthorityConfig']:
        """
        (Updatable) The configuration details for creating a certificate authority (CA).
        """
        return pulumi.get(self, "certificate_authority_config")

    @property
    @pulumi.getter(name="certificateAuthorityRules")
    def certificate_authority_rules(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateAuthorityCertificateAuthorityRule']]]:
        """
        (Updatable) A list of rules that control how the CA is used and managed.
        """
        return pulumi.get(self, "certificate_authority_rules")

    @property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> pulumi.Output[Optional['outputs.CertificateAuthorityCertificateRevocationListDetails']]:
        """
        (Updatable) The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The compartment in which you want to create the CA.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configType")
    def config_type(self) -> pulumi.Output[str]:
        """
        The origin of the CA.
        """
        return pulumi.get(self, "config_type")

    @property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> pulumi.Output[Sequence['outputs.CertificateAuthorityCurrentVersion']]:
        """
        The metadata details of the certificate authority (CA) version. This summary object does not contain the CA contents.
        """
        return pulumi.get(self, "current_versions")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A brief description of the CA.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> pulumi.Output[str]:
        """
        The OCID of the parent CA that issued this CA. If this is the root CA, then this value is null.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Oracle Cloud Infrastructure Vault key used to encrypt the CA.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current CA lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-friendly name for the CA. Names are unique within a compartment. Avoid entering confidential information. Valid characters include uppercase or lowercase letters, numbers, hyphens, underscores, and periods.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm used to sign public key certificates that the CA issues.
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the certificate authority.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subjects(self) -> pulumi.Output[Sequence['outputs.CertificateAuthoritySubject']]:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        A property indicating when the CA was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[str]:
        """
        An optional property indicating when to delete the CA version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")

