# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceApplicationPatchArgs', 'WorkspaceApplicationPatch']

@pulumi.input_type
class WorkspaceApplicationPatchArgs:
    def __init__(__self__, *,
                 application_key: pulumi.Input[str],
                 patch_type: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs']] = None):
        """
        The set of arguments for constructing a WorkspaceApplicationPatch resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] patch_type: The type of the patch applied or being applied on the application.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] description: Detailed description for the object.
        :param pulumi.Input[str] identifier: Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The object's key.
        :param pulumi.Input[str] model_version: The object's model version.
        :param pulumi.Input[str] name: Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_keys: The array of object keys to publish into application.
        :param pulumi.Input[int] object_status: The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs'] registry_metadata: Information about the object and its parent.
        """
        pulumi.set(__self__, "application_key", application_key)
        pulumi.set(__self__, "patch_type", patch_type)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_keys is not None:
            pulumi.set(__self__, "object_keys", object_keys)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Input[str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> pulumi.Input[str]:
        """
        The type of the patch applied or being applied on the application.
        """
        return pulumi.get(self, "patch_type")

    @patch_type.setter
    def patch_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "patch_type", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The object's key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        The object's model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The array of object keys to publish into application.
        """
        return pulumi.get(self, "object_keys")

    @object_keys.setter
    def object_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_keys", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs']]:
        """
        Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)


@pulumi.input_type
class _WorkspaceApplicationPatchState:
    def __init__(__self__, *,
                 application_key: Optional[pulumi.Input[str]] = None,
                 application_version: Optional[pulumi.Input[int]] = None,
                 dependent_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchDependentObjectMetadataArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 error_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 key_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchParentRefArgs']]]] = None,
                 patch_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchPatchObjectMetadataArgs']]]] = None,
                 patch_status: Optional[pulumi.Input[str]] = None,
                 patch_type: Optional[pulumi.Input[str]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs']] = None,
                 time_patched: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApplicationPatch resources.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[int] application_version: The application version of the patch.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchDependentObjectMetadataArgs']]] dependent_object_metadatas: List of dependent objects in this patch.
        :param pulumi.Input[str] description: Detailed description for the object.
        :param pulumi.Input[Mapping[str, Any]] error_messages: The errors encountered while applying the patch, if any.
        :param pulumi.Input[str] identifier: Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The object's key.
        :param pulumi.Input[Mapping[str, Any]] key_map: A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchMetadataArgs']]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: The object type.
        :param pulumi.Input[str] model_version: The object's model version.
        :param pulumi.Input[str] name: Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_keys: The array of object keys to publish into application.
        :param pulumi.Input[int] object_status: The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: The object version.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchParentRefArgs']]] parent_reves: A reference to the object's parent.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchPatchObjectMetadataArgs']]] patch_object_metadatas: List of objects that are published or unpublished in this patch.
        :param pulumi.Input[str] patch_status: Status of the patch applied or being applied on the application
        :param pulumi.Input[str] patch_type: The type of the patch applied or being applied on the application.
        :param pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs'] registry_metadata: Information about the object and its parent.
        :param pulumi.Input[str] time_patched: The date and time the patch was applied, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if application_version is not None:
            pulumi.set(__self__, "application_version", application_version)
        if dependent_object_metadatas is not None:
            pulumi.set(__self__, "dependent_object_metadatas", dependent_object_metadatas)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if error_messages is not None:
            pulumi.set(__self__, "error_messages", error_messages)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_map is not None:
            pulumi.set(__self__, "key_map", key_map)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_keys is not None:
            pulumi.set(__self__, "object_keys", object_keys)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_reves is not None:
            pulumi.set(__self__, "parent_reves", parent_reves)
        if patch_object_metadatas is not None:
            pulumi.set(__self__, "patch_object_metadatas", patch_object_metadatas)
        if patch_status is not None:
            pulumi.set(__self__, "patch_status", patch_status)
        if patch_type is not None:
            pulumi.set(__self__, "patch_type", patch_type)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if time_patched is not None:
            pulumi.set(__self__, "time_patched", time_patched)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[str]]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> Optional[pulumi.Input[int]]:
        """
        The application version of the patch.
        """
        return pulumi.get(self, "application_version")

    @application_version.setter
    def application_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "application_version", value)

    @property
    @pulumi.getter(name="dependentObjectMetadatas")
    def dependent_object_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchDependentObjectMetadataArgs']]]]:
        """
        List of dependent objects in this patch.
        """
        return pulumi.get(self, "dependent_object_metadatas")

    @dependent_object_metadatas.setter
    def dependent_object_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchDependentObjectMetadataArgs']]]]):
        pulumi.set(self, "dependent_object_metadatas", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The errors encountered while applying the patch, if any.
        """
        return pulumi.get(self, "error_messages")

    @error_messages.setter
    def error_messages(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "error_messages", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The object's key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @key_map.setter
    def key_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "key_map", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchMetadataArgs']]]]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        The object type.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        The object's model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The array of object keys to publish into application.
        """
        return pulumi.get(self, "object_keys")

    @object_keys.setter
    def object_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_keys", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[int]]:
        """
        The object version.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchParentRefArgs']]]]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @parent_reves.setter
    def parent_reves(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchParentRefArgs']]]]):
        pulumi.set(self, "parent_reves", value)

    @property
    @pulumi.getter(name="patchObjectMetadatas")
    def patch_object_metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchPatchObjectMetadataArgs']]]]:
        """
        List of objects that are published or unpublished in this patch.
        """
        return pulumi.get(self, "patch_object_metadatas")

    @patch_object_metadatas.setter
    def patch_object_metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationPatchPatchObjectMetadataArgs']]]]):
        pulumi.set(self, "patch_object_metadatas", value)

    @property
    @pulumi.getter(name="patchStatus")
    def patch_status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the patch applied or being applied on the application
        """
        return pulumi.get(self, "patch_status")

    @patch_status.setter
    def patch_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_status", value)

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the patch applied or being applied on the application.
        """
        return pulumi.get(self, "patch_type")

    @patch_type.setter
    def patch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch_type", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs']]:
        """
        Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationPatchRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="timePatched")
    def time_patched(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the patch was applied, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_patched")

    @time_patched.setter
    def time_patched(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_patched", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceApplicationPatch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 patch_type: Optional[pulumi.Input[str]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchRegistryMetadataArgs']]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Application Patch resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a patch in an application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_patch = oci.data_integration.WorkspaceApplicationPatch("test_workspace_application_patch",
            application_key=workspace_application_patch_application_key,
            identifier=workspace_application_patch_identifier,
            name=workspace_application_patch_name,
            object_keys=workspace_application_patch_object_keys,
            patch_type=workspace_application_patch_patch_type,
            workspace_id=test_workspace["id"],
            description=workspace_application_patch_description,
            key=workspace_application_patch_key,
            model_version=workspace_application_patch_model_version,
            object_status=workspace_application_patch_object_status,
            registry_metadata=oci.data_integration.WorkspaceApplicationPatchRegistryMetadataArgs(
                aggregator_key=workspace_application_patch_registry_metadata_aggregator_key,
                is_favorite=workspace_application_patch_registry_metadata_is_favorite,
                key=workspace_application_patch_registry_metadata_key,
                labels=workspace_application_patch_registry_metadata_labels,
                registry_version=workspace_application_patch_registry_metadata_registry_version,
            ))
        ```

        ## Import

        WorkspaceApplicationPatches can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationPatch:WorkspaceApplicationPatch test_workspace_application_patch "workspaces/{workspaceId}/applications/{applicationKey}/patches/{patchKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] description: Detailed description for the object.
        :param pulumi.Input[str] identifier: Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The object's key.
        :param pulumi.Input[str] model_version: The object's model version.
        :param pulumi.Input[str] name: Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_keys: The array of object keys to publish into application.
        :param pulumi.Input[int] object_status: The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[str] patch_type: The type of the patch applied or being applied on the application.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchRegistryMetadataArgs']] registry_metadata: Information about the object and its parent.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApplicationPatchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Application Patch resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a patch in an application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_patch = oci.data_integration.WorkspaceApplicationPatch("test_workspace_application_patch",
            application_key=workspace_application_patch_application_key,
            identifier=workspace_application_patch_identifier,
            name=workspace_application_patch_name,
            object_keys=workspace_application_patch_object_keys,
            patch_type=workspace_application_patch_patch_type,
            workspace_id=test_workspace["id"],
            description=workspace_application_patch_description,
            key=workspace_application_patch_key,
            model_version=workspace_application_patch_model_version,
            object_status=workspace_application_patch_object_status,
            registry_metadata=oci.data_integration.WorkspaceApplicationPatchRegistryMetadataArgs(
                aggregator_key=workspace_application_patch_registry_metadata_aggregator_key,
                is_favorite=workspace_application_patch_registry_metadata_is_favorite,
                key=workspace_application_patch_registry_metadata_key,
                labels=workspace_application_patch_registry_metadata_labels,
                registry_version=workspace_application_patch_registry_metadata_registry_version,
            ))
        ```

        ## Import

        WorkspaceApplicationPatches can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationPatch:WorkspaceApplicationPatch test_workspace_application_patch "workspaces/{workspaceId}/applications/{applicationKey}/patches/{patchKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApplicationPatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApplicationPatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 patch_type: Optional[pulumi.Input[str]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchRegistryMetadataArgs']]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApplicationPatchArgs.__new__(WorkspaceApplicationPatchArgs)

            if application_key is None and not opts.urn:
                raise TypeError("Missing required property 'application_key'")
            __props__.__dict__["application_key"] = application_key
            __props__.__dict__["description"] = description
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["key"] = key
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["object_keys"] = object_keys
            __props__.__dict__["object_status"] = object_status
            if patch_type is None and not opts.urn:
                raise TypeError("Missing required property 'patch_type'")
            __props__.__dict__["patch_type"] = patch_type
            __props__.__dict__["registry_metadata"] = registry_metadata
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["application_version"] = None
            __props__.__dict__["dependent_object_metadatas"] = None
            __props__.__dict__["error_messages"] = None
            __props__.__dict__["key_map"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["model_type"] = None
            __props__.__dict__["object_version"] = None
            __props__.__dict__["parent_reves"] = None
            __props__.__dict__["patch_object_metadatas"] = None
            __props__.__dict__["patch_status"] = None
            __props__.__dict__["time_patched"] = None
        super(WorkspaceApplicationPatch, __self__).__init__(
            'oci:DataIntegration/workspaceApplicationPatch:WorkspaceApplicationPatch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_key: Optional[pulumi.Input[str]] = None,
            application_version: Optional[pulumi.Input[int]] = None,
            dependent_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchDependentObjectMetadataArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            error_messages: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            key_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchMetadataArgs']]]]] = None,
            model_type: Optional[pulumi.Input[str]] = None,
            model_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            object_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            object_status: Optional[pulumi.Input[int]] = None,
            object_version: Optional[pulumi.Input[int]] = None,
            parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchParentRefArgs']]]]] = None,
            patch_object_metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchPatchObjectMetadataArgs']]]]] = None,
            patch_status: Optional[pulumi.Input[str]] = None,
            patch_type: Optional[pulumi.Input[str]] = None,
            registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchRegistryMetadataArgs']]] = None,
            time_patched: Optional[pulumi.Input[str]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'WorkspaceApplicationPatch':
        """
        Get an existing WorkspaceApplicationPatch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[int] application_version: The application version of the patch.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchDependentObjectMetadataArgs']]]] dependent_object_metadatas: List of dependent objects in this patch.
        :param pulumi.Input[str] description: Detailed description for the object.
        :param pulumi.Input[Mapping[str, Any]] error_messages: The errors encountered while applying the patch, if any.
        :param pulumi.Input[str] identifier: Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] key: The object's key.
        :param pulumi.Input[Mapping[str, Any]] key_map: A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchMetadataArgs']]]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: The object type.
        :param pulumi.Input[str] model_version: The object's model version.
        :param pulumi.Input[str] name: Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_keys: The array of object keys to publish into application.
        :param pulumi.Input[int] object_status: The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: The object version.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchParentRefArgs']]]] parent_reves: A reference to the object's parent.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchPatchObjectMetadataArgs']]]] patch_object_metadatas: List of objects that are published or unpublished in this patch.
        :param pulumi.Input[str] patch_status: Status of the patch applied or being applied on the application
        :param pulumi.Input[str] patch_type: The type of the patch applied or being applied on the application.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationPatchRegistryMetadataArgs']] registry_metadata: Information about the object and its parent.
        :param pulumi.Input[str] time_patched: The date and time the patch was applied, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApplicationPatchState.__new__(_WorkspaceApplicationPatchState)

        __props__.__dict__["application_key"] = application_key
        __props__.__dict__["application_version"] = application_version
        __props__.__dict__["dependent_object_metadatas"] = dependent_object_metadatas
        __props__.__dict__["description"] = description
        __props__.__dict__["error_messages"] = error_messages
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["key"] = key
        __props__.__dict__["key_map"] = key_map
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["object_keys"] = object_keys
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["parent_reves"] = parent_reves
        __props__.__dict__["patch_object_metadatas"] = patch_object_metadatas
        __props__.__dict__["patch_status"] = patch_status
        __props__.__dict__["patch_type"] = patch_type
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["time_patched"] = time_patched
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApplicationPatch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter(name="applicationVersion")
    def application_version(self) -> pulumi.Output[int]:
        """
        The application version of the patch.
        """
        return pulumi.get(self, "application_version")

    @property
    @pulumi.getter(name="dependentObjectMetadatas")
    def dependent_object_metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationPatchDependentObjectMetadata']]:
        """
        List of dependent objects in this patch.
        """
        return pulumi.get(self, "dependent_object_metadatas")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The errors encountered while applying the patch, if any.
        """
        return pulumi.get(self, "error_messages")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The object's key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationPatchMetadata']]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[str]:
        """
        The object type.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[str]:
        """
        The object's model version.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        The array of object keys to publish into application.
        """
        return pulumi.get(self, "object_keys")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[int]:
        """
        The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[int]:
        """
        The object version.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationPatchParentRef']]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @property
    @pulumi.getter(name="patchObjectMetadatas")
    def patch_object_metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationPatchPatchObjectMetadata']]:
        """
        List of objects that are published or unpublished in this patch.
        """
        return pulumi.get(self, "patch_object_metadatas")

    @property
    @pulumi.getter(name="patchStatus")
    def patch_status(self) -> pulumi.Output[str]:
        """
        Status of the patch applied or being applied on the application
        """
        return pulumi.get(self, "patch_status")

    @property
    @pulumi.getter(name="patchType")
    def patch_type(self) -> pulumi.Output[str]:
        """
        The type of the patch applied or being applied on the application.
        """
        return pulumi.get(self, "patch_type")

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceApplicationPatchRegistryMetadata']:
        """
        Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @property
    @pulumi.getter(name="timePatched")
    def time_patched(self) -> pulumi.Output[str]:
        """
        The date and time the patch was applied, in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_patched")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

