"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .balance_transfer_category import BalanceTransferCategory
from .entity_balance_transfer_party import (
    EntityBalanceTransferParty,
    EntityBalanceTransferPartyTypedDict,
)
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class EntityBalanceTransferTypedDict(TypedDict):
    id: str
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    source: EntityBalanceTransferPartyTypedDict
    r"""A party involved in the balance transfer, either the sender or the receiver."""
    destination: EntityBalanceTransferPartyTypedDict
    r"""A party involved in the balance transfer, either the sender or the receiver."""
    description: str
    r"""The transfer description for initiating party."""
    category: NotRequired[BalanceTransferCategory]
    r"""The type of the transfer. Different fees may apply to different types of transfers."""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class EntityBalanceTransfer(BaseModel):
    id: str

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    source: EntityBalanceTransferParty
    r"""A party involved in the balance transfer, either the sender or the receiver."""

    destination: EntityBalanceTransferParty
    r"""A party involved in the balance transfer, either the sender or the receiver."""

    description: str
    r"""The transfer description for initiating party."""

    category: Optional[BalanceTransferCategory] = None
    r"""The type of the transfer. Different fees may apply to different types of transfers."""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["category", "testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
