# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from google.cloud.dlp import gapic_version as package_version

__version__ = package_version.__version__


from google.cloud.dlp_v2.services.dlp_service.async_client import DlpServiceAsyncClient
from google.cloud.dlp_v2.services.dlp_service.client import DlpServiceClient
from google.cloud.dlp_v2.types.dlp import (
    Action,
    ActionDetails,
    ActivateJobTriggerRequest,
    AllOtherDatabaseResources,
    AllOtherResources,
    AmazonS3Bucket,
    AmazonS3BucketConditions,
    AmazonS3BucketRegex,
    AnalyzeDataSourceRiskDetails,
    AwsAccount,
    AwsAccountRegex,
    BigQueryDiscoveryTarget,
    BigQueryRegex,
    BigQueryRegexes,
    BigQuerySchemaModification,
    BigQueryTableCollection,
    BigQueryTableModification,
    BigQueryTableType,
    BigQueryTableTypeCollection,
    BigQueryTableTypes,
    BoundingBox,
    BucketingConfig,
    ByteContentItem,
    CancelDlpJobRequest,
    CharacterMaskConfig,
    CharsToIgnore,
    CloudSqlDiscoveryTarget,
    CloudSqlIamCredential,
    CloudSqlProperties,
    CloudStorageDiscoveryTarget,
    CloudStorageRegex,
    CloudStorageResourceReference,
    Color,
    ColumnDataProfile,
    Connection,
    ConnectionState,
    Container,
    ContentItem,
    ContentLocation,
    ContentOption,
    CreateConnectionRequest,
    CreateDeidentifyTemplateRequest,
    CreateDiscoveryConfigRequest,
    CreateDlpJobRequest,
    CreateInspectTemplateRequest,
    CreateJobTriggerRequest,
    CreateStoredInfoTypeRequest,
    CryptoDeterministicConfig,
    CryptoHashConfig,
    CryptoKey,
    CryptoReplaceFfxFpeConfig,
    DatabaseResourceCollection,
    DatabaseResourceReference,
    DatabaseResourceRegex,
    DatabaseResourceRegexes,
    DataProfileAction,
    DataProfileBigQueryRowSchema,
    DataProfileConfigSnapshot,
    DataProfileFinding,
    DataProfileFindingLocation,
    DataProfileFindingRecordLocation,
    DataProfileJobConfig,
    DataProfileLocation,
    DataProfilePubSubCondition,
    DataProfilePubSubMessage,
    DataProfileUpdateFrequency,
    DataRiskLevel,
    DataSourceType,
    DateShiftConfig,
    DateTime,
    DeidentifyConfig,
    DeidentifyContentRequest,
    DeidentifyContentResponse,
    DeidentifyDataSourceDetails,
    DeidentifyDataSourceStats,
    DeidentifyTemplate,
    DeleteConnectionRequest,
    DeleteDeidentifyTemplateRequest,
    DeleteDiscoveryConfigRequest,
    DeleteDlpJobRequest,
    DeleteFileStoreDataProfileRequest,
    DeleteInspectTemplateRequest,
    DeleteJobTriggerRequest,
    DeleteStoredInfoTypeRequest,
    DeleteTableDataProfileRequest,
    Disabled,
    DiscoveryBigQueryConditions,
    DiscoveryBigQueryFilter,
    DiscoveryCloudSqlConditions,
    DiscoveryCloudSqlFilter,
    DiscoveryCloudSqlGenerationCadence,
    DiscoveryCloudStorageConditions,
    DiscoveryCloudStorageFilter,
    DiscoveryCloudStorageGenerationCadence,
    DiscoveryConfig,
    DiscoveryFileStoreConditions,
    DiscoveryGenerationCadence,
    DiscoveryInspectTemplateModifiedCadence,
    DiscoveryOtherCloudConditions,
    DiscoveryOtherCloudFilter,
    DiscoveryOtherCloudGenerationCadence,
    DiscoverySchemaModifiedCadence,
    DiscoveryStartingLocation,
    DiscoveryTableModifiedCadence,
    DiscoveryTarget,
    DiscoveryVertexDatasetConditions,
    DiscoveryVertexDatasetFilter,
    DiscoveryVertexDatasetGenerationCadence,
    DlpJob,
    DlpJobType,
    DocumentLocation,
    Domain,
    EncryptionStatus,
    Error,
    ExcludeByHotword,
    ExcludeInfoTypes,
    ExclusionRule,
    FieldTransformation,
    FileClusterSummary,
    FileClusterType,
    FileExtensionInfo,
    FileStoreCollection,
    FileStoreDataProfile,
    FileStoreInfoTypeSummary,
    FileStoreRegex,
    FileStoreRegexes,
    Finding,
    FinishDlpJobRequest,
    FixedSizeBucketingConfig,
    GetColumnDataProfileRequest,
    GetConnectionRequest,
    GetDeidentifyTemplateRequest,
    GetDiscoveryConfigRequest,
    GetDlpJobRequest,
    GetFileStoreDataProfileRequest,
    GetInspectTemplateRequest,
    GetJobTriggerRequest,
    GetProjectDataProfileRequest,
    GetStoredInfoTypeRequest,
    GetTableDataProfileRequest,
    HybridContentItem,
    HybridFindingDetails,
    HybridInspectDlpJobRequest,
    HybridInspectJobTriggerRequest,
    HybridInspectResponse,
    HybridInspectStatistics,
    ImageLocation,
    ImageTransformations,
    InfoTypeCategory,
    InfoTypeDescription,
    InfoTypeStats,
    InfoTypeSummary,
    InfoTypeSupportedBy,
    InfoTypeTransformations,
    InspectConfig,
    InspectContentRequest,
    InspectContentResponse,
    InspectDataSourceDetails,
    InspectionRule,
    InspectionRuleSet,
    InspectJobConfig,
    InspectResult,
    InspectTemplate,
    JobTrigger,
    KmsWrappedCryptoKey,
    LargeCustomDictionaryConfig,
    LargeCustomDictionaryStats,
    ListColumnDataProfilesRequest,
    ListColumnDataProfilesResponse,
    ListConnectionsRequest,
    ListConnectionsResponse,
    ListDeidentifyTemplatesRequest,
    ListDeidentifyTemplatesResponse,
    ListDiscoveryConfigsRequest,
    ListDiscoveryConfigsResponse,
    ListDlpJobsRequest,
    ListDlpJobsResponse,
    ListFileStoreDataProfilesRequest,
    ListFileStoreDataProfilesResponse,
    ListInfoTypesRequest,
    ListInfoTypesResponse,
    ListInspectTemplatesRequest,
    ListInspectTemplatesResponse,
    ListJobTriggersRequest,
    ListJobTriggersResponse,
    ListProjectDataProfilesRequest,
    ListProjectDataProfilesResponse,
    ListStoredInfoTypesRequest,
    ListStoredInfoTypesResponse,
    ListTableDataProfilesRequest,
    ListTableDataProfilesResponse,
    Location,
    LocationSupport,
    Manual,
    MatchingType,
    MetadataLocation,
    MetadataType,
    NullPercentageLevel,
    OtherCloudDiscoveryStartingLocation,
    OtherCloudDiscoveryTarget,
    OtherCloudResourceCollection,
    OtherCloudResourceRegex,
    OtherCloudResourceRegexes,
    OtherCloudSingleResourceReference,
    OtherInfoTypeSummary,
    OutputStorageConfig,
    PrimitiveTransformation,
    PrivacyMetric,
    ProcessingLocation,
    ProfileGeneration,
    ProfileStatus,
    ProjectDataProfile,
    QuasiId,
    QuoteInfo,
    Range,
    RecordCondition,
    RecordLocation,
    RecordSuppression,
    RecordTransformation,
    RecordTransformations,
    RedactConfig,
    RedactImageRequest,
    RedactImageResponse,
    ReidentifyContentRequest,
    ReidentifyContentResponse,
    RelatedResource,
    RelationalOperator,
    ReplaceDictionaryConfig,
    ReplaceValueConfig,
    ReplaceWithInfoTypeConfig,
    ResourceVisibility,
    RiskAnalysisJobConfig,
    SaveToGcsFindingsOutput,
    Schedule,
    SearchConnectionsRequest,
    SearchConnectionsResponse,
    SecretManagerCredential,
    SecretsDiscoveryTarget,
    StatisticalTable,
    StorageMetadataLabel,
    StoredInfoType,
    StoredInfoTypeConfig,
    StoredInfoTypeState,
    StoredInfoTypeStats,
    StoredInfoTypeVersion,
    Table,
    TableDataProfile,
    TableLocation,
    Tag,
    TagFilter,
    TagFilters,
    TimePartConfig,
    TransformationConfig,
    TransformationContainerType,
    TransformationDescription,
    TransformationDetails,
    TransformationDetailsStorageConfig,
    TransformationErrorHandling,
    TransformationLocation,
    TransformationOverview,
    TransformationResultStatus,
    TransformationResultStatusType,
    TransformationSummary,
    TransformationType,
    TransientCryptoKey,
    UniquenessScoreLevel,
    UnwrappedCryptoKey,
    UpdateConnectionRequest,
    UpdateDeidentifyTemplateRequest,
    UpdateDiscoveryConfigRequest,
    UpdateInspectTemplateRequest,
    UpdateJobTriggerRequest,
    UpdateStoredInfoTypeRequest,
    Value,
    ValueFrequency,
    VersionDescription,
    VertexDatasetCollection,
    VertexDatasetDiscoveryTarget,
    VertexDatasetRegex,
    VertexDatasetRegexes,
    VertexDatasetResourceReference,
)
from google.cloud.dlp_v2.types.storage import (
    BigQueryField,
    BigQueryKey,
    BigQueryOptions,
    BigQueryTable,
    CloudStorageFileSet,
    CloudStorageOptions,
    CloudStoragePath,
    CloudStorageRegexFileSet,
    CustomInfoType,
    DatastoreKey,
    DatastoreOptions,
    EntityId,
    FieldId,
    FileType,
    HybridOptions,
    InfoType,
    Key,
    KindExpression,
    Likelihood,
    PartitionId,
    RecordKey,
    SensitivityScore,
    StorageConfig,
    StoredType,
    TableOptions,
    TableReference,
)

__all__ = (
    "DlpServiceClient",
    "DlpServiceAsyncClient",
    "Action",
    "ActionDetails",
    "ActivateJobTriggerRequest",
    "AllOtherDatabaseResources",
    "AllOtherResources",
    "AmazonS3Bucket",
    "AmazonS3BucketConditions",
    "AmazonS3BucketRegex",
    "AnalyzeDataSourceRiskDetails",
    "AwsAccount",
    "AwsAccountRegex",
    "BigQueryDiscoveryTarget",
    "BigQueryRegex",
    "BigQueryRegexes",
    "BigQueryTableCollection",
    "BigQueryTableTypes",
    "BoundingBox",
    "BucketingConfig",
    "ByteContentItem",
    "CancelDlpJobRequest",
    "CharacterMaskConfig",
    "CharsToIgnore",
    "CloudSqlDiscoveryTarget",
    "CloudSqlIamCredential",
    "CloudSqlProperties",
    "CloudStorageDiscoveryTarget",
    "CloudStorageRegex",
    "CloudStorageResourceReference",
    "Color",
    "ColumnDataProfile",
    "Connection",
    "Container",
    "ContentItem",
    "ContentLocation",
    "CreateConnectionRequest",
    "CreateDeidentifyTemplateRequest",
    "CreateDiscoveryConfigRequest",
    "CreateDlpJobRequest",
    "CreateInspectTemplateRequest",
    "CreateJobTriggerRequest",
    "CreateStoredInfoTypeRequest",
    "CryptoDeterministicConfig",
    "CryptoHashConfig",
    "CryptoKey",
    "CryptoReplaceFfxFpeConfig",
    "DatabaseResourceCollection",
    "DatabaseResourceReference",
    "DatabaseResourceRegex",
    "DatabaseResourceRegexes",
    "DataProfileAction",
    "DataProfileBigQueryRowSchema",
    "DataProfileConfigSnapshot",
    "DataProfileFinding",
    "DataProfileFindingLocation",
    "DataProfileFindingRecordLocation",
    "DataProfileJobConfig",
    "DataProfileLocation",
    "DataProfilePubSubCondition",
    "DataProfilePubSubMessage",
    "DataRiskLevel",
    "DataSourceType",
    "DateShiftConfig",
    "DateTime",
    "DeidentifyConfig",
    "DeidentifyContentRequest",
    "DeidentifyContentResponse",
    "DeidentifyDataSourceDetails",
    "DeidentifyDataSourceStats",
    "DeidentifyTemplate",
    "DeleteConnectionRequest",
    "DeleteDeidentifyTemplateRequest",
    "DeleteDiscoveryConfigRequest",
    "DeleteDlpJobRequest",
    "DeleteFileStoreDataProfileRequest",
    "DeleteInspectTemplateRequest",
    "DeleteJobTriggerRequest",
    "DeleteStoredInfoTypeRequest",
    "DeleteTableDataProfileRequest",
    "Disabled",
    "DiscoveryBigQueryConditions",
    "DiscoveryBigQueryFilter",
    "DiscoveryCloudSqlConditions",
    "DiscoveryCloudSqlFilter",
    "DiscoveryCloudSqlGenerationCadence",
    "DiscoveryCloudStorageConditions",
    "DiscoveryCloudStorageFilter",
    "DiscoveryCloudStorageGenerationCadence",
    "DiscoveryConfig",
    "DiscoveryFileStoreConditions",
    "DiscoveryGenerationCadence",
    "DiscoveryInspectTemplateModifiedCadence",
    "DiscoveryOtherCloudConditions",
    "DiscoveryOtherCloudFilter",
    "DiscoveryOtherCloudGenerationCadence",
    "DiscoverySchemaModifiedCadence",
    "DiscoveryStartingLocation",
    "DiscoveryTableModifiedCadence",
    "DiscoveryTarget",
    "DiscoveryVertexDatasetConditions",
    "DiscoveryVertexDatasetFilter",
    "DiscoveryVertexDatasetGenerationCadence",
    "DlpJob",
    "DocumentLocation",
    "Domain",
    "Error",
    "ExcludeByHotword",
    "ExcludeInfoTypes",
    "ExclusionRule",
    "FieldTransformation",
    "FileClusterSummary",
    "FileClusterType",
    "FileExtensionInfo",
    "FileStoreCollection",
    "FileStoreDataProfile",
    "FileStoreInfoTypeSummary",
    "FileStoreRegex",
    "FileStoreRegexes",
    "Finding",
    "FinishDlpJobRequest",
    "FixedSizeBucketingConfig",
    "GetColumnDataProfileRequest",
    "GetConnectionRequest",
    "GetDeidentifyTemplateRequest",
    "GetDiscoveryConfigRequest",
    "GetDlpJobRequest",
    "GetFileStoreDataProfileRequest",
    "GetInspectTemplateRequest",
    "GetJobTriggerRequest",
    "GetProjectDataProfileRequest",
    "GetStoredInfoTypeRequest",
    "GetTableDataProfileRequest",
    "HybridContentItem",
    "HybridFindingDetails",
    "HybridInspectDlpJobRequest",
    "HybridInspectJobTriggerRequest",
    "HybridInspectResponse",
    "HybridInspectStatistics",
    "ImageLocation",
    "ImageTransformations",
    "InfoTypeCategory",
    "InfoTypeDescription",
    "InfoTypeStats",
    "InfoTypeSummary",
    "InfoTypeTransformations",
    "InspectConfig",
    "InspectContentRequest",
    "InspectContentResponse",
    "InspectDataSourceDetails",
    "InspectionRule",
    "InspectionRuleSet",
    "InspectJobConfig",
    "InspectResult",
    "InspectTemplate",
    "JobTrigger",
    "KmsWrappedCryptoKey",
    "LargeCustomDictionaryConfig",
    "LargeCustomDictionaryStats",
    "ListColumnDataProfilesRequest",
    "ListColumnDataProfilesResponse",
    "ListConnectionsRequest",
    "ListConnectionsResponse",
    "ListDeidentifyTemplatesRequest",
    "ListDeidentifyTemplatesResponse",
    "ListDiscoveryConfigsRequest",
    "ListDiscoveryConfigsResponse",
    "ListDlpJobsRequest",
    "ListDlpJobsResponse",
    "ListFileStoreDataProfilesRequest",
    "ListFileStoreDataProfilesResponse",
    "ListInfoTypesRequest",
    "ListInfoTypesResponse",
    "ListInspectTemplatesRequest",
    "ListInspectTemplatesResponse",
    "ListJobTriggersRequest",
    "ListJobTriggersResponse",
    "ListProjectDataProfilesRequest",
    "ListProjectDataProfilesResponse",
    "ListStoredInfoTypesRequest",
    "ListStoredInfoTypesResponse",
    "ListTableDataProfilesRequest",
    "ListTableDataProfilesResponse",
    "Location",
    "LocationSupport",
    "Manual",
    "MetadataLocation",
    "OtherCloudDiscoveryStartingLocation",
    "OtherCloudDiscoveryTarget",
    "OtherCloudResourceCollection",
    "OtherCloudResourceRegex",
    "OtherCloudResourceRegexes",
    "OtherCloudSingleResourceReference",
    "OtherInfoTypeSummary",
    "OutputStorageConfig",
    "PrimitiveTransformation",
    "PrivacyMetric",
    "ProcessingLocation",
    "ProfileStatus",
    "ProjectDataProfile",
    "QuasiId",
    "QuoteInfo",
    "Range",
    "RecordCondition",
    "RecordLocation",
    "RecordSuppression",
    "RecordTransformation",
    "RecordTransformations",
    "RedactConfig",
    "RedactImageRequest",
    "RedactImageResponse",
    "ReidentifyContentRequest",
    "ReidentifyContentResponse",
    "RelatedResource",
    "ReplaceDictionaryConfig",
    "ReplaceValueConfig",
    "ReplaceWithInfoTypeConfig",
    "RiskAnalysisJobConfig",
    "SaveToGcsFindingsOutput",
    "Schedule",
    "SearchConnectionsRequest",
    "SearchConnectionsResponse",
    "SecretManagerCredential",
    "SecretsDiscoveryTarget",
    "StatisticalTable",
    "StorageMetadataLabel",
    "StoredInfoType",
    "StoredInfoTypeConfig",
    "StoredInfoTypeStats",
    "StoredInfoTypeVersion",
    "Table",
    "TableDataProfile",
    "TableLocation",
    "Tag",
    "TagFilter",
    "TagFilters",
    "TimePartConfig",
    "TransformationConfig",
    "TransformationDescription",
    "TransformationDetails",
    "TransformationDetailsStorageConfig",
    "TransformationErrorHandling",
    "TransformationLocation",
    "TransformationOverview",
    "TransformationResultStatus",
    "TransformationSummary",
    "TransientCryptoKey",
    "UnwrappedCryptoKey",
    "UpdateConnectionRequest",
    "UpdateDeidentifyTemplateRequest",
    "UpdateDiscoveryConfigRequest",
    "UpdateInspectTemplateRequest",
    "UpdateJobTriggerRequest",
    "UpdateStoredInfoTypeRequest",
    "Value",
    "ValueFrequency",
    "VersionDescription",
    "VertexDatasetCollection",
    "VertexDatasetDiscoveryTarget",
    "VertexDatasetRegex",
    "VertexDatasetRegexes",
    "VertexDatasetResourceReference",
    "BigQuerySchemaModification",
    "BigQueryTableModification",
    "BigQueryTableType",
    "BigQueryTableTypeCollection",
    "ConnectionState",
    "ContentOption",
    "DataProfileUpdateFrequency",
    "DlpJobType",
    "EncryptionStatus",
    "InfoTypeSupportedBy",
    "MatchingType",
    "MetadataType",
    "NullPercentageLevel",
    "ProfileGeneration",
    "RelationalOperator",
    "ResourceVisibility",
    "StoredInfoTypeState",
    "TransformationContainerType",
    "TransformationResultStatusType",
    "TransformationType",
    "UniquenessScoreLevel",
    "BigQueryField",
    "BigQueryKey",
    "BigQueryOptions",
    "BigQueryTable",
    "CloudStorageFileSet",
    "CloudStorageOptions",
    "CloudStoragePath",
    "CloudStorageRegexFileSet",
    "CustomInfoType",
    "DatastoreKey",
    "DatastoreOptions",
    "EntityId",
    "FieldId",
    "HybridOptions",
    "InfoType",
    "Key",
    "KindExpression",
    "PartitionId",
    "RecordKey",
    "SensitivityScore",
    "StorageConfig",
    "StoredType",
    "TableOptions",
    "TableReference",
    "FileType",
    "Likelihood",
)
