"""Aquarium environment v0"""

from pettingzoo.utils import aec_to_parallel, parallel_to_aec
from pettingzoo.utils.wrappers import AssertOutOfBoundsWrapper, OrderEnforcingWrapper

from marl_aquarium.env.aquarium import raw_env


def env(
    render_mode: str = "human",
    observable_walls: int = 2,
    width: int = 800,
    height: int = 800,
    caption: str = "Aquarium",
    fps: int = 60,
    max_time_steps: int = 3000,
    action_count: int = 16,
    predator_count: int = 1,
    prey_count: int = 16,
    predator_observe_count: int = 1,
    prey_observe_count: int = 3,
    draw_force_vectors: bool = False,
    draw_action_vectors: bool = False,
    draw_view_cones: bool = False,
    draw_hit_boxes: bool = False,
    draw_death_circles: bool = False,
    fov_enabled: bool = True,
    keep_prey_count_constant: bool = True,
    prey_radius: int = 20,
    prey_max_acceleration: float = 1,
    prey_max_velocity: float = 4,
    prey_view_distance: int = 100,
    prey_replication_age: int = 200,
    prey_max_steer_force: float = 0.6,
    prey_fov: int = 120,
    prey_reward: int = 1,
    prey_punishment: int = 1000,
    max_prey_count: int = 20,
    predator_max_acceleration: float = 0.6,
    predator_radius: int = 30,
    predator_max_velocity: float = 5,
    predator_view_distance: int = 200,
    predator_max_steer_force: float = 0.6,
    predator_max_age: int = 3000,
    predator_fov: int = 150,
    predator_reward: int = 10,
    catch_radius: int = 100,
    procreate: bool = False,
):
    """Returns the AEC environment"""
    env_aec = parallel_to_aec(
        raw_env(
            render_mode=render_mode,
            observable_walls=observable_walls,
            width=width,
            height=height,
            caption=caption,
            fps=fps,
            max_time_steps=max_time_steps,
            action_count=action_count,
            predator_count=predator_count,
            prey_count=prey_count,
            predator_observe_count=predator_observe_count,
            prey_observe_count=prey_observe_count,
            draw_force_vectors=draw_force_vectors,
            draw_action_vectors=draw_action_vectors,
            draw_view_cones=draw_view_cones,
            draw_hit_boxes=draw_hit_boxes,
            draw_death_circles=draw_death_circles,
            fov_enabled=fov_enabled,
            keep_prey_count_constant=keep_prey_count_constant,
            prey_radius=prey_radius,
            prey_max_acceleration=prey_max_acceleration,
            prey_max_velocity=prey_max_velocity,
            prey_view_distance=prey_view_distance,
            prey_replication_age=prey_replication_age,
            prey_max_steer_force=prey_max_steer_force,
            prey_fov=prey_fov,
            prey_reward=prey_reward,
            prey_punishment=prey_punishment,
            max_prey_count=max_prey_count,
            predator_max_acceleration=predator_max_acceleration,
            predator_radius=predator_radius,
            predator_max_velocity=predator_max_velocity,
            predator_view_distance=predator_view_distance,
            predator_max_steer_force=predator_max_steer_force,
            predator_max_age=predator_max_age,
            predator_fov=predator_fov,
            predator_reward=predator_reward,
            catch_radius=catch_radius,
            procreate=procreate,
        )
    )
    env_aec = AssertOutOfBoundsWrapper(env_aec)
    env_aec = OrderEnforcingWrapper(env_aec)

    return env_aec


def parallel_env(
    render_mode: str = "human",
    observable_walls: int = 2,
    width: int = 800,
    height: int = 800,
    caption: str = "Aquarium",
    fps: int = 60,
    max_time_steps: int = 3000,
    action_count: int = 16,
    predator_count: int = 1,
    prey_count: int = 16,
    predator_observe_count: int = 1,
    prey_observe_count: int = 3,
    draw_force_vectors: bool = False,
    draw_action_vectors: bool = False,
    draw_view_cones: bool = False,
    draw_hit_boxes: bool = False,
    draw_death_circles: bool = False,
    fov_enabled: bool = True,
    keep_prey_count_constant: bool = True,
    prey_radius: int = 20,
    prey_max_acceleration: float = 1,
    prey_max_velocity: float = 4,
    prey_view_distance: int = 100,
    prey_replication_age: int = 200,
    prey_max_steer_force: float = 0.6,
    prey_fov: int = 120,
    prey_reward: int = 1,
    prey_punishment: int = 1000,
    max_prey_count: int = 20,
    predator_max_acceleration: float = 0.6,
    predator_radius: int = 30,
    predator_max_velocity: float = 5,
    predator_view_distance: int = 200,
    predator_max_steer_force: float = 0.6,
    predator_max_age: int = 3000,
    predator_fov: int = 150,
    predator_reward: int = 10,
    catch_radius: int = 100,
    procreate: bool = False,
):
    """Returns the parallel environment"""
    return aec_to_parallel(
        env(
            render_mode=render_mode,
            observable_walls=observable_walls,
            width=width,
            height=height,
            caption=caption,
            fps=fps,
            max_time_steps=max_time_steps,
            action_count=action_count,
            predator_count=predator_count,
            prey_count=prey_count,
            predator_observe_count=predator_observe_count,
            prey_observe_count=prey_observe_count,
            draw_force_vectors=draw_force_vectors,
            draw_action_vectors=draw_action_vectors,
            draw_view_cones=draw_view_cones,
            draw_hit_boxes=draw_hit_boxes,
            draw_death_circles=draw_death_circles,
            fov_enabled=fov_enabled,
            keep_prey_count_constant=keep_prey_count_constant,
            prey_radius=prey_radius,
            prey_max_acceleration=prey_max_acceleration,
            prey_max_velocity=prey_max_velocity,
            prey_view_distance=prey_view_distance,
            prey_replication_age=prey_replication_age,
            prey_max_steer_force=prey_max_steer_force,
            prey_fov=prey_fov,
            prey_reward=prey_reward,
            prey_punishment=prey_punishment,
            max_prey_count=max_prey_count,
            predator_max_acceleration=predator_max_acceleration,
            predator_radius=predator_radius,
            predator_max_velocity=predator_max_velocity,
            predator_view_distance=predator_view_distance,
            predator_max_steer_force=predator_max_steer_force,
            predator_max_age=predator_max_age,
            predator_fov=predator_fov,
            predator_reward=predator_reward,
            catch_radius=catch_radius,
            procreate=procreate,
        )
    )
