"""Adds a empty protocols column to `base_result` and wavefunction to `result`

Revision ID: c194a8ef6acf
Revises: cc54842bb6ba
Create Date: 2019-09-30 10:31:23.552722

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "c194a8ef6acf"
down_revision = "cc54842bb6ba"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("base_result", sa.Column("protocols", postgresql.JSONB(astext_type=sa.Text()), nullable=True))
    op.execute("UPDATE base_result SET protocols='{}'::json")
    op.alter_column("base_result", "protocols", nullable=False)
    op.add_column("result", sa.Column("wavefunction", postgresql.JSONB(astext_type=sa.Text()), nullable=True))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("base_result", "protocols")
    op.drop_column("result", "wavefunction")
    # ### end Alembic commands ###
