"""Wavefunction data table

Revision ID: 1bd2f7711e68
Revises: a2f76bb7be65
Create Date: 2019-10-17 14:03:07.364322

"""

import sqlalchemy as sa
from alembic import op

import qcfractal

# revision identifiers, used by Alembic.
import qcfractal.db_socket.column_types

revision = "1bd2f7711e68"
down_revision = "a2f76bb7be65"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "wavefunction_store",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("basis", qcfractal.db_socket.column_types.MsgpackExt(), nullable=False),
        sa.Column("restricted", sa.Boolean(), nullable=False),
        sa.Column("h_core_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("h_core_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("h_effective_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("h_effective_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_orbitals_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_orbitals_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_density_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_density_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_fock_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_fock_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_eigenvalues_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_eigenvalues_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_occupations_a", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("scf_occupations_b", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.Column("extras", qcfractal.db_socket.column_types.MsgpackExt(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.add_column("result", sa.Column("wavefunction_data_id", sa.Integer(), nullable=True))
    op.create_foreign_key(
        "result_wavefunction_data_id_fkey", "result", "wavefunction_store", ["wavefunction_data_id"], ["id"]
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint("result_wavefunction_data_id_fkey", "result", type_="foreignkey")
    op.drop_column("result", "wavefunction_data_id")
    op.drop_table("wavefunction_store")
    # ### end Alembic commands ###
