"""Add/fix some indices on base_result and molecule

Revision ID: c05d63683601
Revises: 5be555fe9dc0
Create Date: 2021-03-04 11:29:11.780381

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "c05d63683601"
down_revision = "5be555fe9dc0"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index("ix_base_result_error", "base_result", ["error"], unique=True)
    op.create_index("ix_base_result_stderr", "base_result", ["stderr"], unique=True)
    op.create_index("ix_base_result_stdout", "base_result", ["stdout"], unique=True)

    # The molecule table may contain duplicates. Don't do this for now
    # op.drop_index("ix_molecule_hash", table_name="molecule")
    # op.create_index("ix_molecule_hash", "molecule", ["molecule_hash"], unique=True)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # op.drop_index("ix_molecule_hash", table_name="molecule")
    # op.create_index("ix_molecule_hash", "molecule", ["molecule_hash"], unique=False)
    op.drop_index("ix_base_result_stdout", table_name="base_result")
    op.drop_index("ix_base_result_stderr", table_name="base_result")
    op.drop_index("ix_base_result_error", table_name="base_result")
    # ### end Alembic commands ###
