"""mol_hash_not_uniq

Revision ID: 6b07e9a3589d
Revises: cd3d3e2915ce
Create Date: 2021-03-18 11:29:54.675313

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "6b07e9a3589d"
down_revision = "cd3d3e2915ce"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # This is safe to run whether or not the hash is uniq
    # This is important because revision cd3d3e2915ce may or may not have made it unique,
    # depending on whether the user upgraded to 0.15.4 before 0.15.5
    op.drop_index("ix_molecule_hash", table_name="molecule")
    op.create_index("ix_molecule_hash", "molecule", ["molecule_hash"], unique=False)

    # Drop the index on base_result hash if it exists, and (re-)create it with unique=False
    op.execute("DROP INDEX IF EXISTS ix_base_result_hash_index")
    op.create_index("ix_base_result_hash_index", "base_result", ["hash_index"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_molecule_hash", table_name="molecule")
    op.create_index("ix_molecule_hash", "molecule", ["molecule_hash"], unique=False)
    # ### end Alembic commands ###
