"""add is_service to base record

Revision ID: fac12b982c1c
Revises: 7fb1093c30ca
Create Date: 2021-12-13 09:50:43.602929

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "fac12b982c1c"
down_revision = "7fb1093c30ca"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("base_record", sa.Column("is_service", sa.Boolean(), nullable=True))

    # singlepoint and optimizations are never services
    # all existing gridopts and torsiondrives are services
    op.execute(
        sa.text("UPDATE base_record SET is_service = False WHERE record_type IN ('singlepoint', 'optimization')")
    )
    op.execute(
        sa.text("UPDATE base_record SET is_service = True WHERE record_type IN ('torsiondrive', 'gridoptimization')")
    )

    op.alter_column("base_record", "is_service", existing_type=sa.Boolean, nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("base_record", "is_service")
    # ### end Alembic commands ###
