"""Add reaction service

Revision ID: bba52fa8efbe
Revises: 92ace6197b01
Create Date: 2022-03-10 11:36:13.393303

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "bba52fa8efbe"
down_revision = "92ace6197b01"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "reaction_record",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("specification_id", sa.Integer(), nullable=False),
        sa.Column("total_energy", postgresql.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(["id"], ["base_record.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["specification_id"],
            ["qc_specification.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "reaction_stoichiometries",
        sa.Column("reaction_id", sa.Integer(), nullable=False),
        sa.Column("molecule_id", sa.Integer(), nullable=False),
        sa.Column("coefficient", postgresql.DOUBLE_PRECISION(), nullable=False),
        sa.ForeignKeyConstraint(
            ["molecule_id"],
            ["molecule.id"],
        ),
        sa.ForeignKeyConstraint(["reaction_id"], ["reaction_record.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("reaction_id", "molecule_id"),
    )
    op.create_table(
        "reaction_components",
        sa.Column("reaction_id", sa.Integer(), nullable=False),
        sa.Column("molecule_id", sa.Integer(), nullable=False),
        sa.Column("singlepoint_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["molecule_id"],
            ["molecule.id"],
        ),
        sa.ForeignKeyConstraint(
            ["reaction_id", "molecule_id"],
            ["reaction_stoichiometries.reaction_id", "reaction_stoichiometries.molecule_id"],
            ondelete="cascade",
        ),
        sa.ForeignKeyConstraint(["reaction_id"], ["reaction_record.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["singlepoint_id"],
            ["singlepoint_record.id"],
        ),
        sa.PrimaryKeyConstraint("reaction_id", "molecule_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("reaction_components")
    op.drop_table("reaction_stoichiometries")
    op.drop_table("reaction_record")
    # ### end Alembic commands ###
