"""Add native files

Revision ID: 6565544dfb94
Revises: 9a86ebfcfd1b
Create Date: 2022-03-30 21:38:03.647374

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "6565544dfb94"
down_revision = "9a86ebfcfd1b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    compression_enum = postgresql.ENUM("none", "gzip", "bzip2", "lzma", name="compressionenum", create_type=False)

    op.create_table(
        "native_file",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("record_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("compression", compression_enum, nullable=False),
        sa.Column("compression_level", sa.Integer(), nullable=False),
        sa.Column("is_text", sa.Boolean(), nullable=False),
        sa.Column("uncompressed_size", sa.Integer(), nullable=False),
        sa.Column("data", sa.LargeBinary(), nullable=False),
        sa.ForeignKeyConstraint(["record_id"], ["base_record.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("record_id", "name", name="ux_native_file_record_id_name"),
    )
    op.create_index("ix_native_file_record_id", "native_file", ["record_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_native_file_record_id", table_name="native_file")
    op.drop_table("native_file")
    # ### end Alembic commands ###
