"""Not nullable columns on dataset entries

Revision ID: a885e15274b2
Revises: 34872c09c1b1
Create Date: 2022-04-11 10:55:27.980392

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "a885e15274b2"
down_revision = "34872c09c1b1"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        sa.text(
            "UPDATE gridoptimization_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords IS NULL"
        )
    )
    op.execute(sa.text("UPDATE gridoptimization_dataset_entry SET attributes = '{}'::jsonb WHERE attributes IS NULL"))

    op.execute(
        sa.text(
            "UPDATE singlepoint_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords IS NULL"
        )
    )
    op.execute(sa.text("UPDATE singlepoint_dataset_entry SET attributes = '{}'::jsonb WHERE attributes IS NULL"))

    op.execute(
        sa.text(
            "UPDATE optimization_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords IS NULL"
        )
    )
    op.execute(sa.text("UPDATE optimization_dataset_entry SET attributes = '{}'::jsonb WHERE attributes IS NULL"))

    op.execute(
        sa.text(
            "UPDATE torsiondrive_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords IS NULL"
        )
    )
    op.execute(sa.text("UPDATE torsiondrive_dataset_entry SET attributes = '{}'::jsonb WHERE attributes IS NULL"))

    op.execute(
        sa.text(
            "UPDATE gridoptimization_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords::text = 'null'"
        )
    )
    op.execute(
        sa.text("UPDATE gridoptimization_dataset_entry SET attributes = '{}'::jsonb WHERE attributes::text = 'null'")
    )

    op.execute(
        sa.text(
            "UPDATE singlepoint_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords::text = 'null'"
        )
    )
    op.execute(sa.text("UPDATE singlepoint_dataset_entry SET attributes = '{}'::jsonb WHERE attributes::text = 'null'"))

    op.execute(
        sa.text(
            "UPDATE optimization_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords::text = 'null'"
        )
    )
    op.execute(
        sa.text("UPDATE optimization_dataset_entry SET attributes = '{}'::jsonb WHERE attributes::text = 'null'")
    )

    op.execute(
        sa.text(
            "UPDATE torsiondrive_dataset_entry SET additional_keywords = '{}'::jsonb WHERE additional_keywords::text = 'null'"
        )
    )
    op.execute(
        sa.text("UPDATE torsiondrive_dataset_entry SET attributes = '{}'::jsonb WHERE attributes::text = 'null'")
    )

    op.alter_column(
        "gridoptimization_dataset_entry",
        "additional_keywords",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    op.alter_column(
        "gridoptimization_dataset_entry",
        "attributes",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    op.alter_column(
        "optimization_dataset_entry",
        "additional_keywords",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    op.alter_column(
        "optimization_dataset_entry",
        "attributes",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    op.alter_column(
        "singlepoint_dataset_entry",
        "additional_keywords",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    op.alter_column(
        "singlepoint_dataset_entry", "attributes", existing_type=postgresql.JSONB(astext_type=sa.Text()), nullable=False
    )
    op.alter_column(
        "torsiondrive_dataset_entry",
        "additional_keywords",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    op.alter_column(
        "torsiondrive_dataset_entry",
        "attributes",
        existing_type=postgresql.JSONB(astext_type=sa.Text()),
        nullable=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    raise RuntimeError("Cannot downgrade")
