"""Add MBE service

Revision ID: f26c30450fdd
Revises: a885e15274b2
Create Date: 2022-05-10 13:32:40.316504

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "f26c30450fdd"
down_revision = "a885e15274b2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "manybody_specification",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("program", sa.String(), nullable=False),
        sa.Column("singlepoint_specification_id", sa.Integer(), nullable=False),
        sa.Column("keywords", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.CheckConstraint("program = LOWER(program)", name="ck_manybody_specification_program_lower"),
        sa.ForeignKeyConstraint(
            ["singlepoint_specification_id"],
            ["qc_specification.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("singlepoint_specification_id", "keywords", name="ux_manybody_specification_keys"),
    )
    op.create_index("ix_manybody_specification_keywords", "manybody_specification", ["keywords"], unique=False)
    op.create_index("ix_manybody_specification_program", "manybody_specification", ["program"], unique=False)
    op.create_index(
        "ix_manybody_specification_singlepoint_specification_id",
        "manybody_specification",
        ["singlepoint_specification_id"],
        unique=False,
    )
    op.create_table(
        "manybody_record",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("initial_molecule_id", sa.Integer(), nullable=False),
        sa.Column("specification_id", sa.Integer(), nullable=False),
        sa.Column("results", postgresql.JSONB(astext_type=sa.Text()), nullable=True),
        sa.ForeignKeyConstraint(["id"], ["base_record.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["initial_molecule_id"],
            ["molecule.id"],
        ),
        sa.ForeignKeyConstraint(
            ["specification_id"],
            ["manybody_specification.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "manybody_cluster",
        sa.Column("manybody_id", sa.Integer(), nullable=False),
        sa.Column("molecule_id", sa.Integer(), nullable=False),
        sa.Column("fragments", postgresql.ARRAY(sa.Integer()), nullable=False),
        sa.Column("basis", postgresql.ARRAY(sa.Integer()), nullable=False),
        sa.Column("degeneracy", sa.Integer(), nullable=False),
        sa.Column("singlepoint_id", sa.Integer(), nullable=True),
        sa.CheckConstraint("array_length(basis, 1) > 0", name="ck_manybody_cluster_basis"),
        sa.CheckConstraint("array_length(fragments, 1) > 0", name="ck_manybody_cluster_fragments"),
        sa.CheckConstraint("degeneracy > 0", name="ck_manybody_cluster_degeneracy"),
        sa.ForeignKeyConstraint(["manybody_id"], ["manybody_record.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["molecule_id"],
            ["molecule.id"],
        ),
        sa.ForeignKeyConstraint(
            ["singlepoint_id"],
            ["singlepoint_record.id"],
        ),
        sa.PrimaryKeyConstraint("manybody_id", "molecule_id"),
    )
    op.create_index("ix_manybody_cluster_molecule_id", "manybody_cluster", ["molecule_id"], unique=False)
    op.create_index("ix_manybody_cluster_singlepoint_id", "manybody_cluster", ["singlepoint_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_manybody_cluster_singlepoint_id", table_name="manybody_cluster")
    op.drop_index("ix_manybody_cluster_molecule_id", table_name="manybody_cluster")
    op.drop_table("manybody_cluster")
    op.drop_table("manybody_record")
    op.drop_index("ix_manybody_specification_singlepoint_specification_id", table_name="manybody_specification")
    op.drop_index("ix_manybody_specification_program", table_name="manybody_specification")
    op.drop_index("ix_manybody_specification_keywords", table_name="manybody_specification")
    op.drop_table("manybody_specification")
    # ### end Alembic commands ###
