"""add manybody dataset

Revision ID: 8a41b7dc30af
Revises: c3cbccb2d572
Create Date: 2022-05-15 10:36:52.811760

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "8a41b7dc30af"
down_revision = "c3cbccb2d572"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "manybody_dataset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["id"], ["collection.id"], ondelete="cascade"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "manybody_dataset_entry",
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("initial_molecule_id", sa.Integer(), nullable=False),
        sa.Column("additional_keywords", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("attributes", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.ForeignKeyConstraint(["dataset_id"], ["manybody_dataset.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["initial_molecule_id"],
            ["molecule.id"],
        ),
        sa.PrimaryKeyConstraint("dataset_id", "name"),
    )
    op.create_index("ix_manybody_dataset_entry_dataset_id", "manybody_dataset_entry", ["dataset_id"], unique=False)
    op.create_index(
        "ix_manybody_dataset_entry_initial_molecule_id", "manybody_dataset_entry", ["initial_molecule_id"], unique=False
    )
    op.create_index("ix_manybody_dataset_entry_name", "manybody_dataset_entry", ["name"], unique=False)
    op.create_table(
        "manybody_dataset_specification",
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("specification_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["dataset_id"], ["manybody_dataset.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["specification_id"],
            ["manybody_specification.id"],
        ),
        sa.PrimaryKeyConstraint("dataset_id", "name"),
    )
    op.create_index(
        "ix_manybody_dataset_specification_dataset_id", "manybody_dataset_specification", ["dataset_id"], unique=False
    )
    op.create_index("ix_manybody_dataset_specification_name", "manybody_dataset_specification", ["name"], unique=False)
    op.create_index(
        "ix_manybody_dataset_specification_specification_id",
        "manybody_dataset_specification",
        ["specification_id"],
        unique=False,
    )
    op.create_table(
        "manybody_dataset_record",
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("entry_name", sa.String(), nullable=False),
        sa.Column("specification_name", sa.String(), nullable=False),
        sa.Column("record_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id", "entry_name"],
            ["manybody_dataset_entry.dataset_id", "manybody_dataset_entry.name"],
            onupdate="cascade",
            ondelete="cascade",
        ),
        sa.ForeignKeyConstraint(
            ["dataset_id", "specification_name"],
            ["manybody_dataset_specification.dataset_id", "manybody_dataset_specification.name"],
            onupdate="cascade",
            ondelete="cascade",
        ),
        sa.ForeignKeyConstraint(["dataset_id"], ["manybody_dataset.id"], ondelete="cascade"),
        sa.ForeignKeyConstraint(
            ["record_id"],
            ["manybody_record.id"],
        ),
        sa.PrimaryKeyConstraint("dataset_id", "entry_name", "specification_name"),
        sa.UniqueConstraint("dataset_id", "entry_name", "specification_name", name="ux_manybody_dataset_record_unique"),
    )
    op.create_index("ix_manybody_dataset_record_record_id", "manybody_dataset_record", ["record_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_manybody_dataset_record_record_id", table_name="manybody_dataset_record")
    op.drop_table("manybody_dataset_record")
    op.drop_index("ix_manybody_dataset_specification_specification_id", table_name="manybody_dataset_specification")
    op.drop_index("ix_manybody_dataset_specification_name", table_name="manybody_dataset_specification")
    op.drop_index("ix_manybody_dataset_specification_dataset_id", table_name="manybody_dataset_specification")
    op.drop_table("manybody_dataset_specification")
    op.drop_index("ix_manybody_dataset_entry_name", table_name="manybody_dataset_entry")
    op.drop_index("ix_manybody_dataset_entry_initial_molecule_id", table_name="manybody_dataset_entry")
    op.drop_index("ix_manybody_dataset_entry_dataset_id", table_name="manybody_dataset_entry")
    op.drop_table("manybody_dataset_entry")
    op.drop_table("manybody_dataset")
    # ### end Alembic commands ###
