"""Not nullable columns on base datasets

Revision ID: 97e1d19796c7
Revises: 21e29b68cbd5
Create Date: 2022-06-23 14:51:38.781543

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "97e1d19796c7"
down_revision = "21e29b68cbd5"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(sa.text("UPDATE base_dataset SET tags = '[]'::json WHERE tags IS NULL"))
    op.execute(sa.text("UPDATE base_dataset SET tagline = '' WHERE tagline IS NULL"))
    op.execute(sa.text("UPDATE base_dataset SET description = '' WHERE description IS NULL"))
    op.execute(sa.text("UPDATE base_dataset SET provenance = '{}'::json WHERE provenance IS NULL"))
    op.execute(sa.text("UPDATE base_dataset SET extras = '{}'::json WHERE extras IS NULL"))

    op.alter_column("base_dataset", "tags", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=False)
    op.alter_column("base_dataset", "tagline", existing_type=sa.VARCHAR(), nullable=False)
    op.alter_column("base_dataset", "description", existing_type=sa.VARCHAR(), nullable=False)
    op.alter_column("base_dataset", "provenance", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=False)
    op.alter_column("base_dataset", "extras", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column("base_dataset", "provenance", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=True)
    op.alter_column("base_dataset", "description", existing_type=sa.VARCHAR(), nullable=True)
    op.alter_column("base_dataset", "tagline", existing_type=sa.VARCHAR(), nullable=True)
    op.alter_column("base_dataset", "tags", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=True)
    op.alter_column("base_dataset", "extras", existing_type=postgresql.JSON(astext_type=sa.Text()), nullable=True)
    # ### end Alembic commands ###
