"""Add user auth types

Revision ID: 5db09491c69d
Revises: b1d1a21895ba
Create Date: 2022-07-07 16:30:42.581429

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "5db09491c69d"
down_revision = "b1d1a21895ba"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    sa_enum = sa.Enum("password", name="authtypeenum")
    sa_enum.create(op.get_bind())

    op.add_column("user", sa.Column("auth_type", sa.Enum(name="authtypeenum"), nullable=True))
    op.execute(sa.text("UPDATE \"user\" SET auth_type = 'password'"))
    op.alter_column("user", "auth_type", nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("user", "auth_type")
    # ### end Alembic commands ###
