"""Remove created_on from task/service queue

Revision ID: d1ee87a66b71
Revises: e6f5053c7600
Create Date: 2023-08-15 17:58:28.061638

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "d1ee87a66b71"
down_revision = "e6f5053c7600"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_service_queue_waiting_sort", table_name="service_queue")
    op.drop_column("service_queue", "created_on")
    op.drop_index("ix_task_queue_waiting_sort", table_name="task_queue")
    op.drop_column("task_queue", "created_on")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("task_queue", sa.Column("created_on", postgresql.TIMESTAMP(), autoincrement=False, nullable=False))
    op.create_index("ix_task_queue_waiting_sort", "task_queue", [sa.text("priority DESC"), "created_on"], unique=False)
    op.add_column("service_queue", sa.Column("created_on", postgresql.TIMESTAMP(), autoincrement=False, nullable=False))
    op.create_index(
        "ix_service_queue_waiting_sort", "service_queue", [sa.text("priority DESC"), "created_on"], unique=False
    )
    # ### end Alembic commands ###
